package com.ejianc.foundation.tenant.api;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.ejianc.foundation.tenant.hystrix.EnterpriseHystrix;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author CJ
 * @Description:
 * @date 2020/8/6 11:57
 */
@FeignClient(name= "ejc-oms-web", url="${common.env.feign-client-url}", path="ejc-oms-web", fallback = EnterpriseHystrix.class)
public interface IEnterpriseApi {

	//供方协同（生成企业信息、租户、超级管理员等信息）
	@PostMapping(value = "/api/enterprise/supplierCollaboration")
    CommonResponse<EnterpriseVO> supplierCollaboration(@RequestBody EnterpriseVO enterpriseVO);

	//根据所给租户id查询租户所属企业信息
	@GetMapping(value = "/api/enterprise/getEnterpriseByTenantId")
    CommonResponse<EnterpriseVO> getEnterpriseByTenantId(@RequestParam("tenantId") Long tenantId);
	
	//获取所有企业列表
	@GetMapping(value = "/api/enterprise/getAllEnterpriseList")
	CommonResponse<List<EnterpriseVO>> getAllEnterpriseList();

	/**
	 * 获取用户总数 以及本年新增用户数
	 * {
	 *     total:100,
	 *     thisYear:20
	 * }
	 * @return
	 */
	@GetMapping(value = "/api/enterprise/getAllUserStatistics")
	CommonResponse<JSONObject> getAllUserStatistics();

	/**
	 * 获取最近即将到期的租户及其到期套餐和时间
	 * @param endDate
	 * @return {
	 *     id:租户id，
	 *     name：租户name，
	 *     comName：到期套餐名称，
	 *     endTime：到期时间
	 * }
	 */
	@GetMapping(value = "/api/enterprise/getEnterpriseComEndTimeInComingSeveralMonth")
	CommonResponse<List<JSONObject>> getEnterpriseComEndTimeInComingSeveralMonth(@RequestParam("endDate") String endDate);

	/**
	 * 根据租户查询该租户：
	 * 服务开始时间
	 * 服务结束时间
	 * 套餐内应用数量
	 * @param tenantId
	 * @return {
	 *     id:租户id，
	 *     name：租户name，
	 *     startTime：服务开始时间，
	 *     endTime：服务结束时间，
	 *     appNum:套餐内应用数量
	 * }
	 */
	@GetMapping(value = "/api/enterprise/getEnterpriseComboInfo")
	CommonResponse<JSONObject> getEnterpriseComboInfo(@RequestParam("tenantId") Long tenantId);

}
