package com.ejianc.foundation.usercenter.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.usercenter.api.param.AiMaterialParam;
import com.ejianc.foundation.usercenter.hystrix.AiHystrix;
import com.ejianc.foundation.usercenter.vo.AiMaterialTrainVO;
import com.ejianc.foundation.usercenter.vo.AiMaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import java.util.List;

@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = AiHystrix.class)
public interface IAiApi {

    @RequestMapping(value = "/ai/material/recognize", method = RequestMethod.POST)
    CommonResponse<List<AiMaterialVO>> aiMaterialRecognize(@RequestBody List<AiMaterialParam> aiMaterialParams);

    @RequestMapping(value = "/ai/material/train", method = RequestMethod.POST)
    CommonResponse<String> putMaterial2AiTrain(@RequestBody List<AiMaterialTrainVO> aiMaterialTrainVos);

}
