package com.ejianc.foundation.tenant.vo;

import java.io.Serializable;

public class PasswordPolicyVO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	private Long id;
	/**
	 * 策略编码
	 */
	private String code;
	/**
	 * 策略名称
	 */
	private String name;
	/**
	 * 密码复杂度（1: 数字和字母混合，2：数字、字母和!@#$%^&*?混合，3：大写字母、小写字母、数字和!@#$%^&*?混合）
	 */
	private Integer pwdComplexity;
	/**
	 * 密码最小长度
	 */
	private Integer minLength;

	/**
	 * 默认密码是否强制修改密码(1:是，0：否)
	 */
	private Integer defaultPwdFlag;
	/**
	 * 密码有效天数
	 */
	private Integer validiteDays;
	/**
	 * 密码过了有效期是否强制修改（1：是，0：否）
	 */
	private Integer forceUpdateFlag;
	/**
	 * 租户ID
	 */
	private Long tenantId;
	/**
	 * 获取默认密码
	 */
	private String defaultPwd;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getPwdComplexity() {
		return pwdComplexity;
	}

	public void setPwdComplexity(Integer pwdComplexity) {
		this.pwdComplexity = pwdComplexity;
	}

	public Integer getMinLength() {
		return minLength;
	}

	public void setMinLength(Integer minLength) {
		this.minLength = minLength;
	}

	public Integer getDefaultPwdFlag() {
		return defaultPwdFlag;
	}

	public void setDefaultPwdFlag(Integer defaultPwdFlag) {
		this.defaultPwdFlag = defaultPwdFlag;
	}

	public Integer getValiditeDays() {
		return validiteDays;
	}

	public void setValiditeDays(Integer validiteDays) {
		this.validiteDays = validiteDays;
	}

	public Integer getForceUpdateFlag() {
		return forceUpdateFlag;
	}

	public void setForceUpdateFlag(Integer forceUpdateFlag) {
		this.forceUpdateFlag = forceUpdateFlag;
	}

	public Long getTenantId() {
		return tenantId;
	}

	public void setTenantId(Long tenantId) {
		this.tenantId = tenantId;
	}

	public String getDefaultPwd() {
		return defaultPwd;
	}

	public void setDefaultPwd(String defaultPwd) {
		this.defaultPwd = defaultPwd;
	}

}
