package com.ejianc.foundation.tenant.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 租户挂靠表
 * 
 * @author generator
 * 
 */
public class TenantAffiliatedVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String myTenantName; // 我的租户名称
    private Long targetTenantId; // 挂靠的租户id
    private String targetTenantName; // 挂靠的租户名称
    private Long  tenantStatus;	 //挂靠状态 1、自由状态；2、一致挂靠；4、已拒绝；3、已拒绝、拒绝允许的数据操作与自由；5、取消挂靠（数据不可）；
    private String  code;	 //申请编码
    private String  memo;	 //申请理由
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate;	 //申请时间

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getTenantStatus() {
        return tenantStatus;
    }

    public void setTenantStatus(Long tenantStatus) {
        this.tenantStatus = tenantStatus;
    }

    public String getMyTenantName() {
        return myTenantName;
    }

    public void setMyTenantName(String myTenantName) {
        this.myTenantName = myTenantName;
    }
    @ReferSerialTransfer(referCode="idm-tenant")
    public Long getTargetTenantId() {
        return targetTenantId;
    }
    @ReferDeserialTransfer
    public void setTargetTenantId(Long targetTenantId) {
        this.targetTenantId = targetTenantId;
    }

    public String getTargetTenantName() {
        return targetTenantName;
    }

    public void setTargetTenantName(String targetTenantName) {
        this.targetTenantName = targetTenantName;
    }
    
}
