package com.ejianc.framework.idmclient;

import java.util.EventListener;

import javax.servlet.Filter;

import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.jasig.cas.client.util.AssertionThreadLocalFilter;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.ejianc.framework.idmclient.cas.AuthenticationFilter;
import com.ejianc.framework.idmclient.cas.ResponseHeaderFilter;
import com.ejianc.framework.idmclient.cas.TenantProxyReceivingTicketValidationFilter;
import com.ejianc.framework.idmclient.cas.logout.SingleSignOutFilter;
import com.ejianc.framework.idmclient.utils.ContextUtils;

@Configuration
@ConfigurationProperties(prefix = "ejc.cas")
public class IdmFilterConfiguration {

	private String casUrl; // cas地址
	private String casServer; // 客户端服务名称
	private String casRedirectUrl; // cas重定向地址
	private String serverName; // 服务器域名
	private String loginUrl; // 客户端回调方法
	private String contextName; // 客户端上下文名称
	private String issimpleregister;

	private String ignorePattern;

	@Bean
	public ContextUtils getContextUtils() {
		ContextUtils contextUtils = new ContextUtils();
		return contextUtils;
	}

	@Bean("singleSignOutHttpSessionListener")
	public ServletListenerRegistrationBean<EventListener> getServletListenerRegister() {
		ServletListenerRegistrationBean<EventListener> servletListenerRegistrationBean = new ServletListenerRegistrationBean<>();
		servletListenerRegistrationBean.setListener(new SingleSignOutHttpSessionListener());
		return servletListenerRegistrationBean;
	}

	@Bean("singleSignOutFilter")
	public FilterRegistrationBean<Filter> buildSingleSignOutFilter() {
		FilterRegistrationBean<Filter> filterRegistrationBean = new FilterRegistrationBean<>();
		filterRegistrationBean.setOrder(1);
		filterRegistrationBean.setFilter(new SingleSignOutFilter());
		filterRegistrationBean.setName("singleSignOutFilter");
		filterRegistrationBean.addUrlPatterns("/*");
		return filterRegistrationBean;
	}

	@Bean("authenticationFilter")
	public FilterRegistrationBean<Filter> buildAuthenticationFilter() {
		FilterRegistrationBean<Filter> filterRegistrationBean = new FilterRegistrationBean<>();
		filterRegistrationBean.setOrder(2);
		filterRegistrationBean.setFilter(new AuthenticationFilter());
		filterRegistrationBean.addInitParameter("ignoreUrlPatternType", "MUTICONTAINS");

		if (StringUtils.isBlank(ignorePattern)) {
			filterRegistrationBean.addInitParameter("ignorePattern", "/sso/logout");
		} else {
			filterRegistrationBean.addInitParameter("ignorePattern", ignorePattern);
		}
		filterRegistrationBean.setName("authenticationFilter");
		filterRegistrationBean.addUrlPatterns("/sso/*");
		return filterRegistrationBean;
	}

	@Bean("tenantProxyReceivingTicketValidationFilter")
	public FilterRegistrationBean<Filter> buildTenantProxyReceivingTicketValidationFilter() {
		FilterRegistrationBean<Filter> filterRegistrationBean = new FilterRegistrationBean<>();
		filterRegistrationBean.setOrder(3);
		filterRegistrationBean.setFilter(new TenantProxyReceivingTicketValidationFilter());
		filterRegistrationBean.addInitParameter("encoding", "UTF-8");
		filterRegistrationBean.setName("tenantProxyReceivingTicketValidationFilter");
		filterRegistrationBean.addUrlPatterns("/sso/*");
		return filterRegistrationBean;
	}

	@Bean("httpServletRequestWrapperFilter")
	public FilterRegistrationBean<Filter> buildHttpServletRequestWrapperFilter() {
		FilterRegistrationBean<Filter> filterRegistrationBean = new FilterRegistrationBean<>();
		filterRegistrationBean.setOrder(4);
		filterRegistrationBean.setFilter(new HttpServletRequestWrapperFilter());
		filterRegistrationBean.setName("httpServletRequestWrapperFilter");
		filterRegistrationBean.addUrlPatterns("/sso/*");
		return filterRegistrationBean;
	}

	@Bean("assertionThreadLocalFilter")
	public FilterRegistrationBean<Filter> buildAssertionThreadLocalFilter() {
		FilterRegistrationBean<Filter> filterRegistrationBean = new FilterRegistrationBean<>();
		filterRegistrationBean.setOrder(5);
		filterRegistrationBean.setFilter(new AssertionThreadLocalFilter());
		filterRegistrationBean.setName("assertionThreadLocalFilter");
		filterRegistrationBean.addUrlPatterns("/sso/*");
		return filterRegistrationBean;
	}

	@Bean("responseHeaderFilter")
	public FilterRegistrationBean<Filter> buildResponseHeaderFilter() {
		FilterRegistrationBean<Filter> filterRegistrationBean = new FilterRegistrationBean<>();
		filterRegistrationBean.addInitParameter("Cache-Control", "no-store");
		filterRegistrationBean.setOrder(6);
		filterRegistrationBean.setFilter(new ResponseHeaderFilter());
		filterRegistrationBean.setName("responseHeaderFilter");
		filterRegistrationBean.addUrlPatterns("/index.html");
		return filterRegistrationBean;
	}

	public String getCasUrl() {
		return casUrl;
	}

	public void setCasUrl(String casUrl) {
		this.casUrl = casUrl;
	}

	public String getCasServer() {
		return casServer;
	}

	public void setCasServer(String casServer) {
		this.casServer = casServer;
	}

	public String getCasRedirectUrl() {
		return casRedirectUrl;
	}

	public void setCasRedirectUrl(String casRedirectUrl) {
		this.casRedirectUrl = casRedirectUrl;
	}

	public String getServerName() {
		return serverName;
	}

	public void setServerName(String serverName) {
		this.serverName = serverName;
	}

	public String getLoginUrl() {
		return loginUrl;
	}

	public void setLoginUrl(String loginUrl) {
		this.loginUrl = loginUrl;
	}

	public String getContextName() {
		return contextName;
	}

	public void setContextName(String contextName) {
		this.contextName = contextName;
	}

	public String getIgnorePattern() {
		return ignorePattern;
	}

	public void setIgnorePattern(String ignorePattern) {
		this.ignorePattern = ignorePattern;
	}

	public String getIssimpleregister() {
		return issimpleregister;
	}

	public void setIssimpleregister(String issimpleregister) {
		this.issimpleregister = issimpleregister;
	}

}
