/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.idmclient.sdk;

import com.ejianc.framework.idmclient.cas.logout.entity.TenantUser;
import com.ejianc.framework.idmclient.esapi.EncryptException;
import com.ejianc.framework.idmclient.utils.ContextUtils;
import com.ejianc.framework.idmclient.utils.TokenGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.lang.StringUtils;
import org.springside.modules.nosql.redis.JedisTemplate;
import org.springside.modules.nosql.redis.JedisUtils;
import org.springside.modules.nosql.redis.pool.JedisPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class UserCacheManagerUtils {
    public static final String TOKEN_SEED = "token_seed";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private int sessionTimeout;
    private JedisTemplate jedisTemplate;
    private static UserCacheManagerUtils instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserCacheManagerUtils getInstance() {
        if (instance != null) return instance;
        Class<UserCacheManagerUtils> clazz = UserCacheManagerUtils.class;
        synchronized (UserCacheManagerUtils.class) {
            if (instance != null) return instance;
            instance = new UserCacheManagerUtils();
            if (UserCacheManagerUtils.instance.jedisTemplate != null) return instance;
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private UserCacheManagerUtils() {
        try {
            this.jedisTemplate = ContextUtils.getBean(JedisTemplate.class);
            this.sessionTimeout = 3600;
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TenantUser getUserCache(String userName) {
        Jedis jedis = null;
        boolean borrowOrOprSuccess = true;
        JedisPool pool = this.jedisTemplate.getJedisPool();
        byte[] value = null;
        byte[] userNameBytes = userName.getBytes(Charset.forName(DEFAULT_CHARSET));
        try {
            jedis = (Jedis)pool.getResource();
            value = jedis.get(userNameBytes);
            if (value != null && value.length > 0) {
                jedis.expire(userNameBytes, this.sessionTimeout);
            }
        }
        catch (JedisConnectionException e) {
            borrowOrOprSuccess = false;
            e.printStackTrace();
        }
        finally {
            this.closeResource(pool, jedis, borrowOrOprSuccess);
        }
        if (value == null) {
            return null;
        }
        return (TenantUser)this.byteToObject(value);
    }

    private String createUserCacheKey(String uname) {
        return "user.info.login.tenant:" + uname;
    }

    private void closeResource(JedisPool pool, Jedis jedis, boolean borrowOrOprSuccess) {
        try {
            if (jedis != null) {
                if (borrowOrOprSuccess) {
                    pool.returnResource(jedis);
                } else {
                    pool.returnBrokenResource(jedis);
                }
            }
        }
        catch (Exception e) {
            if (jedis != null) {
                JedisUtils.destroyJedis((Jedis)jedis);
            }
            e.printStackTrace();
        }
    }

    public Object byteToObject(byte[] bytes) {
        Object obj = null;
        try {
            ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
            ObjectInputStream oi = new ObjectInputStream(bi);
            obj = oi.readObject();
            bi.close();
            oi.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public String findSeed() {
        String seed = this.jedisTemplate.get(TOKEN_SEED);
        if (StringUtils.isBlank((String)seed)) {
            try {
                seed = TokenGenerator.genSeed();
            }
            catch (EncryptException e) {
                e.printStackTrace();
                return null;
            }
            this.jedisTemplate.set(TOKEN_SEED, seed);
        }
        return seed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Serializable> T getSessionCacheAttribute(String sid, String key) {
        Jedis jedis = null;
        boolean borrowOrOprSuccess = true;
        JedisPool pool = this.jedisTemplate.getJedisPool();
        byte[] value = null;
        byte[] keyBytes = sid.getBytes(Charset.forName(DEFAULT_CHARSET));
        byte[] fieldBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
        try {
            jedis = (Jedis)pool.getResource();
            value = jedis.hget(keyBytes, fieldBytes);
            if (value != null && value.length > 0) {
                jedis.expire(sid, this.sessionTimeout);
            }
        }
        catch (JedisConnectionException e) {
            borrowOrOprSuccess = false;
            e.printStackTrace();
        }
        finally {
            this.closeResource(pool, jedis, borrowOrOprSuccess);
        }
        if (value == null) {
            return null;
        }
        return (T)((Serializable)this.byteToObject(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void cacheUser(String uname, T user) {
        Jedis jedis = null;
        boolean borrowOrOprSuccess = true;
        JedisPool pool = this.jedisTemplate.getJedisPool();
        byte[] keyBytes = this.createUserCacheKey(uname).getBytes(Charset.forName(DEFAULT_CHARSET));
        byte[] valueBytes = UserCacheManagerUtils.objectToByte(user);
        try {
            jedis = (Jedis)pool.getResource();
            jedis.setex(keyBytes, this.sessionTimeout, valueBytes);
        }
        catch (JedisConnectionException e) {
            borrowOrOprSuccess = false;
            e.printStackTrace();
        }
        finally {
            this.closeResource(pool, jedis, borrowOrOprSuccess);
        }
    }

    static byte[] objectToByte(Object obj) {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(obj);
            bytes = bo.toByteArray();
            bo.close();
            oo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putSessionCacheAttribute(String sid, String key, T value) {
        Jedis jedis = null;
        boolean borrowOrOprSuccess = true;
        JedisPool pool = this.jedisTemplate.getJedisPool();
        byte[] keyBytes = sid.getBytes(Charset.forName(DEFAULT_CHARSET));
        byte[] fieldBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
        byte[] valueBytes = UserCacheManagerUtils.objectToByte(value);
        try {
            jedis = (Jedis)pool.getResource();
            jedis.hset(keyBytes, fieldBytes, valueBytes);
            jedis.expire(sid, this.sessionTimeout);
        }
        catch (JedisConnectionException e) {
            borrowOrOprSuccess = false;
            e.printStackTrace();
        }
        finally {
            this.closeResource(pool, jedis, borrowOrOprSuccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disCacheUser(String uname) {
        Jedis jedis = null;
        boolean borrowOrOprSuccess = true;
        JedisPool pool = this.jedisTemplate.getJedisPool();
        try {
            jedis = (Jedis)pool.getResource();
            jedis.del(this.createUserCacheKey(uname));
        }
        catch (JedisConnectionException e) {
            borrowOrOprSuccess = false;
            e.printStackTrace();
        }
        finally {
            this.closeResource(pool, jedis, borrowOrOprSuccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionCacheAttribute(String sid, String key) {
        Jedis jedis = null;
        boolean borrowOrOprSuccess = true;
        JedisPool pool = this.jedisTemplate.getJedisPool();
        try {
            jedis = (Jedis)pool.getResource();
            jedis.hdel(sid, new String[]{key});
        }
        catch (JedisConnectionException e) {
            borrowOrOprSuccess = false;
            e.printStackTrace();
        }
        finally {
            this.closeResource(pool, jedis, borrowOrOprSuccess);
        }
    }
}

