package com.ejianc.framework.idmclient.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

import javax.servlet.http.Cookie;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Cookies操作工具类
 */
public class CookieUtil {
	
	private static Logger logger = LoggerFactory.getLogger(CookieUtil.class);

    /**
     * 创建cookie，不过期，js不可操作。base64编码
     *
     * @param key
     * @param value
     * @return Cookie
     */
    public static Cookie createCookie(String key, String value) {
        return createCookie(key, value, true);
    }

    /**
     * 创建cookie，不过期，js不可操作。base64编码
     *
     * @param key
     * @param value
     * @return Cookie
     */
    public static Cookie createCookie(String key, String value, boolean httpOnly) {
        Cookie cookie = null;
		try {
			cookie = new Cookie(key, URLEncoder.encode(value,"UTF-8"));
			cookie.setHttpOnly(httpOnly);
			cookie.setMaxAge(-1);
			cookie.setPath("/");
		} catch (UnsupportedEncodingException e) {
			logger.error("encode error!", e);
		}
        return cookie;
    }


    /**
     * 查找cookie内容
     *
     * @param cookies
     * @param key
     * @return String
     */
    public static String findCookieValue(Cookie[] cookies, String key) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName().equals(key)) {
                    try {
						return URLDecoder.decode(cookie.getValue(),"UTF-8");
					} catch (UnsupportedEncodingException e) {
						logger.error("decode error!", e);
					}
                }
            }
        }
        return null;

    }

    /**
     * 将cookie过期
     *
     * @param key
     */
    public static Cookie expireCookieWithPath(String key, String path) {
        Cookie cookie = new Cookie(key, null);
        cookie.setMaxAge(0);
        cookie.setPath(path);
        return cookie;
    }

}