/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.idmclient;

import com.ejianc.framework.idmclient.cas.AuthenticationFilter;
import com.ejianc.framework.idmclient.cas.ResponseHeaderFilter;
import com.ejianc.framework.idmclient.cas.TenantProxyReceivingTicketValidationFilter;
import com.ejianc.framework.idmclient.cas.logout.SingleSignOutFilter;
import com.ejianc.framework.idmclient.utils.ContextUtils;
import java.util.EventListener;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.jasig.cas.client.util.AssertionThreadLocalFilter;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="ejc.cas")
public class IdmFilterConfiguration {
    private String casUrl;
    private String casServer;
    private String casRedirectUrl;
    private String serverName;
    private String loginUrl;
    private String contextName;
    private String issimpleregister;
    private String ignorePattern;
    private String multiDomain = "false";

    @Bean
    public ContextUtils getContextUtils() {
        ContextUtils contextUtils = new ContextUtils();
        return contextUtils;
    }

    @Bean(value={"singleSignOutHttpSessionListener"})
    public ServletListenerRegistrationBean<EventListener> getServletListenerRegister() {
        ServletListenerRegistrationBean servletListenerRegistrationBean = new ServletListenerRegistrationBean();
        servletListenerRegistrationBean.setListener((EventListener)new SingleSignOutHttpSessionListener());
        return servletListenerRegistrationBean;
    }

    @Bean(value={"singleSignOutFilter"})
    public FilterRegistrationBean<Filter> buildSingleSignOutFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setOrder(1);
        filterRegistrationBean.setFilter((Filter)new SingleSignOutFilter());
        filterRegistrationBean.setName("singleSignOutFilter");
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        return filterRegistrationBean;
    }

    @Bean(value={"authenticationFilter"})
    public FilterRegistrationBean<Filter> buildAuthenticationFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setOrder(2);
        filterRegistrationBean.setFilter((Filter)new AuthenticationFilter());
        filterRegistrationBean.addInitParameter("ignoreUrlPatternType", "MUTICONTAINS");
        if (StringUtils.isBlank((CharSequence)this.ignorePattern)) {
            filterRegistrationBean.addInitParameter("ignorePattern", "/sso/logout");
        } else {
            filterRegistrationBean.addInitParameter("ignorePattern", this.ignorePattern);
        }
        filterRegistrationBean.setName("authenticationFilter");
        filterRegistrationBean.addUrlPatterns(new String[]{"/sso/*"});
        return filterRegistrationBean;
    }

    @Bean(value={"tenantProxyReceivingTicketValidationFilter"})
    public FilterRegistrationBean<Filter> buildTenantProxyReceivingTicketValidationFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setOrder(3);
        filterRegistrationBean.setFilter((Filter)new TenantProxyReceivingTicketValidationFilter());
        filterRegistrationBean.addInitParameter("encoding", "UTF-8");
        filterRegistrationBean.setName("tenantProxyReceivingTicketValidationFilter");
        filterRegistrationBean.addUrlPatterns(new String[]{"/sso/*"});
        return filterRegistrationBean;
    }

    @Bean(value={"httpServletRequestWrapperFilter"})
    public FilterRegistrationBean<Filter> buildHttpServletRequestWrapperFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setOrder(4);
        filterRegistrationBean.setFilter((Filter)new HttpServletRequestWrapperFilter());
        filterRegistrationBean.setName("httpServletRequestWrapperFilter");
        filterRegistrationBean.addUrlPatterns(new String[]{"/sso/*"});
        return filterRegistrationBean;
    }

    @Bean(value={"assertionThreadLocalFilter"})
    public FilterRegistrationBean<Filter> buildAssertionThreadLocalFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setOrder(5);
        filterRegistrationBean.setFilter((Filter)new AssertionThreadLocalFilter());
        filterRegistrationBean.setName("assertionThreadLocalFilter");
        filterRegistrationBean.addUrlPatterns(new String[]{"/sso/*"});
        return filterRegistrationBean;
    }

    @Bean(value={"responseHeaderFilter"})
    public FilterRegistrationBean<Filter> buildResponseHeaderFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.addInitParameter("Cache-Control", "no-store");
        filterRegistrationBean.setOrder(6);
        filterRegistrationBean.setFilter((Filter)new ResponseHeaderFilter());
        filterRegistrationBean.setName("responseHeaderFilter");
        filterRegistrationBean.addUrlPatterns(new String[]{"/index.html"});
        return filterRegistrationBean;
    }

    public String getCasUrl() {
        return this.casUrl;
    }

    public void setCasUrl(String casUrl) {
        this.casUrl = casUrl;
    }

    public String getCasServer() {
        return this.casServer;
    }

    public void setCasServer(String casServer) {
        this.casServer = casServer;
    }

    public String getCasRedirectUrl() {
        return this.casRedirectUrl;
    }

    public void setCasRedirectUrl(String casRedirectUrl) {
        this.casRedirectUrl = casRedirectUrl;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getIgnorePattern() {
        return this.ignorePattern;
    }

    public void setIgnorePattern(String ignorePattern) {
        this.ignorePattern = ignorePattern;
    }

    public String getIssimpleregister() {
        return this.issimpleregister;
    }

    public void setIssimpleregister(String issimpleregister) {
        this.issimpleregister = issimpleregister;
    }

    public String getMultiDomain() {
        return this.multiDomain;
    }

    public void setMultiDomain(String multiDomain) {
        this.multiDomain = multiDomain;
    }
}

