package com.ejianc.framework.idmclient.utils;

import org.owasp.esapi.ESAPI;

import com.ejianc.framework.idmclient.esapi.EncryptException;
import com.ejianc.framework.idmclient.esapi.IEOPESAPI;

public class TokenGenerator {
	public static String genToken(String uname, long ts, String seed) throws EncryptException {
		return IEOPESAPI.encryptor().hash(uname + ts, seed);
	}

	public static String genSeed() throws EncryptException {
		return IEOPESAPI.encryptor().hash(new String(ESAPI.securityConfiguration().getMasterKey()),new String(ESAPI.securityConfiguration().getMasterSalt()));
	}
}