package com.ejianc.foundation.comment.service;

import com.ejianc.foundation.comment.bean.CommentEntity;
import com.ejianc.foundation.comment.vo.CommentVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 评论
 * 
 * @author generator
 * 
 */
public interface ICommentService extends IBaseService<CommentEntity> {

    /**
     * 保存评论
     * @param entity
     * @param b
     * @return
     */
    public CommentVO saveOrUpdates(CommentEntity entity, boolean b);

    public void sendMessage(CommentVO vo);

    /**
     * 根据用户单据id和用户id删除一条数据
     * @param billTypeId
     * @param userId
     */
    public void removeUserById(Long billTypeId,Long userId);

    /**
     * 查询提醒
     * @param billTypeId
     * @return
     */
    public List<CommentVO> queryTipsList(Long billTypeId);

    /**
     * 立即处理提醒
     * @param id
     */
    void updateHandleTips(Long billTypeId);
}
