/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.usercenter.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.bean.FaceReviewEntity;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.mapper.FaceReviewMapper;
import com.ejianc.foundation.usercenter.service.IFaceReviewService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.vo.FaceReviewVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FaceReviewServiceImpl
extends BaseServiceImpl<FaceReviewMapper, FaceReviewEntity>
implements IFaceReviewService {
    @Autowired
    private FaceReviewMapper faceReviewMapper;
    @Autowired
    private IUserService userService;
    @Autowired
    private IOrgService orgService;

    @Override
    public IPage<FaceReviewVO> queryData(QueryParam param) {
        LinkedHashMap order;
        OrgVO orgVo;
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Integer pn = param.getPageIndex();
        pn = pn - 1 < 0 ? 1 : pn;
        long startLine = (pn - 1) * param.getPageSize();
        params.put("pageIndex", pn);
        params.put("pageSize", param.getPageSize());
        params.put("startLine", startLine);
        Map pa = param.getParams();
        if (pa != null) {
            for (String key : pa.keySet()) {
                params.put(key, ((Parameter)pa.get(key)).getValue());
            }
        }
        if ((orgVo = this.orgService.queryDetail(InvocationInfoProxy.getOrgId())) != null) {
            params.put("innerCode", orgVo.getInnerCode());
        }
        if ((order = param.getOrderMap()) != null) {
            String orderSql = "";
            for (String key : order.keySet()) {
                if (orderSql != "") {
                    orderSql = orderSql + "," + key + " " + (String)order.get(key);
                    continue;
                }
                orderSql = orderSql + key + " " + (String)order.get(key);
            }
            params.put("orderSql", orderSql);
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            params.put("searchText", param.getSearchText());
        }
        long total = this.faceReviewMapper.countData(params);
        page.setTotal(total);
        if (total == 0L) {
            page.setRecords(new ArrayList());
            return page;
        }
        List<FaceReviewVO> voList = this.faceReviewMapper.queryData(params);
        page.setRecords(voList);
        return page;
    }

    @Override
    public List<FaceReviewVO> queryLastDetail(Long userid) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.faceReviewMapper.queryLastDetail(userid, tenantId);
    }

    @Override
    public FaceReviewVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.faceReviewMapper.queryDetail(id, tenantId);
    }

    @Override
    public FaceReviewVO saveData(FaceReviewVO saveOrUpdateVO) {
        FaceReviewEntity oldEntity;
        FaceReviewEntity entity = (FaceReviewEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FaceReviewEntity.class));
        if (entity.getAuditStatus() == 2) {
            UserEntity userEntity = (UserEntity)((Object)this.userService.getById(entity.getUserId()));
            userEntity.setFaceSignature(userEntity.getId().toString());
            userEntity.setFaceImg(entity.getFaceImg());
            this.userService.saveOrUpdate((Object)userEntity, false);
        } else if (entity.getAuditStatus() == 3 && (oldEntity = (FaceReviewEntity)((Object)this.selectById(entity.getId()))).getAuditStatus() != null && oldEntity.getAuditStatus() == 2) {
            UserEntity userEntity = (UserEntity)((Object)this.userService.getById(entity.getUserId()));
            userEntity.setFaceSignature(null);
            userEntity.setFaceImg(null);
            this.userService.saveOrUpdate((Object)userEntity, false);
        }
        this.saveOrUpdate((Object)entity, false);
        FaceReviewVO vo = (FaceReviewVO)BeanMapper.map((Object)((Object)entity), FaceReviewVO.class);
        return vo;
    }
}

