/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.workbench.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.tenant.service.ITenantService;
import com.ejianc.foundation.workbench.bean.WidgetEntity;
import com.ejianc.foundation.workbench.bean.WidgetGroupEntity;
import com.ejianc.foundation.workbench.mapper.WidgetGroupMapper;
import com.ejianc.foundation.workbench.mapper.WidgetMapper;
import com.ejianc.foundation.workbench.service.IWidgetService;
import com.ejianc.foundation.workbench.vo.WidgetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WidgetServiceImpl
extends BaseServiceImpl<WidgetMapper, WidgetEntity>
implements IWidgetService {
    private static final String WIDGET_BILL_CODE = "IDM_WIDGET";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITenantService tenantService;
    @Autowired
    private WidgetGroupMapper widgetGroupMapper;

    @Override
    public WidgetVO save(WidgetVO widgetVO) {
        TenantEntity tenantEntity;
        Long tenantId = InvocationInfoProxy.getTenantid();
        WidgetEntity saveEntity = null;
        if (widgetVO.getTenantId() != null && widgetVO.getParentId() != null) {
            List list;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"dr", (Object)0);
            wrapper.eq((Object)"tenant_id", (Object)widgetVO.getTenantId());
            wrapper.eq((Object)"parent_id", (Object)widgetVO.getParentId());
            if (widgetVO.getId() != null) {
                wrapper.ne((Object)"id", (Object)widgetVO.getId());
            }
            if ((list = this.list((Wrapper)wrapper)) != null && list.size() > 0) {
                throw new BusinessException("\u8be5\u79df\u6237\u4e0b\u5df2\u5b58\u5728");
            }
        }
        if (widgetVO.getParentId() != null && widgetVO.getTenantId() == 999999L) {
            throw new BusinessException("\u5e73\u53f0\u79df\u6237\u4e0d\u8981\u65b0\u589e\u5b50\u7ea7\u5c0f\u90e8\u4ef6");
        }
        if (null != widgetVO.getId()) {
            saveEntity = (WidgetEntity)((Object)BeanMapper.map((Object)widgetVO, WidgetEntity.class));
        } else {
            CommonResponse commonResponse = this.billCodeApi.getCodeBatchByRuleCode(WIDGET_BILL_CODE, tenantId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            widgetVO.setCode((String)commonResponse.getData());
            widgetVO.setId(Long.valueOf(IdWorker.getId()));
            widgetVO.setSetting(StringUtils.isNotBlank((CharSequence)widgetVO.getSetting()) ? widgetVO.getSetting().replace("widgetid_value", widgetVO.getId().toString()) : "");
            saveEntity = (WidgetEntity)((Object)BeanMapper.map((Object)widgetVO, WidgetEntity.class));
        }
        if (saveEntity.getTenantId() != null) {
            tenantEntity = (TenantEntity)((Object)this.tenantService.getById(saveEntity.getTenantId()));
            saveEntity.setTenantName(tenantEntity.getName());
        } else {
            tenantEntity = (TenantEntity)((Object)this.tenantService.getById(InvocationInfoProxy.getTenantid()));
            saveEntity.setTenantName(tenantEntity.getName());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        return (WidgetVO)BeanMapper.map((Object)((Object)saveEntity), WidgetVO.class);
    }

    @Override
    public WidgetEntity getById(Long id) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"parent_id", (Object)id);
        wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List entities = ((WidgetMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (entities != null && entities.size() > 0) {
            return (WidgetEntity)((Object)entities.get(0));
        }
        return (WidgetEntity)((Object)((WidgetMapper)this.baseMapper).selectById(id));
    }

    @Override
    public List<WidgetEntity> getWidgetByIds(String widgetIds) {
        List<WidgetEntity> widgetEntities = ((WidgetMapper)this.baseMapper).getWidgetByIds(widgetIds);
        return widgetEntities;
    }

    @Override
    public List<WidgetEntity> queryWidgetList(String searchText, Long groupId) {
        String innerCode = "";
        if (groupId != null && groupId > 0L) {
            WidgetGroupEntity widgetGroupEntity = (WidgetGroupEntity)((Object)this.widgetGroupMapper.selectById(groupId));
            innerCode = widgetGroupEntity.getInnerCode();
        }
        List<WidgetEntity> entities = ((WidgetMapper)this.baseMapper).queryWidgetList(searchText, innerCode);
        return entities;
    }

    @Override
    public List<WidgetVO> queryListByGroupId(Long id) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"group_id", (Object)id);
        List entities = ((WidgetMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (entities != null) {
            return BeanMapper.mapList((Iterable)entities, WidgetVO.class);
        }
        return null;
    }
}

