package com.ejianc.foundation.openapi.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.openapi.bean.SecurityKeyDetailEntity;
import com.ejianc.foundation.openapi.bean.SecurityKeyEntity;
import com.ejianc.foundation.openapi.mapper.SecurityKeyMapper;
import com.ejianc.foundation.openapi.service.ISecurityKeyDetailService;
import com.ejianc.foundation.openapi.service.ISecurityKeyService;
import com.ejianc.foundation.openapi.vo.SecurityKeyDetailVO;
import com.ejianc.foundation.openapi.vo.SecurityKeyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.Base64Util;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;

/**
 * @author CJ
 * @Description:
 * @date 2020/8/10 10:09
 */
@Service(value = "securityKeyService")
public class SecurityKeyServiceImpl extends BaseServiceImpl<SecurityKeyMapper, SecurityKeyEntity> implements ISecurityKeyService {
	
	@Autowired
	private SecurityKeyMapper securityKeyMapper;
	@Autowired
	private ISecurityKeyDetailService securityKeyDetailService;

	@Override
	public CommonResponse<String> saveOrUpdate(SecurityKeyVO securityKeyVo) {
		SecurityKeyEntity securityKeyEntity = null;
		String operateType = null;
		if(securityKeyVo.getId() != null && securityKeyVo.getId() > 0) {
			securityKeyEntity = securityKeyMapper.selectById(securityKeyVo.getId());
			securityKeyEntity.setSecurityName(securityKeyVo.getSecurityName());
			securityKeyEntity.setSecretDesc(securityKeyVo.getSecretDesc());
			securityKeyEntity.setSecretState(securityKeyVo.getSecretState());
			
			operateType = "edit";
		}else{ //新增
			String appid = IdWorker.getId()+"";
			String secret = Base64Util.encode(appid.getBytes());
			
			securityKeyEntity = BeanMapper.map(securityKeyVo, SecurityKeyEntity.class);
			securityKeyEntity.setId(IdWorker.getId());
			securityKeyEntity.setAppId(appid);
			securityKeyEntity.setSecretKey(secret);
			
			operateType = "add";
		}
		super.saveOrUpdate(securityKeyEntity);
		
		//子表
		List<SecurityKeyDetailVO> securityKeyDetailVos = securityKeyVo.getGridheaders();
		List<SecurityKeyDetailEntity> saveOrUpdates = new ArrayList<SecurityKeyDetailEntity>();
		List<Long> deleteIds = new ArrayList<>();
		for(SecurityKeyDetailVO securityKeyDetailVo:securityKeyDetailVos) {
			if("add".equals(securityKeyDetailVo.getRowState())) {
				SecurityKeyDetailEntity securityKeyDetailEntity = BeanMapper.map(securityKeyDetailVo, SecurityKeyDetailEntity.class);
				securityKeyDetailEntity.setSecurityKeyId(securityKeyEntity.getId());
				saveOrUpdates.add(securityKeyDetailEntity);
			}else if("edit".equals(securityKeyDetailVo.getRowState())) {
				SecurityKeyDetailEntity securityKeyDetailEntity = BeanMapper.map(securityKeyDetailVo, SecurityKeyDetailEntity.class);
				saveOrUpdates.add(securityKeyDetailEntity);
			}else if("del".equals(securityKeyDetailVo.getRowState())) {
				deleteIds.add(securityKeyDetailVo.getId());
			}
		}
		
		if(saveOrUpdates.size() > 0) {
			securityKeyDetailService.saveOrUpdateBatch(saveOrUpdates, saveOrUpdates.size(), false);
		}
		
		if(deleteIds.size() > 0) {
			securityKeyDetailService.removeByIds(deleteIds, false);
		}
		
		if("add".equals(operateType)) {
			return CommonResponse.success("保存成功");
		}else{
			return CommonResponse.success("修改成功");
		}
	}

	@Override
	public SecurityKeyVO queryDetail(Long id) {
		SecurityKeyEntity entity = securityKeyMapper.selectById(id);
		if(entity != null) {
			SecurityKeyVO securityKeyVo = BeanMapper.map(entity, SecurityKeyVO.class);
			List<SecurityKeyDetailVO> securityKeyDetails = securityKeyDetailService.querySecurityKeyDetailListBySecurityId(securityKeyVo.getId());
			securityKeyVo.setGridheaders(securityKeyDetails);
			return securityKeyVo;
		}
		return null;
	}

}
