package com.ejianc.foundation.workbench.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.workbench.element.node.Cell;
import com.ejianc.foundation.workbench.element.node.Container;
import com.ejianc.foundation.workbench.element.node.Element;
import com.ejianc.foundation.workbench.element.node.WidgetBox;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class ElementParser {

    public static List<Element> parse(String json) {
        Assert.notNull(json);

        JSONArray jsonArray = JSON.parseArray(json);

        return parse(jsonArray);
    }

    public static List<Element> parse(JSONArray jsonArray) {
        List<Element> elements = new ArrayList<>();

        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);

            String tagName = jsonObject.getString("tag");

            Set<String> keys = jsonObject.keySet();

            Element element = null;
            if ("Container".equals(tagName)) {
                element = new Container(tagName);
            }

            if ("ContainerCell".equals(tagName)) {
                element = new Cell(tagName);
            }

            if ("Widget".equals(tagName)) {
                element = new WidgetBox(tagName);
            }

            if (element != null) {
                elements.add(element);

                for (String key : keys) {
                    if ("subElements".equals(key)) {
                        JSONArray subJSONArray = jsonObject.getJSONArray(key);
                        List<Element> subElements = parse(subJSONArray);
                        element.setSubElements(subElements);
                    } else {
                        element.attr(key, jsonObject.getString(key));
                    }
                }
            }
        }
        return elements;
    }
}
