package com.ejianc.foundation.apigateway.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.apigateway.bean.GroupEntity;
import com.ejianc.foundation.apigateway.mapper.GroupMapper;
import com.ejianc.foundation.apigateway.service.IGroupService;
import com.ejianc.foundation.apigateway.vo.GroupVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class GroupServiceImpl extends BaseServiceImpl<GroupMapper, GroupEntity> implements IGroupService {

	@Autowired
	private GroupMapper groupMapper;
	
	@Override
	public GroupEntity queryDetail(Long id) {
		GroupEntity entity = groupMapper.selectById(id);
		return entity;
	}

	@Override
	public List<GroupVO> queyrListByPid(Long parentId) {
		QueryWrapper<GroupEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("parent_id", parentId);
		wrapper.eq("dr", 0);
		List<GroupEntity> dataList = groupMapper.selectList(wrapper);
		if(dataList != null && dataList.size() > 0) {
			return BeanMapper.mapList(dataList, GroupVO.class);
		}
		return null;
	}

	@Override
	public void delete(Long id) {
		groupMapper.deleteById(id);
	}

}
