package com.ejianc.foundation.oms.service.impl;

import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.http.conn.ConnectTimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.oms.bean.TryoutEntity;
import com.ejianc.foundation.oms.mapper.TryoutMapper;
import com.ejianc.foundation.oms.service.ITryoutService;
import com.ejianc.foundation.oms.vo.TryoutVO;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.JobVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.bean.RoleEntity;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.pm.encoder.PasswordEncoder;
import com.ejianc.foundation.usercenter.pm.encoder.UsernameSaltPasswordEncoder;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.PinYinUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;

@Service
public class TryoutServiceImpl extends BaseServiceImpl<TryoutMapper, TryoutEntity> implements ITryoutService {
	
	@Autowired
	private IUserService userService;
	@Autowired
	private IOrgService orgService;
	@Autowired
	private IEmployeeService employeeService;
    @Autowired
    private IJobService jobService;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IRoleUserRelationService roleUserRelationService;
    @Autowired
    private EnvironmentTools environmentTools;
    
	@Override
	public void saveTryout(TryoutVO tryoutVo) {
		TryoutEntity entity = BeanMapper.map(tryoutVo, TryoutEntity.class);
		if(entity.getId()==null){
			entity.setId(IdWorker.getId());
		}
		this.saveOrUpdate(entity, false);
	}

	@SuppressWarnings("unchecked")
	@Override
	public CommonResponse<String> assignUser(TryoutVO tryoutVO) {
		//查询试用租户的组织
		Long tenantId = 888888l;
		
		OrgVO orgVO = orgService.findOrgByTenantId(tenantId);
		Long orgId = orgVO.getId();
		UserVO userVO = new UserVO();
		userVO.setTenantId(tenantId);
		userVO.setOrgId(orgId);
		userVO.setUserName(tryoutVO.getUserName());
		String code = "sy_" + PinYinUtil.getEachFirstSpell(tryoutVO.getEnterpriseName().replace("有限", "").replace("公司", "").replace("责任", ""));
		//根据code查询用户是否存在
		boolean flag = true;
		Integer i = 1;
		while (flag){
			QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("dr", 0);
			queryWrapper.eq("user_code", code);
			List<UserEntity> list = userService.list(queryWrapper);
			if(list!=null&&list.size()>0){
				if(i==1){
					code += i;
				}else{
					Integer j = i-1;
					code = code.replace((j).toString(), i.toString());
				}
				i++;
			}else{
				flag = false;
				break;
			}
		}
		userVO.setUserCode(code);
		PasswordUtils.setSalt(userVO);
        PasswordEncoder encoder = new UsernameSaltPasswordEncoder(code, userVO.getSalt());
        String encryptedPassword = encoder.encode(code);
		userVO.setPassword(encryptedPassword);
		userVO.setUserState(1);
		userVO.setTypeId(2);
		userVO.setPwdStartTime(new Date());
		userVO.setRegistTime(new Date());
		UserEntity userEntity = BeanMapper.map(userVO, UserEntity.class);
		//生成用户信息
		userService.saveOrUpdate(userEntity , false);

		EmployeeVO employeeVO = new EmployeeVO();
		employeeVO.setName(userEntity.getUserName());
		employeeVO.setCode("SY-"+userEntity.getId());
		employeeVO.setEmployeeType(1);
		employeeVO.setSex(1);
		employeeVO.setMobilePhone(userEntity.getUserMobile());
		employeeVO.setOrgName(orgVO.getName());
		employeeVO.setOrgId(orgId);
		employeeVO.setTenantId(tenantId);
		employeeVO.setState(1);
        employeeVO.setDr(BaseVO.DR_UNDELETE);
        employeeVO.setUserId(userEntity.getId());
        employeeVO.setId(userEntity.getId()); //将用户Id和人员Id设置为同一值
        employeeVO.setSequence(1);
        employeeVO.setWorkTime(new Date());
        EmployeeEntity dbEntity = BeanMapper.map(employeeVO, EmployeeEntity.class);
        //生成人员信息
        employeeService.saveOrUpdate(dbEntity,false);

        JobEntity jobVO = new JobEntity();
        // 属性类型：主职
        jobVO.setProperty(JobVO.JOB_TYPE_MAIN);
        jobVO.setEmployeeId(employeeVO.getId());
        // 新的工作记录
        jobVO.setCurState(JobVO.STATE_ACTIVE);
        jobVO.setJobStartTime(employeeVO.getWorkTime());
        jobVO.setOrgId(employeeVO.getOrgId());
        jobVO.setDeptId(employeeVO.getDeptId());
        jobVO.setPostId(employeeVO.getPostId());
        jobVO.setDr(BaseVO.DR_UNDELETE);
        jobVO.setTenantId(employeeVO.getTenantId());
        jobService.saveOrUpdate(jobVO, false);
        
        //同步用户id、code到试用表
        TryoutEntity tryoutEntity = this.getById(tryoutVO.getId());
        tryoutEntity.setUserCode(userEntity.getUserCode());
        tryoutEntity.setUserId(userEntity.getId());
        this.saveOrUpdate(tryoutEntity,false);
        
		//生成默认的套餐关系
        QueryWrapper<RoleEntity> roleWrapper = new QueryWrapper<>();
        roleWrapper.eq("dr", 0);
        roleWrapper.eq("code", "SY-ROLE");
        roleWrapper.eq("tenant_id", tenantId);
        RoleEntity roleEntity = roleService.getOne(roleWrapper);
        if(roleEntity!=null){
			//授权角色用户关系
			List<RoleUserRelationVO> data = new ArrayList<>();
			RoleUserRelationVO roleUserRelationVO = new RoleUserRelationVO();
			roleUserRelationVO.setAuthOrgId(orgId);
			roleUserRelationVO.setEmployeeId(employeeVO.getId());
			roleUserRelationVO.setJobId(jobVO.getId());
			roleUserRelationVO.setProperty(String.valueOf(employeeVO.getJobType()));
			roleUserRelationVO.setRoleId(roleEntity.getId());
			roleUserRelationVO.setUserId(userEntity.getId());
			roleUserRelationVO.setTenantId(tenantId);
			data.add(roleUserRelationVO);
			roleUserRelationService.saveRoleUser(data);
        }
        
        JSONObject messageParam = new JSONObject();
		messageParam.put("phone", tryoutVO.getPhone());
		messageParam.put("templateCode", "SMS_199774063");
		
		JSONObject params = new JSONObject();
		params.put("userName", code);
		params.put("userPassword", code);
		messageParam.put("params", params);
		
		String messageUrl = environmentTools.getBaseHost() + "ejc-message-web/no_auth/sms/sendMessage";
		try {
			String responseStr = HttpTookit.postByJson(messageUrl, JSON.toJSONString(messageParam));
			CommonResponse<String> response = JSON.parseObject(responseStr, CommonResponse.class);
			if(response.isSuccess()) {
				return CommonResponse.success("分配账户成功,并已发送短信");
			}
		} catch (ConnectTimeoutException e) {
			e.printStackTrace();
		} catch (SocketTimeoutException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	       
		return CommonResponse.success("分配账户成功");
	}

	@Override
	public CommonResponse<String> frozen(Long id) {
		TryoutEntity entity = this.getById(id);
		entity.setTryoutState("1");//冻结
		this.saveOrUpdate(entity,false);
		//停用账户
		EmployeeVO vo = employeeService.queryEmployeeByUserId(entity.getUserId());
		vo.setState(0);//停用
		employeeService.enabledEmployeeState(vo);
		return CommonResponse.success("冻结账户成功");
	}

	@Override
	public CommonResponse<String> recovery(Long id) {
		TryoutEntity entity = this.getById(id);
		entity.setTryoutState(null);//恢复
		this.saveOrUpdate(entity,false);
		//恢复账户
		EmployeeVO vo = employeeService.queryEmployeeByUserId(entity.getUserId());
		vo.setState(1);//启用
		employeeService.enabledEmployeeState(vo);
		return CommonResponse.success("恢复账户成功");
	}
	
}
