package com.ejianc.foundation.orgcenter.bean;

import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 组织bean
 * 
 * @author guominga
 */
@TableName("ejc_idm_org")
public class OrgEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "enterprise_id")
	private Long enterpriseId; // 企业ID

	@TableField(value = "parent_id")
	private Long parentId; // 父ID

	@TableField(value = "code")
	private String code; // 组织编号

	@TableField(value = "name")
	private String name; // 组织名称

	@TableField(value = "short_name")
	private String shortName; // 组织简称

	@TableField(value = "org_type")
	private Integer orgType; // 组织类型(1：集团 ， 2：分（子）公司，3：经理部，4：虚拟组织，5：项目部)

	@TableField(value = "manager")
	private String manager; // 负责人

	@TableField(value = "phone")
	private String phone; // 联系电话

	@TableField(value = "note")
	private String note; // 备注

	@TableField(value = "inner_code")
	private String innerCode; // 组织内码

	@TableField(value = "state")
	private Integer state; // 状态标识（1：启用，0：停用）

	@TableField(value = "sequence")
	private Integer sequence; // 排序

	@TableField(value = "source_id")
	private String sourceId; // 来源组织id

	@TableField(value = "system_id")
	private String systemId; // 系统id

	@TableField(value = "project_code")
	private String projectCode; // 项目部组织对应的项目档案编码，目前云南建投使用

	@TableField(value = "project_state")
	private Integer projectState; // 项目状态（1：在建项目， 2：全部项目）

	@TableField(exist = false)
	private List<OrgEntity> children;

	public Long getEnterpriseId() {
		return enterpriseId;
	}

	public void setEnterpriseId(Long enterpriseId) {
		this.enterpriseId = enterpriseId;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public Integer getOrgType() {
		return orgType;
	}

	public void setOrgType(Integer orgType) {
		this.orgType = orgType;
	}

	public String getManager() {
		return manager;
	}

	public void setManager(String manager) {
		this.manager = manager;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public String getInnerCode() {
		return innerCode;
	}

	public void setInnerCode(String innerCode) {
		this.innerCode = innerCode;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public Integer getProjectState() {
		return projectState;
	}

	public void setProjectState(Integer projectState) {
		this.projectState = projectState;
	}

	public List<OrgEntity> getChildren() {
		return children;
	}

	public void setChildren(List<OrgEntity> children) {
		this.children = children;
	}

}
