package com.ejianc.foundation.orgcenter.service;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.vo.JobVO;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 任职service
 * 
 * @author guominga
 *
 */
public interface IJobService extends IBaseService<JobEntity> {

    /**
     * 根据人员主键Id获取到人员当前的主职工作记录
     *
     * @param employeeId
     * @return
     */
    JobEntity getCurMainJob(Long employeeId);

    /**
     * 根据人员主键Id获取到人员所属租户主职工作记录
     *
     * @param employeeId
     * @return
     */
    JobEntity getMainJob(Long employeeId,Long tenantId);

    /**
     * 根据主键Id查询对应的任职记录
     *
     * @param id
     * @return
     */
    JobEntity getById(Long id);

    /**
     * 批量查询指定人员的主职信息
     *
     * @param employeeIds
     * @param isAll 是否包含未启用的主职信息，true-包含，false-不包含
     * @return
     */
    List<JobEntity> getEmployeesMainJob(List<Long> employeeIds, boolean isAll);

    /**
     * 查询人员的所有任职信息
     * 
     * @param emplmoyeeId
     * @return
     */
	List<JobVO> queryAllJobByEmployeeId(Long emplmoyeeId,Long tenantId);

    /**
     * 查询人员的兼职任职信息
     *
     * @param employeeId
     * @return
     */
	List<JobVO> queryPartJobsByEmployeeId(Long employeeId,Long tenantId);

    /**
     * 查询 组织下的人员
     *
     * @param orgId
     * @return
     */
	List<JobVO> queryJobsByOrgId(Long orgId);

    /**
     * 将指定人员的所有任职记录修改为指定的状态
     *  停用时，将该人员所有兼职记录执行注销操作，主职改为停用状态
     *
     * @param employeeId
     * @param curState
     */
    void updateStateByEmpId(Long employeeId, Integer curState);

    /**
     * 根据人员ID删除所有的任职信息
     * 
     * @param employeeId
     */
	void deleteAllByEmployeeId(Long employeeId);

	/**
	 * 根据人员ID删除所有的兼职信息
	 * 
	 * @param employeeId
	 */
	void deleteAllPartJobByEmployeeId(Long employeeId);

	/**
	 * 将原先的部门负责人置空
	 * 
	 */
	void updateDeptHeadNoByDeptId(Long deptId);

	Long queryDeptUserCount( Long deptId,
							 Long orgId,
							 String searchText);

	List<JSONObject> queryDeptUser( Long deptId,
								    Long orgId,
								    String searchText,
								    int startLine,
								    int pageSize);
}
