package com.ejianc.foundation.permission.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.permission.bean.AppConfigureEntity;
import com.ejianc.foundation.permission.bean.AppEntity;
import com.ejianc.foundation.permission.mapper.AppConfigureMapper;
import com.ejianc.foundation.permission.mapper.AppMapper;
import com.ejianc.foundation.permission.service.IAppConfigureService;
import com.ejianc.foundation.permission.vo.AppConfigureVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class AppConfigureServiceImpl extends BaseServiceImpl<AppConfigureMapper, AppConfigureEntity> implements IAppConfigureService {

	@Value("${oms.tenantid}")
	private Long omsTenantid;
	
	@Autowired
	private AppConfigureMapper appConfigureMapper;
	@Autowired
	private AppMapper appMapper;

	@Override
	public List<AppConfigureVO> queryAppConfigureList(Long appId) {
		QueryWrapper<AppConfigureEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("app_id", appId);
		queryWrapper.eq("dr", 0);
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		List<AppConfigureEntity> entitys = this.list(queryWrapper);
		List<AppConfigureVO> list = BeanMapper.mapList(entitys, AppConfigureVO.class);
		return list;
	}

	@Override
	public CommonResponse<String> saveAppConfigure(List<AppConfigureVO> appConfigureVOs) {
		List<AppConfigureEntity> saveList = new ArrayList<>();
		List<Long> delIds = new ArrayList<>();
		appConfigureVOs.forEach(vo -> {
			if("del".equals(vo.getRowState())){
				delIds.add(vo.getId());
			}else{
				saveList.add(BeanMapper.map(vo, AppConfigureEntity.class));
			}
		});
		if(delIds!=null&&delIds.size()>0){
			this.removeByIds(delIds, false);
		}
		if(saveList!=null&&saveList.size()>0){
			this.saveOrUpdateBatch(saveList, saveList.size(), false);
		}
		return CommonResponse.success("保存成功");
	}

	@Override
	public Map<String, String> queryConfigByAppCode(String appcode) {
		Map<String, String> resultMap = new HashMap<String, String>();
		
		QueryWrapper<AppEntity> appWrapper = new QueryWrapper<>();
		appWrapper.eq("code", appcode);
		AppEntity appEntity = appMapper.selectOne(appWrapper);
		if(appEntity != null) {
			QueryWrapper<AppConfigureEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("app_id", appEntity.getId());
			queryWrapper.eq("dr", 0);
			queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
			List<AppConfigureEntity> entitys = this.list(queryWrapper);
			if(entitys != null && entitys.size() > 0) {
				for(AppConfigureEntity entity:entitys) {
					resultMap.put(entity.getKeyName(), entity.getKeyValue());
				}
			}
		}
		return resultMap;
	}
	
}
