package com.ejianc.foundation.usercenter.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.vo.FaceReviewVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.usercenter.bean.FaceReviewEntity;
import com.ejianc.foundation.usercenter.mapper.FaceReviewMapper;
import com.ejianc.foundation.usercenter.service.IFaceReviewService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.*;

@Service
public class FaceReviewServiceImpl extends BaseServiceImpl<FaceReviewMapper, FaceReviewEntity> implements IFaceReviewService {

    @Autowired
    private FaceReviewMapper faceReviewMapper;
    @Autowired
    private IUserService userService;
    @Autowired
    private IOrgService orgService;

    @Override
    public IPage<FaceReviewVO> queryData(QueryParam param) {
        IPage<FaceReviewVO> page = new Page<>(param.getPageIndex(),param.getPageSize());
        Map<String,Object> params = new HashMap<>();
        Integer pn = param.getPageIndex();
        pn = pn - 1 < 0 ? 1 : pn;
        long startLine = (pn - 1) * param.getPageSize();
        params.put("pageIndex", pn);
        params.put("pageSize", param.getPageSize());
        params.put("startLine", startLine);
        Map<String, Parameter> pa = param.getParams();
        if(pa!=null){
            for(String key : pa.keySet()){
                params.put(key, pa.get(key).getValue());
            }
        }
        OrgVO orgVo = orgService.queryDetail(InvocationInfoProxy.getOrgId());
        if(orgVo != null) {
            params.put("innerCode", orgVo.getInnerCode());
        }
        LinkedHashMap<String, String> order = param.getOrderMap();
        if(order!=null){
            String orderSql = "";
            for(String key : order.keySet()){
                if(orderSql!=""){
                    orderSql += ("," + key + " " + order.get(key));
                }else{
                    orderSql += (key + " " + order.get(key));
                }
            }
            params.put("orderSql", orderSql);
        }
        if(StringUtils.isNotBlank(param.getSearchText())){
            params.put("searchText", param.getSearchText());
        }
        long total = faceReviewMapper.countData(params);
        page.setTotal(total);
        if(total == 0) {
            page.setRecords(new ArrayList<>());
            return page;
        }
        List<FaceReviewVO> voList = faceReviewMapper.queryData(params);
        page.setRecords(voList);
        return page;
    }

    @Override
    public List<FaceReviewVO> queryLastDetail(Long userid) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return faceReviewMapper.queryLastDetail(userid, tenantId);
    }

    @Override
    public FaceReviewVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return faceReviewMapper.queryDetail(id, tenantId);
    }

    @Override
    public FaceReviewVO saveData(FaceReviewVO saveOrUpdateVO) {
        FaceReviewEntity entity = BeanMapper.map(saveOrUpdateVO, FaceReviewEntity.class);
        if(entity.getAuditStatus() == 2){
            //认证通过，修改人员
            UserEntity userEntity = userService.getById(entity.getUserId());
            userEntity.setFaceSignature(userEntity.getId().toString());
            userEntity.setFaceImg(entity.getFaceImg());
            userService.saveOrUpdate(userEntity,false);
        }else if(entity.getAuditStatus() == 3){
            FaceReviewEntity oldEntity = this.selectById(entity.getId());
            if(oldEntity.getAuditStatus()!=null&&oldEntity.getAuditStatus() == 2){
                //审批通过的需要将原先用户的认证信息清除
                UserEntity userEntity = userService.getById(entity.getUserId());
                userEntity.setFaceSignature(null);
                userEntity.setFaceImg(null);
                userService.saveOrUpdate(userEntity,false);
            }
        }
        this.saveOrUpdate(entity, false);
        FaceReviewVO vo = BeanMapper.map(entity, FaceReviewVO.class);
        return vo;
    }
}
