package com.ejianc.foundation.apply.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.apply.vo.EnterpriseAppRelationVO;
import com.ejianc.foundation.apply.vo.UserJoinEnterpriseApplyVO;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.foundation.apply.bean.UserJoinEnterpriseApplyEntity;

import java.util.List;
import java.util.Map;

/**
 * 用户加入企业申请单
 * 
 * @author generator
 * 
 */
public interface IUserJoinEnterpriseApplyService extends IBaseService<UserJoinEnterpriseApplyEntity> {

    IPage<EnterpriseAppRelationVO> pageList(Map<String, Object> params);

    /**
     * 审核
     * @param id
     * @param state
     */
    void updateExamine(Long id, String state);

    /**
     * 根据用户id查询企业申请表数据
     * @param userId
     * @return
     */
    List<UserJoinEnterpriseApplyEntity> queryListByUserId(Long userId);

    /**
     * 发送信息
     * @param entity
     */
    void sendMessage(EnterpriseVO enterpriseVO, UserJoinEnterpriseApplyEntity entity);

    /**
     * 验证保存
     * @param userId
     * @param enterpriseId
     * @return
     */
    UserJoinEnterpriseApplyEntity checkSaveOrUpdate(Long userId, Long enterpriseId);
}
