package com.ejianc.foundation.apigateway.service;

import java.util.List;

import com.ejianc.foundation.apigateway.bean.ServInfoEntity;
import com.ejianc.foundation.apigateway.vo.ServInfoVO;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IServInfoService extends IBaseService<ServInfoEntity> {

	/**
	 * 根据分组Id查询其服务列表
	 * 
	 * @param groupId
	 * @return
	 */
	List<ServInfoVO> queryListByGroupId(Long groupId);

	/**
	 * 根据主键ID查询详情
	 * 
	 * @param id
	 * @return
	 */
	ServInfoEntity queryDetail(Long id);

	/**
	 * 根据ids删除数据
	 * 
	 * @param ids
	 */
	void deleteServInfo(List<Long> ids);

	/**
	 * 刷新服务进缓存
	 */
	void refreshServInfoCache();

	/**
	 * 增加或修改数据
	 * 
	 * @param uniqueBean
	 */
	void saveOrUpdateBean(ServInfoEntity uniqueBean);

}
