package com.ejianc.foundation.helpcenter.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.helpcenter.bean.ScDocEntity;
import com.ejianc.foundation.helpcenter.bean.ScGroupEntity;
import com.ejianc.foundation.helpcenter.mapper.ScDocMapper;
import com.ejianc.foundation.helpcenter.mapper.ScGroupMapper;
import com.ejianc.foundation.helpcenter.service.IScDocService;
import com.ejianc.foundation.helpcenter.vo.ScDocVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class ScDocServiceImpl extends BaseServiceImpl<ScDocMapper, ScDocEntity> implements IScDocService {

	@Autowired
	private ScDocMapper scDocMapper;
	@Autowired
	private ScGroupMapper scGroupMapper;
	
	@Override
	public List<ScDocEntity> queryListByGroupId(Long groupId) {
		QueryWrapper<ScDocEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("group_id", groupId);
		List<ScDocEntity> resultList = super.list(queryWrapper);
		return resultList;
	}

	@Override
	public IPage<ScDocVO> queryScDocPage(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			if("groupId".equals(entry.getKey())) {
				Parameter parameter = entry.getValue();
				if(StringUtils.isBlank(parameter.getValue()+"")) {
					continue;
				}
				ScGroupEntity scGroupEntity = scGroupMapper.selectById(parameter.getValue()+"");
				if(scGroupEntity != null) {
					condition.put("innerCode", scGroupEntity.getInnerCode());
				}
			}else{
				condition.put(entry.getKey(), entry.getValue().getValue());
			}
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());

		List<ScDocVO> records = scDocMapper.queryList(condition);
		Long count = scDocMapper.queryCount(condition);
		for(ScDocVO vo : records){
			vo.setIntro(null);
		}
		IPage<ScDocVO> page = new Page<>();
		page.setCurrent(queryParam.getPageIndex());
		page.setSize(queryParam.getPageSize());
		page.setTotal(count);
		page.setRecords(BeanMapper.mapList(records, ScDocVO.class));
		return page;
	}

	@Override
	public List<ScDocVO> queryScDocListByInnercode(String innerCode) {
		List<ScDocVO> scDocVos = scDocMapper.queryScDocListByInnercode(innerCode);
		return scDocVos;
	}

	@Override
	public List<ScDocVO> queryDocListBySearch(String searchText) {
		List<ScDocVO> scDocVos = scDocMapper.queryDocListBySearch(searchText);
		return scDocVos;
	}

}
