package com.ejianc.foundation.news.bean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 公告表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_idm_gonggao")
public class GonggaoEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 编号
    @TableField(value="name")
    private String name; // 标题
    @TableField(value="notice_type")
    private String noticeType; // 公告类型
    @TableField(value="notice_way")
    private String noticeWay; // 提醒方式
    @TableField(value="notice_scope")
    private String noticeScope; // 可见范围
    @TableField(value="notice_scope_tenant_ids")
    private String noticeScopeTenantIds; // 可见范围租户id
    @TableField(value="notice_abstract")
    private String noticeAbstract; // 摘要
    @TableField(value="public_way")
    private String publicWay; // 发布方式
    @TableField(value="public_time")
    private Date publicTime; // 发布时间
    @TableField(value="public_status")
    private String publicStatus; // 发布状态
    @TableField(value="notice_end_time")
    private Date noticeEndTime; // 弹窗提醒截止时间
    @TableField(value="content")
    private String content; // 内容
    @TableField(value="tenant_show")
    private Boolean tenantShow; // 租户公告列表是否显示

    @TableField(exist=false)
    @SubEntity(serviceName="gonggaoSubService")
    List<GonggaoSubEntity> tenants = new ArrayList<>();

    public List<GonggaoSubEntity> getTenants() {
        return tenants;
    }

    public void setTenants(List<GonggaoSubEntity> tenants) {
        this.tenants = tenants;
    }

    public Boolean getTenantShow() {
        return tenantShow;
    }

    public void setTenantShow(Boolean tenantShow) {
        this.tenantShow = tenantShow;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getNoticeType() {
        return noticeType;
    }

    public void setNoticeType(String noticeType) {
        this.noticeType = noticeType;
    }
    public String getNoticeWay() {
        return noticeWay;
    }

    public void setNoticeWay(String noticeWay) {
        this.noticeWay = noticeWay;
    }
    public String getNoticeScope() {
        return noticeScope;
    }

    public void setNoticeScope(String noticeScope) {
        this.noticeScope = noticeScope;
    }
    public String getNoticeScopeTenantIds() {
        return noticeScopeTenantIds;
    }

    public void setNoticeScopeTenantIds(String noticeScopeTenantIds) {
        this.noticeScopeTenantIds = noticeScopeTenantIds;
    }
    public String getNoticeAbstract() {
        return noticeAbstract;
    }

    public void setNoticeAbstract(String noticeAbstract) {
        this.noticeAbstract = noticeAbstract;
    }
    public String getPublicWay() {
        return publicWay;
    }

    public void setPublicWay(String publicWay) {
        this.publicWay = publicWay;
    }
    public Date getPublicTime() {
        return publicTime;
    }

    public void setPublicTime(Date publicTime) {
        this.publicTime = publicTime;
    }
    public String getPublicStatus() {
        return publicStatus;
    }

    public void setPublicStatus(String publicStatus) {
        this.publicStatus = publicStatus;
    }
    public Date getNoticeEndTime() {
        return noticeEndTime;
    }

    public void setNoticeEndTime(Date noticeEndTime) {
        this.noticeEndTime = noticeEndTime;
    }
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
    
}
