package com.ejianc.foundation.usercenter.service.impl;

import java.util.List;

import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.usercenter.bean.PwdHistoryEntity;
import com.ejianc.foundation.usercenter.mapper.PwdHistoryMapper;
import com.ejianc.foundation.usercenter.service.IPwdHistoryService;
import com.ejianc.foundation.usercenter.vo.PwdHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class PwdHistoryServiceImpl extends BaseServiceImpl<PwdHistoryMapper, PwdHistoryEntity> implements IPwdHistoryService {

	@Override
	public Boolean isUsedAtLastest(Long userId, String password) {
		QueryWrapper<PwdHistoryEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("user_id", userId);
		queryWrapper.orderByDesc("used_pwd_time");
		List<PwdHistoryEntity> pwdHistoryList = this.list(queryWrapper);
		if(pwdHistoryList != null) {
            return password.equals(pwdHistoryList.get(0).getUsedPassword());
		}
		return false;
	}

	@Override
	public void insert(PwdHistoryVO pwdHistoryVO) {
		if(pwdHistoryVO != null) {
			PwdHistoryEntity entity = BeanMapper.map(pwdHistoryVO, PwdHistoryEntity.class);
			this.save(entity);
		}
	}

}
