package com.ejianc.foundation.weixinpay.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 微信订单发票抬头信息
 * 
 */
@TableName("ejc_idm_weixinpay_invoice")
public class WeixinpayInvoiceEntity extends BaseEntity {

	private static final long serialVersionUID = 4965615188065927421L;

	@TableField(value = "code")
	private String code; // 编码

	@TableField(value = "invoice_type")
	private String invoiceType; // 发票类型

	@TableField(value = "express_no")
	private String expressNo; // 快递单号

	@TableField(value = "money")
	private BigDecimal money; // 金额

	@TableField(value = "invoice_header_id")
	private Long invoiceHeaderId; // 发票抬头id

	@TableField(value = "reason")
	private String reason; // 原因

	@TableField(value = "invoice_state")
	private String invoiceState; // 发票状态

	@TableField(exist=false)
	@SubEntity(serviceName="weixinpayInvoiceOrderService", pidName="invoiceId")
	private List<WeixinpayInvoiceOrderEntity> orderList = new ArrayList<>(); //

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public BigDecimal getMoney() {
		return money;
	}

	public void setMoney(BigDecimal money) {
		this.money = money;
	}

	public Long getInvoiceHeaderId() {
		return invoiceHeaderId;
	}

	public void setInvoiceHeaderId(Long invoiceHeaderId) {
		this.invoiceHeaderId = invoiceHeaderId;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public String getInvoiceType() {
		return invoiceType;
	}

	public void setInvoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
	}

	public String getExpressNo() {
		return expressNo;
	}

	public void setExpressNo(String expressNo) {
		this.expressNo = expressNo;
	}

	public String getInvoiceState() {
		return invoiceState;
	}

	public void setInvoiceState(String invoiceState) {
		this.invoiceState = invoiceState;
	}

	public List<WeixinpayInvoiceOrderEntity> getOrderList() {
		return orderList;
	}

	public void setOrderList(List<WeixinpayInvoiceOrderEntity> orderList) {
		this.orderList = orderList;
	}
}
