/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.apply.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.apply.bean.UserJoinEnterpriseApplyEntity;
import com.ejianc.foundation.apply.mapper.UserJoinEnterpriseApplyMapper;
import com.ejianc.foundation.apply.service.IUserJoinEnterpriseApplyService;
import com.ejianc.foundation.apply.vo.EnterpriseAppRelationVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userJoinEnterpriseApplyService")
public class UserJoinEnterpriseApplyServiceImpl
extends BaseServiceImpl<UserJoinEnterpriseApplyMapper, UserJoinEnterpriseApplyEntity>
implements IUserJoinEnterpriseApplyService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IUserTenantRelationService userTenantRelationService;
    @Autowired
    private UserJoinEnterpriseApplyMapper userJoinEnterpriseApplyMapper;
    @Autowired
    private IJobService jobService;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private EnvironmentTools environmentTools;

    @Override
    public IPage<EnterpriseAppRelationVO> pageList(Map<String, Object> params) {
        List<Object> voList = new ArrayList();
        Page page = new Page();
        page.setCurrent((long)Integer.valueOf(params.get("pageIndex").toString()).intValue());
        page.setSize((long)Integer.valueOf(params.get("pageSize").toString()).intValue());
        long total = this.userJoinEnterpriseApplyMapper.count(params);
        page.setTotal(total);
        if (total == 0L) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1L ? 0L : page.getCurrent() - 1L) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        voList = this.userJoinEnterpriseApplyMapper.getList(params);
        page.setRecords(voList);
        return page;
    }

    @Override
    public void updateExamine(Long id, String state) {
        UserJoinEnterpriseApplyEntity enterpriseApplyEntity = (UserJoinEnterpriseApplyEntity)((Object)this.selectById(id));
        enterpriseApplyEntity.setState(state);
        if (state.equals("4")) {
            this.saveOrUpdateRelation(enterpriseApplyEntity);
        }
        this.saveOrUpdate((Object)enterpriseApplyEntity);
    }

    public void saveOrUpdateRelation(UserJoinEnterpriseApplyEntity enterpriseApplyEntity) {
        List<UserTenantRelationEntity> list = this.queryEnterpriseIdByUserIdList(enterpriseApplyEntity.getUserId(), enterpriseApplyEntity.getEnterpriseId());
        if (!CollectionUtil.isEmpty(list)) {
            throw new BusinessException("\u8be5\u7528\u6237\u5df2\u52a0\u5165\u4f01\u4e1a\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u52a0\u5165\uff01");
        }
        OrgVO orgVo = this.orgService.findOrgByTenantId(enterpriseApplyEntity.getTenantId());
        UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
        userTenantRelationEntity.setUserId(enterpriseApplyEntity.getUserId());
        userTenantRelationEntity.setTenantId(enterpriseApplyEntity.getTenantId());
        userTenantRelationEntity.setTypeId(2);
        userTenantRelationEntity.setMainSpaceFlag(0);
        userTenantRelationEntity.setState(1);
        userTenantRelationEntity.setOrgId(orgVo.getId());
        userTenantRelationEntity.setEmployeeId(enterpriseApplyEntity.getUserId());
        this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity);
        JobEntity jobEntity = new JobEntity();
        jobEntity.setEmployeeId(enterpriseApplyEntity.getUserId());
        jobEntity.setTenantId(enterpriseApplyEntity.getTenantId());
        jobEntity.setProperty(1);
        jobEntity.setJobStartTime(new Date());
        jobEntity.setOrgId(orgVo.getId());
        jobEntity.setCurState(0);
        this.jobService.saveOrUpdate((Object)jobEntity);
    }

    @Override
    public List<UserJoinEnterpriseApplyEntity> queryListByUserId(Long userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)userId);
        queryWrapper.eq((Object)"state", (Object)"4");
        return this.list((Wrapper)queryWrapper);
    }

    public List<UserTenantRelationEntity> queryEnterpriseIdByUserIdList(Long userId, Long enterpriseId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)userId);
        queryWrapper.eq((Object)"tenant_id", (Object)enterpriseId);
        queryWrapper.ne((Object)"type_id", (Object)1);
        return this.userTenantRelationService.list((Wrapper)queryWrapper);
    }

    @Override
    public void sendMessage(EnterpriseVO enterpriseVO, UserJoinEnterpriseApplyEntity entity) {
        block5: {
            try {
                String[] receivers = new String[]{enterpriseVO.getUserId().toString()};
                this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
                PushMsgParameter parameter = new PushMsgParameter();
                ArrayList<String> channel = new ArrayList<String>();
                channel.add("sys");
                parameter.setChannel(channel.toArray(new String[channel.size()]));
                parameter.setReceivers(receivers);
                parameter.setMsgType("notice");
                parameter.setSubject("\u60a8\u6536\u5230\u4e00\u6761\u4f01\u4e1a\u7533\u8bf7\u4fe1\u606f");
                String url = this.environmentTools.getBaseHost() + "ejc-idm-frontend/#/personnelManagement";
                parameter.setContent("\u60a8\u6536\u5230\u4e00\u6761\u4f01\u4e1a\u7533\u8bf7\u4fe1\u606f\u3002<a href=\"" + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
                parameter.setTenantId(String.valueOf(enterpriseVO.getTenantId()));
                parameter.setSendUserId(InvocationInfoProxy.getUserid());
                try {
                    CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                    if (result.isSuccess()) {
                        this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg() + "---");
                        break block5;
                    }
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
                catch (Exception e) {
                    this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public UserJoinEnterpriseApplyEntity checkSaveOrUpdate(Long userId, Long enterpriseId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)userId);
        queryWrapper.eq((Object)"enterprise_id", (Object)enterpriseId);
        queryWrapper.eq((Object)"state", (Object)2);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return (UserJoinEnterpriseApplyEntity)((Object)list.get(0));
        }
        return null;
    }
}

