/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.orgcenter.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.bean.PostEntity;
import com.ejianc.foundation.orgcenter.mapper.JobMapper;
import com.ejianc.foundation.orgcenter.mapper.PostMapper;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IPostService;
import com.ejianc.foundation.orgcenter.vo.PostUserVO;
import com.ejianc.foundation.orgcenter.vo.PostVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.BuilderException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="postService")
public class PostServiceImpl
extends BaseServiceImpl<PostMapper, PostEntity>
implements IPostService {
    private static final String POST_BILL_CODE = "IDM_POST";
    @Autowired
    private JobMapper jobMapper;
    @Autowired
    private IJobService jobService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${oms.tenantid}")
    private String BASE_TENANT_ID;
    @Autowired
    private PostMapper postMapper;

    @Override
    public void delete(List<Long> ids) {
        QueryWrapper jobQueryWrapper = new QueryWrapper();
        jobQueryWrapper.in((Object)"post_id", ids);
        List jobs = this.jobMapper.selectList((Wrapper)jobQueryWrapper);
        if (jobs != null && jobs.size() > 0) {
            throw new BusinessException("\u8981\u5220\u9664\u7684\u5c97\u4f4d\u4e2d\u5df2\u7ecf\u6709\u4eba\u5458\u4efb\u804c\u4e86\uff0c \u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        ((PostMapper)this.baseMapper).deleteBatchIds(ids);
    }

    @Override
    public PostVO queryDetail(Long id) throws Exception {
        PostVO vo = null;
        PostEntity e = (PostEntity)((Object)((PostMapper)this.baseMapper).selectById(id));
        if (null != e) {
            vo = (PostVO)BeanMapper.map((Object)((Object)e), PostVO.class);
        }
        return vo;
    }

    @Override
    public void save(PostVO postVo) throws Exception {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PostEntity saveData = null;
        if (null != postVo.getId()) {
            saveData = (PostEntity)((Object)((PostMapper)this.baseMapper).selectById(postVo.getId()));
            saveData.setNote(postVo.getNote());
            saveData.setName(postVo.getName());
            saveData.setSequence(postVo.getSequence());
            saveData.setState(postVo.getState());
            saveData.setPostDictId(postVo.getPostDictId());
        } else {
            CommonResponse postResponse = this.billCodeApi.getCodeBatchByRuleCode(POST_BILL_CODE, tenantId);
            if (!postResponse.isSuccess()) {
                throw new BuilderException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            postVo.setCode((String)postResponse.getData());
            postVo.setTenantId(tenantId);
            postVo.setType(Integer.valueOf(0));
            postVo.setDr(BaseVO.DR_UNDELETE);
            saveData = (PostEntity)((Object)BeanMapper.map((Object)postVo, PostEntity.class));
        }
        super.saveOrUpdate((Object)saveData);
    }

    @Override
    public void changeState(PostVO postVO) {
        PostEntity entity = (PostEntity)((Object)((PostMapper)this.baseMapper).selectById(postVO.getId()));
        if (null == entity) {
            throw new RuntimeException("\u4fee\u6539\u5c97\u4f4d\u72b6\u6001\u5931\u8d25\uff0c\u5c97\u4f4d\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        entity.setState(postVO.getState());
        super.saveOrUpdate((Object)entity);
    }

    @Override
    public PostEntity selectById(Long postId) {
        return (PostEntity)((Object)((PostMapper)this.baseMapper).selectById(postId));
    }

    @Override
    public List<PostEntity> getAllByIds(List<Long> postIds) {
        return ((PostMapper)this.baseMapper).selectBatchIds(postIds);
    }

    @Override
    public void changeType(PostVO postVO) {
        PostEntity entity = (PostEntity)((Object)((PostMapper)this.baseMapper).selectById(postVO.getId()));
        if (null == entity) {
            throw new RuntimeException("\u4fee\u6539\u5c97\u4f4d\u7c7b\u578b\u5931\u8d25\uff0c\u5c97\u4f4d\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        entity.setType(postVO.getType());
        super.saveOrUpdate((Object)entity);
    }

    @Override
    public void insertPostListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<PostVO> addList = this.postMapper.unSyncPostList(tenantId);
        if (!addList.isEmpty()) {
            CommonResponse codes = this.billCodeApi.getCodeBatchByRuleCode(POST_BILL_CODE, tenantId, addList.size());
            if (!codes.isSuccess()) {
                throw new RuntimeException("\u540c\u6b65\u5e73\u53f0\u5c97\u4f4d\u6863\u6848\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5c97\u4f4d\u7f16\u7801\u5931\u8d25\uff01");
            }
            List codeList = (List)codes.getData();
            for (int i = 0; i < codeList.size(); ++i) {
                addList.get(i).setCode((String)codeList.get(i));
            }
            super.saveOrUpdateBatch((Collection)BeanMapper.mapList(addList, PostEntity.class));
        }
    }

    @Override
    public Integer getCountByPostDictId(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"post_dict_id", (Object)id);
        queryWrapper.eq((Object)"dr", (Object)0);
        Integer count = this.postMapper.selectCount((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public IPage<PostUserVO> pagePostUserList(Map<String, Object> params) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        Long count = this.postMapper.countPostUserList(params);
        Page page = new Page();
        if (count > 0L) {
            List<PostUserVO> appVO = this.postMapper.queryPostUserList(params);
            page.setRecords(appVO);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }

    @Override
    public CommonResponse<String> savePostUser(List<PostUserVO> vos) {
        ArrayList<Long> jobIds = new ArrayList<Long>();
        Long postId = vos.get(0).getPostId();
        for (PostUserVO post : vos) {
            jobIds.add(post.getId());
        }
        List jonEntitys = (List)this.jobService.listByIds(jobIds);
        for (JobEntity job : jonEntitys) {
            job.setPostId(postId);
        }
        this.jobService.saveOrUpdateBatch(jonEntitys, jonEntitys.size(), false);
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> deletePostUser(List<Long> ids) {
        List jonEntitys = (List)this.jobService.listByIds(ids);
        for (JobEntity job : jonEntitys) {
            job.setPostId(null);
        }
        this.jobService.saveOrUpdateBatch(jonEntitys, jonEntitys.size(), false);
        return CommonResponse.success();
    }
}

