/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.permission.bean.AppConfigureEntity;
import com.ejianc.foundation.permission.bean.AppEntity;
import com.ejianc.foundation.permission.mapper.AppConfigureMapper;
import com.ejianc.foundation.permission.mapper.AppMapper;
import com.ejianc.foundation.permission.service.IAppConfigureService;
import com.ejianc.foundation.permission.vo.AppConfigureVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppConfigureServiceImpl
extends BaseServiceImpl<AppConfigureMapper, AppConfigureEntity>
implements IAppConfigureService {
    @Value(value="${oms.tenantid}")
    private Long omsTenantid;
    @Autowired
    private AppConfigureMapper appConfigureMapper;
    @Autowired
    private AppMapper appMapper;

    @Override
    public List<AppConfigureVO> queryAppConfigureList(Long appId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"app_id", (Object)appId);
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List entitys = this.list((Wrapper)queryWrapper);
        List list = BeanMapper.mapList((Iterable)entitys, AppConfigureVO.class);
        return list;
    }

    @Override
    public CommonResponse<String> saveAppConfigure(List<AppConfigureVO> appConfigureVOs) {
        ArrayList saveList = new ArrayList();
        ArrayList delIds = new ArrayList();
        appConfigureVOs.forEach(vo -> {
            if ("del".equals(vo.getRowState())) {
                delIds.add(vo.getId());
            } else {
                saveList.add(BeanMapper.map((Object)vo, AppConfigureEntity.class));
            }
        });
        if (delIds != null && delIds.size() > 0) {
            this.removeByIds(delIds, false);
        }
        if (saveList != null && saveList.size() > 0) {
            this.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public Map<String, String> queryConfigByAppCode(String appcode) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        QueryWrapper appWrapper = new QueryWrapper();
        appWrapper.eq((Object)"code", (Object)appcode);
        AppEntity appEntity = (AppEntity)((Object)this.appMapper.selectOne((Wrapper)appWrapper));
        if (appEntity != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"app_id", (Object)appEntity.getId());
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            List entitys = this.list((Wrapper)queryWrapper);
            if (entitys != null && entitys.size() > 0) {
                for (AppConfigureEntity entity : entitys) {
                    resultMap.put(entity.getKeyName(), entity.getKeyValue());
                }
            }
        }
        return resultMap;
    }
}

