package com.ejianc.foundation.sync.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.bean.DeptEntity;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.service.IDeptService;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.sync.service.ISyncService;
import com.ejianc.foundation.sync.vo.SyncEmployeeAndUserVO;
import com.ejianc.foundation.sync.vo.SyncOrgAndDeptVO;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;

@Service
public class SyncServiceImpl implements ISyncService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IOrgService orgService;
	
	@Autowired
	private IDeptService deptService;
	
	@Autowired
	private IEmployeeService employeeService;
	
	@Autowired
	private IUserService userService;
	
	@Autowired
	private IJobService jobService;

	//组织信息单条保存，保证组织信息保存在部门信息之前
	@Override
	public CommonResponse<String> syncOrgAndDeptList(List<SyncOrgAndDeptVO> orgAndDeptVOS) {
//		List<OrgVO> saveOrgList = new ArrayList<>();//保存组织
//		List<DeptVO> saveDeptList = new ArrayList<>();//保存部门
//		List<String> delDeptList = new ArrayList<>();//删除部门
		for(SyncOrgAndDeptVO syncVO : orgAndDeptVOS){
			try{
				if("org".equals(syncVO.getClassify())){
					OrgVO vo = syncVO.getOrg();
					if("3".equals(syncVO.getType())){
						//删除(删除执行停用操作)
						QueryWrapper<OrgEntity> queryWrapper = new QueryWrapper<>();
						queryWrapper.eq("dr", 0);
						queryWrapper.eq("source_id", vo.getSourceId());
						OrgEntity OrgEntity = orgService.getOne(queryWrapper);
						if(OrgEntity!=null){
							OrgEntity.setState(0);
							//必须单条保存.......
							orgService.saveOrUpdate(BeanMapper.map(vo, OrgEntity.class), false);
//							saveOrgList.add(BeanMapper.map(OrgEntity, OrgVO.class));
						}else{
							logger.info("删除组织失败，组织不存在------------------");
							logger.info(JSON.toJSONString(vo));
						}
						
					}else if("1".equals(syncVO.getType())){
						//新增
						QueryWrapper<OrgEntity> queryCheckWrapper = new QueryWrapper<>();
						queryCheckWrapper.eq("dr", 0);
						queryCheckWrapper.eq("source_id", vo.getSourceId());
						OrgEntity orgEntity = orgService.getOne(queryCheckWrapper, false);
						if(orgEntity!=null){
							logger.info("组织："+vo.getName()+"已存在");
							continue;
//							return CommonResponse.error("组织："+vo.getName()+"未查询到信息");
						}
						vo.setId(IdWorker.getId());
						//当pid不为空时，查询该pid对应的组织信息
						if(syncVO.getSourceOrgParentId()!=null){
							QueryWrapper<OrgEntity> queryWrapper = new QueryWrapper<>();
							queryWrapper.eq("dr", 0);
							queryWrapper.eq("source_id", syncVO.getSourceOrgParentId());
							OrgEntity OrgEntity = orgService.getOne(queryWrapper);
							vo.setInnerCode(OrgEntity.getInnerCode()+"|"+vo.getId());
							vo.setParentId(OrgEntity.getId());
						}
						vo.setState(1);
						//必须单条保存.......
						orgService.saveOrUpdate(BeanMapper.map(vo, OrgEntity.class), false);
//						saveOrgList.add(vo);
						logger.info("保存开始--------》》》"+vo.getName());
					}else {
						//保存
						QueryWrapper<OrgEntity> queryWrapper = new QueryWrapper<>();
						queryWrapper.eq("dr", 0);
						queryWrapper.eq("source_id", vo.getSourceId());
						OrgEntity orgEntity = orgService.getOne(queryWrapper, false);
						if(orgEntity==null){
							logger.info("组织："+vo.getName()+"未查询到信息");
							continue;
//							return CommonResponse.error("组织："+vo.getName()+"未查询到信息");
						}
						orgEntity.setCode(vo.getCode());
						orgEntity.setName(vo.getName());
						orgEntity.setSequence(vo.getSequence());
						orgEntity.setOrgType(vo.getOrgType());

						if(syncVO.getSourceOrgParentId()!=null){
							QueryWrapper<OrgEntity> queryOrgWrapper = new QueryWrapper<>();
							queryOrgWrapper.eq("dr", 0);
							queryOrgWrapper.eq("source_id", syncVO.getSourceOrgParentId());
							OrgEntity OrgEntity = orgService.getOne(queryOrgWrapper);
							vo.setInnerCode(OrgEntity.getInnerCode()+"|"+vo.getId());
							vo.setParentId(OrgEntity.getId());
						}else{
							orgEntity.setParentId(null);
							orgEntity.setInnerCode(null);
						}
						//必须单条保存.......
						orgService.saveOrUpdate(BeanMapper.map(vo, OrgEntity.class), false);
//						saveOrgList.add(BeanMapper.map(orgEntity, OrgVO.class));
					}
				}else{
					DeptVO vo = syncVO.getDept();
					if("3".equals(syncVO.getType())){
						//删除(删除执行)
//						delDeptList.add(vo.getSourceId());
						QueryWrapper<DeptEntity> delWrapper = new QueryWrapper<>();
						delWrapper.eq("dr", 0);
						delWrapper.eq("source_id", vo.getSourceId());
						deptService.remove(delWrapper, false);
					}else if("1".equals(syncVO.getType())){
						//新增
						QueryWrapper<DeptEntity> queryWrapper = new QueryWrapper<>();
						queryWrapper.eq("dr", 0);
						queryWrapper.eq("source_id", vo.getSourceId());
						DeptEntity deptEntity = deptService.getOne(queryWrapper, false);
						if(deptEntity!=null){
							logger.info("部门："+vo.getName()+"已存在");
							continue;
						}
						vo.setState(1);
						//查询部门的上级组织
						if(syncVO.getSourceDeptParentId()!=null){
							QueryWrapper<OrgEntity> queryOrgWrapper = new QueryWrapper<>();
							queryOrgWrapper.eq("dr", 0);
							queryOrgWrapper.eq("source_id", syncVO.getSourceDeptParentId());
							OrgEntity OrgEntity = orgService.getOne(queryOrgWrapper);
							vo.setOrgId(OrgEntity.getId());
						}
//						saveDeptList.add(vo);
						deptService.saveOrUpdate(BeanMapper.map(vo, DeptEntity.class), false);
					}else {
						//保存
						QueryWrapper<DeptEntity> queryWrapper = new QueryWrapper<>();
						queryWrapper.eq("dr", 0);
						queryWrapper.eq("source_id", vo.getSourceId());
						DeptEntity deptEntity = deptService.getOne(queryWrapper, false);
						if(deptEntity==null){
							logger.info("部门："+vo.getName()+"未查询到信息");
							continue;
						}
						//查询部门的上级组织
						if(syncVO.getSourceDeptParentId()!=null){
							QueryWrapper<OrgEntity> queryOrgWrapper = new QueryWrapper<>();
							queryOrgWrapper.eq("dr", 0);
							queryOrgWrapper.eq("source_id", syncVO.getSourceDeptParentId());
							OrgEntity OrgEntity = orgService.getOne(queryOrgWrapper);
							deptEntity.setOrgId(OrgEntity.getId());
						}
						deptEntity.setCode(vo.getCode());
						deptEntity.setName(vo.getName());
						deptEntity.setOrgId(vo.getOrgId());
						deptService.saveOrUpdate(deptEntity, false);
//						saveDeptList.add(BeanMapper.map(deptEntity, DeptVO.class));
					}
				}
			}catch (Exception e){
				logger.info("组织、部门信息同步失败--------------->");
				logger.info(JSON.toJSONString(syncVO));
			}
			
		}
		logger.info("组织、部门信息同步成功！！！！-------666--------");
		return CommonResponse.success("同步组织、部门信息成功！");
	}
	

	@Override
	public CommonResponse<String> syncEmployeeAndUserList(List<SyncEmployeeAndUserVO> employeeAndUserVOs) {
//		List<EmployeeVO> saveEmployeeList = new ArrayList<>();//保存
//		List<JobEntity> saveJobList = new ArrayList<>();//同步更新主职信息表
//		List<UserEntity> saveUserList = new ArrayList<>();//用户信息
//		System.out.println(JSON.parseArray(JSON.toJSONString(employeeAndUserVOs)));
		for(SyncEmployeeAndUserVO syncVO : employeeAndUserVOs){
			try{
				EmployeeVO employeeVo = syncVO.getEmployee();
				UserVO userVo = syncVO.getUser();
				logger.info("=================");
				logger.info(JSON.toJSONString(syncVO));
				if("3".equals(syncVO.getType())){
					//删除用户
					QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
					queryWrapper.eq("dr", 0);
					queryWrapper.eq("source_id", userVo.getSourceId());
					UserEntity userEntity = userService.getOne(queryWrapper);
					if(userEntity!=null){
						userEntity.setUserState(0);
						userService.saveOrUpdate(userEntity, false);
					}else{
						logger.info("删除用户失败------------------");
						logger.info(JSON.toJSONString(userVo));
					}
					
					//删除人员
					QueryWrapper<EmployeeEntity> queryEmployeeWrapper = new QueryWrapper<>();
					queryEmployeeWrapper.eq("dr", 0);
					queryEmployeeWrapper.eq("source_id", employeeVo.getSourceId());
					EmployeeEntity employeeEntity = employeeService.getOne(queryEmployeeWrapper);
					if(employeeEntity!=null){
						employeeEntity.setState(0);
						employeeService.saveOrUpdate(employeeEntity, false);
//							saveEmployeeList.add(BeanMapper.map(employeeEntity, EmployeeVO.class));
					}else{
						logger.info("删除用户失败------------------");
						logger.info(JSON.toJSONString(employeeVo));
					}
				}else if("1".equals(syncVO.getType())){
					QueryWrapper<UserEntity> queryUserWrapper = new QueryWrapper<>();
					queryUserWrapper.eq("dr", 0);
					queryUserWrapper.eq("source_id", userVo.getSourceId());
					UserEntity userCheckEntity = userService.getOne(queryUserWrapper);
					if(userCheckEntity!=null){
						logger.info("++++++++++");
						logger.info("人员："+userVo.getUserName()+"已存在");
						continue;
					}

					QueryWrapper<DeptEntity> queryWrapper = new QueryWrapper<>();
					queryWrapper.eq("dr", 0);
					queryWrapper.eq("source_id", syncVO.getSourceOrgId());
					DeptEntity deptEntity = deptService.getOne(queryWrapper);
					OrgEntity orgEntity = null;
					if(deptEntity == null) {
						QueryWrapper<OrgEntity> orgWrapper = new QueryWrapper<>();
						orgWrapper.eq("dr", 0);
						orgWrapper.eq("source_id", syncVO.getSourceOrgId());
						orgEntity = orgService.getOne(orgWrapper);
					}
					if(deptEntity != null) {
						userVo.setOrgId(deptEntity.getOrgId());
					}else{
						userVo.setOrgId(orgEntity != null ? orgEntity.getId():null);
					}
					
					Long pkId = IdWorker.getId();
					//新增用户
					userVo.setId(pkId);
					userVo.setTypeId(2); //普通用户
					userVo.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态
					userVo.setDr(BaseVO.DR_UNDELETE);
					//生成默认密码
					PasswordUtils.setSalt(userVo);
					String shaPassword = PasswordUtils.encodePasswordUsingSHA("sdbj_ejc_2020");
					userVo.setPassword(shaPassword);
					userVo.setPassword(PasswordUtils.encodebyUserCode(userVo));
					userVo.setPwdStartTime(new Date());
					UserEntity userEntity = BeanMapper.map(userVo, UserEntity.class);
					userService.saveOrUpdate(userEntity, false);
					
					//新增人员
					if(deptEntity != null) {
						employeeVo.setOrgId(deptEntity.getOrgId());
						employeeVo.setDeptId(deptEntity.getId());
					}else{
						employeeVo.setOrgId(orgEntity != null ? orgEntity.getId():null);
					}
					employeeVo.setId(pkId);
					employeeVo.setState(1);
					employeeVo.setEmployeeType(1);//在职
					employeeVo.setUserId(userEntity.getId());
					employeeVo.setUserId(pkId);
					EmployeeEntity employeeEntity = BeanMapper.map(employeeVo, EmployeeEntity.class);
					employeeService.saveOrUpdate(employeeEntity, false);
					
					//任职信息
					JobEntity job = new JobEntity();
					job.setOrgId(employeeVo.getOrgId());
					job.setDeptId(employeeVo.getDeptId());
					job.setEmployeeId(employeeVo.getId());
					job.setProperty(1);
					job.setJobStartTime(new Date());
					job.setCurState(0);
					job.setSystemId(employeeVo.getSystemId());
					jobService.saveOrUpdate(job,false);
					
				}else {
					QueryWrapper<DeptEntity> queryDeptWrapper = new QueryWrapper<>();
					queryDeptWrapper.eq("dr", 0);
					queryDeptWrapper.eq("source_id", syncVO.getSourceOrgId());
					DeptEntity deptEntity = deptService.getOne(queryDeptWrapper);
					OrgEntity orgEntity = null;
					if(deptEntity == null) {
						QueryWrapper<OrgEntity> orgWrapper = new QueryWrapper<>();
						orgWrapper.eq("dr", 0);
						orgWrapper.eq("source_id", syncVO.getSourceOrgId());
						orgEntity = orgService.getOne(orgWrapper);
					}
					if(deptEntity != null) {
						userVo.setOrgId(deptEntity.getOrgId());
					}else{
						userVo.setOrgId(orgEntity != null ? orgEntity.getId():null);
					}
					//保存用户
					QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
					queryWrapper.eq("dr", 0);
					queryWrapper.eq("source_id", userVo.getSourceId());
					UserEntity userEntity = userService.getOne(queryWrapper);
					if(userEntity==null){
						logger.info("人员："+userVo.getUserName()+"未查询到信息");
						continue;
//						throw new BusinessException("人员："+userVo.getUserName()+"未查询到信息");
					}
//							employeeEntity.setCode(vo.getCode());//若修改编码需要修改密码，
					userEntity.setUserName(userVo.getUserName());
					userEntity.setSex(Integer.valueOf(userVo.getSex()));
					userEntity.setRegistTime(userVo.getRegistTime());
					userEntity.setUserMobile(userVo.getUserMobile());
					userEntity.setUserEmail(userVo.getUserEmail());
					userEntity.setOrgId(userVo.getOrgId());
					userEntity.setQqId(userVo.getQqId());
					userService.saveOrUpdate(userEntity, false);					

					//新增人员
					if(deptEntity != null) {
						employeeVo.setOrgId(deptEntity.getOrgId());
						employeeVo.setDeptId(deptEntity.getId());
					}else{
						employeeVo.setOrgId(orgEntity != null ? orgEntity.getId():null);
					}
					//保存
					QueryWrapper<EmployeeEntity> queryEmployeeWrapper = new QueryWrapper<>();
					queryEmployeeWrapper.eq("dr", 0);
					queryEmployeeWrapper.eq("source_id", employeeVo.getSourceId());
					EmployeeEntity employeeEntity = employeeService.getOne(queryEmployeeWrapper);
					if(employeeEntity==null){
						logger.info("人员："+userVo.getUserName()+"未查询到信息");
						continue;
//						return CommonResponse.error("人员："+employeeVo.getName()+"未查询到信息");
					}
					List<JobEntity> saveJob = new ArrayList<>();//同步更新主职信息表
					if(((employeeVo.getOrgId()!=null&&employeeEntity.getOrgId()==null)||
						(employeeEntity.getOrgId()!=null&&employeeVo.getOrgId()==null)||
						(employeeVo.getOrgId()!=null&&employeeEntity.getOrgId()!=null&&!employeeVo.getOrgId().equals(employeeEntity.getOrgId())))||(
							(employeeVo.getDeptId()!=null&&employeeEntity.getDeptId()==null)||
							(employeeEntity.getDeptId()!=null&&employeeVo.getDeptId()==null)||
							(employeeVo.getDeptId()!=null&&employeeEntity.getDeptId()!=null&&!employeeVo.getDeptId().equals(employeeEntity.getDeptId()))
							)){
						//当用户的组织改变时，修改主职的信息(相当于调用)
						QueryWrapper<JobEntity> jobWrapper = new QueryWrapper<>();
						jobWrapper.eq("dr", 0);
						jobWrapper.eq("employee_id", employeeEntity.getId());
						jobWrapper.eq("property", 1);//主职
						jobWrapper.eq("cur_state", 0);//启用
						JobEntity jobEntity = jobService.getOne(jobWrapper, false);
						//将原先的主职信息停用掉
						if(jobEntity!=null){
							jobEntity.setCurState(1);
							jobEntity.setJobEndTime(new Date());
							saveJob.add(jobEntity);
						}
						//新增一条新的记录

						JobEntity jobNewEntity = new JobEntity();
						jobNewEntity.setOrgId(employeeVo.getOrgId());
						jobNewEntity.setDeptId(employeeVo.getDeptId());
						jobNewEntity.setEmployeeId(employeeEntity.getId());
						jobNewEntity.setProperty(1);
						jobNewEntity.setJobStartTime(new Date());
						jobNewEntity.setCurState(0);
						jobNewEntity.setSystemId(employeeVo.getSystemId());
						saveJob.add(jobNewEntity);
					}
					employeeEntity.setCode(employeeVo.getCode());
					employeeEntity.setName(employeeVo.getName());
					employeeEntity.setIdcard(employeeVo.getIdcard());
					employeeEntity.setBirthday(employeeVo.getBirthday());
					employeeEntity.setSex(employeeVo.getSex());
					employeeEntity.setWorkTime(employeeVo.getWorkTime());
					employeeEntity.setDeptId(employeeVo.getDeptId());
					employeeEntity.setMobilePhone(employeeVo.getMobilePhone());
					employeeEntity.setOtherPhone(employeeVo.getOtherPhone());
					employeeEntity.setOrgId(employeeVo.getOrgId());
//						saveEmployeeList.add(BeanMapper.map(employeeEntity, EmployeeVO.class));
					employeeService.saveOrUpdate(employeeEntity, false);
					if(saveJob.size()>0){
						//主职信息保存
						jobService.saveOrUpdateBatch(saveJob, saveJob.size(),false);
					}
				}
			}catch (Exception e){
				logger.info("人员、用户信息同步失败--------------->");
				logger.info(JSON.toJSONString(syncVO));
			}
			
		}
		return CommonResponse.success("保存人员、用户信息成功！");
	}
	
	
}
