package com.ejianc.foundation.weixinpay.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * 微信支付订单表
 * 
 */
public class WeixinpayOrderVO extends BaseVO {

	private static final long serialVersionUID = 4965615188065927421L;

	private String mchid; // 直连商户号

	private String orderNo; // 订单号

	private String type; // 业务类型

	private String typeName; // 业务类型

	private Integer num; // 开通条数

	private Integer money;// 支付金额（分）

	private BigDecimal moneyValue;// 支付金额（元）

	private String state; // 支付状态（SUCCESS：支付成功,REFUND：转入退款,NOTPAY：未支付,CLOSED：已关闭,REVOKED：已撤销（付款码支付）,USERPAYING：用户支付中（付款码支付）,PAYERROR：支付失败(其他原因，如银行返回失败)）

	private String invoiceState; // 发票状态

	public String getMchid() {
		return mchid;
	}

	public void setMchid(String mchid) {
		this.mchid = mchid;
	}

	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getNum() {
		return num;
	}

	public void setNum(Integer num) {
		this.num = num;
	}

	public Integer getMoney() {
		return money;
	}

	public void setMoney(Integer money) {
		this.money = money;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getInvoiceState() {
		return invoiceState;
	}

	public void setInvoiceState(String invoiceState) {
		this.invoiceState = invoiceState;
	}

	public String getTypeName() {
		if("all".equals(this.type)){
			return "发票识别与验真";
		}else if("invoiceIdentificationNum".equals(this.type)){
			return "发票识别";
		}else if("invoiceVerificationNum".equals(this.type)){
			return "发票验真";
		}
		return this.type;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public BigDecimal getMoneyValue() {
		moneyValue = new BigDecimal(0);
		if(money!=null){
			moneyValue = new BigDecimal(this.money).divide(new BigDecimal(100));
		}
		return moneyValue;
	}

	public void setMoneyValue(BigDecimal moneyValue) {
		this.moneyValue = moneyValue;
	}
}
