/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.tenant.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.initData.api.InitDataApi;
import com.ejianc.foundation.initData.api.InitShareDataApi;
import com.ejianc.foundation.initData.vo.EnterpriseInitVO;
import com.ejianc.foundation.oms.bean.ComboEntity;
import com.ejianc.foundation.oms.service.IComboEnterpriseService;
import com.ejianc.foundation.oms.service.IComboService;
import com.ejianc.foundation.oms.vo.ComboEnterpriseVO;
import com.ejianc.foundation.openapi.bean.OpenApiEntity;
import com.ejianc.foundation.openapi.bean.OpenApiGroupEntity;
import com.ejianc.foundation.openapi.bean.SecurityKeyDetailEntity;
import com.ejianc.foundation.openapi.bean.SecurityKeyEntity;
import com.ejianc.foundation.openapi.service.IOpenApiGroupService;
import com.ejianc.foundation.openapi.service.IOpenApiService;
import com.ejianc.foundation.openapi.service.ISecurityKeyDetailService;
import com.ejianc.foundation.openapi.service.ISecurityKeyService;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.JobVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.tenant.bean.DefaultPwdEntity;
import com.ejianc.foundation.tenant.bean.EnterpriseEntity;
import com.ejianc.foundation.tenant.bean.PasswordPolicyEntity;
import com.ejianc.foundation.tenant.bean.TenantAffiliatedEntity;
import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.tenant.mapper.EnterpriseMapper;
import com.ejianc.foundation.tenant.service.IDefaultpwdService;
import com.ejianc.foundation.tenant.service.IEnterpriseService;
import com.ejianc.foundation.tenant.service.IPasswordPolicyService;
import com.ejianc.foundation.tenant.service.ITenantAffiliatedService;
import com.ejianc.foundation.tenant.service.ITenantService;
import com.ejianc.foundation.tenant.vo.EnterpriseAndTenantVO;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.tenant.vo.PasswordPolicyVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.foundation.usercenter.bean.CooperateEnterpriseEntity;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.service.ICooperateEnterpriseService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.PinYinUtil;
import com.ejianc.foundation.workbench.bean.MenuCategoryEntity;
import com.ejianc.foundation.workbench.service.IMenuCategoryService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Base64Util;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnterpriseServiceImpl
extends BaseServiceImpl<EnterpriseMapper, EnterpriseEntity>
implements IEnterpriseService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ROLE_BILL_CODE = "IDM_ROLE";
    @Autowired
    private ITenantService iTenantService;
    @Autowired
    private IPasswordPolicyService iPasswordPolicyService;
    @Autowired
    private IDefaultpwdService iDefaultpwdService;
    @Autowired
    private IOrgService iOrgService;
    @Autowired
    private IUserService iUserService;
    @Autowired
    private InitDataApi initDataApi;
    @Autowired
    private InitShareDataApi initShareDataApi;
    @Autowired
    private IEmployeeService iEmployeeService;
    @Autowired
    private IComboService comboService;
    @Autowired
    private IComboEnterpriseService comboEnterpriseService;
    @Autowired
    private IUserTenantRelationService userTenantRelationService;
    @Autowired
    private IJobService jobService;
    @Autowired
    private ICooperateEnterpriseService cooperateEnterpriseService;
    @Autowired
    private ISecurityKeyService securityKeyService;
    @Autowired
    private ISecurityKeyDetailService securityKeyDetailService;
    @Autowired
    private IOpenApiGroupService openApiGroupService;
    @Autowired
    private IOpenApiService openApiService;
    @Autowired
    private ITenantAffiliatedService tenantAffiliatedService;
    @Autowired
    private IRoleUserRelationService roleUserRelationService;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    private IMenuCategoryService menuCategoryService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private EnterpriseMapper enterpriseMapper;
    @Value(value="${oemHost}")
    private String oemHost;

    @Override
    public EnterpriseVO selectById(Long enterpriseId) {
        EnterpriseEntity entity = (EnterpriseEntity)((Object)this.getById(enterpriseId));
        if (entity != null) {
            EnterpriseVO enterpriseVo = (EnterpriseVO)BeanMapper.map((Object)((Object)entity), EnterpriseVO.class);
            return enterpriseVo;
        }
        return null;
    }

    @Override
    public EnterpriseVO queryEnterpriseByTenantId(Long tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        List entities = ((EnterpriseMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (entities != null && entities.size() > 0) {
            return (EnterpriseVO)BeanMapper.map(entities.get(0), EnterpriseVO.class);
        }
        return null;
    }

    @Override
    @Transactional
    public void approvalPassed(EnterpriseEntity entity) {
        UserEntity userEntity = (UserEntity)((Object)this.iUserService.getById(entity.getUserId()));
        if (userEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u521b\u5efa\u4f01\u4e1a\u7684\u7528\u6237\u4fe1\u606f\uff01");
        }
        Long tenantId = IdWorker.getId();
        Long passwordPolicyId = IdWorker.getId();
        Long orgId = IdWorker.getId();
        entity.setTenantId(tenantId);
        userEntity.setTenantId(tenantId);
        userEntity.setOrgId(orgId);
        TenantEntity tenantEntity = new TenantEntity();
        tenantEntity.setId(tenantId);
        tenantEntity.setTenantId(tenantId);
        tenantEntity.setName(entity.getName());
        tenantEntity.setCode("T" + tenantId);
        tenantEntity.setEnterpriseId(entity.getId());
        tenantEntity.setPasswordPolicyId(passwordPolicyId);
        tenantEntity.setState(1);
        tenantEntity.setMenuCategoryId(entity.getMenuCategoryId());
        PasswordPolicyVO passwordPolicyVO = this.iPasswordPolicyService.findByTenantId(999999L);
        passwordPolicyVO.setId(passwordPolicyId);
        passwordPolicyVO.setTenantId(tenantId);
        passwordPolicyVO.setCode("PP" + passwordPolicyId);
        passwordPolicyVO.setTenantId(tenantId);
        passwordPolicyVO.setForceUpdateFlag(Integer.valueOf(0));
        passwordPolicyVO.setValiditeDays(Integer.valueOf(30));
        passwordPolicyVO.setPwdComplexity(Integer.valueOf(1));
        passwordPolicyVO.setMinLength(Integer.valueOf(6));
        PasswordPolicyEntity policyEntity = (PasswordPolicyEntity)((Object)BeanMapper.map((Object)passwordPolicyVO, PasswordPolicyEntity.class));
        DefaultPwdEntity defaultPwdEntity = this.iDefaultpwdService.getUserDefaultPassword(999999L);
        defaultPwdEntity.setId(IdWorker.getId());
        defaultPwdEntity.setTenantId(tenantId);
        defaultPwdEntity.setDefaultpwd("a123456");
        defaultPwdEntity.setCreateTime(null);
        defaultPwdEntity.setUpdateTime(null);
        defaultPwdEntity.setUpdateUserCode(null);
        defaultPwdEntity.setCreateUserCode(null);
        defaultPwdEntity.setVersion(null);
        OrgEntity orgEntity = new OrgEntity();
        orgEntity.setId(orgId);
        orgEntity.setCode("BASE" + orgId);
        orgEntity.setEnterpriseId(entity.getId());
        orgEntity.setInnerCode(orgEntity.getId().toString());
        orgEntity.setState(1);
        orgEntity.setTenantId(tenantId);
        orgEntity.setName(entity.getName());
        orgEntity.setOrgType(1);
        orgEntity.setShortName(entity.getName());
        orgEntity.setManager(entity.getLegalName());
        orgEntity.setPhone(entity.getTelephone());
        orgEntity.setSequence(1);
        EmployeeVO employeeVO = new EmployeeVO();
        if ("2".equals(entity.getWays())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"user_id", (Object)userEntity.getId());
            List employeeEntity = this.iEmployeeService.list((Wrapper)wrapper);
            employeeVO = (EmployeeVO)BeanMapper.map(employeeEntity.get(0), EmployeeVO.class);
        } else {
            employeeVO.setName(userEntity.getUserName());
            employeeVO.setCode("BASE-EMP" + userEntity.getId());
            employeeVO.setEmployeeType(Integer.valueOf(1));
            employeeVO.setSex(Integer.valueOf(1));
            employeeVO.setMobilePhone(userEntity.getUserMobile());
            employeeVO.setOrgName(orgEntity.getName());
            employeeVO.setOrgId(orgId);
            employeeVO.setTenantId(tenantId);
        }
        UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)entity.getUserId());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"main_space_flag", (Object)1);
        List exit = this.userTenantRelationService.list((Wrapper)queryWrapper);
        if (exit != null && exit.size() > 0) {
            userTenantRelationEntity.setMainSpaceFlag(0);
        } else {
            userTenantRelationEntity.setMainSpaceFlag(1);
        }
        userTenantRelationEntity.setEmployeeId(employeeVO.getId() != null ? employeeVO.getId() : entity.getUserId());
        userTenantRelationEntity.setUserId(entity.getUserId());
        userTenantRelationEntity.setTenantId(tenantId);
        userTenantRelationEntity.setTypeId(1);
        userTenantRelationEntity.setOrgId(orgId);
        userTenantRelationEntity.setState(1);
        try {
            EnterpriseInitVO vo = (EnterpriseInitVO)BeanMapper.map((Object)((Object)entity), EnterpriseInitVO.class);
            this.initDataApi.initData(vo);
        }
        catch (Exception e) {
            this.initDataApi.rollBack(tenantId);
            throw new BusinessException("\u521d\u59cb\u5316\u652f\u6491\u4e2d\u5fc3\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage());
        }
        try {
            this.iTenantService.saveOrUpdate((Object)tenantEntity, false);
            this.iPasswordPolicyService.saveOrUpdate((Object)policyEntity, false);
            this.iDefaultpwdService.saveOrUpdate((Object)defaultPwdEntity, false);
            this.iOrgService.saveOrUpdate((Object)orgEntity, false);
            if ("2".equals(entity.getWays())) {
                JobEntity jobEntity = new JobEntity();
                jobEntity.setProperty(JobVO.JOB_TYPE_MAIN);
                jobEntity.setEmployeeId(employeeVO.getId());
                jobEntity.setCurState(JobVO.STATE_ACTIVE);
                jobEntity.setJobStartTime(employeeVO.getWorkTime());
                jobEntity.setOrgId(orgId);
                jobEntity.setDr(BaseVO.DR_UNDELETE);
                jobEntity.setTenantId(tenantId);
                this.jobService.saveOrUpdate((Object)jobEntity, false);
            } else {
                this.iEmployeeService.save(employeeVO, userEntity);
                this.iUserService.saveOrUpdate((Object)userEntity);
            }
            super.saveOrUpdate((Object)entity, false);
            this.logger.info("------\u63d2\u5165\u7528\u6237\u79df\u6237\u5173\u7cfb\u8868start------");
            this.logger.info("userTenantRelationEntity" + JSONObject.toJSONString((Object)((Object)userTenantRelationEntity)));
            this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
        }
        catch (Exception e) {
            this.initDataApi.rollBack(tenantId);
            throw new BusinessException("\u6301\u4e45\u5316\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage());
        }
    }

    @Override
    public List<EnterpriseEntity> queryEnterpriseByUserId(Long userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)userId);
        List entities = ((EnterpriseMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return entities;
    }

    @Override
    public EnterpriseAndTenantVO queryEnterpriseAndTenantByTenantId(Long tenantId) {
        EnterpriseAndTenantVO vo = new EnterpriseAndTenantVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        List entities = ((EnterpriseMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (entities != null && entities.size() > 0) {
            vo = (EnterpriseAndTenantVO)BeanMapper.map(entities.get(0), EnterpriseAndTenantVO.class);
            TenantEntity tenantEntity = (TenantEntity)((Object)this.iTenantService.getById(tenantId));
            vo.setTenantName(tenantEntity.getName());
            vo.setTenantRegisterTime(tenantEntity.getCreateTime());
            UserEntity userEntity = (UserEntity)((Object)this.iUserService.getById(vo.getUserId()));
            vo.setTenantUserName(userEntity.getUserName());
            vo.setTenantUserMobile(userEntity.getUserMobile());
        }
        return vo;
    }

    @Override
    public CommonResponse<EnterpriseVO> supplierCollaboration(EnterpriseVO enterpriseVO) {
        if (enterpriseVO.getUserId() != null) {
            JSONObject vo = new JSONObject();
            vo.put("userId", (Object)enterpriseVO.getUserId());
            vo.put("systemId", (Object)enterpriseVO.getId());
            vo.put("tenantId", (Object)enterpriseVO.getTenantId());
            vo.put("newPhone", (Object)enterpriseVO.getTelephone());
            vo.put("newName", (Object)enterpriseVO.getAuditName());
            CommonResponse<String> res = this.updateSupplierUserPhoneAndName(vo);
            if (res.isSuccess()) {
                return CommonResponse.success((Object)enterpriseVO);
            }
            return CommonResponse.error((String)res.getMsg());
        }
        QueryWrapper userPhoneWrapper = new QueryWrapper();
        ((QueryWrapper)userPhoneWrapper.eq((Object)"user_mobile", (Object)enterpriseVO.getTelephone())).eq((Object)"dr", (Object)0);
        UserEntity checkEntity = (UserEntity)((Object)this.iUserService.getOne((Wrapper)userPhoneWrapper));
        if (checkEntity != null) {
            return CommonResponse.error((String)"\u8be5\u624b\u673a\u53f7\u5728\u7cfb\u7edf\u5185\u5df2\u88ab\u4ed6\u4eba\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u624b\u673a\u53f7");
        }
        QueryWrapper entityQueryWrapper = new QueryWrapper();
        ((QueryWrapper)entityQueryWrapper.eq((Object)"social_credit_code", (Object)enterpriseVO.getSocialCreditCode())).eq((Object)"dr", (Object)0);
        EnterpriseEntity entity = (EnterpriseEntity)((Object)this.getOne((Wrapper)entityQueryWrapper, false));
        if (entity != null) {
            return CommonResponse.error((String)("\u5df2\u6709\u4f9b\u5e94\u5546\u3010" + entity.getName() + "\u3011\u534f\u540c\u4e86\u8be5\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u91cd\u590d\u5f55\u5165\u4e86\u4f9b\u5e94\u5546\uff01"));
        }
        enterpriseVO.setWays("3");
        enterpriseVO.setBusinessType("2");
        if (StringUtils.isNotEmpty((String)this.oemHost)) {
            enterpriseVO.setOemHost(this.oemHost);
        }
        Long tenantId = IdWorker.getId();
        Long passwordPolicyId = IdWorker.getId();
        Long orgId = IdWorker.getId();
        Long userId = IdWorker.getId();
        enterpriseVO.setTenantId(tenantId);
        TenantEntity tenantEntity = new TenantEntity();
        tenantEntity.setId(tenantId);
        tenantEntity.setTenantId(tenantId);
        tenantEntity.setName(enterpriseVO.getName());
        tenantEntity.setCode("T" + tenantId);
        tenantEntity.setEnterpriseId(enterpriseVO.getId());
        tenantEntity.setPasswordPolicyId(passwordPolicyId);
        tenantEntity.setState(1);
        UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
        userTenantRelationEntity.setMainSpaceFlag(1);
        userTenantRelationEntity.setUserId(userId);
        userTenantRelationEntity.setTenantId(tenantId);
        userTenantRelationEntity.setTypeId(1);
        userTenantRelationEntity.setEmployeeId(userId);
        userTenantRelationEntity.setOrgId(orgId);
        userTenantRelationEntity.setState(1);
        PasswordPolicyVO passwordPolicyVO = this.iPasswordPolicyService.findByTenantId(999999L);
        passwordPolicyVO.setId(passwordPolicyId);
        passwordPolicyVO.setTenantId(tenantId);
        passwordPolicyVO.setCode("PP" + passwordPolicyId);
        passwordPolicyVO.setTenantId(tenantId);
        passwordPolicyVO.setForceUpdateFlag(Integer.valueOf(0));
        passwordPolicyVO.setValiditeDays(Integer.valueOf(30));
        passwordPolicyVO.setPwdComplexity(Integer.valueOf(1));
        passwordPolicyVO.setMinLength(Integer.valueOf(6));
        PasswordPolicyEntity policyEntity = (PasswordPolicyEntity)((Object)BeanMapper.map((Object)passwordPolicyVO, PasswordPolicyEntity.class));
        DefaultPwdEntity defaultPwdEntity = this.iDefaultpwdService.getUserDefaultPassword(999999L);
        defaultPwdEntity.setId(IdWorker.getId());
        defaultPwdEntity.setTenantId(tenantId);
        if (StringUtils.isNotBlank((String)enterpriseVO.getPassword())) {
            defaultPwdEntity.setDefaultpwd(enterpriseVO.getPassword());
        }
        defaultPwdEntity.setCreateTime(null);
        defaultPwdEntity.setUpdateTime(null);
        defaultPwdEntity.setUpdateUserCode(null);
        defaultPwdEntity.setCreateUserCode(null);
        defaultPwdEntity.setVersion(null);
        OrgEntity orgEntity = new OrgEntity();
        orgEntity.setId(orgId);
        orgEntity.setCode("BASE" + orgId);
        orgEntity.setEnterpriseId(enterpriseVO.getId());
        orgEntity.setInnerCode(orgEntity.getId().toString());
        orgEntity.setState(1);
        orgEntity.setTenantId(tenantId);
        orgEntity.setName(enterpriseVO.getName());
        orgEntity.setOrgType(1);
        orgEntity.setShortName(enterpriseVO.getName());
        orgEntity.setManager(enterpriseVO.getLegalName());
        orgEntity.setPhone(enterpriseVO.getTelephone());
        orgEntity.setSequence(1);
        UserVO userVO = new UserVO();
        userVO.setTenantId(tenantId);
        userVO.setOrgId(orgId);
        userVO.setId(userId);
        userVO.setUserName(enterpriseVO.getAuditName());
        userVO.setUserMobile(enterpriseVO.getTelephone());
        userVO.setUserCode("U" + IdWorker.getId());
        userVO.setUserState(UserVO.USER_STATE_ACTIVE);
        userVO.setDr(BaseVO.DR_UNDELETE);
        userVO.setTypeId(Integer.valueOf(1));
        PasswordUtils.setSalt(userVO);
        String password = enterpriseVO.getTelephone().substring(enterpriseVO.getTelephone().length() - 6);
        String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
        userVO.setPassword(shaPassword);
        userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
        userVO.setPwdStartTime(new Date());
        UserEntity userEntity = (UserEntity)((Object)BeanMapper.map((Object)userVO, UserEntity.class));
        enterpriseVO.setUserId(userId);
        EmployeeVO employeeVO = new EmployeeVO();
        employeeVO.setId(userId);
        employeeVO.setUserId(userId);
        employeeVO.setName(userEntity.getUserName());
        employeeVO.setCode("BASE-SUP" + userEntity.getId());
        employeeVO.setEmployeeType(Integer.valueOf(1));
        employeeVO.setState(Integer.valueOf(0));
        employeeVO.setSex(Integer.valueOf(1));
        employeeVO.setMobilePhone(userEntity.getUserMobile());
        employeeVO.setOrgName(orgEntity.getName());
        employeeVO.setOrgId(orgId);
        employeeVO.setTenantId(tenantId);
        QueryWrapper roleWrapper = new QueryWrapper();
        roleWrapper.eq((Object)"dr", (Object)0);
        roleWrapper.eq((Object)"code", (Object)"SY-SUP");
        ComboEntity comboEntity = (ComboEntity)((Object)this.comboService.getOne((Wrapper)roleWrapper));
        ComboEnterpriseVO comboEnterpriseVO = new ComboEnterpriseVO();
        if (comboEntity != null) {
            comboEnterpriseVO.setBuyerId(tenantId);
            comboEnterpriseVO.setComboId(comboEntity.getId());
            comboEnterpriseVO.setUserId(userId);
            comboEnterpriseVO.setEnabled("1");
            comboEnterpriseVO.setComboName(comboEntity.getName());
            comboEnterpriseVO.setOpeningTime(new Date());
            comboEnterpriseVO.setStartTime(new Date());
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
            try {
                comboEnterpriseVO.setEndTime(sdf2.parse("2900-10-10"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        QueryWrapper openApiGroupWaper = new QueryWrapper();
        openApiGroupWaper.eq((Object)"group_name", (Object)"\u4f9b\u65b9\u5e73\u53f0\u63a5\u6536\u6570\u636e\u670d\u52a1\u63a5\u53e3");
        openApiGroupWaper.eq((Object)"dr", (Object)0);
        List openApiGroupList = this.openApiGroupService.list((Wrapper)openApiGroupWaper);
        SecurityKeyEntity securityKeyEntity = new SecurityKeyEntity();
        ArrayList<SecurityKeyDetailEntity> securityKeyDetailList = new ArrayList<SecurityKeyDetailEntity>();
        Long securityKeyId = IdWorker.getId();
        String appid = IdWorker.getId() + "";
        String secret = Base64Util.encode((byte[])appid.getBytes());
        if (ListUtil.isNotEmpty((List)openApiGroupList)) {
            securityKeyEntity.setAppId(appid);
            securityKeyEntity.setId(securityKeyId);
            securityKeyEntity.setSecretKey(secret);
            securityKeyEntity.setTenantId(tenantId);
            securityKeyEntity.setSecretDesc("\u5185\u90e8\u4f9b\u65b9\u751f\u6210\u79df\u6237\u521d\u59cb\u5316\u670d\u52a1\uff1a" + enterpriseVO.getName() + "\u63a5\u6536\u6570\u636e\u670d\u52a1\u63a5\u53e3");
            securityKeyEntity.setSecretState(1);
            securityKeyEntity.setSecurityName(enterpriseVO.getName() + "\u63a5\u6536\u6570\u636e\u670d\u52a1\u63a5\u53e3");
            QueryWrapper openApiWrapper = new QueryWrapper();
            openApiWrapper.eq((Object)"group_id", (Object)((OpenApiGroupEntity)((Object)openApiGroupList.get(0))).getId());
            openApiWrapper.eq((Object)"dr", (Object)0);
            List openApiList = this.openApiService.list((Wrapper)openApiWrapper);
            if (ListUtil.isNotEmpty((List)openApiList)) {
                for (OpenApiEntity apiEntity : openApiList) {
                    SecurityKeyDetailEntity detailEntity = new SecurityKeyDetailEntity();
                    detailEntity.setOpenApiId(apiEntity.getId());
                    detailEntity.setSecurityKeyId(securityKeyId);
                    detailEntity.setTenantId(tenantId);
                    securityKeyDetailList.add(detailEntity);
                }
                this.securityKeyService.saveOrUpdate((Object)securityKeyEntity, false);
                this.securityKeyDetailService.saveOrUpdateBatch(securityKeyDetailList, securityKeyDetailList.size(), false);
                enterpriseVO.setDataAppId(appid);
                enterpriseVO.setDataAppSecret(secret);
                enterpriseVO.setDataHost(this.environmentTools.getBaseHost().substring(0, this.environmentTools.getBaseHost().length() - 1));
                this.logger.info("\u5185\u90e8\u63a8\u9001\u4f9b\u5e94\u5546\uff0c\u521d\u59cb\u5316\u3010\u4f9b\u65b9\u5e73\u53f0\u63a5\u6536\u6570\u636e\u670d\u52a1\u63a5\u53e3\u3011\u7ec4\u5177\u4f53\u7684openapi\u670d\u52a1\u6210\u529f\uff01 " + enterpriseVO.getName());
            } else {
                this.logger.error("\u672a\u521d\u59cb\u5316\u3010\u4f9b\u65b9\u5e73\u53f0\u63a5\u6536\u6570\u636e\u670d\u52a1\u63a5\u53e3\u3011\u7ec4\u5177\u4f53\u7684openapi\u670d\u52a1,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u521d\u59cb\u5316\u6570\u636e , enterpriseEntity = " + enterpriseVO.getId());
            }
        } else {
            this.logger.error("\u672a\u521d\u59cb\u5316openapi\u7684\u3010\u4f9b\u65b9\u5e73\u53f0\u63a5\u6536\u6570\u636e\u670d\u52a1\u63a5\u53e3\u3011\u7ec4,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u521d\u59cb\u5316\u6570\u636e , enterpriseEntity = " + enterpriseVO.getId());
        }
        try {
            this.iTenantService.saveOrUpdate((Object)tenantEntity, false);
            this.iPasswordPolicyService.saveOrUpdate((Object)policyEntity, false);
            this.iDefaultpwdService.saveOrUpdate((Object)defaultPwdEntity, false);
            this.iOrgService.saveOrUpdate((Object)orgEntity, false);
            this.iEmployeeService.save(employeeVO, userEntity);
            this.iUserService.saveOrUpdate((Object)userEntity);
            this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
            if (comboEntity != null) {
                this.comboEnterpriseService.saveComboEnterprise(comboEnterpriseVO);
            }
            entity = (EnterpriseEntity)((Object)BeanMapper.map((Object)enterpriseVO, EnterpriseEntity.class));
            super.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((Object)enterpriseVO);
        }
        catch (Exception e) {
            throw new BusinessException("\u6301\u4e45\u5316\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<TenantVO> createGfmhTenant(EnterpriseVO vo) {
        QueryParam param2;
        EnterpriseEntity enterpriseEntity = null;
        Long loadTenantId = vo.getLoadTenantId();
        if ("1".equals(vo.getEnterpriseType())) {
            if (!StringUtils.isNotBlank((String)vo.getTaxCode())) throw new BusinessException("\u7f3a\u5c11\u53c2\u6570\uff1a\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
            param2 = new QueryParam();
            param2.getParams().put("taxCode", new Parameter("eq", (Object)vo.getTaxCode()));
            param2.getParams().put("examineState", new Parameter("ne", (Object)2));
            List listTaxCode = this.queryList(param2);
            if (listTaxCode != null && listTaxCode.size() > 0) {
                enterpriseEntity = (EnterpriseEntity)((Object)listTaxCode.get(0));
            }
        } else {
            if (!StringUtils.isNotBlank((String)vo.getIdCard())) throw new BusinessException("\u7f3a\u5c11\u53c2\u6570\uff1a\u8eab\u4efd\u8bc1\u53f7");
            param2 = new QueryParam();
            param2.getParams().put("idcard", new Parameter("eq", (Object)vo.getIdCard()));
            param2.getParams().put("examineState", new Parameter("ne", (Object)2));
            List listIdcard = this.queryList(param2);
            if (listIdcard != null && listIdcard.size() > 0) {
                enterpriseEntity = (EnterpriseEntity)((Object)listIdcard.get(0));
            }
        }
        if (enterpriseEntity != null) {
            UserVO userVO;
            enterpriseEntity.setLoadTenantId(loadTenantId);
            this.logger.info("\u4f01\u4e1a\u6863\u6848\u5b58\u5728-- " + JSONObject.toJSONString((Object)((Object)enterpriseEntity)));
            if (enterpriseEntity.getAuditTime() == null) {
                enterpriseEntity.setAuditTime(new Date());
            }
            if (enterpriseEntity.getTenantId() != null && enterpriseEntity.getTenantId() != -1L) {
                QueryParam param = new QueryParam();
                param.getParams().put("tenantId", new Parameter("eq", (Object)enterpriseEntity.getTenantId()));
                param.getParams().put("supplierId", new Parameter("eq", (Object)vo.getSupplierId()));
                param.getParams().put("cooperate_enterid", new Parameter("eq", (Object)vo.getSystemId()));
                List entities = this.cooperateEnterpriseService.queryList(param, false);
                CooperateEnterpriseEntity cooperateEnterpriseEntity = new CooperateEnterpriseEntity();
                if (ListUtil.isEmpty((List)entities)) {
                    cooperateEnterpriseEntity.setCooperateEnterId(Long.parseLong(vo.getSystemId()));
                    cooperateEnterpriseEntity.setCooperationEnterpriseName(((EnterpriseEntity)((Object)this.selectById((Serializable)((Object)vo.getSystemId())))).getName());
                    cooperateEnterpriseEntity.setMyEnterpriseId(enterpriseEntity.getId());
                    cooperateEnterpriseEntity.setSupplierId(vo.getSupplierId().toString());
                    cooperateEnterpriseEntity.setApplyState("3");
                    cooperateEnterpriseEntity.setTenantId(enterpriseEntity.getTenantId());
                    this.cooperateEnterpriseService.saveOrUpdate((Object)cooperateEnterpriseEntity, false);
                    this.logger.info("\u4f01\u4e1a\u6863\u6848\u5b58\u5728,\u6709\u79df\u6237-- \u5408\u4f5c\u4f01\u4e1a\u7ef4\u62a4\u5b8c\u6210");
                } else {
                    cooperateEnterpriseEntity = (CooperateEnterpriseEntity)((Object)entities.get(0));
                }
                if (StringUtils.isEmpty((String)enterpriseEntity.getDataAppId())) {
                    QueryWrapper openApiGroupWaper = new QueryWrapper();
                    openApiGroupWaper.eq((Object)"group_name", (Object)"\u4f9b\u65b9\u5e73\u53f0\u63a5\u6536\u6570\u636e\u670d\u52a1\u63a5\u53e3");
                    openApiGroupWaper.eq((Object)"dr", (Object)0);
                    List openApiGroupList = this.openApiGroupService.list((Wrapper)openApiGroupWaper);
                    SecurityKeyEntity securityKeyEntity = new SecurityKeyEntity();
                    ArrayList<SecurityKeyDetailEntity> securityKeyDetailList = new ArrayList<SecurityKeyDetailEntity>();
                    Long securityKeyId = IdWorker.getId();
                    String appid = IdWorker.getId() + "";
                    String secret = Base64Util.encode((byte[])appid.getBytes());
                    enterpriseEntity.setDataAppId(appid);
                    enterpriseEntity.setDataAppSecret(secret);
                    if (openApiGroupList != null && openApiGroupList.size() > 0) {
                        securityKeyEntity.setAppId(appid);
                        securityKeyEntity.setId(securityKeyId);
                        securityKeyEntity.setSecretKey(secret);
                        securityKeyEntity.setSecurityName(enterpriseEntity.getName() + "\u63a5\u6536\u6570\u636e\u670d\u52a1\u63a5\u53e3");
                        securityKeyEntity.setSecretDesc("\u4f9b\u65b9\u5e73\u53f0\u751f\u6210\u79df\u6237\u521d\u59cb\u5316\u670d\u52a1\uff1a" + enterpriseEntity.getName() + "\u63a5\u6536\u6570\u636e\u670d\u52a1\u63a5\u53e3");
                        securityKeyEntity.setSecretState(1);
                        QueryWrapper openApiWrapper = new QueryWrapper();
                        openApiWrapper.eq((Object)"group_id", (Object)((OpenApiGroupEntity)((Object)openApiGroupList.get(0))).getId());
                        openApiWrapper.eq((Object)"dr", (Object)0);
                        List openApiList = this.openApiService.list((Wrapper)openApiWrapper);
                        if (openApiList != null && openApiList.size() > 0) {
                            for (OpenApiEntity apiEntity : openApiList) {
                                BaseEntity entity = new SecurityKeyDetailEntity();
                                entity.setOpenApiId(apiEntity.getId());
                                entity.setSecurityKeyId(securityKeyId);
                                securityKeyDetailList.add((SecurityKeyDetailEntity)entity);
                            }
                            this.securityKeyService.saveOrUpdate((Object)securityKeyEntity, false);
                            this.securityKeyDetailService.saveOrUpdateBatch(securityKeyDetailList, securityKeyDetailList.size(), false);
                        } else {
                            this.logger.error("\u672a\u521d\u59cb\u5316\u5177\u4f53\u7684openapi\u670d\u52a1,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u521d\u59cb\u5316\u6570\u636e , enterpriseEntity = " + enterpriseEntity.getId());
                        }
                    } else {
                        this.logger.error("\u672a\u521d\u59cb\u5316openapi,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u521d\u59cb\u5316\u6570\u636e , enterpriseEntity = " + enterpriseEntity.getId());
                    }
                }
                this.logger.info("\u4f01\u4e1a\u6863\u6848\u5b58\u5728,\u6709\u79df\u6237-- " + JSONObject.toJSONString((Object)((Object)enterpriseEntity)));
                TenantVO tenantVO = this.iTenantService.selectById(enterpriseEntity.getTenantId());
                UserVO userVO2 = this.iUserService.querySuperAdminByTenantId(enterpriseEntity.getTenantId());
                EmployeeEntity employeeEntity = (EmployeeEntity)((Object)this.iEmployeeService.selectById(userVO2.getId()));
                if (employeeEntity == null) {
                    employeeEntity = new EmployeeEntity();
                    employeeEntity.setId(userVO2.getId());
                    employeeEntity.setUserId(userVO2.getId());
                    employeeEntity.setName(userVO2.getUserName());
                    employeeEntity.setCode("BASE-GFMH" + userVO2.getId());
                    employeeEntity.setEmployeeType(1);
                    employeeEntity.setState(0);
                    employeeEntity.setSex(1);
                    employeeEntity.setMobilePhone(userVO2.getUserMobile());
                    employeeEntity.setOrgId(this.iOrgService.findOrgByTenantId(tenantVO.getId()).getId());
                    employeeEntity.setTenantId(enterpriseEntity.getTenantId());
                    this.logger.info("\u4f01\u4e1a\u6863\u6848\u5b58\u5728,\u6709\u79df\u6237,\u65e0\u4eba\u5458\u91cd\u65b0\u751f\u6210-- " + JSONObject.toJSONString((Object)((Object)employeeEntity)));
                    QueryParam utrp = new QueryParam();
                    utrp.getParams().put("employeeId", new Parameter("eq", (Object)userVO2.getId()));
                    utrp.getParams().put("tenantId", new Parameter("eq", (Object)tenantVO.getId()));
                    utrp.getParams().put("orgId", new Parameter("eq", (Object)employeeEntity.getOrgId()));
                    List listJ = this.jobService.queryList(utrp);
                    if (ListUtil.isEmpty((List)listJ)) {
                        JobEntity jobEntity = new JobEntity();
                        jobEntity.setProperty(JobVO.JOB_TYPE_MAIN);
                        jobEntity.setEmployeeId(userVO2.getId());
                        jobEntity.setCurState(JobVO.STATE_ACTIVE);
                        jobEntity.setJobStartTime(new Date());
                        jobEntity.setOrgId(employeeEntity.getOrgId());
                        jobEntity.setDr(BaseVO.DR_UNDELETE);
                        jobEntity.setTenantId(tenantVO.getId());
                        jobEntity.setId(IdWorker.getId());
                        this.jobService.saveOrUpdate((Object)jobEntity, false);
                        this.logger.info("\u4f01\u4e1a\u6863\u6848\u5b58\u5728,\u6709\u79df\u6237,\u65e0\u4eba\u5458\uff0c\u65e0\u4efb\u804c\u8bb0\u5f55\uff0c\u91cd\u65b0\u6301\u4e45\u5316job\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)jobEntity)));
                    }
                }
                if (StringUtils.isNotEmpty((String)vo.getAuditName()) && PinYinUtil.getFullSpell(enterpriseEntity.getName()).equals(userVO2.getUserName())) {
                    userVO2.setUserName(vo.getAuditName());
                    employeeEntity.setName(userVO2.getUserName());
                    userVO2.setUserMobile(vo.getTelephone());
                    employeeEntity.setMobilePhone(userVO2.getUserMobile());
                    this.logger.info("\u4f01\u4e1a\u6863\u6848\u5b58\u5728,\u6709\u79df\u6237,\u5224\u65ad\u624b\u673a\u53f7\u662f\u5426\u91cd\u590d  -- " + JSONObject.toJSONString((Object)userVO2));
                    userVO2.setTenantId(enterpriseEntity.getTenantId());
                    employeeEntity.setTenantId(enterpriseEntity.getTenantId());
                    UserVO dbVO = this.iUserService.queryLoginUserByUserCodeOrPhoneNumOrEMail(vo.getTelephone());
                    if (dbVO == null) {
                        this.logger.info("\u4f01\u4e1a\u6863\u6848\u5b58\u5728,\u6709\u79df\u6237,\u624b\u673a\u53f7\u4e0d\u91cd\u590d\uff0c\u66f4\u65b0\u7ba1\u7406\u5458\u540d\u79f0\u548c\u624b\u673a\u53f7  -- " + JSONObject.toJSONString((Object)userVO2));
                        UserEntity userEntity = (UserEntity)((Object)BeanMapper.map((Object)userVO2, UserEntity.class));
                        this.iUserService.saveOrUpdate((Object)userEntity, false);
                        userVO2 = (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
                        this.iEmployeeService.saveOrUpdate((Object)employeeEntity, false);
                    } else {
                        this.logger.info("\u4f01\u4e1a\u6863\u6848\u5b58\u5728,\u6709\u79df\u6237,\u624b\u673a\u53f7\u91cd\u590d\uff0c\u5220\u9664\u4ee5\u524d\u9ed8\u8ba4\u751f\u6210\u7684\u7528\u6237\uff0c\u91cd\u65b0\u6302\u8f7d\u7528\u6237\u79df\u6237\u5173\u7cfb  -- " + JSONObject.toJSONString((Object)userVO2));
                        QueryParam utrp = new QueryParam();
                        utrp.getParams().put("userId", new Parameter("eq", (Object)userVO2.getId()));
                        utrp.getParams().put("tenantId", new Parameter("eq", (Object)tenantVO.getId()));
                        List list = this.userTenantRelationService.queryList(utrp);
                        UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
                        if (ListUtil.isNotEmpty((List)list)) {
                            userTenantRelationEntity = (UserTenantRelationEntity)((Object)list.get(0));
                        } else {
                            userTenantRelationEntity.setMainSpaceFlag(1);
                        }
                        userTenantRelationEntity.setUserId(dbVO.getId());
                        userTenantRelationEntity.setEmployeeId(dbVO.getEmployeeId());
                        userTenantRelationEntity.setTenantId(tenantVO.getId());
                        userTenantRelationEntity.setTypeId(1);
                        userTenantRelationEntity.setState(1);
                        this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
                        this.logger.info("\u66f4\u65b0\u79df\u6237\u7528\u6237\u5173\u7cfb\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)userTenantRelationEntity)));
                        JobEntity jobEntity = new JobEntity();
                        utrp = new QueryParam();
                        utrp.getParams().put("employeeId", new Parameter("eq", (Object)userVO2.getId()));
                        utrp.getParams().put("tenantId", new Parameter("eq", (Object)tenantVO.getId()));
                        List listJ = this.jobService.queryList(utrp);
                        if (ListUtil.isNotEmpty((List)list)) {
                            jobEntity = (JobEntity)((Object)listJ.get(0));
                        }
                        jobEntity.setEmployeeId(dbVO.getEmployeeId());
                        this.jobService.saveOrUpdate((Object)jobEntity, false);
                        this.logger.info("\u66f4\u65b0\u7528\u6237\u4efb\u804c\u5173\u7cfb\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)userTenantRelationEntity)));
                        utrp = new QueryParam();
                        utrp.getParams().put("employeeId", new Parameter("eq", (Object)userVO2.getId()));
                        utrp.getParams().put("userId", new Parameter("eq", (Object)userVO2.getId()));
                        utrp.getParams().put("tenantId", new Parameter("eq", (Object)tenantVO.getId()));
                        List entityList = this.roleUserRelationService.queryList(utrp);
                        if (ListUtil.isNotEmpty((List)entityList)) {
                            for (BaseEntity entity : entityList) {
                                entity.setEmployeeId(dbVO.getEmployeeId());
                                entity.setUserId(dbVO.getId());
                                ArrayList<RoleUserRelationVO> data = new ArrayList<RoleUserRelationVO>();
                                data.add((RoleUserRelationVO)BeanMapper.map((Object)entity, RoleUserRelationVO.class));
                                this.roleUserRelationService.saveRoleUser(data);
                            }
                            this.logger.info("\u66f4\u65b0\u7528\u6237\u89d2\u8272\u5173\u7cfb\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)userTenantRelationEntity)));
                        }
                        userVO2 = dbVO;
                    }
                }
                if (userVO2.getTenantId() == null) {
                    userVO2.setTenantId(enterpriseEntity.getTenantId());
                }
                if (employeeEntity.getTenantId() == null) {
                    employeeEntity.setTenantId(enterpriseEntity.getTenantId());
                }
                this.iUserService.saveOrUpdate(BeanMapper.map((Object)userVO2, UserEntity.class), false);
                this.iEmployeeService.saveOrUpdate((Object)employeeEntity, false);
                this.logger.info("\u4f01\u4e1a\u6863\u6848\u5b58\u5728,\u6709\u79df\u6237,\u6709\u7528\u6237\uff0c\u91cd\u65b0\u6302\u8f7d\u79df\u6237id  -- " + JSONObject.toJSONString((Object)userVO2));
                TenantAffiliatedEntity affiliatedEntity = null;
                if ("3".equals(enterpriseEntity.getEnterpriseType())) {
                    if (loadTenantId != null) {
                        param = new QueryParam();
                        param.getParams().put("tenantId", new Parameter("eq", (Object)enterpriseEntity.getTenantId()));
                        param.getParams().put("target_tenant_id", new Parameter("eq", (Object)loadTenantId));
                        List affiliatedEntities = this.tenantAffiliatedService.queryList(param, false);
                        if (ListUtil.isEmpty((List)affiliatedEntities)) {
                            TenantVO targetTenantVo = this.iTenantService.selectById(loadTenantId);
                            affiliatedEntity = new TenantAffiliatedEntity();
                            affiliatedEntity.setTenantId(enterpriseEntity.getTenantId());
                            affiliatedEntity.setTargetTenantId(loadTenantId);
                            affiliatedEntity.setTargetTenantName(targetTenantVo.getName());
                            affiliatedEntity.setMyTenantName(enterpriseEntity.getName());
                            affiliatedEntity.setMemo("\u540c\u610f-\u7cfb\u7edf\u81ea\u52a8\u6302\u9760");
                            affiliatedEntity.setTenantStatus(3L);
                            affiliatedEntity.setApplyDate(new Date());
                            affiliatedEntity.setSupplierId(((CooperateEnterpriseEntity)((Object)entities.get(0))).getSupplierId());
                            this.tenantAffiliatedService.saveOrUpdate((Object)affiliatedEntity, false);
                            this.logger.info("\u5206\u5305\u8d1f\u8d23\u4eba\u6302\u9760\u5230\u5206\u5305\u4f9b\u5e94\u5546\u79df\u6237---{}", (Object)JSONObject.toJSONString((Object)((Object)affiliatedEntity)));
                        } else {
                            this.logger.error("\u5206\u5305\u73ed\u7ec4\u79df\u6237\u672a\u6302\u9760\u5230\u4f9b\u5e94\u5546\u79df\u6237\u4e0a\uff0c\u56e0\u4e3a\u6ca1\u6709\u627e\u5230\u8981\u6302\u9760\u7684\u4f9b\u5e94\u5546\u79df\u6237\u6240\u5728\u7684\u79c1\u6709\u5316\u4f01\u4e1a\u7684supplierId\uff0c\u5206\u5305\u4f9b\u5e94\u5546\u7684\u5408\u4f5c\u8868\u6ca1\u627e\u5230\uff01" + JSONObject.toJSONString((Object)((Object)enterpriseEntity)));
                        }
                    } else {
                        this.logger.error("\u5206\u5305\u73ed\u7ec4\u79df\u6237\u672a\u6302\u9760\u5230\u4f9b\u5e94\u5546\u79df\u6237\u4e0a\uff0c\u56e0\u4e3a\u53c2\u6570\u6ca1\u643a\u5e26\u8981\u6302\u9760\u7684\u4f9b\u5e94\u5546\u79df\u6237id, enterpriseEntity = " + enterpriseEntity.getId() + "  tenantId = " + tenantVO.getId());
                    }
                }
                DefaultPwdEntity defaultPwdEntity = this.iDefaultpwdService.getUserDefaultPassword(userVO2.getTenantId());
                tenantVO.setManagerId(userVO2.getId());
                tenantVO.setManagerName(userVO2.getUserName());
                tenantVO.setManagerPhone(userVO2.getUserMobile());
                return CommonResponse.success((Object)tenantVO);
            }
            enterpriseEntity.setAuditName(vo.getAuditName());
            enterpriseEntity.setTelephone(vo.getTelephone());
            this.logger.info("\u4f01\u4e1a\u6863\u6848\u5b58\u5728,\u6ca1\u6709\u751f\u6210\u79df\u6237-- " + JSONObject.toJSONString((Object)((Object)enterpriseEntity)));
            if (StringUtils.isNotBlank((String)vo.getTelephone())) {
                enterpriseEntity.setTelephone(vo.getTelephone());
            }
            if ((userVO = this.iUserService.queryLoginUserByUserCodeOrPhoneNumOrEMail(enterpriseEntity.getTelephone())) == null) {
                enterpriseEntity.setAuditName(vo.getAuditName());
                userVO = new UserVO();
                this.logger.info("\u4f01\u4e1a\u6863\u6848\u5b58\u5728,\u6ca1\u6709\u751f\u6210\u79df\u6237\uff0c\u624b\u673a\u53f7\u4e0d\u5b58\u5728\u7528\u6237-- " + JSONObject.toJSONString((Object)((Object)enterpriseEntity)));
                return this.createGfmh(enterpriseEntity, vo.getSupplierId(), userVO, vo.getSystemId());
            } else {
                this.logger.info("\u4f01\u4e1a\u6863\u6848\u5b58\u5728,\u6ca1\u6709\u751f\u6210\u79df\u6237\uff0c\u624b\u673a\u53f7\u5b58\u5728\u7528\u6237-- " + JSONObject.toJSONString((Object)((Object)enterpriseEntity)) + " userVO = " + JSONObject.toJSONString((Object)userVO));
            }
            return this.createGfmh(enterpriseEntity, vo.getSupplierId(), userVO, vo.getSystemId());
        }
        this.logger.info("\u4f01\u4e1a\u6863\u6848\u4e0d\u5b58\u5728,\u6ca1\u6709\u751f\u6210\u79df\u6237 -- " + JSONObject.toJSONString((Object)((Object)enterpriseEntity)));
        vo.setId(Long.valueOf(IdWorker.getId()));
        enterpriseEntity = (EnterpriseEntity)((Object)BeanMapper.map((Object)vo, EnterpriseEntity.class));
        enterpriseEntity.setExamineState("1");
        enterpriseEntity.setWays("4");
        enterpriseEntity.setTenantId(-1L);
        enterpriseEntity.setAuditTime(new Date());
        this.saveOrUpdateNoES((Object)enterpriseEntity);
        this.logger.info("\u4f01\u4e1a\u6863\u6848\u4e0d\u5b58\u5728,\u6ca1\u6709\u751f\u6210\u79df\u6237-- \u4fdd\u5b58\u4f01\u4e1a\u6210\u529f" + JSONObject.toJSONString((Object)((Object)enterpriseEntity)));
        QueryWrapper userPhoneWrapper = new QueryWrapper();
        ((QueryWrapper)userPhoneWrapper.eq((Object)"user_mobile", (Object)vo.getTelephone())).eq((Object)"dr", (Object)0);
        UserEntity checkEntity = (UserEntity)((Object)this.iUserService.getOne((Wrapper)userPhoneWrapper));
        UserVO userVO = new UserVO();
        if (checkEntity == null) return this.createGfmh(enterpriseEntity, vo.getSupplierId(), userVO, vo.getSystemId());
        userVO = (UserVO)BeanMapper.map((Object)((Object)checkEntity), UserVO.class);
        this.logger.info("\u4f01\u4e1a\u6863\u6848\u4e0d\u5b58\u5728,\u6ca1\u6709\u751f\u6210\u79df\u6237\uff0c\u624b\u673a\u53f7\u5b58\u5728\u7528\u6237-- " + JSONObject.toJSONString((Object)((Object)enterpriseEntity)) + " userVo = " + JSONObject.toJSONString((Object)userVO));
        return this.createGfmh(enterpriseEntity, vo.getSupplierId(), userVO, vo.getSystemId());
    }

    @Override
    public CommonResponse<String> generateSupplierTenant(JSONObject vo) {
        UserVO userVO = this.iUserService.selectById(vo.getLong("userId"));
        if (userVO == null) {
            this.logger.error("\u751f\u6210\u4f9b\u65b9\u5931\u8d25\uff0cvo= " + vo.toJSONString());
            return CommonResponse.error((String)"\u4f9b\u65b9\u7528\u6237\u4e0d\u5b58\u5728");
        }
        userVO.setUserName(vo.getString("userName"));
        userVO.setUserMobile(vo.getString("telephone"));
        this.iUserService.saveOrUpdate(BeanMapper.map((Object)userVO, UserEntity.class), false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    public CommonResponse<TenantVO> createGfmh(EnterpriseEntity enterpriseEntity, Long supplierId, UserVO userVO, String systemId) {
        enterpriseEntity.setExamineState("1");
        enterpriseEntity.setWays("4");
        enterpriseEntity.setBusinessType("2");
        Long tenantId = IdWorker.getId();
        Long passwordPolicyId = IdWorker.getId();
        Long orgId = IdWorker.getId();
        Long userId = userVO.getId() == null ? IdWorker.getId() : userVO.getId();
        enterpriseEntity.setTenantId(tenantId);
        enterpriseEntity.setUserId(userId);
        TenantEntity tenantEntity = new TenantEntity();
        tenantEntity.setId(tenantId);
        tenantEntity.setTenantId(tenantId);
        tenantEntity.setName(enterpriseEntity.getName());
        tenantEntity.setCode("T" + tenantId);
        tenantEntity.setEnterpriseId(enterpriseEntity.getId());
        tenantEntity.setPasswordPolicyId(passwordPolicyId);
        tenantEntity.setState(1);
        QueryWrapper categoryWapper = new QueryWrapper();
        categoryWapper.eq((Object)"default_flag", (Object)"1");
        List list = this.menuCategoryService.list((Wrapper)categoryWapper);
        if (list != null && list.size() > 0) {
            tenantEntity.setMenuCategoryId(((MenuCategoryEntity)((Object)list.get(0))).getId());
        }
        UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
        if (userVO.getId() == null) {
            userTenantRelationEntity.setMainSpaceFlag(1);
        } else {
            userTenantRelationEntity.setMainSpaceFlag(0);
        }
        userTenantRelationEntity.setUserId(userId);
        userTenantRelationEntity.setTenantId(tenantId);
        userTenantRelationEntity.setTypeId(1);
        userTenantRelationEntity.setEmployeeId(userId);
        userTenantRelationEntity.setOrgId(orgId);
        userTenantRelationEntity.setState(1);
        PasswordPolicyVO passwordPolicyVO = this.iPasswordPolicyService.findByTenantId(999999L);
        passwordPolicyVO.setId(passwordPolicyId);
        passwordPolicyVO.setTenantId(tenantId);
        passwordPolicyVO.setCode("PP" + passwordPolicyId);
        passwordPolicyVO.setTenantId(tenantId);
        passwordPolicyVO.setForceUpdateFlag(Integer.valueOf(0));
        passwordPolicyVO.setValiditeDays(Integer.valueOf(30));
        passwordPolicyVO.setPwdComplexity(Integer.valueOf(1));
        passwordPolicyVO.setMinLength(Integer.valueOf(6));
        PasswordPolicyEntity policyEntity = (PasswordPolicyEntity)((Object)BeanMapper.map((Object)passwordPolicyVO, PasswordPolicyEntity.class));
        DefaultPwdEntity defaultPwdEntity = this.iDefaultpwdService.getUserDefaultPassword(999999L);
        defaultPwdEntity.setId(IdWorker.getId());
        defaultPwdEntity.setTenantId(tenantId);
        defaultPwdEntity.setCreateTime(null);
        defaultPwdEntity.setUpdateTime(null);
        defaultPwdEntity.setUpdateUserCode(null);
        defaultPwdEntity.setCreateUserCode(null);
        defaultPwdEntity.setVersion(null);
        OrgEntity orgEntity = new OrgEntity();
        orgEntity.setId(orgId);
        orgEntity.setCode("BASE" + orgId);
        orgEntity.setEnterpriseId(enterpriseEntity.getId());
        orgEntity.setInnerCode(orgEntity.getId().toString());
        orgEntity.setState(1);
        orgEntity.setTenantId(tenantId);
        orgEntity.setName(enterpriseEntity.getName());
        orgEntity.setOrgType(1);
        orgEntity.setShortName(enterpriseEntity.getName());
        orgEntity.setManager(enterpriseEntity.getLegalName());
        orgEntity.setPhone(enterpriseEntity.getTelephone());
        orgEntity.setSequence(1);
        EmployeeVO employeeVO = null;
        UserEntity userEntity = null;
        if (userVO.getId() == null) {
            userVO.setId(userId);
            userVO.setTenantId(tenantId);
            userVO.setOrgId(orgId);
            userVO.setUserName(enterpriseEntity.getAuditName() != null ? enterpriseEntity.getAuditName() : PinYinUtil.getFullSpell(enterpriseEntity.getName()));
            userVO.setUserMobile(enterpriseEntity.getTelephone() != null ? enterpriseEntity.getTelephone() : "M" + IdWorker.getId());
            userVO.setUserCode("U" + IdWorker.getId());
            userVO.setUserState(UserVO.USER_STATE_ACTIVE);
            userVO.setDr(BaseVO.DR_UNDELETE);
            userVO.setTypeId(Integer.valueOf(1));
            PasswordUtils.setSalt(userVO);
            String password = userVO.getUserMobile().substring(userVO.getUserMobile().length() - 6);
            String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
            userVO.setPassword(shaPassword);
            userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
            userVO.setPwdStartTime(new Date());
            userEntity = (UserEntity)((Object)BeanMapper.map((Object)userVO, UserEntity.class));
            employeeVO = new EmployeeVO();
            employeeVO.setId(userId);
            employeeVO.setUserId(userId);
            employeeVO.setName(userEntity.getUserName());
            employeeVO.setCode("BASE-GFMH" + userEntity.getId());
            employeeVO.setEmployeeType(Integer.valueOf(1));
            employeeVO.setState(Integer.valueOf(0));
            employeeVO.setSex(Integer.valueOf(1));
            employeeVO.setMobilePhone(userEntity.getUserMobile());
            employeeVO.setOrgName(orgEntity.getName());
            employeeVO.setOrgId(orgId);
            employeeVO.setTenantId(tenantId);
        } else {
            EmployeeEntity employeeEntity = (EmployeeEntity)((Object)this.employeeService.selectById(userId));
            userVO.setUserName(enterpriseEntity.getAuditName() != null ? enterpriseEntity.getAuditName() : PinYinUtil.getFullSpell(enterpriseEntity.getName()));
            PasswordUtils.setSalt(userVO);
            String password = userVO.getUserMobile().substring(userVO.getUserMobile().length() - 6);
            String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
            userVO.setPassword(shaPassword);
            userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
            userVO.setPwdStartTime(new Date());
            if (userVO.getTenantId() == null) {
                userVO.setTenantId(tenantId);
            }
            if (userVO.getOrgId() == null) {
                userVO.setOrgId(orgId);
            }
            userEntity = (UserEntity)((Object)BeanMapper.map((Object)userVO, UserEntity.class));
            if (employeeEntity == null) {
                employeeVO = new EmployeeVO();
                employeeVO.setId(userId);
                employeeVO.setUserId(userId);
                employeeVO.setName(userEntity.getUserName());
                employeeVO.setCode("BASE-GFMH" + userEntity.getId());
                employeeVO.setEmployeeType(Integer.valueOf(1));
                employeeVO.setState(Integer.valueOf(0));
                employeeVO.setSex(Integer.valueOf(1));
                employeeVO.setMobilePhone(userEntity.getUserMobile());
                employeeVO.setOrgName(orgEntity.getName());
                employeeVO.setOrgId(orgId);
                employeeVO.setTenantId(tenantId);
            } else {
                employeeVO = (EmployeeVO)BeanMapper.map((Object)((Object)employeeEntity), EmployeeVO.class);
            }
        }
        JobEntity jobEntity = new JobEntity();
        jobEntity.setProperty(JobVO.JOB_TYPE_MAIN);
        jobEntity.setEmployeeId(userId);
        jobEntity.setCurState(JobVO.STATE_ACTIVE);
        jobEntity.setJobStartTime(new Date());
        jobEntity.setOrgId(orgId);
        jobEntity.setDr(BaseVO.DR_UNDELETE);
        jobEntity.setTenantId(tenantId);
        jobEntity.setId(IdWorker.getId());
        QueryWrapper roleWrapper = new QueryWrapper();
        roleWrapper.eq((Object)"dr", (Object)0);
        roleWrapper.eq((Object)"code", (Object)"PRO-GFMH");
        ComboEntity comboEntity = (ComboEntity)((Object)this.comboService.getOne((Wrapper)roleWrapper));
        ComboEnterpriseVO comboEnterpriseVO = new ComboEnterpriseVO();
        if (comboEntity != null) {
            comboEnterpriseVO.setTenantId(999999L);
            comboEnterpriseVO.setBuyerId(tenantId);
            comboEnterpriseVO.setComboId(comboEntity.getId());
            comboEnterpriseVO.setUserId(userId);
            comboEnterpriseVO.setEnabled("1");
            comboEnterpriseVO.setComboName(comboEntity.getName());
            comboEnterpriseVO.setOpeningTime(new Date());
            comboEnterpriseVO.setStartTime(new Date());
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
            try {
                comboEnterpriseVO.setEndTime(sdf2.parse("2900-10-10"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            this.logger.info("\u6ca1\u6709\u914d\u7f6e\u4f9b\u5e94\u5546\u9ed8\u8ba4\u5957\u9910\uff01");
        }
        EnterpriseInitVO initvo = (EnterpriseInitVO)BeanMapper.map((Object)((Object)enterpriseEntity), EnterpriseInitVO.class);
        try {
            this.initDataApi.initDataByParams(initvo);
        }
        catch (Exception e) {
            this.initDataApi.rollBackByParams(initvo);
            this.logger.error("\u521d\u59cb\u5316\u652f\u6491\u4e2d\u5fc3\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage() + ", enterpriseEntity = " + enterpriseEntity.getId());
        }
        CooperateEnterpriseEntity cooperateEnterpriseEntity = new CooperateEnterpriseEntity();
        cooperateEnterpriseEntity.setCode("CO-" + IdWorker.getId());
        cooperateEnterpriseEntity.setCooperateEnterId(Long.parseLong(systemId));
        cooperateEnterpriseEntity.setCooperationEnterpriseName(((EnterpriseEntity)((Object)this.selectById((Serializable)((Object)systemId)))).getName());
        cooperateEnterpriseEntity.setMyEnterpriseId(enterpriseEntity.getId());
        cooperateEnterpriseEntity.setSupplierId(supplierId.toString());
        cooperateEnterpriseEntity.setApplyState("3");
        cooperateEnterpriseEntity.setTenantId(tenantId);
        cooperateEnterpriseEntity.setApplyTime(new Date());
        cooperateEnterpriseEntity.setApplyReason("\u65bd\u5de5\u65b9\u63a8\u9001\u751f\u6210");
        cooperateEnterpriseEntity.setApplyPerson("\u7cfb\u7edf\u751f\u6210");
        QueryWrapper openApiGroupWaper = new QueryWrapper();
        openApiGroupWaper.eq((Object)"group_name", (Object)"\u4f9b\u65b9\u5e73\u53f0\u63a5\u6536\u6570\u636e\u670d\u52a1\u63a5\u53e3");
        openApiGroupWaper.eq((Object)"dr", (Object)0);
        List openApiGroupList = this.openApiGroupService.list((Wrapper)openApiGroupWaper);
        SecurityKeyEntity securityKeyEntity = new SecurityKeyEntity();
        ArrayList<SecurityKeyDetailEntity> securityKeyDetailList = new ArrayList<SecurityKeyDetailEntity>();
        Long securityKeyId = IdWorker.getId();
        String appid = IdWorker.getId() + "";
        String secret = Base64Util.encode((byte[])appid.getBytes());
        enterpriseEntity.setDataAppId(appid);
        enterpriseEntity.setDataAppSecret(secret);
        securityKeyEntity.setAppId(appid);
        securityKeyEntity.setSecretState(1);
        securityKeyEntity.setId(securityKeyId);
        securityKeyEntity.setSecretKey(secret);
        securityKeyEntity.setTenantId(tenantId);
        securityKeyEntity.setSecurityName(enterpriseEntity.getName() + "\u63a5\u6536\u6570\u636e\u670d\u52a1\u63a5\u53e3");
        securityKeyEntity.setSecretDesc("\u4f9b\u65b9\u5e73\u53f0\u751f\u6210\u79df\u6237\u521d\u59cb\u5316\u670d\u52a1\uff1a" + enterpriseEntity.getName() + "\u63a5\u6536\u6570\u636e\u670d\u52a1\u63a5\u53e3");
        if (openApiGroupList != null && openApiGroupList.size() > 0) {
            QueryWrapper openApiWrapper = new QueryWrapper();
            openApiWrapper.eq((Object)"group_id", (Object)((OpenApiGroupEntity)((Object)openApiGroupList.get(0))).getId());
            openApiWrapper.eq((Object)"dr", (Object)0);
            List openApiList = this.openApiService.list((Wrapper)openApiWrapper);
            if (openApiList != null && openApiList.size() > 0) {
                for (OpenApiEntity apiEntity : openApiList) {
                    SecurityKeyDetailEntity entity = new SecurityKeyDetailEntity();
                    entity.setOpenApiId(apiEntity.getId());
                    entity.setSecurityKeyId(securityKeyId);
                    securityKeyDetailList.add(entity);
                }
            } else {
                this.logger.error("\u672a\u521d\u59cb\u5316\u5177\u4f53\u7684openapi\u670d\u52a1,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u521d\u59cb\u5316\u6570\u636e , enterpriseEntity = " + enterpriseEntity.getId() + "  tenantId = " + tenantId);
            }
        } else {
            this.logger.error("\u672a\u521d\u59cb\u5316openapi,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u521d\u59cb\u5316\u6570\u636e , enterpriseEntity = " + enterpriseEntity.getId() + "  tenantId = " + tenantId);
        }
        TenantAffiliatedEntity affiliatedEntity = null;
        if ("3".equals(enterpriseEntity.getEnterpriseType())) {
            if (enterpriseEntity.getLoadTenantId() != null) {
                QueryParam param = new QueryParam();
                param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
                param.getParams().put("target_tenant_id", new Parameter("eq", (Object)enterpriseEntity.getLoadTenantId()));
                List entities = this.tenantAffiliatedService.queryList(param, false);
                if (ListUtil.isEmpty((List)entities)) {
                    TenantVO targetTenantVo = this.iTenantService.selectById(enterpriseEntity.getLoadTenantId());
                    affiliatedEntity = new TenantAffiliatedEntity();
                    affiliatedEntity.setTenantId(tenantId);
                    affiliatedEntity.setTargetTenantId(enterpriseEntity.getLoadTenantId());
                    affiliatedEntity.setTargetTenantName(targetTenantVo.getName());
                    affiliatedEntity.setMyTenantName(tenantEntity.getName());
                    affiliatedEntity.setMemo("\u540c\u610f-\u7cfb\u7edf\u81ea\u52a8\u6302\u9760");
                    affiliatedEntity.setTenantStatus(3L);
                    affiliatedEntity.setApplyDate(new Date());
                    affiliatedEntity.setSupplierId(((TenantAffiliatedEntity)((Object)entities.get(0))).getSupplierId());
                    this.logger.info("\u5206\u5305\u8d1f\u8d23\u4eba\u6302\u9760\u5230\u5206\u5305\u4f9b\u5e94\u5546\u79df\u6237---{}", (Object)JSONObject.toJSONString((Object)((Object)affiliatedEntity)));
                } else {
                    this.logger.error("\u5206\u5305\u73ed\u7ec4\u79df\u6237\u672a\u6302\u9760\u5230\u4f9b\u5e94\u5546\u79df\u6237\u4e0a\uff0c\u56e0\u4e3a\u6ca1\u6709\u627e\u5230\u8981\u6302\u9760\u7684\u4f9b\u5e94\u5546\u79df\u6237\u6240\u5728\u7684\u79c1\u6709\u5316\u4f01\u4e1a\u7684supplierId\uff0c\u5206\u5305\u4f9b\u5e94\u5546\u7684\u5408\u4f5c\u8868\u6ca1\u627e\u5230\uff01" + JSONObject.toJSONString((Object)((Object)enterpriseEntity)));
                }
            } else {
                this.logger.error("\u5206\u5305\u73ed\u7ec4\u79df\u6237\u672a\u6302\u9760\u5230\u4f9b\u5e94\u5546\u79df\u6237\u4e0a\uff0c\u56e0\u4e3a\u53c2\u6570\u6ca1\u643a\u5e26\u8981\u6302\u9760\u7684\u4f9b\u5e94\u5546\u79df\u6237id, enterpriseEntity = " + enterpriseEntity.getId() + "  tenantId = " + tenantId);
            }
        }
        try {
            this.logger.info("\u5f00\u59cb\u6301\u4e45\u5316\u6570\u636e-- ");
            this.iTenantService.saveOrUpdate((Object)tenantEntity, false);
            this.logger.info("\u6301\u4e45\u5316\u79df\u6237\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)tenantEntity)));
            this.iPasswordPolicyService.saveOrUpdate((Object)policyEntity, false);
            this.logger.info("\u6301\u4e45\u5316\u5bc6\u7801\u7b56\u7565\u6210\u529f-- ");
            this.iDefaultpwdService.saveOrUpdate((Object)defaultPwdEntity, false);
            this.logger.info("\u6301\u4e45\u5316\u9ed8\u8ba4\u5bc6\u7801\u6210\u529f-- ");
            this.iOrgService.saveOrUpdate((Object)orgEntity, false);
            this.logger.info("\u6301\u4e45\u5316\u6839\u7ec4\u7ec7\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)orgEntity)));
            this.iEmployeeService.saveOrUpdate(BeanMapper.map((Object)employeeVO, EmployeeEntity.class));
            this.iUserService.saveOrUpdate((Object)userEntity);
            this.logger.info("\u6301\u4e45\u5316\u7528\u6237\u4eba\u5458\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)userEntity)));
            QueryParam utrp = new QueryParam();
            utrp.getParams().put("employeeId", new Parameter("eq", (Object)userId));
            utrp.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            utrp.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            List listJ = this.jobService.queryList(utrp);
            if (ListUtil.isEmpty((List)listJ)) {
                this.jobService.saveOrUpdate((Object)jobEntity, false);
                this.logger.info("\u6301\u4e45\u5316job\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)jobEntity)));
            }
            this.cooperateEnterpriseService.saveOrUpdate((Object)cooperateEnterpriseEntity, false);
            this.logger.info("\u6301\u4e45\u5316\u5408\u4f5c\u4f01\u4e1a\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)cooperateEnterpriseEntity)));
            if (comboEntity != null) {
                if (employeeVO == null) {
                    EmployeeEntity employeeEntity = (EmployeeEntity)((Object)this.iEmployeeService.selectById(userId));
                    if (employeeEntity == null) {
                        this.logger.error("\u554a\u6b27\uff0c\u8fd8\u662f\u6ca1\u627e\u5230employeeVO, enterpriseEntity = " + enterpriseEntity.getId());
                    }
                    employeeVO = (EmployeeVO)BeanMapper.map((Object)((Object)employeeEntity), EmployeeVO.class);
                }
                employeeVO.setJobType(jobEntity.getProperty().intValue());
                employeeVO.setJobId(jobEntity.getId());
                this.comboEnterpriseService.loadComboEnterprise(comboEnterpriseVO, orgId, employeeVO);
                this.logger.info("\u6301\u4e45\u5316\u5957\u9910\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)comboEnterpriseVO)));
            }
            this.securityKeyService.saveOrUpdate((Object)securityKeyEntity, false);
            if (securityKeyDetailList != null && securityKeyDetailList.size() > 0) {
                this.securityKeyDetailService.saveOrUpdateBatch(securityKeyDetailList, securityKeyDetailList.size(), false);
            }
            this.logger.info("\u6301\u4e45\u5316\u79df\u6237openAPI\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)securityKeyEntity)));
            super.saveOrUpdate((Object)enterpriseEntity, false);
            this.logger.info("\u6301\u4e45\u5316\u4f01\u4e1a\u4fe1\u606f\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)enterpriseEntity)));
            this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
            this.logger.info("\u6301\u4e45\u5316\u79df\u6237\u7528\u6237\u5173\u7cfb\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)userTenantRelationEntity)));
            if (affiliatedEntity != null) {
                this.tenantAffiliatedService.saveOrUpdate((Object)affiliatedEntity, false);
                this.logger.info("\u6301\u4e45\u5316\u79df\u6237\u6302\u8f7d\u6210\u529f-- " + JSONObject.toJSONString((Object)((Object)affiliatedEntity)));
            }
            this.logger.info("\u6301\u4e45\u5316\u6570\u636e\u7ed3\u675f-- ");
            TenantVO tenantVO = (TenantVO)BeanMapper.map((Object)((Object)tenantEntity), TenantVO.class);
            tenantVO.setManagerId(userVO.getId());
            tenantVO.setManagerName(userVO.getUserName());
            tenantVO.setManagerPhone(userVO.getUserMobile());
            return CommonResponse.success((Object)tenantVO);
        }
        catch (Exception e) {
            this.logger.error("\u6301\u4e45\u5316\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage() + ", enterpriseEntity = " + enterpriseEntity.getId());
            e.printStackTrace();
            TenantVO tenantVO = (TenantVO)BeanMapper.map((Object)((Object)tenantEntity), TenantVO.class);
            tenantVO.setManagerId(userVO.getId());
            tenantVO.setManagerName(userVO.getUserName());
            tenantVO.setManagerPhone(userVO.getUserMobile());
            return CommonResponse.success((Object)tenantVO);
        }
    }

    private void sendMsg(UserVO userVO, CooperateEnterpriseEntity cooperateEnterpriseEntity, DefaultPwdEntity defaultPwdEntity, TenantVO tenantVO) {
        block6: {
            if (StringUtils.isNotBlank((String)userVO.getUserMobile()) && userVO.getUserMobile().length() == 11) {
                JSONObject messageParam = new JSONObject();
                messageParam.put("phone", (Object)userVO.getUserMobile());
                messageParam.put("templateCode", (Object)"SMS_250340068");
                messageParam.put("signName", (Object)"\u5206\u4f9b\u4e00\u4f53\u5316\u670d\u52a1\u5e73\u53f0");
                JSONObject params = new JSONObject();
                params.put("enterpriseName", (Object)("[" + cooperateEnterpriseEntity.getCooperationEnterpriseName() + "]"));
                params.put("userCode", (Object)userVO.getUserMobile());
                params.put("userPassword", (Object)defaultPwdEntity.getDefaultpwd());
                messageParam.put("params", (Object)params);
                String messageUrl = this.environmentTools.getBaseHost() + "ejc-message-web/no_auth/sms/sendMessage";
                try {
                    String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
                    CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
                    if (response.isSuccess()) {
                        this.logger.info("\u534f\u540c\u6210\u529f\u7684\u77ed\u4fe1\u901a\u77e5\u53d1\u9001\u6210\u529f\uff01----" + JSONObject.toJSONString((Object)tenantVO));
                        break block6;
                    }
                    this.logger.info("\u534f\u540c\u6210\u529f\u7684\u77ed\u4fe1\u901a\u77e5 \u53d1\u9001\u5931\u8d25\uff01----" + JSONObject.toJSONString((Object)tenantVO) + "   " + JSONObject.toJSONString((Object)response));
                }
                catch (SocketTimeoutException | ConnectTimeoutException e) {
                    e.printStackTrace();
                    this.logger.error("\u534f\u540c\u6210\u529f\u7684\u77ed\u4fe1\u901a\u77e5 \u53d1\u9001\u5931\u8d25\uff01----" + JSONObject.toJSONString((Object)tenantVO), e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("\u534f\u540c\u6210\u529f\u7684\u77ed\u4fe1\u901a\u77e5 \u53d1\u9001\u5931\u8d25\uff01----" + JSONObject.toJSONString((Object)tenantVO), (Throwable)e);
                }
            } else {
                this.logger.info("\u534f\u540c\u6210\u529f\u7684\u77ed\u4fe1\u901a\u77e5 \u672a\u53d1\u9001\uff01----" + JSONObject.toJSONString((Object)tenantVO));
            }
        }
    }

    @Override
    public CommonResponse<String> updateSupplierUserPhoneAndName(JSONObject vo) {
        this.logger.info("\u66f4\u65b0\u4f9b\u65b9\u624b\u673a\u53f7\u76f8\u5173\u53c2\u6570\uff1a" + vo.toJSONString());
        Long userId = vo.getLong("userId");
        Long systemId = vo.getLong("systemId");
        Long tenantId = vo.getLong("tenantId");
        String newPhone = vo.getString("newPhone");
        String newName = vo.getString("newName");
        if (StringUtils.isBlank((String)newPhone) || newPhone.length() != 11) {
            return CommonResponse.error((String)"\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        UserEntity userEntity = (UserEntity)((Object)this.iUserService.getById(userId));
        if (userEntity == null) {
            return CommonResponse.error((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        EmployeeEntity employeeEntity = (EmployeeEntity)((Object)this.iEmployeeService.getById(userId));
        if (employeeEntity == null) {
            return CommonResponse.error((String)"\u4eba\u5458\u4e0d\u5b58\u5728\uff01");
        }
        EnterpriseEntity enterpriseEntity = (EnterpriseEntity)((Object)this.getById(systemId));
        if (enterpriseEntity == null) {
            return CommonResponse.error((String)"\u62db\u91c7\u4f01\u4e1a\u4e0d\u5b58\u5728\uff01");
        }
        TenantVO tenantVO = this.iTenantService.selectById(tenantId);
        if (tenantVO == null) {
            return CommonResponse.error((String)"\u62db\u91c7\u79df\u6237\u4e0d\u5b58\u5728\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("userId", new Parameter("eq", (Object)userId));
        param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        List userTenantList = this.userTenantRelationService.queryList(param);
        if (ListUtil.isEmpty((List)userTenantList)) {
            return CommonResponse.error((String)"\u7528\u6237\u4e0e\u79df\u6237\u6570\u636e\u4e0d\u5339\u914d\uff01");
        }
        if (!Objects.equals(tenantVO.getEnterpriseId(), enterpriseEntity.getId())) {
            return CommonResponse.error((String)"\u4f01\u4e1a\u4e0e\u79df\u6237\u6570\u636e\u4e0d\u5339\u914d\uff01");
        }
        param = new QueryParam();
        param.getParams().put("user_mobile", new Parameter("eq", (Object)newPhone));
        List exist = this.iUserService.queryList(param);
        if (ListUtil.isNotEmpty((List)exist) && (exist.size() > 1 || !((UserEntity)((Object)exist.get(0))).getId().equals(userId))) {
            return CommonResponse.error((String)"\u65b0\u624b\u673a\u53f7\u5728\u7cfb\u7edf\u5185\u5df2\u88ab\u4ed6\u4eba\u4f7f\u7528\uff0c\u4e0d\u80fd\u66f4\u65b0\uff01");
        }
        String op = userEntity.getUserMobile();
        String name = userEntity.getUserName();
        userEntity.setUserMobile(newPhone);
        employeeEntity.setMobilePhone(newPhone);
        if (StringUtils.isNotBlank((String)newName)) {
            userEntity.setUserName(newName);
            employeeEntity.setName(newName);
        }
        this.iUserService.saveOrUpdate((Object)userEntity, false);
        this.employeeService.saveOrUpdate((Object)employeeEntity, false);
        this.logger.info("\u66f4\u65b0\u4f9b\u65b9\u624b\u673a\u53f7\u76f8\u5173\u53c2\u6570\uff1a" + vo.toJSONString() + " \u5df2\u5c06\u4f9b\u65b9\u7528\u6237id:" + userEntity.getId() + "  \u7528\u6237\u540d\uff1a" + name + ",\u624b\u673a\u53f7\uff1a" + op + " \u66f4\u65b0\u4e3a " + newName + "  " + newPhone);
        return CommonResponse.success((String)"\u62db\u91c7\u8d26\u53f7\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01");
    }

    @Override
    @Transactional
    public void initData(EnterpriseVO enterpriseVO) {
        Object vo;
        this.logger.info("1\u3001\u521d\u59cb\u5316\u79df\u6237\u3001\u7528\u6237\u3001\u7ec4\u7ec7\u7b49\u4fe1\u606f-----\u9489\u9489\u6216\u4f01\u4e1a\u5fae\u4fe1\u521d\u59cb\u5316\u4fe1\u606f\u8c03\u7528\uff01" + JSONObject.toJSONString((Object)enterpriseVO));
        if (StringUtils.isBlank((String)enterpriseVO.getSourceFrom())) {
            throw new BusinessException("\u9489\u9489\u6216\u4f01\u4e1a\u5fae\u4fe1\u521d\u59cb\u5316\u4fe1\u606f\u51fa\u9519\uff1a\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)enterpriseVO.getCorpid())) {
            throw new BusinessException("\u9489\u9489\u6216\u4f01\u4e1a\u5fae\u4fe1\u521d\u59cb\u5316\u4fe1\u606f\u51fa\u9519\uff1a\u9489\u9489\u6216\u8005\u4f01\u4e1a\u5fae\u4fe1id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        boolean exitTenant = false;
        QueryWrapper tenantWrapper = new QueryWrapper();
        ((QueryWrapper)tenantWrapper.eq((Object)"corpid", (Object)enterpriseVO.getCorpid())).eq((Object)"dr", (Object)0);
        TenantEntity exitTenantEntity = (TenantEntity)((Object)this.iTenantService.getOne((Wrapper)tenantWrapper));
        OrgVO exitOrgVO = new OrgVO();
        if (exitTenantEntity != null) {
            exitTenant = true;
            exitOrgVO = this.iOrgService.findOrgByTenantId(exitTenantEntity.getId());
        }
        boolean exitUser = false;
        QueryWrapper checkUserWrapper = new QueryWrapper();
        ((QueryWrapper)checkUserWrapper.eq((Object)"source_id", (Object)enterpriseVO.getUserSourceId())).eq((Object)"dr", (Object)0);
        UserEntity exitUserEntity = (UserEntity)((Object)this.iUserService.getOne((Wrapper)checkUserWrapper));
        if (exitUserEntity != null) {
            exitUser = true;
        }
        this.logger.info("2\u3001\u521d\u59cb\u5316\u79df\u6237\u3001\u7528\u6237\u3001\u7ec4\u7ec7\u7b49\u4fe1\u606f-----exitTenant=" + exitTenant + " exitUser =  " + exitUser);
        Long tenantId = IdWorker.getId();
        Long orgId = IdWorker.getId();
        if (exitTenant) {
            tenantId = exitTenantEntity.getId();
            orgId = exitOrgVO.getId();
        } else {
            enterpriseVO.setId(Long.valueOf(IdWorker.getId()));
        }
        Long passwordPolicyId = IdWorker.getId();
        Long userId = IdWorker.getId();
        if (exitUser) {
            userId = exitUserEntity.getId();
        }
        enterpriseVO.setTenantId(tenantId);
        TenantEntity tenantEntity = new TenantEntity();
        if (!exitTenant) {
            tenantEntity.setId(tenantId);
            tenantEntity.setTenantId(tenantId);
            tenantEntity.setName(enterpriseVO.getName());
            tenantEntity.setCode("T" + tenantId);
            tenantEntity.setEnterpriseId(enterpriseVO.getId());
            tenantEntity.setPasswordPolicyId(passwordPolicyId);
            tenantEntity.setState(1);
            tenantEntity.setSourceFrom(enterpriseVO.getSourceFrom());
            tenantEntity.setCorpid(enterpriseVO.getCorpid());
            tenantEntity.setPermanentCode(enterpriseVO.getPermanentCode());
            QueryWrapper categoryWapper = new QueryWrapper();
            categoryWapper.eq((Object)"default_flag", (Object)"1");
            List list = this.menuCategoryService.list((Wrapper)categoryWapper);
            if (list != null && list.size() > 0) {
                tenantEntity.setMenuCategoryId(((MenuCategoryEntity)((Object)list.get(0))).getId());
            }
        } else {
            tenantEntity = exitTenantEntity;
            tenantEntity.setPermanentCode(enterpriseVO.getPermanentCode());
        }
        UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
        userTenantRelationEntity.setMainSpaceFlag(1);
        userTenantRelationEntity.setUserId(userId);
        userTenantRelationEntity.setTenantId(tenantId);
        userTenantRelationEntity.setTypeId(1);
        userTenantRelationEntity.setEmployeeId(userId);
        userTenantRelationEntity.setOrgId(orgId);
        userTenantRelationEntity.setState(1);
        PasswordPolicyEntity policyEntity = new PasswordPolicyEntity();
        DefaultPwdEntity defaultPwdEntity = new DefaultPwdEntity();
        OrgEntity orgEntity = new OrgEntity();
        if (!exitTenant) {
            PasswordPolicyVO passwordPolicyVO = this.iPasswordPolicyService.findByTenantId(999999L);
            passwordPolicyVO.setId(passwordPolicyId);
            passwordPolicyVO.setTenantId(tenantId);
            passwordPolicyVO.setCode("PP" + passwordPolicyId);
            passwordPolicyVO.setTenantId(tenantId);
            passwordPolicyVO.setForceUpdateFlag(Integer.valueOf(0));
            passwordPolicyVO.setValiditeDays(Integer.valueOf(30));
            passwordPolicyVO.setPwdComplexity(Integer.valueOf(1));
            passwordPolicyVO.setMinLength(Integer.valueOf(6));
            policyEntity = (PasswordPolicyEntity)((Object)BeanMapper.map((Object)passwordPolicyVO, PasswordPolicyEntity.class));
            defaultPwdEntity = this.iDefaultpwdService.getUserDefaultPassword(999999L);
            defaultPwdEntity.setId(IdWorker.getId());
            defaultPwdEntity.setTenantId(tenantId);
            if (StringUtils.isNotBlank((String)enterpriseVO.getPassword())) {
                defaultPwdEntity.setDefaultpwd(enterpriseVO.getPassword());
            }
            defaultPwdEntity.setCreateTime(null);
            defaultPwdEntity.setUpdateTime(null);
            defaultPwdEntity.setUpdateUserCode(null);
            defaultPwdEntity.setCreateUserCode(null);
            defaultPwdEntity.setVersion(null);
            orgEntity.setId(orgId);
            orgEntity.setCode("BASE" + orgId);
            orgEntity.setEnterpriseId(enterpriseVO.getId());
            orgEntity.setInnerCode(orgEntity.getId().toString());
            orgEntity.setState(1);
            orgEntity.setTenantId(tenantId);
            orgEntity.setName(enterpriseVO.getName());
            orgEntity.setOrgType(1);
            orgEntity.setShortName(enterpriseVO.getName());
            orgEntity.setManager(enterpriseVO.getLegalName());
            orgEntity.setPhone(enterpriseVO.getTelephone());
            orgEntity.setSequence(1);
        } else {
            orgEntity = (OrgEntity)((Object)BeanMapper.map((Object)exitOrgVO, OrgEntity.class));
        }
        UserVO userVO = new UserVO();
        UserEntity userEntity = new UserEntity();
        EmployeeVO employeeVO = new EmployeeVO();
        if (!exitUser) {
            userVO.setTenantId(tenantId);
            userVO.setOrgId(orgId);
            userVO.setId(userId);
            userVO.setUserName(enterpriseVO.getUserName());
            userVO.setUserMobile(enterpriseVO.getTelephone());
            userVO.setSourceId(enterpriseVO.getUserSourceId());
            userVO.setUserCode(enterpriseVO.getUserCode());
            userVO.setUserState(UserVO.USER_STATE_ACTIVE);
            userVO.setTypeId(Integer.valueOf(1));
            userVO.setDr(BaseVO.DR_UNDELETE);
            PasswordUtils.setSalt(userVO);
            String password = defaultPwdEntity.getDefaultpwd();
            if (StringUtils.isNotBlank((String)enterpriseVO.getPassword())) {
                password = enterpriseVO.getPassword();
            }
            String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
            userVO.setPassword(shaPassword);
            userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
            userVO.setPwdStartTime(new Date());
            userEntity = (UserEntity)((Object)BeanMapper.map((Object)userVO, UserEntity.class));
            employeeVO.setId(userId);
            employeeVO.setUserId(userId);
            employeeVO.setName(userEntity.getUserName());
            employeeVO.setCode(enterpriseVO.getUserCode());
            employeeVO.setEmployeeType(Integer.valueOf(1));
            employeeVO.setState(Integer.valueOf(0));
            employeeVO.setSex(Integer.valueOf(1));
            if (StringUtils.isBlank((String)userEntity.getUserMobile())) {
                employeeVO.setMobilePhone(userEntity.getSourceId());
            } else {
                employeeVO.setMobilePhone(userEntity.getUserMobile());
            }
            employeeVO.setOrgName(orgEntity.getName());
            employeeVO.setOrgId(orgId);
            employeeVO.setTenantId(tenantId);
        }
        enterpriseVO.setUserId(userId);
        QueryWrapper roleWrapper = new QueryWrapper();
        roleWrapper.eq((Object)"dr", (Object)0);
        roleWrapper.eq((Object)"code", (Object)enterpriseVO.getComboCode());
        ComboEntity comboEntity = (ComboEntity)((Object)this.comboService.getOne((Wrapper)roleWrapper));
        ComboEnterpriseVO comboEnterpriseVO = new ComboEnterpriseVO();
        if (comboEntity != null) {
            comboEnterpriseVO.setBuyerId(tenantId);
            comboEnterpriseVO.setComboId(comboEntity.getId());
            comboEnterpriseVO.setUserId(userId);
            comboEnterpriseVO.setEnabled("1");
            comboEnterpriseVO.setComboName(comboEntity.getName());
            comboEnterpriseVO.setOpeningTime(new Date());
            comboEnterpriseVO.setStartTime(new Date());
            comboEnterpriseVO.setTenantId(999999L);
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(5, 15);
            comboEnterpriseVO.setEndTime(cal.getTime());
        }
        this.logger.info("3\u3001\u521d\u59cb\u5316\u79df\u6237\u3001\u7528\u6237\u3001\u7ec4\u7ec7\u7b49\u4fe1\u606f-----\u5411\u652f\u6491\u4e2d\u5fc3\u521d\u59cb\u5316\u6570\u636e=" + JSONObject.toJSONString((Object)enterpriseVO));
        if (!exitTenant) {
            try {
                vo = (EnterpriseInitVO)BeanMapper.map((Object)enterpriseVO, EnterpriseInitVO.class);
                this.initDataApi.initData((EnterpriseInitVO)vo);
            }
            catch (Exception e) {
                this.logger.info("3\u3001\u521d\u59cb\u5316\u79df\u6237\u3001\u7528\u6237\u3001\u7ec4\u7ec7\u7b49\u4fe1\u606f-----\u5411\u652f\u6491\u4e2d\u5fc3\u521d\u59cb\u5316\u6570\u636e\u51fa\u5dee****" + e.getMessage());
                e.printStackTrace();
                this.initDataApi.rollBack(tenantId);
                throw new BusinessException("\u521d\u59cb\u5316\u652f\u6491\u4e2d\u5fc3\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        this.logger.info("4\u3001\u521d\u59cb\u5316\u79df\u6237\u3001\u7528\u6237\u3001\u7ec4\u7ec7\u7b49\u4fe1\u606f-----\u6570\u636e\u6301\u4e45\u5316");
        try {
            this.iTenantService.saveOrUpdate((Object)tenantEntity, false);
            if (!exitTenant) {
                this.logger.info("4\u3001\u521d\u59cb\u5316\u79df\u6237");
                this.iPasswordPolicyService.saveOrUpdate((Object)policyEntity, false);
                this.iDefaultpwdService.saveOrUpdate((Object)defaultPwdEntity, false);
                this.iOrgService.saveOrUpdate((Object)orgEntity, false);
                enterpriseVO.setLogoPath(this.environmentTools.getBaseHost() + "portal/themes/default/images/yjb_logo.png");
                EnterpriseEntity entity = (EnterpriseEntity)((Object)BeanMapper.map((Object)enterpriseVO, EnterpriseEntity.class));
                super.saveOrUpdate((Object)entity, false);
            } else {
                enterpriseVO = this.selectById(tenantEntity.getEnterpriseId());
            }
            if (!exitUser) {
                this.logger.info("4\u3001\u521d\u59cb\u5316 \u7528\u6237");
                this.iEmployeeService.save(employeeVO, userEntity);
                this.iUserService.saveOrUpdate((Object)userEntity);
                this.logger.info("4\u3001\u521d\u59cb\u5316\u79df\u6237\u3001\u7528\u6237\u5173\u7cfb");
                this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
            } else {
                vo = new JobEntity();
                ((JobEntity)((Object)vo)).setProperty(JobVO.JOB_TYPE_MAIN);
                ((JobEntity)((Object)vo)).setEmployeeId(employeeVO.getId());
                ((JobEntity)((Object)vo)).setCurState(JobVO.STATE_ACTIVE);
                ((JobEntity)((Object)vo)).setJobStartTime(new Date());
                ((JobEntity)((Object)vo)).setOrgId(employeeVO.getOrgId());
                ((JobEntity)((Object)vo)).setDeptId(employeeVO.getDeptId());
                ((JobEntity)((Object)vo)).setPostId(employeeVO.getPostId());
                vo.setDr(BaseVO.DR_UNDELETE);
                vo.setTenantId(employeeVO.getTenantId());
                ((JobEntity)((Object)vo)).setDeptHead(employeeVO.getDeptHead());
                this.jobService.saveOrUpdate(vo, false);
                this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
            }
            if (comboEntity != null && !exitTenant) {
                this.logger.info("4\u3001\u521d\u59cb\u5316\u5957\u9910");
                this.comboEnterpriseService.saveComboEnterprise(comboEnterpriseVO);
            }
            this.initQYWXAndDDDefaultProject(tenantEntity, orgEntity, enterpriseVO);
        }
        catch (Exception e) {
            this.logger.info("4\u3001\u521d\u59cb\u5316\u79df\u6237\u3001\u7528\u6237\u3001\u7ec4\u7ec7\u7b49\u4fe1\u606f-----\u6570\u636e\u6301\u4e45\u5316\u51fa\u5dee****{}", (Throwable)e);
            e.printStackTrace();
            if (!exitTenant) {
                this.initDataApi.rollBack(tenantId);
            }
            throw new BusinessException("\u6301\u4e45\u5316\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage());
        }
    }

    private void initQYWXAndDDDefaultProject(TenantEntity tenantEntity, OrgEntity orgEntity, EnterpriseVO enterpriseVO) {
        String projectUrl = this.environmentTools.getBaseHost() + "ejc-market-web/projectRegister/no_auth/initQYWXAndDDDefaultProject";
        try {
            JSONObject body = new JSONObject();
            body.put("tenantId", (Object)tenantEntity.getId());
            body.put("orgId", (Object)orgEntity.getId());
            body.put("orgName", (Object)orgEntity.getName());
            body.put("enterpriseId", (Object)enterpriseVO.getId());
            String responseStr = HttpTookit.postByJson((String)projectUrl, (String)JSON.toJSONString((Object)body));
            if (StringUtils.isBlank((String)responseStr)) {
                this.logger.info("\u521d\u59cb\u5316\u9ed8\u8ba4\u9879\u76ee\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740{}\uff0c\u53c2\u6570{}\uff0c\u8fd4\u56de\u503c\u4e3a\u7a7a\uff01", (Object)projectUrl, (Object)body.toJSONString());
                return;
            }
            CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
            if (!response.isSuccess()) {
                this.logger.info("\u521d\u59cb\u5316\u9ed8\u8ba4\u9879\u76ee\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740{}\uff0c\u53c2\u6570{}\uff0c\u8fd4\u56de\u503c{}", new Object[]{projectUrl, body.toJSONString(), responseStr});
                return;
            }
            this.logger.info("\u521d\u59cb\u5316\u9ed8\u8ba4\u9879\u76ee\u6210\u529f\uff0c\u8bf7\u6c42\u5730\u5740{}\uff0c\u53c2\u6570{}\uff0c\u8fd4\u56de\u503c{}", new Object[]{projectUrl, body.toJSONString(), responseStr});
            JSONObject data = (JSONObject)response.getData();
            if (!data.getBoolean("exist").booleanValue()) {
                OrgEntity orgDeptInfo = (OrgEntity)((Object)data.getObject("orgDeptInfo", OrgEntity.class));
                orgDeptInfo.setInnerCode(orgEntity.getInnerCode() + "|" + orgDeptInfo.getId());
                this.iOrgService.saveOrUpdate((Object)orgDeptInfo, false);
                this.logger.info("\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u65b0\u589e\u9879\u76ee\u90e8, \u521d\u59cb\u5316\u9ed8\u8ba4\u9879\u76ee\u90e8\u6210\u529f\uff0c{}", (Object)JSONObject.toJSONString((Object)((Object)orgDeptInfo)));
            } else {
                this.logger.info("\u9879\u76ee\u90e8\u5df2\u5b58\u5728\uff0c\u4e0d\u518d\u65b0\u589e\u9879\u76ee\u90e8,\u8fd4\u56de\u503c{}", (Object)responseStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<EnterpriseVO> getAllEnterpriseList() {
        List<EnterpriseVO> enterpriseVos = this.enterpriseMapper.getAllEnterpriseList();
        return enterpriseVos;
    }

    @Override
    public Long getAllUserNum() {
        return this.enterpriseMapper.getAllUserNum();
    }

    @Override
    public Long getUserThisYearNum() {
        return this.enterpriseMapper.getUserThisYearNum();
    }

    @Override
    public List<JSONObject> getEnterpriseComEndTimeLast3Month(String endDate) {
        return this.enterpriseMapper.getEnterpriseComEndTimeLast3Month(endDate);
    }

    @Override
    public JSONObject getEnterpriseComboInfo(Long tenantId) {
        return this.enterpriseMapper.getEnterpriseComboInfo(tenantId);
    }

    @Override
    public CommonResponse<EnterpriseVO> saveAndSubmit(EnterpriseVO vo) {
        UserEntity uniqueBean;
        EnterpriseEntity entity = (EnterpriseEntity)((Object)BeanMapper.map((Object)vo, EnterpriseEntity.class));
        entity.setWays("5");
        entity.setExamineState("1");
        entity.setEnterpriseType("1");
        QueryParam param = new QueryParam();
        param.getParams().put("name", new Parameter("eq", (Object)vo.getName()));
        List list = this.queryList(param);
        if (ListUtil.isNotEmpty((List)list) && ((EnterpriseEntity)((Object)list.get(0))).getId() != null && !((EnterpriseEntity)((Object)list.get(0))).getId().equals(entity.getId())) {
            return CommonResponse.error((String)"\u4f01\u4e1a\u5df2\u5b58\u5728\uff01");
        }
        QueryParam params = new QueryParam();
        params.getParams().put("taxCode", new Parameter("eq", (Object)vo.getName()));
        List listTaxCode = this.queryList(params);
        if (ListUtil.isNotEmpty((List)listTaxCode) && ((EnterpriseEntity)((Object)listTaxCode.get(0))).getId() != null && !((EnterpriseEntity)((Object)listTaxCode.get(0))).getId().equals(entity.getId())) {
            return CommonResponse.error((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        if (StringUtils.isNotBlank((String)vo.getManageAccount())) {
            QueryWrapper userCodeWrapper = new QueryWrapper();
            ((QueryWrapper)userCodeWrapper.eq((Object)"user_code", (Object)vo.getManageAccount())).eq((Object)"dr", (Object)0);
            uniqueBean = (UserEntity)((Object)this.iUserService.getOne((Wrapper)userCodeWrapper));
            if (uniqueBean != null) {
                throw new BusinessException("\u7528\u6237\u6821\u9a8c\u5931\u8d25\uff0c\u7528\u6237\u7f16\u7801\u5df2\u5b58\u5728\uff01");
            }
        }
        if (StringUtils.isNotBlank((String)vo.getManagePhone())) {
            QueryWrapper userPhoneWrapper = new QueryWrapper();
            ((QueryWrapper)userPhoneWrapper.eq((Object)"user_mobile", (Object)vo.getManagePhone())).eq((Object)"dr", (Object)0);
            uniqueBean = (UserEntity)((Object)this.iUserService.getOne((Wrapper)userPhoneWrapper));
            if (uniqueBean != null) {
                throw new BusinessException("\u7528\u6237\u6821\u9a8c\u5931\u8d25\uff0c\u7528\u6237\u624b\u673a\u5df2\u5b58\u5728\uff01");
            }
        }
        Long tenantId = IdWorker.getId();
        Long passwordPolicyId = IdWorker.getId();
        Long orgId = IdWorker.getId();
        Long userId = IdWorker.getId();
        UserVO userVO = new UserVO();
        userVO.setId(userId);
        userVO.setTenantId(tenantId);
        userVO.setUserName(vo.getManageName());
        userVO.setUserCode(vo.getManageAccount());
        userVO.setUserMobile(vo.getManagePhone());
        userVO.setUserState(UserVO.USER_STATE_ACTIVE);
        userVO.setDr(BaseVO.DR_UNDELETE);
        userVO.setTypeId(Integer.valueOf(1));
        userVO.setOrgId(orgId);
        PasswordUtils.setSalt(userVO);
        String shaPassword = PasswordUtils.encodePasswordUsingSHA("a123456");
        userVO.setPassword(shaPassword);
        userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
        userVO.setPwdStartTime(new Date());
        userVO.setTenantId(InvocationInfoProxy.getTenantid());
        UserEntity userEntity = (UserEntity)((Object)BeanMapper.map((Object)userVO, UserEntity.class));
        entity.setTenantId(tenantId);
        this.saveOrUpdateNoES((Object)entity);
        userEntity.setTenantId(tenantId);
        userEntity.setOrgId(orgId);
        TenantEntity tenantEntity = new TenantEntity();
        tenantEntity.setId(tenantId);
        tenantEntity.setTenantId(tenantId);
        tenantEntity.setName(entity.getName());
        tenantEntity.setCode("T" + tenantId);
        tenantEntity.setEnterpriseId(entity.getId());
        tenantEntity.setPasswordPolicyId(passwordPolicyId);
        tenantEntity.setState(1);
        QueryWrapper categoryWapper = new QueryWrapper();
        categoryWapper.eq((Object)"default_flag", (Object)"1");
        List categorylist = this.menuCategoryService.list((Wrapper)categoryWapper);
        if (categorylist != null && categorylist.size() > 0) {
            tenantEntity.setMenuCategoryId(((MenuCategoryEntity)((Object)categorylist.get(0))).getId());
        }
        PasswordPolicyVO passwordPolicyVO = this.iPasswordPolicyService.findByTenantId(999999L);
        passwordPolicyVO.setId(passwordPolicyId);
        passwordPolicyVO.setTenantId(tenantId);
        passwordPolicyVO.setCode("PP" + passwordPolicyId);
        passwordPolicyVO.setTenantId(tenantId);
        passwordPolicyVO.setForceUpdateFlag(Integer.valueOf(0));
        passwordPolicyVO.setValiditeDays(Integer.valueOf(30));
        passwordPolicyVO.setPwdComplexity(Integer.valueOf(1));
        passwordPolicyVO.setMinLength(Integer.valueOf(6));
        PasswordPolicyEntity policyEntity = (PasswordPolicyEntity)((Object)BeanMapper.map((Object)passwordPolicyVO, PasswordPolicyEntity.class));
        DefaultPwdEntity defaultPwdEntity = this.iDefaultpwdService.getUserDefaultPassword(999999L);
        defaultPwdEntity.setId(IdWorker.getId());
        defaultPwdEntity.setTenantId(tenantId);
        defaultPwdEntity.setDefaultpwd("a123456");
        defaultPwdEntity.setCreateTime(null);
        defaultPwdEntity.setUpdateTime(null);
        defaultPwdEntity.setUpdateUserCode(null);
        defaultPwdEntity.setCreateUserCode(null);
        defaultPwdEntity.setVersion(null);
        OrgEntity orgEntity = new OrgEntity();
        orgEntity.setId(orgId);
        orgEntity.setCode("BASE" + orgId);
        orgEntity.setEnterpriseId(entity.getId());
        orgEntity.setInnerCode(orgEntity.getId().toString());
        orgEntity.setState(1);
        orgEntity.setTenantId(tenantId);
        orgEntity.setName(entity.getName());
        orgEntity.setOrgType(1);
        orgEntity.setShortName(entity.getName());
        orgEntity.setManager(entity.getLegalName());
        orgEntity.setPhone(entity.getTelephone());
        orgEntity.setSequence(1);
        EmployeeVO employeeVO = new EmployeeVO();
        employeeVO.setId(userId);
        employeeVO.setUserId(userId);
        employeeVO.setName(vo.getManageName());
        employeeVO.setMobilePhone(vo.getManagePhone());
        employeeVO.setCode("BASE-EMP" + userEntity.getId());
        employeeVO.setEmployeeType(Integer.valueOf(1));
        employeeVO.setSex(Integer.valueOf(1));
        employeeVO.setMobilePhone(userEntity.getUserMobile());
        employeeVO.setOrgName(orgEntity.getName());
        employeeVO.setOrgId(orgId);
        employeeVO.setTenantId(tenantId);
        employeeVO.setState(Integer.valueOf(1));
        employeeVO.setDr(BaseVO.DR_UNDELETE);
        employeeVO.setSequence(Integer.valueOf(1));
        employeeVO.setWorkTime(new Date());
        UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
        userTenantRelationEntity.setMainSpaceFlag(1);
        userTenantRelationEntity.setEmployeeId(userId);
        userTenantRelationEntity.setUserId(userId);
        userTenantRelationEntity.setTenantId(tenantId);
        userTenantRelationEntity.setTypeId(1);
        userTenantRelationEntity.setOrgId(orgId);
        userTenantRelationEntity.setState(1);
        try {
            EnterpriseInitVO vo1 = (EnterpriseInitVO)BeanMapper.map((Object)((Object)entity), EnterpriseInitVO.class);
            this.initShareDataApi.initData(vo1);
        }
        catch (Exception e) {
            this.initShareDataApi.rollBack(tenantId);
            throw new BusinessException("\u521d\u59cb\u5316\u652f\u6491\u4e2d\u5fc3\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage());
        }
        try {
            this.iTenantService.saveOrUpdate((Object)tenantEntity, false);
            this.iPasswordPolicyService.saveOrUpdate((Object)policyEntity, false);
            this.iDefaultpwdService.saveOrUpdate((Object)defaultPwdEntity, false);
            this.iOrgService.saveOrUpdate((Object)orgEntity, false);
            this.iUserService.saveOrUpdate((Object)userEntity);
            JobEntity jobEntity = new JobEntity();
            jobEntity.setProperty(JobVO.JOB_TYPE_MAIN);
            jobEntity.setEmployeeId(employeeVO.getId());
            jobEntity.setCurState(JobVO.STATE_ACTIVE);
            jobEntity.setJobStartTime(employeeVO.getWorkTime());
            jobEntity.setOrgId(orgId);
            jobEntity.setDr(BaseVO.DR_UNDELETE);
            jobEntity.setTenantId(tenantId);
            this.jobService.saveOrUpdate((Object)jobEntity, false);
            this.iEmployeeService.saveOrUpdate(BeanMapper.map((Object)employeeVO, EmployeeEntity.class));
            super.saveOrUpdate((Object)entity, false);
            this.logger.info("------\u63d2\u5165\u7528\u6237\u79df\u6237\u5173\u7cfb\u8868start------");
            this.logger.info("userTenantRelationEntity" + JSONObject.toJSONString((Object)((Object)userTenantRelationEntity)));
            this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
        }
        catch (Exception e) {
            this.initDataApi.rollBack(tenantId);
            throw new BusinessException("\u6301\u4e45\u5316\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage());
        }
        EnterpriseVO back = (EnterpriseVO)BeanMapper.map((Object)((Object)entity), EnterpriseVO.class);
        back.setManageName(vo.getManageName());
        back.setManageAccount(vo.getManageAccount());
        back.setManagePhone(vo.getManagePhone());
        return CommonResponse.success((Object)back);
    }

    @Override
    public void fixUserRelation() {
        QueryParam param = new QueryParam();
        param.getParams().put("employee_id", new Parameter("eq", null));
        List relationEntities = this.userTenantRelationService.queryList(param);
        if (ListUtil.isNotEmpty((List)relationEntities)) {
            param = new QueryParam();
            ArrayList<JobEntity> jobEntities = new ArrayList<JobEntity>();
            for (UserTenantRelationEntity entity : relationEntities) {
                entity.setEmployeeId(entity.getUserId());
                param.getParams().put("orgId", new Parameter("eq", (Object)entity.getOrgId()));
                param.getParams().put("employeeId", new Parameter("eq", (Object)entity.getOrgId()));
                List list = this.jobService.queryList(param);
                if (!ListUtil.isEmpty((List)list)) continue;
                JobEntity job = new JobEntity();
                job.setTenantId(entity.getTenantId());
                job.setOrgId(entity.getOrgId());
                job.setEmployeeId(entity.getUserId());
                job.setCurState(0);
                job.setProperty(1);
                jobEntities.add(job);
            }
            this.userTenantRelationService.saveOrUpdateBatch(relationEntities);
            if (ListUtil.isNotEmpty(jobEntities)) {
                this.jobService.saveOrUpdateBatch(jobEntities);
            }
        }
    }
}

