package com.ejianc.foundation.tenant.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 租户bean
 * 
 * @author guominga
 *
 */
@TableName("ejc_idm_tenant")
public class TenantEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "enterprise_id")
	private Long enterpriseId; // 企业ID

	@TableField(value = "code")
	private String code; // 租户编码

	@TableField(value = "name")
	private String name; // 租户名称

	@TableField(value = "password_policy_id")
	private Long passwordPolicyId; // 租户密码策略Id

	@TableField(value = "state")
	private Integer state; // 租户状态(1:启用，0：停用)

	@TableField(value = "permanent_code")
	private String permanentCode; // 钉钉、企业微信永久授权码

	@TableField(value = "corpid")
	private String corpid; // 钉钉、企业微信id

	@TableField(value = "source_from")
	private String sourceFrom; // 渠道来源：企业微信、钉钉

	@TableField(value = "agentid")
	private String agentid; // 企业微信第三方应用agentid发消息使用

	@TableField(value = "menu_category_id")
	private Long menuCategoryId; // 菜单分类id

	public Long getEnterpriseId() {
		return enterpriseId;
	}

	public void setEnterpriseId(Long enterpriseId) {
		this.enterpriseId = enterpriseId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getPasswordPolicyId() {
		return passwordPolicyId;
	}

	public void setPasswordPolicyId(Long passwordPolicyId) {
		this.passwordPolicyId = passwordPolicyId;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public String getPermanentCode() {
		return permanentCode;
	}

	public void setPermanentCode(String permanentCode) {
		this.permanentCode = permanentCode;
	}

	public String getCorpid() {
		return corpid;
	}

	public void setCorpid(String corpid) {
		this.corpid = corpid;
	}

	public String getSourceFrom() {
		return sourceFrom;
	}

	public void setSourceFrom(String sourceFrom) {
		this.sourceFrom = sourceFrom;
	}

	public String getAgentid() {
		return agentid;
	}

	public void setAgentid(String agentid) {
		this.agentid = agentid;
	}

	public Long getMenuCategoryId() {
		return menuCategoryId;
	}

	public void setMenuCategoryId(Long menuCategoryId) {
		this.menuCategoryId = menuCategoryId;
	}
}
