package com.ejianc.foundation.usercenter.service;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.ProjectMembersVO;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.vo.UserRefVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IUserService extends IBaseService<UserEntity> {

	UserVO selectById(Long userId);

	/**
	 * 修改用户密码
	 *
	 * @param userId
	 * @param encryptedPassword
	 */
	void updateUserPassword(Long userId, String password);

	/**
	 * 查询用户账号信息
	 * 
	 * @param condition
	 * @return
	 */
	UserVO queryLoginUserByUserCodeOrPhoneNumOrEMail(String condition);

	/**
	 * 根据人员信息生成对应用户
	 *
	 * @param employeeVO
	 * @return
	 */
	UserVO generateNewUser(EmployeeVO employeeVO);

	/**
	 * 用户密码重置
	 *
	 * @param userId
	 */
    void resetpwd(Long userId);

    //根据组织查询用户+人员+任职
	IPage<UserRefVO> pageList(Map<String, Object> params);

	/**
	 * 修改用户状态
	 * 
	 * @param userId
	 * @param state
	 */
	void updateUserState(Long userId, Integer state);
	
	/**
	 * 根据用户主键ID列表查询对应用户列表
	 *
	 * @param userIds
	 * @return
	 */
    List<UserVO> selectAllByIds(List<Long> userIds, Long tenantId);

    /**
     * 查询用户翻页列表
     * 
     * @param queryParam
     * @param pageIndex
     * @param pageSize
     * @return
     */
	IPage<UserRefVO> queryPage(Map<String, Object> queryParam, Integer pageIndex, Integer pageSize);

	/**
	 * 查询指定组织（本下）的人员信息
	 *
	 * @param orgId
	 * @return
	 */
    List<Map<String, Object>> getEmployeeList(Long orgId);

    /**
     * 查询组织下的某些岗位用户列表
     *
     * @param orgIds
     * @param postIds
     * @return
     */
	List<UserVO> queryUserByPostAndOrg(List<Long> postIds, List<Long> orgIds);

	/**
	 * 根据微信openid获取用户详情接口
	 * 
	 * @param openId
	 * @return
	 */
	UserVO getUserByWxOpenId(String openId);


	/**
	 * 根据企业微信用户ID获取用户详情接口
	 * @param weixineeId
	 * @return
	 */
	UserVO getUserByWeixineeId(String weixineeId);

	/**
	 * 根据第三方应用 企业微信租户 获取用户列表接口
	 * @return
	 */
	List<UserEntity> getWXEEThirdUserByTenantId();

	/**
	 * 自动绑定openid
	 * 
	 * @param userId
	 * @param openId
	 */
	void updateOpenId(Long userId, String openId);

	/**
	 * 解除绑定
	 * 
	 * @param userid
	 */
	void unbindingWechat(Long userid);

	/**
	 * 更新用户最后一次登录时间
	 * 
	 * @param userid
	 */
	void updateUserLastLoginTime(Long userid);


	/**
	 * 更新用户基本资料（手机号、用户名、邮箱、头像）,同步更新人员信息（个人签名）---其他勿调
	 * 
	 * @param userVo
	 */
	CommonResponse<UserVO> save(UserVO userVo);

	/**
	 * 修改密码
	 * 
	 */
	CommonResponse<String> modifyPwd(Map<String, Object> param);

	/**
	 * 根据租户Id查询其租户下超级管理员账号
	 * 
	 * @param tenantId
	 * @return
	 */
	UserVO querySuperAdminByTenantId(Long tenantId);

	/**
	 * 自动绑定wxeeId
	 *
	 * @param userId
	 * @param wxeeId
	 */
	void updateWxEEId(Long userId, String wxeeId);
	
	/**
	 * 自动绑定weixinId
	 * 
	 * @param id
	 * @param weixinId
	 */
	void updateWeixinId(Long userId, String weixinId);

	/**
	 * 自动绑定钉钉Id
	 *
	 * @param userId
	 * @param ddId
	 */
	void updateDdId(Long userId, String ddId);

	/**
	 * 根据微信openid或者小程序openid获取用户信息
	 * 
	 * @param openid
	 * @return
	 */
	UserVO getUserByWxIdOrMinProgramIdOrWxEEIdOrDdId(String openid,String reqFrom);

	/**
	 * 查询用户根据主键或者sourceId
	 * 
	 * @param userId
	 * @return
	 */
	UserVO queryUserByIdOrSourceId(String userId);

	/**
	 * 查询用户根据 sourceId 和 租户id
	 *
	 * @param sourceId
	 * @return
	 */
	UserVO queryUserBySourceId(String sourceId,Long tenantId);

	/**
	 * 通过微信公众号返回的code 换取openid 再根据openid查询供方用户信息
	 * 仅供供方使用
	 *
	 * @param code 微信传的 code
	 * @return 查到返回具体用户信息，没有返回null
	 */
	UserVO querySupplierUserInfoByWXCode(String code);

	/**
	 * 根据用户查询用户编码信息
	 *
	 * @param userCode
	 * @return
	 */
	UserVO queryUserByUserCode(String userCode);
	/**
	 * 根据用户编码列表查询用户信息
	 *
	 * @param userCodes
	 * @return
	 */
	List<UserVO> queryUserByUserCodes(String[] userCodes);

	/**
	 * 刷新用户缓存
	 * 
	 */
	void refreshReferUserCache();

	/**
	 * 修改当前用户和人员的租户ID、用户类型
	 * 
	 * @param userId
	 * @param tenantId
	 * @param orgId
	 * @param deptId 
	 * @param postId 
	 */
	void updateTenantIdAndUserType(Integer userType, Long userId, long tenantId, Long orgId, Long deptId, Long postId);

	/**
	 * 根据手机号查询匹配的用户
	 *
	 * @param phone
	 * @return
	 */
    UserVO findByUserMobile(String phone);

	/**
	 * 给指定手机号发送验证码或者短信
	 * @param phone         手机号
	 * @param templateCode  短信模板编码
	 * @param signName      短信签名
	 * @return
	 */
    void sendMsg(String phone,String templateCode,String signName);

	/**
	 * 根据传入的sourceIds查询符合条件的sourceIds
	 * @param users     传入的用户sourceIds
	 * @param tenantId  租户id
	 * @param type      条件（disabled：租户内已停用的用户，exitOther：不存在当前租户中的用户id，toDisabled：该租户内要停用的用户id, exit: 获取存在当前系统的中的用户id）
	 * @return 符合条件的sourceIds
	 */
	List<String> selectSourceIds(List<String> users, Long tenantId, String type);
	/**
	 * 初始化 用户 信息-----钉钉或企业微信 云市场 初始化信息调用
	 */
	void initThirdAppUsers(String thirdUserId,String name,String mobile,String openUserId,Long tenantId,String roleCode);
	/**
	 * 更新 用户 信息-----钉钉或企业微信 云市场 初始化信息调用
	 * @param state 状态标识 (1:启用，0：停用)
	 */
	void updateThirdAppUsers(UserVO userVo,Integer state);

	/**
	 * 钉钉 企业微信 第三方应用 增加人员 挂载权限
	 * @param userId
	 * @param tenantId
	 * @param orgId
	 * @param typeId
	 * @param roleCode
	 */
	void addUserApp(Long userId, Long tenantId, Long orgId, Integer typeId,String roleCode);

	List<UserVO> queryMangerUserList(QueryParam param);
	/**
	 * 查询当前登录人员是否拥有某个应用的权限
	 * */
	Boolean queryUserHasAppPermission(Long appId);
	/**
	 * 查询当前登录人员的用户信息，并且当当前租户空间不是主空间时手动切换
	 * */
    UserVO dealAndDealUserBySourceId(String ddId, Long tenantId);

	List<JSONObject> queryUserInfosForZds(Map<String, String> param);

	List<ProjectMembersVO> queryProjectMembersByOrgId(List<Long> orgIds);
}
