package com.ejianc.foundation.workbench.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.workbench.vo.WidgetGroupVO;
import com.ejianc.foundation.workbench.bean.WidgetGroupEntity;
import com.ejianc.foundation.workbench.mapper.WidgetGroupMapper;
import com.ejianc.foundation.workbench.service.IWidgetGroupService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class WidgetGroupServiceImpl extends BaseServiceImpl<WidgetGroupMapper, WidgetGroupEntity> implements IWidgetGroupService {

	@Autowired
	private WidgetGroupMapper widgetGroupMapper;

	@Override
	public List<WidgetGroupVO> queryListByPid(Long id) {
		QueryWrapper<WidgetGroupEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("parent_id", id);
		List<WidgetGroupEntity> entities = widgetGroupMapper.selectList(wrapper);
		if(entities != null) {
			return BeanMapper.mapList(entities, WidgetGroupVO.class);
		}
		return null;
	}

}
