package com.ejianc.foundation.orgcenter.service.impl;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.mapper.JobMapper;
import com.ejianc.foundation.permission.mapper.RoleUserRelationMapper;
import com.ejianc.foundation.sign.bean.SignEntity;
import com.ejianc.foundation.sign.service.ISignService;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.builder.BuilderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.bean.DeptEntity;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.bean.PostEntity;
import com.ejianc.foundation.orgcenter.mapper.EmployeeMapper;
import com.ejianc.foundation.orgcenter.service.IDeptService;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.service.IPostService;
import com.ejianc.foundation.orgcenter.vo.EmployeeImportVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeJobVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.JobVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.tenant.service.IPasswordPolicyService;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.bean.UserManagerRelationAppEntity;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.service.IUserManagerRelationAppService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.gdty.param.GdtyEmp;
import com.ejianc.foundation.utils.ynsbj.param.YnsbjEmp;
import com.ejianc.foundation.utils.ynsbj.param.YnsbjEmpJob;
import com.ejianc.foundation.utils.ynsbj.resp.YnsbjDataInfo;
import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;

@SuppressWarnings("unchecked")
@Service("employeeService")
public class EmployeeServiceImpl extends BaseServiceImpl<EmployeeMapper, EmployeeEntity> implements IEmployeeService {

	private static final String EMPLOYEE_BILL_CODE = "IDM_EMPLOYEE";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private EmployeeMapper employeeMapper;
    @Autowired
    private IJobService jobService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IRoleUserRelationService roleUserRelationService;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private PermissionCacheManage permissionCacheManager;
    @Autowired
	private IBillCodeApi billCodeApi;
    @Autowired
    private IDeptService deptService;
    @Autowired
    private IPostService postService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IUserTenantRelationService userTenantRelationService;
    @Autowired
    private IUserManagerRelationAppService userManagerRelationAppService;
    @Autowired
    private RedissonLocker redissonLocker;
    @Autowired
    private IPasswordPolicyService passwordPolicyService;
    @Autowired
    private JobMapper jobMapper;
    @Autowired
    private RoleUserRelationMapper roleUserRelationMapper;
    @Autowired
    private ISignService signService;
    
    @Override
    public IPage<EmployeeVO> pageList(Map<String, Object> params) {
    	Object orgId = params.get("orgId");
    	if(orgId != null) {
    		OrgVO orgVo = orgService.queryDetail(Long.parseLong(orgId.toString()));
    		if(orgVo != null) {
    			params.put("innerCode", orgVo.getInnerCode());
    		}
    	}else{
    		return new Page<>();
    	}
        List<EmployeeVO> voList = new ArrayList<>();
        IPage<EmployeeVO> page = new Page<>();
        page.setCurrent(Integer.valueOf(params.get("pageNumber").toString()));
        page.setSize(Integer.valueOf(params.get("pageSize").toString()));

        long total = employeeMapper.count(params);
        page.setTotal(total);
        if(total == 0) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1 ? 0 : page.getCurrent() -  1) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        voList = employeeMapper.getList(params);
        page.setRecords(voList);
        return page;
    }


    @Override
    public IPage<EmployeeVO> pageALLList(Map<String, Object> params) {
        List<EmployeeVO> voList = new ArrayList<>();
        IPage<EmployeeVO> page = new Page<>();
        page.setCurrent(Integer.valueOf(params.get("pageNumber").toString()));
        page.setSize(Integer.valueOf(params.get("pageSize").toString()));

        long total = employeeMapper.count(params);
        page.setTotal(total);
        if(total == 0) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1 ? 0 : page.getCurrent() -  1) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        voList = employeeMapper.getList(params);
        page.setRecords(voList);
        return page;
    }
    @Override
    public EmployeeEntity save(EmployeeVO employeeVO) {
    	Long tenantId = InvocationInfoProxy.getTenantid();
        EmployeeEntity dbEntity = super.getById(employeeVO.getId());
		try{
			redissonLocker.lock(employeeVO.getMobilePhone()+"_save", TimeUnit.SECONDS, 10);
	        JobEntity job = jobService.getCurMainJob(employeeVO.getId());
	        UserTenantRelationEntity userTenantRelationEntity = null;//当前用户租户关系数据
	        if(null == dbEntity) {
                if(StringUtils.isBlank(employeeVO.getCode())){
                    CommonResponse<String> employeeResponse = billCodeApi.getCodeBatchByRuleCode(EMPLOYEE_BILL_CODE, tenantId);
                    if(employeeResponse.isSuccess()) {
                        employeeVO.setCode(employeeResponse.getData());
                    }else{
                        throw new BuilderException("网络异常， 编码生成失败， 请稍后再试");
                    }
                }
	            //新增用户
	        	employeeVO.setState(1);
	            employeeVO.setTenantId(tenantId);
	            employeeVO.setDr(BaseVO.DR_UNDELETE);
	            UserVO user = userService.generateNewUser(employeeVO);
	            if(user == null) {
	            	throw new BusinessException("新增人员失败， 手机号已存在,请用户自己申请加入企业");
	            }
	            employeeVO.setUserId(user.getId());
	            employeeVO.setId(user.getId()); //将用户Id和人员Id设置为同一值
	
	            QueryWrapper<EmployeeEntity> query = new QueryWrapper<>();
	            query.eq("dr", BaseVO.DR_UNDELETE);
	            query.eq("org_id", employeeVO.getOrgId());
	            Integer sequence = employeeMapper.selectCount(query);
	
	            employeeVO.setSequence(null == sequence ? 1 : sequence + 1);
	            dbEntity = BeanMapper.map(employeeVO, EmployeeEntity.class);

	            //判断部门负责人是否是该部门的部门负责人
            	Long deptId = employeeVO.getDeptId();
	            if(deptId!=null&&Objects.equals(1, employeeVO.getDeptHead())){
	            	//获取该部门的信息（取该部门的负责人信息）
	            	DeptEntity dept = deptService.selectById(deptId);
	            	if(dept.getDeptHead()!=null&& !Objects.equals(dept.getDeptHead(), user.getId())){
	            		//部门负责人发生变化----
	            		//原先的部门负责人任职清空
	            		jobService.updateDeptHeadNoByDeptId(deptId);
	            		//原先的部门负责人替换
	            		dept.setDeptHead(user.getId());
	            		deptService.saveOrUpdate(dept);
	            		//任职信息中的部门负责人添加
	            	}
	            }
	            //生成对应的工作记录
	            job = generateJob(employeeVO);
	            
				//生成用户租户关系表
	            UserTenantRelationEntity entity = new UserTenantRelationEntity();
	            entity.setUserId(user.getId());
	            entity.setEmployeeId(employeeVO.getId());
	            entity.setOrgId(employeeVO.getOrgId());
	            entity.setTenantId(employeeVO.getTenantId());
	            entity.setPostId(employeeVO.getTenantId());
	            entity.setDeptId(employeeVO.getDeptId());
	            entity.setMainSpaceFlag(1);//主空间
                if(employeeVO.getTypeId()==null){
                    entity.setTypeId(2);//普通用户
                }else {
                    entity.setTypeId(employeeVO.getTypeId());//前端传入
                }
	            entity.setState(1);//启用
	            userTenantRelationService.saveOrUpdate(entity, false);
	        } else {
                if(StringUtils.isBlank(employeeVO.getCode())){
                    throw new BuilderException("保存人员失败，人员编码不能为空！");
                }
	            //更新用户信息
	            UserVO user = userService.selectById(dbEntity.getUserId());
	            user.setUserMobile(employeeVO.getMobilePhone());
	            user.setSex(employeeVO.getSex()!=null?employeeVO.getSex().toString():null);
	            user.setUserName(employeeVO.getName());
	            user.setAvator(employeeVO.getPhotoPath());
                if(employeeVO.getTypeId()!=null){
                    user.setTypeId(employeeVO.getTypeId());//前端传入
                }
	            
	            //工作记录信息（获取当前用户主职任职信息）
	            job = jobService.getCurMainJob(employeeVO.getId());
	            //处理部门负责人
	            this.dealDeptHead(employeeVO,job);
                //更新职位角色
                job.setRoleIds(employeeVO.getRoleIds());
                job.setRoleNames(employeeVO.getRoleNames());

                job.setDeptHead(employeeVO.getDeptHead());
	    		QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
	    		wrapper.eq("user_id", dbEntity.getUserId());
	    		wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
	    		wrapper.eq("dr", 0);
				List<UserTenantRelationEntity> list = userTenantRelationService.list(wrapper);
				if(list!=null&&list.size()>0){
					userTenantRelationEntity = list.get(0);
	//				1. 直接修改租户关系表中的任职信息
					userTenantRelationEntity.setOrgId(employeeVO.getOrgId());
					userTenantRelationEntity.setPostId(employeeVO.getPostId());
					userTenantRelationEntity.setDeptId(employeeVO.getDeptId());
                    if(employeeVO.getTypeId()!=null){
                        userTenantRelationEntity.setTypeId(employeeVO.getTypeId());//前端传入
                    }
					if(userTenantRelationEntity.getMainSpaceFlag()==1){
	//		           	当前用户在主空间下：  2.人员、用户表中的租户、组织、部门、岗位修改；
	
			            dbEntity = BeanMapper.map(employeeVO, EmployeeEntity.class);
			            //更新用户组织信息
			            user.setOrgId(employeeVO.getOrgId());
					}else{
	//		        	当前用户不再主空间下：不能将前端传回的组织、租户、部门、岗位信息修改
						employeeVO.setTenantId(dbEntity.getTenantId());
						employeeVO.setOrgId(dbEntity.getOrgId());
						employeeVO.setDeptId(dbEntity.getDeptId());
						employeeVO.setPostId(dbEntity.getPostId());
			            dbEntity = BeanMapper.map(employeeVO, EmployeeEntity.class);
					}
					userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
					
					if(null != job && null != userTenantRelationEntity) {
			            job.setEmployeeId(dbEntity.getId());
			            job.setOrgId(userTenantRelationEntity.getOrgId());
			            job.setPostId(userTenantRelationEntity.getPostId());
			            job.setDeptId(userTenantRelationEntity.getDeptId());
			        }
				}
	            userService.saveOrUpdate(BeanMapper.map(user, UserEntity.class), false);
	        }
	
	        saveOrUpdate(dbEntity,false);

            if(employeeVO.getUserSignatureFileId()!=null){
                attachmentApi.updateAttachRef(employeeVO.getId(), Arrays.asList(employeeVO.getUserSignatureFileId()));
            }
            signService.updateFromEmpployee(dbEntity.getUserId(), employeeVO.getUserSignatureFileId(), employeeVO.getUserSignaturePath());

//	        CommonResponse<List<AttachmentVO>> attachListResp = attachmentApi.queryListBySourceId(employeeVO.getId(), null, "userSignature", null);
//	        if(attachListResp.isSuccess()) {
//	            List<AttachmentVO> attachList = attachListResp.getData();
//	            CommonResponse<String> updateResp = null;
//	            if(attachList.isEmpty() && (null != employeeVO.getUserSignatureFileId())) {
//	                updateResp = attachmentApi.updateAttachRef(employeeVO.getId(), Arrays.asList(employeeVO.getUserSignatureFileId()));
//	            } else {
//	                StringBuilder delIds = new StringBuilder();
//	                for(AttachmentVO file : attachList) {
//	                    if(!file.getId().equals(employeeVO.getUserSignatureFileId())) {
//	                        delIds.append(file.getId()).append(",");
//	                    }
//	                }
//	                if(delIds.length() > 1) {
//	                    updateResp = attachmentApi.delete(delIds.substring(0, delIds.length() -1));
//	                }
//	            }
//	            if(null !=updateResp && !updateResp.isSuccess()) {
//	                logger.error("保存/更新人员签名信息失败，更新对应人员签名文件信息失败！");
//	            }
//	        } else {
//	            logger.error("保存/更新人员签名信息失败，查询对应人员签名文件信息失败！");
//	        }

	        jobService.saveOrUpdate(job, false);
            if(employeeVO.getRoleDataList()!=null && employeeVO.getRoleDataList().size()>0){
                List<RoleUserRelationVO> addRoleUserList = new ArrayList<>();
                List<Long> delRoleUserIds = new ArrayList<>();
                for(RoleUserRelationVO item : employeeVO.getRoleDataList()){
                    if("add".equals(item.getRowState())){
                        RoleUserRelationVO vo = new RoleUserRelationVO();
                        vo.setRoleId(item.getRoleId());
                        vo.setUserId(dbEntity.getUserId());
                        vo.setEmployeeId(dbEntity.getId());
                        vo.setJobId(job.getId());
                        vo.setAuthOrgId(job.getOrgId());
                        addRoleUserList.add(vo);
                    }else if("del".equals(item.getRowState())){
                        delRoleUserIds.add(item.getId());
                    }
                }
                if(addRoleUserList!=null && addRoleUserList.size()>0){
                    roleUserRelationService.saveRoleUser(addRoleUserList);
                }
                if(delRoleUserIds!=null && delRoleUserIds.size()>0){
                    roleUserRelationService.delete(delRoleUserIds);
                }
            }
		} catch (Exception e) {
			e.printStackTrace();
//			throw new BusinessException(e.getMessage());
		} finally {
			redissonLocker.unlock(employeeVO.getMobilePhone()+"_save");
		}
        return dbEntity;
    }

    //处理部门负责人
    private void dealDeptHead(EmployeeVO employeeVO, JobEntity job) {
        //1、部门未变化--
        //1.1、部门负责人变化：是--->否; 1.2、部门负责人变化：否--->是; 1.3、部门负责人为变：无事件
        //2、部门发生变化
        //2.1、部门由无到有：且是部门负责人; 2.2、部门由无到有：不是部门负责人：无变化; 2.3、部门由有到无：且原先是部门负责人：
        //2.4、部门由有到无：原先不是部门负责人：无变化; 
    	//2.5、部门有，且变化：
		//2.5.1、原先是部门负责人，且现在也是部门负责人; 2.5.2、原先是部门负责人，现在不是部门负责人
		//2.5.3、原先不是部门负责人，现在是部门负责人; 2.5.4、原先不是部门负责人，现在也不是部门负责人：无事件
        if(Objects.equals(job.getDeptId(), employeeVO.getDeptId())){
            //1、部门未变化--
        	if(!Objects.equals(job.getDeptHead(), employeeVO.getDeptHead()) && job.getDeptId()!=null){
	            //1.1、部门负责人变化：是--->否
            	DeptEntity dept = deptService.selectById(job.getDeptId());
        		if(Objects.equals(job.getDeptHead(),1) && !Objects.equals(employeeVO.getDeptHead(),1)){
            		//原先的部门负责人任职清空
            		jobService.updateDeptHeadNoByDeptId(job.getDeptId());
            		//原先的部门负责人替换
            		dept.setDeptHead(null);
            		deptService.saveOrUpdate(dept);
        		}
	            //1.2、部门负责人变化：否--->是
        		if(Objects.equals(employeeVO.getDeptHead(),1) && !Objects.equals(job.getDeptHead(),1)){
            		//原先的部门负责人任职清空
            		jobService.updateDeptHeadNoByDeptId(job.getDeptId());
            		//原先的部门负责人替换
            		dept.setDeptHead(employeeVO.getUserId());
            		deptService.saveOrUpdate(dept);
        		}
        	}else{
	            //1.3、部门负责人为变：无事件
        	}
        }else{
            //2、部门发生变化
        	if(job.getDeptId()==null&&employeeVO.getDeptId()!=null && Objects.equals(employeeVO.getDeptHead(),1)){
	            //2.1、部门由无到有：且是部门负责人：
            	DeptEntity dept = deptService.selectById(employeeVO.getDeptId());
        		//部门负责人任职清空
        		jobService.updateDeptHeadNoByDeptId(employeeVO.getDeptId());
        		//部门负责人替换
        		dept.setDeptHead(employeeVO.getUserId());
        		deptService.saveOrUpdate(dept);
        	}
        	if(job.getDeptId()==null&&employeeVO.getDeptId()!=null && !Objects.equals(employeeVO.getDeptHead(),1)){
	            //2.2、部门由无到有：不是部门负责人：无变化：
        		
        	}
        	
        	if(employeeVO.getDeptId()==null&&job.getDeptId()!=null && Objects.equals(job.getDeptHead(),1)){
	            //2.3、部门由有到无：且原先是部门负责人：
            	DeptEntity dept = deptService.selectById(job.getDeptId());
        		//部门负责人任职清空
        		jobService.updateDeptHeadNoByDeptId(employeeVO.getDeptId());
        		//部门负责人替换
        		dept.setDeptHead(null);
        		deptService.saveOrUpdate(dept);
        	}
        	if(employeeVO.getDeptId()==null&&job.getDeptId()!=null && !Objects.equals(job.getDeptHead(),1)){
	            //2.4、部门由有到无：原先不是部门负责人：无变化：
        	}
            if(employeeVO.getDeptId()!=null&&job.getDeptId()!=null){
	            //2.5、部门有，且变化：
            	if(Objects.equals(job.getDeptHead(),1) && Objects.equals(employeeVO.getDeptHead(),1)){
            		//2.5.1、原先是部门负责人，且现在也是部门负责人
	            	DeptEntity olddept = deptService.selectById(job.getDeptId());
            		//部门负责人任职清空
            		jobService.updateDeptHeadNoByDeptId(job.getDeptId());
            		//部门负责人替换
            		olddept.setDeptHead(null);
            		deptService.saveOrUpdate(olddept);
            		
	            	DeptEntity dept = deptService.selectById(employeeVO.getDeptId());
            		//部门负责人任职清空
            		jobService.updateDeptHeadNoByDeptId(employeeVO.getDeptId());
            		//部门负责人替换
            		dept.setDeptHead(employeeVO.getUserId());
            		deptService.saveOrUpdate(dept);
            		
            	}
            	if(Objects.equals(job.getDeptHead(),1) && !Objects.equals(employeeVO.getDeptHead(),1)){
            		//2.5.2、原先是部门负责人，现在不是部门负责人
	            	DeptEntity olddept = deptService.selectById(job.getDeptId());
            		//部门负责人任职清空
            		jobService.updateDeptHeadNoByDeptId(job.getDeptId());
            		//部门负责人替换
            		olddept.setDeptHead(null);
            		deptService.saveOrUpdate(olddept);
            	}
            	if(!Objects.equals(job.getDeptHead(),1) && Objects.equals(employeeVO.getDeptHead(),1)){
            		//2.5.3、原先不是部门负责人，现在是部门负责人
	            	DeptEntity dept = deptService.selectById(employeeVO.getDeptId());
            		//部门负责人任职清空
            		jobService.updateDeptHeadNoByDeptId(employeeVO.getDeptId());
            		//部门负责人替换
            		dept.setDeptHead(employeeVO.getUserId());
            		deptService.saveOrUpdate(dept);
            		
            	}
            	if(!Objects.equals(job.getDeptHead(),1) && !Objects.equals(employeeVO.getDeptHead(),1)){
            		//2.5.4、原先不是部门负责人，现在也不是部门负责人：无事件
            	}
            }
        }
	}

	/**
     * 保存信息检查
     *
     * @param employeeVO
     */
    private void checkInfo(EmployeeVO employeeVO) {
        //判断手机号是否已被使用
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("mobilePhone", new Parameter(QueryParam.EQ, employeeVO.getMobilePhone()));
        queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<EmployeeEntity> list = queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("保存人员信息失败，该租户注册手机号已被人员id为【"+list.get(0).getId()+"】的用户使用！");
        }
    }
    @Override
    @Transactional
    public EmployeeEntity save(EmployeeVO employeeVO, UserEntity user) {
        checkInfo(employeeVO);
        //新增人员
        employeeVO.setState(1);
        employeeVO.setDr(BaseVO.DR_UNDELETE);
        employeeVO.setUserId(user.getId());
        employeeVO.setId(user.getId()); //将用户Id和人员Id设置为同一值
        employeeVO.setSequence(1);
        employeeVO.setWorkTime(new Date());
        EmployeeEntity dbEntity = BeanMapper.map(employeeVO, EmployeeEntity.class);
        super.saveOrUpdate(dbEntity,false);
        //生成对应的工作记录
        JobEntity job = generateJob(employeeVO);
        jobService.saveOrUpdate(job, false);
        employeeVO.setJobId(job.getId());
        employeeVO.setOrgId(job.getOrgId());
        employeeVO.setDeptId(job.getDeptId());
        employeeVO.setPostId(job.getPostId());
        return dbEntity;
    }

    /**
     * 根据人员信息生成工作记录
     *
     * @param employeeVO
     * @return
     */
    public JobEntity generateJob(EmployeeVO employeeVO) {
        JobEntity vo = new JobEntity();
        // 属性类型：主职
        vo.setProperty(JobVO.JOB_TYPE_MAIN);
        vo.setEmployeeId(employeeVO.getId());
        // 新的工作记录
        vo.setCurState(JobVO.STATE_ACTIVE);
        vo.setJobStartTime(employeeVO.getWorkTime());
        vo.setOrgId(employeeVO.getOrgId());
        vo.setDeptId(employeeVO.getDeptId());
        vo.setPostId(employeeVO.getPostId());
        vo.setDr(BaseVO.DR_UNDELETE);
        vo.setTenantId(employeeVO.getTenantId());
        vo.setDeptHead(employeeVO.getDeptHead());
        vo.setRoleIds(employeeVO.getRoleIds());
        vo.setRoleNames(employeeVO.getRoleNames());
        return vo;
    }

    /**
     * 只针对兼职职位进行注销
     */
    @Override
    @Transactional
    public void writtenOff(JobVO job) {
        EmployeeEntity e = baseMapper.selectById(job.getEmployeeId());
        if(null == e) {
            logger.error(String.format("人员主键-{}对应的记录不存在", job.getEmployeeId()));
            throw new BusinessException("人员注销失败，人员记录不存在!");
        }
        JobEntity jobEntity = jobService.getById(job.getId());
        if(null == jobEntity) {
            logger.error(String.format("待删除的人员-{}该任职记录不存在", e.getName()));
            throw new BusinessException(String.format("待删除的人员-[%s]该任职记录不存在", e.getName()));
        }

        if(jobEntity.getProperty().equals(JobVO.JOB_TYPE_MAIN)) {
            throw new BusinessException("主职不允许注销！");
        }
        
        //查询用户授权表
        QueryParam roleUserQueryParam = new QueryParam();
        roleUserQueryParam.getParams().put("employeeId", new Parameter(QueryParam.EQ, jobEntity.getEmployeeId()));
        roleUserQueryParam.getParams().put("jobId", new Parameter(QueryParam.EQ, jobEntity.getId()));
        roleUserQueryParam.getParams().put("authOrgId", new Parameter(QueryParam.EQ, jobEntity.getOrgId()));
        List<RoleUserRelationEntity> roleUserRelations = roleUserRelationService.queryList(roleUserQueryParam, false);
        //删除该工作记录对应的角色人员关系
        if(CollectionUtils.isNotEmpty(roleUserRelations)) {
            roleUserRelationService.delete(roleUserRelations.stream().map(r -> r.getId()).collect(Collectors.toList()));
        }

        //设置职位为注销状态
        jobEntity.setCurState(JobVO.STATE_INACTIVE);
        jobEntity.setJobEndTime(new Timestamp(System.currentTimeMillis()));
        jobService.saveOrUpdate(jobEntity, false);

        //处理部门负责人
        if(job.getDeptId()!=null&&Objects.equals(job.getDeptHead(), 1)){
        	DeptEntity dept = deptService.selectById(job.getDeptId());
    		//部门负责人任职清空
    		jobService.updateDeptHeadNoByDeptId(job.getDeptId());
    		//部门负责人替换
    		dept.setDeptHead(null);
    		deptService.saveOrUpdate(dept);
        }
    }

	@Override
    public void moveEmployee(Map<String, Object> param) {
        Long orgId = Long.valueOf(param.get("orgId").toString());
        Long deptId = null != param.get("deptId") ? Long.valueOf(param.get("deptId").toString()) : null;
        Long postId = param.get("postId") != null ? Long.valueOf(param.get("postId").toString()) : null;
        Integer deptHead = null != param.get("deptHead") ? Integer.valueOf(param.get("deptHead").toString()) : null;
		logger.info("#########{}",param);
        //Map<EmployeeId, List<RoleUserRelation>
        Map<String, List<RoleUserRelationVO>> relations = null;
        if(param.get("detail") == null){
            relations = new HashMap<>();
            List<Map<String,String>> emp = (List<Map<String,String>>)param.get("selectEmployees");
            logger.info("emp{}",JSONObject.toJSONString(emp));
            for (Map<String, String> map : emp) {
                List<RoleUserRelationVO> relationVOS = new ArrayList<>();
                RoleUserRelationVO vo = new RoleUserRelationVO();
                vo.setAuthOrgId(orgId);
                vo.setEmployeeId(Long.parseLong(map.get("id")));
                vo.setPostId(postId);
                relationVOS.add(vo);
                relations.put(map.get("id"),relationVOS);
            }
        }else {
            relations = (Map<String, List<RoleUserRelationVO>>) param.get("detail");
        }

        //待更新人员列表
        List<EmployeeEntity> employeeList = new ArrayList<>();
        //待更新用户列表
        List<UserEntity> updateUserList = new ArrayList<>();
        //待更新用户租户关系列表
        List<UserTenantRelationEntity> userTenantRelationList = new ArrayList<>();
        //当前人员主职对应关系列表
        List<RoleUserRelationVO> currentRelation = null;
        //人员当前启用的主职工作记录
        JobEntity currentMainJob = null;
        //人员所有主职工作记录主键
        List<JobEntity> curEmployeeMainJobs = new ArrayList<>();
        //待删除人员角色关系列表
        List<Long> delRealtionList = new ArrayList<>();
        //待更新、新增工作记录列表
        List<JobEntity> saveJobList = new ArrayList<>();
        //查询条件
        QueryParam  queryParam = null;
        //待新增人员角色关系列表
        List<RoleUserRelationVO> saveRelation = new ArrayList<>();
        List<RoleUserRelationVO> newRelations = null;

        //当前工作记录对应角色人员关系：roleId+'_'+'orgId'
        List<String> curRelationsStr = new ArrayList<>();
        for(String employeeId : relations.keySet()) {
            newRelations = JSONArray.parseArray(JSONArray.toJSONString(relations.get(employeeId)), RoleUserRelationVO.class);
            curRelationsStr.clear();
          /**
           * 当前用户在主空间下： 1. 直接修改租户关系表中的任职信息； 2.人员、用户表中的租户、组织、部门、岗位修改；  3.增加任职信息
           * 当前用户不再主空间下： 1. 直接修改租户关系表中的任职信息（不能将前端传回的组织、租户、部门、岗位信息修改） 2.增加任职信息
           **/
    		QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
    		wrapper.eq("employee_id", employeeId);
    		wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
    		wrapper.eq("dr", 0);
			List<UserTenantRelationEntity> list = userTenantRelationService.list(wrapper);
			Boolean mainSpaceFlag = false;
			UserTenantRelationEntity nowUserTenantRelationEntity = null;
			if(list!=null&&list.size()>0){
				nowUserTenantRelationEntity = list.get(0);
				if(list.get(0).getMainSpaceFlag()==1){
					mainSpaceFlag = true;
					nowUserTenantRelationEntity.setOrgId(orgId);
					nowUserTenantRelationEntity.setDeptId(deptId);
					nowUserTenantRelationEntity.setPostId(postId);
					userTenantRelationList.add(nowUserTenantRelationEntity);
				}
			}
			
            //查询当前人员之前所有的主职记录（启用+停用）
            queryParam = new QueryParam();
            queryParam.getParams().put("employee_id", new Parameter(QueryParam.EQ, Long.valueOf(employeeId)));
            queryParam.getParams().put("property", new Parameter(QueryParam.EQ, JobVO.JOB_TYPE_MAIN));
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            curEmployeeMainJobs = jobService.queryList(queryParam, false);

            //过滤出当前启用的主职
            for(JobEntity job : curEmployeeMainJobs) {
                if(job.getCurState() == JobVO.STATE_ACTIVE) {
                    currentMainJob = job;
                    break;
                }
            }
            Map<String, Object> p = new HashMap<>();
            p.put("jobIds", curEmployeeMainJobs.stream().map(job -> job.getId()).collect(Collectors.toList()));
            p.put("tenantId", InvocationInfoProxy.getTenantid());
            currentRelation = roleUserRelationService.queryListByProperties(p);

            if(CollectionUtils.isNotEmpty(currentRelation)) {
                curRelationsStr.addAll(currentRelation.stream().map(r -> r.getRoleId()+"_"+r.getAuthOrgId()).collect(Collectors.toList()));
            }
            
            //创建新的工作记录
            JobEntity newJob = new JobEntity();
			String projectPost =newRelations.get(0).getProjectPost();
            Long postIds = newRelations.get(0).getPostId() != null?newRelations.get(0).getPostId():postId;
            logger.info("postId{}",postIds);

            generateNewJob(Long.valueOf(employeeId), orgId, deptId, postIds, newJob, JobVO.JOB_TYPE_MAIN, deptHead,projectPost);
            saveJobList.add(newJob);
            
            if(mainSpaceFlag){
            	//在主空间下：人员、用户表中的租户、组织、部门、岗位修改
                EmployeeEntity employee = baseMapper.selectById(newRelations.get(0).getEmployeeId());
            	//更新人员信息
                employee.setOrgId(orgId);
                employee.setTenantId(InvocationInfoProxy.getTenantid());
                employee.setDeptId(deptId);
                if(postIds != null){
                    employee.setPostId(postIds);
                }else{
                    employee.setPostId(employee.getPostId());
                }
                employeeList.add(employee);

                //更新人员对应用户信息
                UserEntity user = userService.getById(employee.getUserId());
                user.setOrgId(orgId);
                user.setTenantId(InvocationInfoProxy.getTenantid());

                updateUserList.add(user);
            }

            for(RoleUserRelationVO newr : newRelations) {
                //任职记录记录任职绑定的角色列表
                if(newr.getRoleId()!=null){
                    newJob.setRoleIds(StringUtils.isNotBlank(newJob.getRoleIds()) ? newJob.getRoleIds() + "," + newr.getRoleId().toString() : newr.getRoleId().toString());
                }
                if(StringUtils.isNotBlank(newr.getRoleName())) {
                    newJob.setRoleNames(StringUtils.isNotBlank(newJob.getRoleNames()) ? newJob.getRoleNames() + "," + newr.getRoleName() : newr.getRoleName());
                }
                if(newr.getRoleId()!=null && curRelationsStr.contains(newr.getRoleId()+"_"+newr.getAuthOrgId())) {
                    curRelationsStr.remove(newr.getRoleId()+"_"+newr.getAuthOrgId());
                    continue;
                }
                newr.setJobId(newJob.getId());
                newr.setUserId(nowUserTenantRelationEntity.getUserId());
                //过滤出要新增的角色人员关系
                if(null != newr.getRoleId()) {
                    saveRelation.add(newr);
                }
            }

            //过滤出要删除的已有角色人员关系
            delRealtionList.addAll(currentRelation.stream()
                    .filter(r -> curRelationsStr.contains(r.getRoleId()+"_"+r.getAuthOrgId()))
                    .map(r -> r.getId()).collect(Collectors.toList()));

            //设置当前工作记录状态为停用
            currentMainJob.setCurState(JobVO.STATE_INACTIVE);
            //设置当前工作记录结束时间
            currentMainJob.setJobEndTime(new Timestamp(System.currentTimeMillis()));
            saveJobList.add(currentMainJob);
        }

        //数据更新

        //处理部门负责人
        EmployeeVO employeeVO = BeanMapper.map(employeeList.get(0), EmployeeVO.class);
        employeeVO.setDeptHead(deptHead);

        this.dealDeptHead(employeeVO, currentMainJob);
        //更新人员信息
        if(employeeList!=null&&employeeList.size()>0){
            for (EmployeeEntity e:employeeList){
                logger.info("数据{},{},{}",e.getId(),e.getName(),e.getPostId());
            }
        	super.saveOrUpdateBatch(employeeList);
        }
        //更新、新增工作记录
        if(saveJobList!=null&&saveJobList.size()>0){
        	jobService.saveOrUpdateBatch(saveJobList, saveJobList.size(), false);
        }
        //更新用户
        if(updateUserList!=null&&updateUserList.size()>0){
        	userService.saveOrUpdateBatch(updateUserList, updateUserList.size(), false);
        }
        //更新用户租户关系表
        if(userTenantRelationList!=null&&userTenantRelationList.size()>0){
        	userTenantRelationService.saveOrUpdateBatch(userTenantRelationList, userTenantRelationList.size(), false);
        }
        
        //删除对应角色人员关系
        if(CollectionUtils.isNotEmpty(delRealtionList)) {
            roleUserRelationService.delete(delRealtionList);
        }
        
        //新增角色人员关系
        if(CollectionUtils.isNotEmpty(saveRelation)) {
            roleUserRelationService.saveOrUpdateBatch(BeanMapper.mapList(saveRelation, RoleUserRelationEntity.class), saveRelation.size(), false);
            
            //放入缓存
            for(RoleUserRelationVO roleUserRelationVo:saveRelation) {
            	permissionCacheManager.putOneRoleUsersCache(roleUserRelationVo.getRoleId(), roleUserRelationVo);
            }
        }
    }

    private void generateNewJob(Long employeeId, Long orgId, Long deptId, Long postId, JobEntity newJob, Integer jobType, Integer deptHead,String projectPost) {
        newJob.setOrgId(orgId);
        newJob.setDeptId(deptId);
        newJob.setPostId(postId);
        newJob.setJobStartTime(new Timestamp(System.currentTimeMillis()));
        newJob.setCurState(JobVO.STATE_ACTIVE);
        newJob.setProperty(jobType);
        newJob.setEmployeeId(employeeId);
        newJob.setDeptHead(deptHead);
        newJob.setId(IdWorker.getId());
		newJob.setProjectPost(projectPost);
    }

	@Override
    public void addParttimeJob(Map<String, Object> param) {
        Long orgId = Long.valueOf(param.get("orgId").toString());
        Long deptId = null != param.get("deptId") ? Long.valueOf(param.get("deptId").toString()) : null;
        Long postId = null != param.get("postId") ? Long.valueOf(param.get("postId").toString()) : null;
        Integer deptHead = null != param.get("deptHead") ? Integer.valueOf(param.get("deptHead").toString()) : null;
        //Map<EmployeeId, List<RoleUserRelation>>
        Map<String, List<RoleUserRelationVO>> relations = null;
        if(param.get("detail") == null){
            relations = new HashMap<>();
            List<Map<String,String>> emp = (List<Map<String,String>>)param.get("selectEmployees");
            logger.info("emp{}",JSONObject.toJSONString(emp));
            for (Map<String, String> map : emp) {
                List<RoleUserRelationVO> relationVOS = new ArrayList<>();
                RoleUserRelationVO vo = new RoleUserRelationVO();
                vo.setAuthOrgId(orgId);
                vo.setPostId(postId);
                vo.setEmployeeId(Long.parseLong(map.get("id")));
                relationVOS.add(vo);
                relations.put(map.get("id"),relationVOS);
            }
        }else {
            relations = (Map<String, List<RoleUserRelationVO>>) param.get("detail");
        }


        //新增的角色人员兼职记录
        List<JobEntity> saveJobList = new ArrayList<>();
        //新增角色人员关系列表
        List<RoleUserRelationVO> saveRelations = new ArrayList<>();
        List<RoleUserRelationVO> rList = null;
        for(String employeeId : relations.keySet()) {
            rList = JSONArray.parseArray(JSONArray.toJSONString(relations.get(employeeId)), RoleUserRelationVO.class);
			String projectPost =rList.get(0).getProjectPost();
            if(postId == null){
                postId = rList.get(0).getPostId();
            }
			//创建新的工作记录
            JobEntity newJob = new JobEntity();
            generateNewJob(Long.valueOf(employeeId), orgId, deptId, postId, newJob, JobVO.JOB_TYPE_PARTTIME, deptHead,projectPost);
            saveJobList.add(newJob);

            //查询对应人员
            EmployeeEntity employee = baseMapper.selectById(Long.valueOf(employeeId));
            UserEntity user = userService.getById(employee.getUserId());

            rList.forEach(relation -> {
                relation.setJobId(newJob.getId());
                relation.setUserId(user.getId());
                if(StringUtils.isNotBlank(relation.getRoleName())&&relation.getRoleId()!=null) {
                    newJob.setRoleIds(StringUtils.isNotBlank(newJob.getRoleIds()) ? newJob.getRoleIds() + "," + relation.getRoleId().toString() : relation.getRoleId().toString());
                    newJob.setRoleNames(StringUtils.isNotBlank(newJob.getRoleNames()) ? newJob.getRoleNames() + "," + relation.getRoleName() : relation.getRoleName());
                }
            });
            saveRelations.addAll(rList.stream().filter(item -> null != item.getRoleId()).collect(Collectors.toList()));
        }

        //处理部门负责人
        if(deptId!=null&&Objects.equals(deptHead,1)){
        	DeptEntity dept = deptService.selectById(deptId);
    		//部门负责人任职清空
    		jobService.updateDeptHeadNoByDeptId(deptId);
    		//部门负责人替换
            if(CollectionUtils.isNotEmpty(saveRelations)) {
                dept.setDeptHead(saveRelations.get(0).getUserId());
            }
    		deptService.saveOrUpdate(dept);
        }
        
        //保存新增的工作记录
        jobService.saveOrUpdateBatch(saveJobList, saveJobList.size(), false);
        //保存关系记录
        if(saveRelations != null && saveRelations.size() > 0) {
        	roleUserRelationService.saveOrUpdateBatch(BeanMapper.mapList(saveRelations, RoleUserRelationEntity.class), saveRelations.size(), false);
        	
        	//放入缓存
            for(RoleUserRelationVO roleUserRelationVo:saveRelations) {
                if(roleUserRelationVo.getRoleId()!=null){
                    permissionCacheManager.putOneRoleUsersCache(roleUserRelationVo.getRoleId(), roleUserRelationVo);
                }
            }
        }
    }

    /**
     * 员工批量兼职到多个组织
     *
     * @param param
     */
    @Override
    public void partJobBeachOrgs(List<JSONObject> param) {
        //新增的角色人员兼职记录
        List<JobEntity> saveJobList = new ArrayList<>();
        //新增角色人员关系列表
        List<RoleUserRelationVO> saveRelations = new ArrayList<>();
        for (JSONObject map : param) {
            RoleUserRelationVO vo = new RoleUserRelationVO();
            vo.setEmployeeId(map.getLong("employeeId"));
            vo.setAuthOrgId(map.getLong("orgId"));
            vo.setPostId(StringUtils.isNotEmpty(map.getString("postId"))?map.getLong("postId"):null);
            vo.setRoleId(map.getLong("roleId"));
            //创建新的工作记录
            JobEntity newJob = new JobEntity();
            generateNewJob(map.getLong("employeeId"), map.getLong("orgId"), map.getLong("deptId"), map.getLong("postId"), newJob, JobVO.JOB_TYPE_PARTTIME, 0,null);
            saveJobList.add(newJob);
            //查询对应人员
            EmployeeEntity employee = baseMapper.selectById(map.getLong("employeeId"));
            UserEntity user = userService.getById(employee.getUserId());
            vo.setJobId(newJob.getId());
            vo.setUserId(user.getId());
            newJob.setRoleIds(vo.getRoleId().toString());
            saveRelations.add(vo);
        }
        //保存新增的工作记录
        jobService.saveOrUpdateBatch(saveJobList, saveJobList.size(), false);
        //保存关系记录
        if(saveRelations.size() > 0) {
            roleUserRelationService.saveOrUpdateBatch(BeanMapper.mapList(saveRelations, RoleUserRelationEntity.class), saveRelations.size(), false);
            //放入缓存
            for(RoleUserRelationVO roleUserRelationVo:saveRelations) {
                if(roleUserRelationVo.getRoleId()!=null){
                    permissionCacheManager.putOneRoleUsersCache(roleUserRelationVo.getRoleId(), roleUserRelationVo);
                }
            }
        }
    }

    @Override
    public List<RoleUserRelationVO> getEmployeeRolesRelations(List<Long> employeeIds) {
        List<JobEntity> mainJobs = jobService.getEmployeesMainJob(employeeIds, true);
        Map<String, Object> param = new HashMap<>();
        param.put("employeeIds", employeeIds);
        param.put("jobIds", mainJobs.stream().map(JobEntity::getId).collect(Collectors.toList()));
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        List<RoleUserRelationVO> relations = roleUserRelationService.queryListByProperties(param);

        return relations;
    }

    @Override
    public List<EmployeeEntity> getAllByIds(List<Long> employeeIds) {
        return baseMapper.selectBatchIds(employeeIds);
    }

	/***
	 * 
		停用： 	当这个用户最后一个租户停用情况下： 1. 关系表状态改成停用 ；2. 把用户、人员的tenantId置为空；人员状态改成停用；3. 把关系表中是否主空间改成0
				多个租户情况下：  当停用主空间： 1. 关系表状态改成停用； 2. 把关系表中是否主空间改成0，把其中一个空间改成主空间，更新人员、用户的表的组织、部门、岗位、租户ID；
							  当停用非主空间： 1. 关系表状态改成停用；
		启用： 	当启用第一个租户：  1. 关系表状态改成启用 2. 把用户、人员的tenantId置为关系表tenantId；人员状态改成停用；3. 把关系表中是否主空间改成1， 更新人员、用户的表的组织、部门、岗位、租户ID 为 关系的。
				当多个租户情况下启用：1. 关系表状态改成启用
	 * 
	 * *****/
	@Override
	@Transactional
	public void enabledEmployeeState(EmployeeVO employeeVo) {
		try{
			redissonLocker.lock(employeeVo.getMobilePhone()+"_enabled", TimeUnit.MICROSECONDS, 10);
			//钉钉或企业微信同步人员时无上下文，故从数据中取
            Long tenantId = InvocationInfoProxy.getTenantid()!=null?InvocationInfoProxy.getTenantid():employeeVo.getTenantId();
            if(1 == employeeVo.getState()) {
				//启用操作
				//查询要改变的用户租户信息
	    		QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
	    		wrapper.eq("user_id", employeeVo.getUserId());
	    		wrapper.eq("tenant_id", tenantId);
	    		wrapper.eq("state", 0);
	    		wrapper.eq("dr", 0);
				List<UserTenantRelationEntity> oldList = userTenantRelationService.list(wrapper);
				if(oldList.size()==0){
					throw new BusinessException("未查询到用户租户关系信息");
				}
				UserTenantRelationEntity userTenantRelationEntity = oldList.get(0);
				if(userTenantRelationEntity.getTypeId()==1){
					throw new BusinessException("超级管理员不能启停用");
				}
				userTenantRelationEntity.setState(employeeVo.getState());//关系表状态改成启用
				//1、查询启用的租户
	    		QueryWrapper<UserTenantRelationEntity> queryWrapper = new QueryWrapper<>();
	    		queryWrapper.eq("user_id", employeeVo.getUserId());
	    		queryWrapper.eq("state", 1);
	    		queryWrapper.eq("dr", 0);
				List<UserTenantRelationEntity> enableList = userTenantRelationService.list(queryWrapper);
				if(enableList!=null&&enableList.size()==0){
//						当启用第一个租户：  1. 关系表状态改成启用 2. 把用户、人员的tenantId置为关系表tenantId；人员状态改成启用；3. 把关系表中是否主空间改成1， 更新人员、用户的表的组织、部门、岗位、租户ID 为 关系的。
					userTenantRelationEntity.setMainSpaceFlag(1);//把关系表中是否主空间改成1
					//1)、把人员的tenantId置为关系表tenantId；人员状态改成停用； 更新人员的表的组织、部门、岗位、租户ID 为 关系的
					EmployeeEntity employee = selectById(employeeVo.getId());
					employee.setState(employeeVo.getState());
					employee.setTenantId(userTenantRelationEntity.getTenantId());
					employee.setOrgId(userTenantRelationEntity.getOrgId());
					employee.setDeptId(userTenantRelationEntity.getDeptId());
					employee.setPostId(userTenantRelationEntity.getPostId());
					saveOrUpdate(employee, false);
					//2)、把用户的tenantId置为关系表tenantId；用户状态改成停用； 更新用户的表的组织、租户ID 为 关系的
					UserEntity user = userService.getById(employeeVo.getUserId());
					user.setUserState(employeeVo.getState());
					user.setTypeId(userTenantRelationEntity.getTypeId());
					user.setTenantId(userTenantRelationEntity.getTenantId());
					user.setOrgId(userTenantRelationEntity.getOrgId());
					userService.saveOrUpdate(user, false);
					
				}else if(enableList!=null&&enableList.size()>0){
//						当多个租户情况下启用：1. 关系表状态改成启用
					
				}
				userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
	    	} else {
	    		//停用操作
				//查询要改变的用户租户信息
	    		QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
	    		wrapper.eq("user_id", employeeVo.getUserId());
	    		wrapper.eq("tenant_id", tenantId);
	    		wrapper.eq("state", 1);
	    		wrapper.eq("dr", 0);
				List<UserTenantRelationEntity> oldList = userTenantRelationService.list(wrapper);
				if(oldList.size()==0){
					throw new BusinessException("未查询到用户租户关系信息");
				}
				UserTenantRelationEntity userTenantRelationEntity = oldList.get(0);
				if(userTenantRelationEntity.getTypeId()==1){
					throw new BusinessException("超级管理员不能启停用");
				}
				userTenantRelationEntity.setState(employeeVo.getState());//关系表状态改成停用
				//1、查询启用的租户
	    		QueryWrapper<UserTenantRelationEntity> queryWrapper = new QueryWrapper<>();
	    		queryWrapper.eq("user_id", employeeVo.getUserId());
	    		queryWrapper.ne("tenant_id", tenantId);
	    		queryWrapper.eq("state", 1);
	    		queryWrapper.eq("dr", 0);
				List<UserTenantRelationEntity> enableList = userTenantRelationService.list(queryWrapper);
				if(enableList!=null&&enableList.size()==0){
//						当这个用户最后一个租户停用情况下： 1. 关系表状态改成停用 ；2. 把用户、人员的tenantId置为空；人员状态改成停用；3. 把关系表中是否主空间改成0
					userTenantRelationEntity.setMainSpaceFlag(0);//把关系表中是否主空间改成0
					//1)、把人员的tenantId置为空；人员状态改成停用
					EmployeeEntity employee = selectById(employeeVo.getId());
					employee.setState(employeeVo.getState());
					employee.setTenantId(null);
					saveOrUpdate(employee, false);
					//2)、把用户的tenantId置为空；用户状态改成停用
					UserEntity user = userService.getById(employeeVo.getUserId());
					user.setUserState(employeeVo.getState());
					user.setTenantId(null);
					userService.saveOrUpdate(user, false);
				}else if(enableList!=null&&enableList.size()>0){
//						多个租户情况下：  当停用主空间： 1. 关系表状态改成停用； 2. 把关系表中是否主空间改成0，把其中一个空间改成主空间，更新人员、用户的表的组织、部门、岗位、租户ID；
//						  当停用非主空间： 1. 关系表状态改成停用；
					if(1==userTenantRelationEntity.getMainSpaceFlag()){
						//当停用主空间： 1. 关系表状态改成停用； 2. 把关系表中是否主空间改成0，把其中一个空间改成主空间，更新人员、用户的表的组织、部门、岗位、租户ID；
						userTenantRelationEntity.setMainSpaceFlag(0);//把关系表中是否主空间改成0
						//把其中一个空间改成主空间，更新人员、用户的表的组织、部门、岗位、租户ID；
						UserTenantRelationEntity relation = enableList.get(0);
						relation.setMainSpaceFlag(1);
						userTenantRelationService.saveOrUpdate(relation, false);
						
						EmployeeEntity employee = selectById(employeeVo.getId());
						employee.setTenantId(relation.getTenantId());
						employee.setOrgId(relation.getOrgId());
						employee.setDeptId(relation.getDeptId());
						employee.setPostId(relation.getPostId());
						saveOrUpdate(employee, false);
						
						UserEntity user = userService.getById(employeeVo.getUserId());
						user.setTenantId(relation.getTenantId());
						user.setTypeId(relation.getTypeId());
						user.setOrgId(relation.getOrgId());
						userService.saveOrUpdate(user, false);
					}else{
						//当停用非主空间： 1. 关系表状态改成停用；
					}
				}
				userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
				//修改任职记录的状态, 停用时注销掉对应的兼职记录。启用时暂无处理逻辑
		        if(0 == employeeVo.getState().intValue()) {
		            jobService.updateStateByEmpId(employeeVo.getId(),  1);
		        }
	    	}
			/*//修改员工的状态
			employeeMapper.updateEmployeeState(employeeVo.getId(), employeeVo.getState());
			//修改用户的状态
			userService.updateUserState(employeeVo.getUserId(), employeeVo.getState());
	        //修改任职记录的状态, 停用时注销掉对应的兼职记录。启用时暂无处理逻辑
	        if(0 == employeeVo.getState().intValue()) {
	            jobService.updateStateByEmpId(employeeVo.getId(),  1);
	        }*/
		} catch (Exception e) {
			throw new BusinessException(e.getMessage());
		} finally {
			redissonLocker.unlock(employeeVo.getMobilePhone()+"_enabled");
		}
		
	}

	@Override
	@Transactional
	public void deleteEmployee(EmployeeVO employeeVo) {
		try{
			redissonLocker.lock(employeeVo.getMobilePhone()+"_delete", TimeUnit.MICROSECONDS, 10);
			//查询用户是否已经登录过系统
			UserVO userVo = userService.selectById(employeeVo.getUserId());
	        EmployeeEntity employee = super.selectById(employeeVo.getId());
			//1、查询租户
			QueryWrapper<UserTenantRelationEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("user_id", employeeVo.getUserId());
			queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
			queryWrapper.eq("dr", 0);
			List<UserTenantRelationEntity> userList = userTenantRelationService.list(queryWrapper);
			if(!(userList!=null&&userList.size()>0)){
				/*******没有关系表则直接清空角色关系、任职记录、缓存数据等等*******/
				
				//查询该人员的所有角色关系
				QueryParam roleUserQueryParam = new QueryParam();
		        roleUserQueryParam.getParams().put("employeeId", new Parameter(QueryParam.EQ, employee.getId()));
		        roleUserQueryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		        List<RoleUserRelationEntity> roleUserRelations = roleUserRelationService.queryList(roleUserQueryParam, false);
				
				//删除该工作记录对应的角色人员关系
		        QueryWrapper<RoleUserRelationEntity> delWrapper = new QueryWrapper<>();
		        delWrapper.eq("employee_id", employee.getId());
		        delWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		        roleUserRelationService.remove(delWrapper, false);
		        
		        //删除该员工任职
		        QueryWrapper<JobEntity> delJobWrapper = new QueryWrapper<>();
		        delJobWrapper.eq("employee_id", employee.getId());
		        delJobWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		        jobService.remove(delJobWrapper, false);
				
				//删除角色用户缓存
		        if(roleUserRelations != null && roleUserRelations.size() > 0) {
		        	for(RoleUserRelationEntity roleUserRelationEntity:roleUserRelations) {
		        		permissionCacheManager.removeRoleUsersCache(roleUserRelationEntity.getRoleId(), roleUserRelationEntity.getUserId(), roleUserRelationEntity.getAuthOrgId());
		        	}
		        }
		        
		        //删除该员工管理员表信息
		        QueryWrapper<UserManagerRelationAppEntity> delManageWrapper = new QueryWrapper<>();
		        delManageWrapper.eq("user_id", employee.getUserId());
		        delManageWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		        userManagerRelationAppService.remove(delManageWrapper, false);
		        return;
			}
			UserTenantRelationEntity nowUserTenantRelation = userList.get(0);
	        if(nowUserTenantRelation.getTypeId().equals(1)){
	        	throw new BusinessException(userVo.getUserName()+"为超级管理员，不能删除");
	        }
	        if(userVo.getLastLoginTime() != null) {
				logger.error(String.format("人员-{}已经登录过系统，账号有效，不允许删除", employee.getName()));
	            throw new BusinessException(String.format("待删除的人员-[%s]已经登录过系统， 账号有效，不允许删除", employee.getName()));
			}else{
	
				QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
				wrapper.eq("user_id", employeeVo.getUserId());
				wrapper.ne("tenant_id", InvocationInfoProxy.getTenantid());
				wrapper.eq("dr", 0);
				List<UserTenantRelationEntity> userTenantList = userTenantRelationService.list(wrapper);
				if(userTenantList!=null&&userTenantList.size()>0){
					if(nowUserTenantRelation.getMainSpaceFlag()==1){
	//					当多个租户情况下执行删除主空间：1. 关系表状态改成删除； 2. 把其中一个空间改成主空间，更新人员、用户的表的组织、部门、岗位、租户ID； 3. 人员、用户不执行删除， 删除任职、权限信息
						UserTenantRelationEntity enrity = userTenantList.get(0);
						enrity.setMainSpaceFlag(1);
						userTenantRelationService.saveOrUpdate(enrity, false);
						
						employee.setTenantId(enrity.getTenantId());
						employee.setOrgId(enrity.getOrgId());
						employee.setPostId(enrity.getPostId());
						employee.setDeptId(enrity.getDeptId());
						this.saveOrUpdate(employee, false);
						
						userVo.setTypeId(enrity.getTypeId());
						userVo.setOrgId(enrity.getOrgId());
						userVo.setTenantId(enrity.getTenantId());
						userService.saveOrUpdate(BeanMapper.map(userVo, UserEntity.class), false);
						
					}else{
	//					当多个租户情况下执行删除非主空间： 1. 关系表状态改成删除；2. 人员、用户不执行删除， 删除任职、权限信息
						
					}
					
				}else{
	//				当这个用户最后一个租户删除情况下： 1. 人员、用户、任职、 租户关系表 执行删除；
					//删除员工
					employeeMapper.deleteById(employee.getId());
			        //删除用户
					userService.removeById(employee.getUserId(), false);
					
				}
				
				//查询该人员的所有角色关系
				QueryParam roleUserQueryParam = new QueryParam();
		        roleUserQueryParam.getParams().put("employeeId", new Parameter(QueryParam.EQ, employee.getId()));
		        roleUserQueryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		        List<RoleUserRelationEntity> roleUserRelations = roleUserRelationService.queryList(roleUserQueryParam, false);
				
				//删除该工作记录对应的角色人员关系
		        QueryWrapper<RoleUserRelationEntity> delWrapper = new QueryWrapper<>();
		        delWrapper.eq("employee_id", employee.getId());
		        delWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		        roleUserRelationService.remove(delWrapper, false);
		        
		        //删除该员工任职
		        QueryWrapper<JobEntity> delJobWrapper = new QueryWrapper<>();
		        delJobWrapper.eq("employee_id", employee.getId());
		        delJobWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		        jobService.remove(delJobWrapper, false);
				
				//删除角色用户缓存
		        if(roleUserRelations != null && roleUserRelations.size() > 0) {
		        	for(RoleUserRelationEntity roleUserRelationEntity:roleUserRelations) {
		        		permissionCacheManager.removeRoleUsersCache(roleUserRelationEntity.getRoleId(), roleUserRelationEntity.getUserId(), roleUserRelationEntity.getAuthOrgId());
		        	}
		        }
		        
		        //删除该员工管理员表信息
		        QueryWrapper<UserManagerRelationAppEntity> delManageWrapper = new QueryWrapper<>();
		        delManageWrapper.eq("user_id", employee.getUserId());
		        delManageWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		        userManagerRelationAppService.remove(delManageWrapper, false);
			}
	        userTenantRelationService.remove(queryWrapper, false);

	        //处理部门负责人
	        if(employeeVo.getDeptId()!=null&&Objects.equals(1, employeeVo.getDeptHead())){
	        	DeptEntity dept = deptService.selectById(employeeVo.getDeptId());
	    		//部门负责人任职清空
	    		jobService.updateDeptHeadNoByDeptId(employeeVo.getDeptId());
	    		//部门负责人替换
	    		dept.setDeptHead(null);
	    		deptService.saveOrUpdate(dept);
	        }
		} catch (Exception e) {
			throw new BusinessException(e.getMessage());
		} finally {
			redissonLocker.unlock(employeeVo.getMobilePhone()+"_delete");
		}
	}

	@Override
	public EmployeeVO queryEmployeeByUserId(Long userId) {
		QueryWrapper<EmployeeEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("user_id", userId);
		List<EmployeeEntity> entities = employeeMapper.selectList(wrapper);
		if(entities != null && entities.size() > 0) {
            EmployeeVO employeeVO = BeanMapper.map(entities.get(0), EmployeeVO.class);
            return getEmployeeDetail(employeeVO);
		}
		return null;
	}

    /**
     * 根据用户id查询用户主兼职组织id
     *
     * @param userId
     * @return
     */
    @Override
    public List<Long> getJobOrgIdsByUserId(Long userId,Long tenantId) {
        List<JobVO> jobEntities = jobService.queryAllJobByEmployeeId(userId,tenantId);
        if(ListUtil.isNotEmpty(jobEntities)){
            return  jobEntities.stream().map(JobVO::getOrgId).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    @Override
    public EmployeeVO detail(Long id) {
        EmployeeEntity entity = selectById(id);
        EmployeeVO employeeVO = BeanMapper.map(entity, EmployeeVO.class);
        JobEntity job = jobService.getCurMainJob(id);
        if(job != null) {
            employeeVO.setJobId(job.getId());
            employeeVO.setOrgId(job.getOrgId());
            employeeVO.setDeptId(job.getDeptId());
            employeeVO.setPostId(job.getPostId());
            employeeVO.setDeptHead(job.getDeptHead());
            employeeVO.setRoleIds(job.getRoleIds());
            employeeVO.setRoleNames(job.getRoleNames());

        }
        SignEntity signEntity = signService.getUserDefaultSign(entity.getUserId());
        if(signEntity!=null && StringUtils.isNotBlank(signEntity.getFileId())){
            employeeVO.setUserSignatureFileId(Long.parseLong(signEntity.getFileId()));
        }
        Map<String, Object> queryParam = new HashMap<>();
        Map<String, Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("employeeId", id);
        queryParam.put("params", params);
        List<RoleUserRelationVO> appVO = roleUserRelationMapper.queryRoleByEmployeeId(queryParam);
        employeeVO.setRoleDataList(appVO);
        return getEmployeeDetail(employeeVO);
    }

    private EmployeeVO getEmployeeDetail(EmployeeVO employeeVO) {
        UserVO userVo = userService.selectById(employeeVO.getUserId());
        if(userVo != null) {
            employeeVO.setUserCode(userVo.getUserCode());
        }
        Long companyId = null, deptId = null, postId = null;
        if(null != employeeVO.getJobId()) {
            companyId = employeeVO.getOrgId();
            deptId = employeeVO.getDeptId();
            postId = employeeVO.getPostId();
        } else {
        	//根据用户租户关系表查询当前租户的主职任职信息
        	if(InvocationInfoProxy.getTenantid()!=null){
        		QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
        		wrapper.eq("user_id", employeeVO.getUserId());
        		wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        		wrapper.eq("dr", 0);
    			List<UserTenantRelationEntity> list = userTenantRelationService.list(wrapper);
                companyId = list.get(0).getOrgId();
                deptId = list.get(0).getDeptId();
                postId = list.get(0).getPostId();
        	}else{
        		//登陆时没有山下文信息，取原先的人员数据
                companyId = employeeVO.getOrgId();
                deptId = employeeVO.getDeptId();
                postId = employeeVO.getPostId();
        	}
        }

        if(null != companyId) {
            OrgVO org = orgService.queryDetail(employeeVO.getOrgId());
            if(null != org) {
                employeeVO.setOrgName(org.getShortName());
            }
        }
        if(null != deptId) {
            DeptEntity dept = deptService.selectById(deptId);
            if(null != dept) {
                employeeVO.setDeptName(dept.getName());
            }
        }
        if(null != postId) {
            PostEntity post = postService.selectById(postId);
            if(null != post) {
                employeeVO.setPostName(post.getName());
            }
        }
        return employeeVO;
    }


    @Override
    public IPage<EmployeeJobVO> queryPostEmployeePage(Map<String, Object> paramMap) {
        List<EmployeeJobVO> records = employeeMapper.queryPostEmployeeList(paramMap);
        Long count = employeeMapper.queryPostEmployeeCount(paramMap);

        IPage<EmployeeJobVO> page = new Page<>();
        page.setSize(count);
        page.setTotal(count);
        page.setRecords(records);
        return page;
    }



    @Override
	public EmployeeVO querySuperEmployeeByTenantId(Long tenantId) {
		return employeeMapper.querySuperEmployeeByTenantId(tenantId);
	}

	@Override
	public CommonResponse<String> batchSaveImport(List<EmployeeImportVO> importVOS) {
    	Long tenantId = InvocationInfoProxy.getTenantid();
    	CommonResponse<List<String>> employeeResponse = billCodeApi.getCodeBatchByRuleCode(EMPLOYEE_BILL_CODE, tenantId,importVOS.size());
    	List<String> codeList = new ArrayList<>();
    	if(employeeResponse.isSuccess()) {
    		codeList = employeeResponse.getData();
    	}else{
    		throw new BuilderException("网络异常， 编码生成失败， 请稍后再试");
    	}
    	List<EmployeeEntity> employeeEntitys = new ArrayList<>();
    	List<JobEntity> jobEntitys = new ArrayList<>();
    	List<UserTenantRelationEntity> userTenantRelationEntitys = new ArrayList<>();
    	
		for(EmployeeImportVO importVO : importVOS){
			EmployeeVO employeeVO = new EmployeeVO();
			employeeVO.setName(importVO.getName());
			employeeVO.setOrgId(importVO.getOrgId());
			employeeVO.setDeptId(importVO.getDeptId());
			employeeVO.setMobilePhone(importVO.getMobilePhone());
            employeeVO.setUserCode(importVO.getUserCode());
            employeeVO.setIdcard(importVO.getIdcard());
			if(StringUtils.isNotBlank(importVO.getSex())){
				employeeVO.setSex("男".equals(importVO.getSex())?1:("女".equals(importVO.getSex())?2:1));
			} else {
			    //默认性别为男
			    employeeVO.setSex(1);
            }
			employeeVO.setEmployeeType(1);
			employeeVO.setState(1);
			
    		employeeVO.setCode(codeList.get(importVOS.indexOf(importVO)));
			
            //新增用户
            employeeVO.setTenantId(tenantId);
            employeeVO.setDr(BaseVO.DR_UNDELETE);
            UserVO user = userService.generateNewUser(employeeVO);
            if(user == null) {
            	throw new BusinessException("新增人员失败， 手机号已存在");
            }
            employeeVO.setUserId(user.getId());
            employeeVO.setId(user.getId()); //将用户Id和人员Id设置为同一值

            QueryWrapper<EmployeeEntity> query = new QueryWrapper<>();
            query.eq("dr", BaseVO.DR_UNDELETE);
            query.eq("org_id", employeeVO.getOrgId());
            Integer sequence = employeeMapper.selectCount(query);

            employeeVO.setSequence(null == sequence ? 1 : sequence + 1);
            EmployeeEntity dbEntity = BeanMapper.map(employeeVO, EmployeeEntity.class);
            employeeEntitys.add(dbEntity);
            //生成对应的工作记录
            JobEntity job = generateJob(employeeVO);

            if(null != job) {
                job.setJobStartTime(dbEntity.getWorkTime());
                job.setEmployeeId(dbEntity.getId());
                job.setOrgId(dbEntity.getOrgId());
                job.setPostId(dbEntity.getPostId());
                job.setDeptId(dbEntity.getDeptId());
            }
            jobEntitys.add(job);
            
			//生成用户租户关系表
            UserTenantRelationEntity relationEntity = new UserTenantRelationEntity();
            relationEntity.setUserId(user.getId());
            relationEntity.setEmployeeId(employeeVO.getId());
            relationEntity.setOrgId(employeeVO.getOrgId());
            relationEntity.setTenantId(employeeVO.getTenantId());
            relationEntity.setPostId(employeeVO.getTenantId());
            relationEntity.setDeptId(employeeVO.getDeptId());
            relationEntity.setMainSpaceFlag(1);//主空间
            relationEntity.setTypeId(2);//普通用户
            relationEntity.setState(1);//启用
            userTenantRelationEntitys.add(relationEntity);
		}

        if(employeeEntitys!=null&&employeeEntitys.size()>0){
        	super.saveOrUpdateBatch(employeeEntitys, employeeEntitys.size(), false);
        }
        if(jobEntitys!=null&&jobEntitys.size()>0){
        	jobService.saveOrUpdateBatch(jobEntitys, jobEntitys.size(), false);
        }
        if(userTenantRelationEntitys!=null&&userTenantRelationEntitys.size()>0){
        	userTenantRelationService.saveOrUpdateBatch(userTenantRelationEntitys,userTenantRelationEntitys.size(), false);
        }
		return CommonResponse.success("导入成功！");
	}

    @Override
    public List<Map<String, String>> getDirectAllByOrgId(Long orgId) {
        return employeeMapper.getDirectAllByOrgId(orgId);
    }

    @Override
    public List<Map<String, String>> searchTenantEmployees(Long tenantId, String searchText, Integer limit) {
        return employeeMapper.searchTenantEmployees(tenantId, searchText, limit);
    }

    @Override
    public EmployeeVO getByCode(String code) {
        EmployeeVO resp = null;
        QueryWrapper<EmployeeEntity> query = new QueryWrapper<>();
        query.eq("code", code);
        query.eq("dr", BaseVO.DR_UNDELETE);

        EmployeeEntity employee = employeeMapper.selectOne(query);
        if(null != employee) {
            resp = BeanMapper.map(employee, EmployeeVO.class);
        }
        return resp;
    }

    @Override
    public List<EmployeeVO> queryAllEmpDetailByIds(List<Long> ids) {
        Map<String, Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("jobType", JobVO.JOB_TYPE_MAIN);
        params.put("employeeIds", ids);
        params.put("startLine", 0);
        params.put("pageSize", ids.size());
        return employeeMapper.getList(params);
    }

    @Override
    public List<EmployeeVO> getJustByIds(List<Long> ids) {
        Map<String, Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("employeeIds", ids);
        return employeeMapper.getJustByIds(params);
    }
/********************************处理云南建投数据开始****************/
    /**
	 * 云南建投总承包人员信息插入或修改
	 * 
	 * @param ynsbjEmp
	 */
	@Override
	public YnsbjDataInfo saveOrUpdateYnsbjEmployeeInfo(YnsbjEmp ynsbjEmp) {
		YnsbjDataInfo dataInfo = null;
		
		if("1".equals(ynsbjEmp.getMainPostFlag())) { //主职
			//判断当前人是否已经存在，存在就修改
			QueryWrapper<EmployeeEntity> employeeWrapper = new QueryWrapper<>();
			employeeWrapper.eq("source_id", ynsbjEmp.getMasterDataCode());
			EmployeeEntity employeeEntity = employeeMapper.selectOne(employeeWrapper);
			if(employeeEntity != null) { //修改
				Long oldOrgId = employeeEntity.getOrgId();
				Long oldDeptId = employeeEntity.getDeptId();
				String orgName = null;
				if(!employeeEntity.getCode().equals(ynsbjEmp.getEmployeeCode())) {
					employeeEntity.setCode(ynsbjEmp.getEmployeeCode());
				}
				employeeEntity.setName(ynsbjEmp.getEmployeeName());
				employeeEntity.setMobilePhone(ynsbjEmp.getMobilePhone());
				employeeEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
				employeeEntity.setState(Integer.parseInt(ynsbjEmp.getState()));
				employeeEntity.setIdcard(ynsbjEmp.getIdcard());
				String noSyncEmpType = ynsbjEmp.getNoSyncEmpType();
                if(StringUtils.isNotBlank(noSyncEmpType) && employeeEntity.getEmployeeType()!=null){
                    String employeeType = employeeEntity.getEmployeeType().toString();
                    String[] types = noSyncEmpType.split(",");
                    for (String type : types) {
                        if(type.equals(employeeType)){
                            logger.info("员工信息不再同步，{}", JSONObject.toJSONString(employeeEntity));
                            return new YnsbjDataInfo(ynsbjEmp.getUuid(), ynsbjEmp.getMasterDataCode(), "0", "员工信息不需要同步");
                        }
                    }

                }
				employeeEntity.setEmployeeType(getEmployeeType(ynsbjEmp.getEmployeeType()));
				//根据部门编码查询组织
				QueryWrapper<DeptEntity> deptWrapper = new QueryWrapper<>();
				deptWrapper.eq("code", ynsbjEmp.getDeptCode());
				DeptEntity deptEntity = deptService.getOne(deptWrapper);
				if(deptEntity != null) {
					employeeEntity.setOrgId(deptEntity.getOrgId());
					employeeEntity.setDeptId(deptEntity.getId());
					if(deptEntity.getOrgId()!=null){
						OrgEntity orgEntity = orgService.selectById(deptEntity.getOrgId());
						if(orgEntity != null) {
							orgName = orgEntity.getName();
						}
					}
				}else{
					QueryWrapper<OrgEntity> orgWrapper = new QueryWrapper<>();
					orgWrapper.eq("code", ynsbjEmp.getDeptCode());
					OrgEntity orgEntity = orgService.getOne(orgWrapper);
					if(orgEntity != null) {
						employeeEntity.setOrgId(orgEntity.getId());
						orgName = orgEntity.getName();
					}
				}
				if(employeeEntity.getOrgId() == null) {
					dataInfo = new YnsbjDataInfo(ynsbjEmp.getUuid(), ynsbjEmp.getMasterDataCode(), "1", "员工所任职的组织不存在");
					return dataInfo;
				}
				employeeEntity.setSourceId(ynsbjEmp.getMasterDataCode());
				saveOrUpdate(employeeEntity, false);
				
				//修改用户信息
				UserEntity userEntity = userService.getById(employeeEntity.getUserId());
				userEntity.setOrgId(employeeEntity.getOrgId());
				userEntity.setUserName(ynsbjEmp.getEmployeeName());
				userEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
				userEntity.setUserMobile(ynsbjEmp.getMobilePhone());
				userEntity.setUserEmail(ynsbjEmp.getEmail());
				userEntity.setSourceId(ynsbjEmp.getMasterDataCode());
				if(userEntity.getTypeId()==null){
					userEntity.setTypeId(2);
				}
				if(!employeeEntity.getCode().equals(ynsbjEmp.getEmployeeCode())) {
					userEntity.setUserCode(ynsbjEmp.getEmployeeCode());
					String password = passwordPolicyService.getUserDefaultPassword(999999l);
					String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
					userEntity.setPassword(PasswordUtils.encodePasswordByUserCode(shaPassword, userEntity.getSalt(), userEntity.getUserCode()));
					userEntity.setPwdStartTime(new Date());
				}
				userEntity.setUserState(Integer.parseInt(ynsbjEmp.getState()));
				userService.saveOrUpdate(userEntity, false);
				
				QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
	    		wrapper.eq("user_id", userEntity.getId());
	    		wrapper.eq("tenant_id", userEntity.getTenantId());
	    		wrapper.eq("dr", 0);
				List<UserTenantRelationEntity> list = userTenantRelationService.list(wrapper);
				if(list!=null&&list.size()>0){
					UserTenantRelationEntity userTenantRelationEntity = list.get(0);
					userTenantRelationEntity.setOrgId(employeeEntity.getOrgId());
					userTenantRelationEntity.setPostId(employeeEntity.getTenantId());
					userTenantRelationEntity.setDeptId(employeeEntity.getDeptId());
					userTenantRelationEntity.setState(Integer.parseInt(ynsbjEmp.getState()));
					userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
				}else{
					UserTenantRelationEntity entity = new UserTenantRelationEntity();
		            entity.setUserId(userEntity.getId());
		            entity.setEmployeeId(employeeEntity.getId());
		            entity.setOrgId(employeeEntity.getOrgId());
		            entity.setTenantId(employeeEntity.getTenantId());
		            entity.setPostId(employeeEntity.getTenantId());
		            entity.setDeptId(employeeEntity.getDeptId());
		            entity.setMainSpaceFlag(1);//主空间
		            entity.setTypeId(2);//普通用户
		            entity.setState(1);//启用
		            userTenantRelationService.saveOrUpdate(entity, false);
				}
				//清理掉这个人的所有任职信息
//				jobService.deleteAllByEmployeeId(employeeEntity.getId());
				
				List<YnsbjEmpJob> ynsbjEmpjobs = ynsbjEmp.getEmpJobs();
				//处理任职信息--包括任职与角色关系数据
				this.dealJob(ynsbjEmpjobs,ynsbjEmp,employeeEntity,oldOrgId,oldDeptId,orgName,true);
				
			}else{ //新增
				Long employeeId = IdWorker.getId();
				Long userId = employeeId;
				
				employeeEntity = new EmployeeEntity();
				employeeEntity.setId(employeeId);
				employeeEntity.setCode(ynsbjEmp.getEmployeeCode());
				employeeEntity.setName(ynsbjEmp.getEmployeeName());
				employeeEntity.setMobilePhone(ynsbjEmp.getMobilePhone());
				employeeEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
				employeeEntity.setState(Integer.parseInt(ynsbjEmp.getState()));
                employeeEntity.setIdcard(ynsbjEmp.getIdcard());
                employeeEntity.setEmployeeType(getEmployeeType(ynsbjEmp.getEmployeeType()));
				QueryWrapper<DeptEntity> deptWrapper = new QueryWrapper<>();
				deptWrapper.eq("code", ynsbjEmp.getDeptCode());
				DeptEntity deptEntity = deptService.getOne(deptWrapper);
				if(deptEntity != null) {
					employeeEntity.setOrgId(deptEntity.getOrgId());
					employeeEntity.setDeptId(deptEntity.getId());
				}else{
					QueryWrapper<OrgEntity> orgWrapper = new QueryWrapper<>();
					orgWrapper.eq("code", ynsbjEmp.getDeptCode());
					OrgEntity orgEntity = orgService.getOne(orgWrapper);
					if(orgEntity != null) {
						employeeEntity.setOrgId(orgEntity.getId());
					}
				}
				if(employeeEntity.getOrgId() == null) {
					dataInfo = new YnsbjDataInfo(ynsbjEmp.getUuid(), ynsbjEmp.getMasterDataCode(), "1", "员工所任职的组织不存在");
					return dataInfo;
				}
				employeeEntity.setTenantId(999999l);
				employeeEntity.setUserId(userId);
				employeeEntity.setSourceId(ynsbjEmp.getMasterDataCode());
				saveOrUpdate(employeeEntity, false);
				
				UserEntity userEntity = new UserEntity();
				userEntity.setId(userId);
				userEntity.setOrgId(employeeEntity.getOrgId());
				userEntity.setUserCode(ynsbjEmp.getEmployeeCode());
				userEntity.setUserName(ynsbjEmp.getEmployeeName());
				userEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
				userEntity.setUserMobile(ynsbjEmp.getMobilePhone());
				userEntity.setSalt(PasswordUtils.getSalt());
				userEntity.setTypeId(2);
				String password = passwordPolicyService.getUserDefaultPassword(999999l);
				String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
				userEntity.setPassword(PasswordUtils.encodePasswordByUserCode(shaPassword, userEntity.getSalt(), userEntity.getUserCode()));
				userEntity.setPwdStartTime(new Date());
				userEntity.setTenantId(999999l);
				userEntity.setUserState(Integer.parseInt(ynsbjEmp.getState()));
				userEntity.setSourceId(ynsbjEmp.getMasterDataCode());
				userService.saveOrUpdate(userEntity, false);
				
				//生成用户租户关系表
	            UserTenantRelationEntity entity = new UserTenantRelationEntity();
	            entity.setUserId(userEntity.getId());
	            entity.setEmployeeId(employeeEntity.getId());
	            entity.setOrgId(employeeEntity.getOrgId());
	            entity.setTenantId(employeeEntity.getTenantId());
	            entity.setPostId(employeeEntity.getTenantId());
	            entity.setDeptId(employeeEntity.getDeptId());
	            entity.setMainSpaceFlag(1);//主空间
	            entity.setTypeId(2);//普通用户
	            entity.setState(1);//启用
	            userTenantRelationService.saveOrUpdate(entity, false);
				
				//保存任职信息
				List<JobEntity> jobList = new ArrayList<>();
				JobEntity mainJob = new JobEntity();
				mainJob.setOrgId(employeeEntity.getOrgId());
				mainJob.setDeptId(employeeEntity.getDeptId());
				mainJob.setEmployeeId(employeeEntity.getId());
				mainJob.setProperty(1);
				mainJob.setCurState(0);
				mainJob.setTenantId(999999l);
				mainJob.setJobStartTime(new Date());
				mainJob.setSourceId(ynsbjEmp.getMasterDataCode());
				jobList.add(mainJob);
				
				logger.info("新增兼职信息条数2-----------------》"+ynsbjEmp.getEmpJobs().size());
				List<YnsbjEmpJob> ynsbjEmpjobs = ynsbjEmp.getEmpJobs();
				if(ynsbjEmpjobs != null && ynsbjEmpjobs.size() > 0) {
					for(YnsbjEmpJob empJob:ynsbjEmpjobs) {
						JobEntity partJob = new JobEntity();
						
						QueryWrapper<DeptEntity> jobDeptWrapper = new QueryWrapper<>();
						jobDeptWrapper.eq("code", empJob.getDeptCode());
						DeptEntity jobDeptEntity = deptService.getOne(jobDeptWrapper);
						if(jobDeptEntity != null) {
							partJob.setOrgId(jobDeptEntity.getOrgId());
							partJob.setDeptId(jobDeptEntity.getId());
							partJob.setEmployeeId(employeeEntity.getId());
							partJob.setProperty(0);
							partJob.setCurState(0);
							partJob.setTenantId(999999l);
							partJob.setJobStartTime(new Date());
							partJob.setSourceId(ynsbjEmp.getMasterDataCode());
							jobList.add(partJob);
						}else{
							QueryWrapper<OrgEntity> jobOrgWrapper = new QueryWrapper<>();
							jobOrgWrapper.eq("code", empJob.getDeptCode());
							OrgEntity jobOrgEntity = orgService.getOne(jobOrgWrapper);
							if(jobOrgEntity != null) {
								partJob.setOrgId(jobOrgEntity.getId());
								partJob.setEmployeeId(employeeEntity.getId());
								partJob.setProperty(0);
								partJob.setCurState(0);
								partJob.setTenantId(999999l);
								partJob.setJobStartTime(new Date());
								partJob.setSourceId(ynsbjEmp.getMasterDataCode());
								jobList.add(partJob);
							}
						}
					}
				}
				jobService.saveOrUpdateBatch(jobList);
			}
		}else{ //兼职
			//判断当前人是否已经存在，存在就修改
			QueryWrapper<EmployeeEntity> employeeWrapper = new QueryWrapper<>();
			employeeWrapper.eq("source_id", ynsbjEmp.getMasterDataCode());
			EmployeeEntity employeeEntity = employeeMapper.selectOne(employeeWrapper);
			if(employeeEntity != null) {
				Long oldOrgId = employeeEntity.getOrgId();
				Long oldDeptId = employeeEntity.getDeptId();
				String orgName = null;
				if(!employeeEntity.getCode().equals(ynsbjEmp.getEmployeeCode())) {
					employeeEntity.setCode(ynsbjEmp.getEmployeeCode());
				}
				employeeEntity.setName(ynsbjEmp.getEmployeeName());
				employeeEntity.setMobilePhone(ynsbjEmp.getMobilePhone());
				employeeEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
				employeeEntity.setState(Integer.parseInt(ynsbjEmp.getState()));
                employeeEntity.setIdcard(ynsbjEmp.getIdcard());
                employeeEntity.setEmployeeType(getEmployeeType(ynsbjEmp.getEmployeeType()));
				//根据部门编码查询组织
				QueryWrapper<DeptEntity> deptWrapper = new QueryWrapper<>();
				deptWrapper.eq("code", ynsbjEmp.getDeptCode());
				DeptEntity deptEntity = deptService.getOne(deptWrapper);
				if(deptEntity != null) {
					employeeEntity.setOrgId(deptEntity.getOrgId());
					employeeEntity.setDeptId(deptEntity.getId());
					if(deptEntity.getOrgId()!=null){
						OrgEntity orgEntity = orgService.selectById(deptEntity.getOrgId());
						if(orgEntity != null) {
							orgName = orgEntity.getName();
						}
					}
				}else{
					QueryWrapper<OrgEntity> orgWrapper = new QueryWrapper<>();
					orgWrapper.eq("code", ynsbjEmp.getDeptCode());
					OrgEntity orgEntity = orgService.getOne(orgWrapper);
					if(orgEntity != null) {
						employeeEntity.setOrgId(orgEntity.getId());
						orgName = orgEntity.getName();
					}
				}
				if(employeeEntity.getOrgId() == null) {
					dataInfo = new YnsbjDataInfo(ynsbjEmp.getUuid(), ynsbjEmp.getMasterDataCode(), "1", "员工所任职的组织不存在");
					return dataInfo;
				}
				employeeEntity.setSourceId(ynsbjEmp.getMasterDataCode());
				saveOrUpdate(employeeEntity, false);
				
				//修改用户信息
				UserEntity userEntity = userService.getById(employeeEntity.getUserId());
				userEntity.setOrgId(employeeEntity.getOrgId());
				userEntity.setUserName(ynsbjEmp.getEmployeeName());
				userEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
				userEntity.setUserMobile(ynsbjEmp.getMobilePhone());
				if(!employeeEntity.getCode().equals(ynsbjEmp.getEmployeeCode())) {
					userEntity.setUserCode(ynsbjEmp.getEmployeeCode());
					String password = passwordPolicyService.getUserDefaultPassword(999999l);
					String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
					userEntity.setPassword(PasswordUtils.encodePasswordByUserCode(shaPassword, userEntity.getSalt(), userEntity.getUserCode()));
					userEntity.setPwdStartTime(new Date());
					userEntity.setUserState(Integer.parseInt(ynsbjEmp.getState()));
				}
				if(userEntity.getTypeId()==null){
					userEntity.setTypeId(2);
				}
				userEntity.setSourceId(ynsbjEmp.getMasterDataCode());
				userService.saveOrUpdate(userEntity, false);
				
				QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
	    		wrapper.eq("user_id", userEntity.getId());
	    		wrapper.eq("tenant_id", userEntity.getTenantId());
	    		wrapper.eq("dr", 0);
				List<UserTenantRelationEntity> list = userTenantRelationService.list(wrapper);
				if(list!=null&&list.size()>0){
					UserTenantRelationEntity userTenantRelationEntity = list.get(0);
					userTenantRelationEntity.setOrgId(employeeEntity.getOrgId());
					userTenantRelationEntity.setPostId(employeeEntity.getTenantId());
					userTenantRelationEntity.setDeptId(employeeEntity.getDeptId());
					userTenantRelationEntity.setState(Integer.parseInt(ynsbjEmp.getState()));
					userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
				}else{
					UserTenantRelationEntity entity = new UserTenantRelationEntity();
		            entity.setUserId(userEntity.getId());
		            entity.setEmployeeId(employeeEntity.getId());
		            entity.setOrgId(employeeEntity.getOrgId());
		            entity.setTenantId(employeeEntity.getTenantId());
		            entity.setPostId(employeeEntity.getTenantId());
		            entity.setDeptId(employeeEntity.getDeptId());
		            entity.setMainSpaceFlag(1);//主空间
		            entity.setTypeId(2);//普通用户
		            entity.setState(1);//启用
		            userTenantRelationService.saveOrUpdate(entity, false);
				}
				//兼职信息的--理论上只会返回一条信息，所以这里只做是否存在校验存在不新增，不存在新增
				List<YnsbjEmpJob> ynsbjEmpjobs = ynsbjEmp.getEmpJobs();
				this.dealJob(ynsbjEmpjobs,ynsbjEmp,employeeEntity,oldOrgId,oldDeptId,orgName,false);
				
			}else{
				Long employeeId = IdWorker.getId();
				Long userId = employeeId;
				
				employeeEntity = new EmployeeEntity();
				employeeEntity.setId(employeeId);
				employeeEntity.setCode(ynsbjEmp.getEmployeeCode());
				employeeEntity.setName(ynsbjEmp.getEmployeeName());
				employeeEntity.setMobilePhone(ynsbjEmp.getMobilePhone());
				employeeEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
				employeeEntity.setState(Integer.parseInt(ynsbjEmp.getState()));
                employeeEntity.setIdcard(ynsbjEmp.getIdcard());
                employeeEntity.setEmployeeType(getEmployeeType(ynsbjEmp.getEmployeeType()));
				QueryWrapper<DeptEntity> deptWrapper = new QueryWrapper<>();
				deptWrapper.eq("code", ynsbjEmp.getDeptCode());
				DeptEntity deptEntity = deptService.getOne(deptWrapper);
				if(deptEntity != null) {
					employeeEntity.setOrgId(deptEntity.getOrgId());
					employeeEntity.setDeptId(deptEntity.getId());
				}else{
					QueryWrapper<OrgEntity> orgWrapper = new QueryWrapper<>();
					orgWrapper.eq("code", ynsbjEmp.getDeptCode());
					OrgEntity orgEntity = orgService.getOne(orgWrapper);
					if(orgEntity != null) {
						employeeEntity.setOrgId(orgEntity.getId());
					}
				}
				if(employeeEntity.getOrgId() == null) {
					dataInfo = new YnsbjDataInfo(ynsbjEmp.getUuid(), ynsbjEmp.getMasterDataCode(), "1", "员工所任职的组织不存在");
					return dataInfo;
				}
				employeeEntity.setSourceId(ynsbjEmp.getMasterDataCode());
				employeeEntity.setTenantId(999999l);
				employeeEntity.setUserId(userId);
				saveOrUpdate(employeeEntity, false);
				
				UserEntity userEntity = new UserEntity();
				userEntity.setId(userId);
				userEntity.setOrgId(employeeEntity.getOrgId());
				userEntity.setUserCode(ynsbjEmp.getEmployeeCode());
				userEntity.setUserName(ynsbjEmp.getEmployeeName());
				userEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
				userEntity.setUserMobile(ynsbjEmp.getMobilePhone());
				userEntity.setSalt(PasswordUtils.getSalt());
				String password = passwordPolicyService.getUserDefaultPassword(999999l);
				String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
				userEntity.setPassword(PasswordUtils.encodePasswordByUserCode(shaPassword, userEntity.getSalt(), userEntity.getUserCode()));
				userEntity.setPwdStartTime(new Date());
				userEntity.setTenantId(999999l);
				userEntity.setUserState(Integer.parseInt(ynsbjEmp.getState()));
				userEntity.setSourceId(ynsbjEmp.getMasterDataCode());
				userEntity.setTypeId(2);
				userService.saveOrUpdate(userEntity, false);
				
				//生成用户租户关系表
	            UserTenantRelationEntity entity = new UserTenantRelationEntity();
	            entity.setUserId(userEntity.getId());
	            entity.setEmployeeId(employeeEntity.getId());
	            entity.setOrgId(employeeEntity.getOrgId());
	            entity.setTenantId(employeeEntity.getTenantId());
	            entity.setPostId(employeeEntity.getTenantId());
	            entity.setDeptId(employeeEntity.getDeptId());
	            entity.setMainSpaceFlag(1);//主空间
	            entity.setTypeId(2);//普通用户
	            entity.setState(1);//启用
	            userTenantRelationService.saveOrUpdate(entity, false);
				
				//保存任职信息
				List<JobEntity> jobList = new ArrayList<>();
				JobEntity mainJob = new JobEntity();
				mainJob.setOrgId(employeeEntity.getOrgId());
				mainJob.setDeptId(employeeEntity.getDeptId());
				mainJob.setEmployeeId(employeeEntity.getId());
				mainJob.setProperty(1);
				mainJob.setCurState(0);
				mainJob.setTenantId(999999l);
				mainJob.setJobStartTime(new Date());
				mainJob.setSourceId(ynsbjEmp.getMasterDataCode());
				jobList.add(mainJob);
				
				List<YnsbjEmpJob> ynsbjEmpjobs = ynsbjEmp.getEmpJobs();
				logger.info("新增兼职信息条数4-----------------》"+ynsbjEmp.getEmpJobs().size());
				if(ynsbjEmpjobs != null && ynsbjEmpjobs.size() > 0) {
					for(YnsbjEmpJob empJob:ynsbjEmpjobs) {
						JobEntity partJob = new JobEntity();
						
						QueryWrapper<DeptEntity> jobDeptWrapper = new QueryWrapper<>();
						jobDeptWrapper.eq("code", empJob.getDeptCode());
						DeptEntity jobDeptEntity = deptService.getOne(jobDeptWrapper);
						if(jobDeptEntity != null) {
							partJob.setOrgId(jobDeptEntity.getOrgId());
							partJob.setDeptId(jobDeptEntity.getId());
							partJob.setEmployeeId(employeeEntity.getId());
							partJob.setProperty(0);
							partJob.setCurState(0);
							partJob.setTenantId(999999l);
							partJob.setJobStartTime(new Date());
							partJob.setSourceId(ynsbjEmp.getMasterDataCode());
							jobList.add(partJob);
						}else{
							QueryWrapper<OrgEntity> jobOrgWrapper = new QueryWrapper<>();
							jobOrgWrapper.eq("code", empJob.getDeptCode());
							OrgEntity jobOrgEntity = orgService.getOne(jobOrgWrapper);
							if(jobOrgEntity != null) {
								partJob.setOrgId(jobOrgEntity.getId());
								partJob.setEmployeeId(employeeEntity.getId());
								partJob.setProperty(0);
								partJob.setCurState(0);
								partJob.setTenantId(999999l);
								partJob.setJobStartTime(new Date());
								partJob.setSourceId(ynsbjEmp.getMasterDataCode());
								jobList.add(partJob);
							}
						}
					}
				}
				jobService.saveOrUpdateBatch(jobList);
			}
		}
		dataInfo = new YnsbjDataInfo(ynsbjEmp.getUuid(), ynsbjEmp.getMasterDataCode(), "0", "");
		return dataInfo;
	}

	/** 翻译云南人员状态
     *  云南建投集团主数据系统	EL平台
     * 外聘(工勤）	外聘员工7
     * 劳务派遣	劳务派遣
     * 外聘（管理）	外聘员工
     * 离职人员	离职
     * 政府委派	其他
     * 退休返聘	在职
     * 停薪留职人员	其他
     * 借调人员	其他
     * 人员类别
     * 内退(退出现职岗位)	退休
     * 劳务外包	外聘员工
     * 集团外部单位借入	其他
     * 借出集团外部单位	其他
     * 长期病休假人员	其他
     * 实习生	其他
     * 离退休人员	退休
     * 集团内部单位借入	其他
     * 退休人员	退休
     * 其他不在岗人员	其他
     * 待、下岗员工	其他
     * 外聘（工勤）	外聘员工
     * 离休人员	退休
     * 内退(一般职工)	退休
     * 外聘人员	外聘员工
     * 离退休死亡	其他
     * 内部退养人员	退休
     * 非在岗职工	其他
     * 集团外部单位借出	其他
     * 在岗职工	在职
     * 在职死亡	其他
     * 股东委派（外部）	其他
     * 合同制员工	在职
     * 集团内部单位借出	其他
     * */
	private Integer getEmployeeType(String type){
        int employeeType = 13;
        if(StringUtils.isEmpty(type)){
            return employeeType;
        }
	    switch (type){
            case "外聘（工勤）":
            case "外聘（管理）":
            case "外聘人员":
            case "劳务外包":
                employeeType=7;
                break;
            case "劳务派遣":
                employeeType=14;
                break;
            case "离职人员":
                employeeType=2;
                break;
            case "政府委派":
            case "停薪留职人员":
            case "借调人员":
            case "集团外部单位借入":
            case "借出集团外部单位":
            case "长期病休假人员":
            case "实习生":
            case "集团内部单位借入":
            case "其他不在岗人员":
            case "待、下岗员工":
            case "离退休死亡":
            case "非在岗职工":
            case "集团外部单位借出":
            case "在职死亡":
            case "股东委派（外部）":
            case "集团内部单位借出":
                break;
            case "退休返聘":
            case "在岗职工":
            case "合同制员工":
                employeeType=1;
                break;
            case "内退(退出现职岗位)":
            case "离退休人员":
            case "退休人员":
            case "离休人员":
            case "内退(一般职工)":
            case "内部退养人员":
                employeeType=3;
                break;
        }
        return employeeType;
    }
	private boolean exitPartJob(Long orgId, Long deptId, List<JobVO> partJobList,Map<Long,JobVO> oldExitJob) {
		boolean exit = false;
		for(JobVO job : partJobList){
			if(job.getProperty()==0){
				//兼职数据才进行判断
				if(orgId.equals(job.getOrgId())){
					if(deptId!=null){
						//新任职存在部门
						if(job.getDeptId()!=null && deptId.equals(job.getDeptId())){
							//新任职存在部门,并和原先一致
							exit = true;
						}
					}else{
						if(job.getDeptId()==null){
							//新任职和之前的任职都不存在部门，且在同一组织下面
							exit = true;
						}
					}
				}
				if(exit || StringUtils.isBlank(job.getSourceId())){
					exit = true;
					oldExitJob.put(job.getId(), job);
					break;
				}
			}
		}
		return exit;
	}

	private void dealJob(List<YnsbjEmpJob> ynsbjEmpjobs, YnsbjEmp ynsbjEmp, EmployeeEntity employeeEntity, Long oldOrgId, Long oldDeptId, String orgName, boolean doDelete) {
		
		JobVO oldMainJob = new JobVO();
		Map<Long,JobVO> oldExitJob = new HashMap<>();//人员任职的不变的兼职
		//获取这个人目前所有的任职信息
		List<JobVO> oldJobs = jobService.queryAllJobByEmployeeId(employeeEntity.getId(),employeeEntity.getTenantId());

		//任职信息
		List<JobEntity> jobList = new ArrayList<>();
		logger.info("兼职信息条数1-----------------》"+ynsbjEmp.getEmpJobs().size());
		if(ynsbjEmpjobs != null && ynsbjEmpjobs.size() > 0) {
			//处理兼职数据
			for(YnsbjEmpJob empJob:ynsbjEmpjobs) {
				JobEntity partJob = new JobEntity();
				QueryWrapper<DeptEntity> jobDeptWrapper = new QueryWrapper<>();
				jobDeptWrapper.eq("code", empJob.getDeptCode());
				DeptEntity jobDeptEntity = deptService.getOne(jobDeptWrapper);
				
				if(jobDeptEntity != null) {
					boolean exit = exitPartJob(jobDeptEntity.getOrgId(),jobDeptEntity.getId(),oldJobs,oldExitJob);
					if(!exit){
						//不存在，说明有新的任职，需要新增
						partJob.setOrgId(jobDeptEntity.getOrgId());
						partJob.setDeptId(jobDeptEntity.getId());
						partJob.setEmployeeId(employeeEntity.getId());
						partJob.setProperty(0);
						partJob.setCurState(0);
						partJob.setJobStartTime(new Date());
						partJob.setTenantId(999999l);
						partJob.setSourceId(ynsbjEmp.getMasterDataCode());
						jobList.add(partJob);
					}
					
				}else{
					QueryWrapper<OrgEntity> jobOrgWrapper = new QueryWrapper<>();
					jobOrgWrapper.eq("code", empJob.getDeptCode());
					OrgEntity jobOrgEntity = orgService.getOne(jobOrgWrapper);
					if(jobOrgEntity != null) {
						boolean exit = exitPartJob(jobOrgEntity.getId(),null,oldJobs,oldExitJob);
						if(!exit){
							//不存在，说明有新的任职，需要新增
							partJob.setOrgId(jobOrgEntity.getId());
							partJob.setEmployeeId(employeeEntity.getId());
							partJob.setProperty(0);
							partJob.setCurState(0);
							partJob.setJobStartTime(new Date());
							partJob.setTenantId(999999l);
							partJob.setSourceId(ynsbjEmp.getMasterDataCode());
							jobList.add(partJob);
						}
					}
				}
			}
		}

		List<Long> partjobIds = new ArrayList<>();//要删除角色的任职的id
		List<Long> roleIds = new ArrayList<>();//要删除的角色id
		for(JobVO jobVO : oldJobs){
			if(jobVO.getProperty()==1){
				oldMainJob = jobVO;
			}else{
				if(doDelete && StringUtils.isNotBlank(jobVO.getSourceId())){
					//获取不在当前任职信息中的任职信息，并将其改为任职结束，并删除角色关系
					if(oldExitJob.get(jobVO.getId())==null){
						partjobIds.add(jobVO.getId());
						jobVO.setCurState(1);
						jobVO.setJobEndTime(new Date());
						jobList.add(BeanMapper.map(jobVO, JobEntity.class));
					}
				}
			}
			
		}
		
		//查询该人的主职信息
		boolean isMoveJob = false;//判断主职是否有变化
		if(oldOrgId!=null && !oldOrgId.equals(employeeEntity.getOrgId())) {
			isMoveJob = true;
		}else if(oldDeptId!=null && employeeEntity.getDeptId()!=null && !oldDeptId.equals(employeeEntity.getDeptId())){
			isMoveJob = true;
		}else if(oldDeptId!=null && employeeEntity.getDeptId()==null){
			isMoveJob = true;
		}else if(oldDeptId==null && employeeEntity.getDeptId()!=null){
			isMoveJob = true;
		}
		
		if(isMoveJob){
			//新增新的主职任职信息
			JobEntity mainJob = new JobEntity();
			Long mainJobId = IdWorker.getId();
			mainJob.setId(mainJobId);
			mainJob.setOrgId(employeeEntity.getOrgId());
			mainJob.setDeptId(employeeEntity.getDeptId());
			mainJob.setEmployeeId(employeeEntity.getId());
			mainJob.setJobStartTime(new Date());
			mainJob.setProperty(1);
			mainJob.setCurState(0);
			mainJob.setTenantId(999999l);
			mainJob.setSourceId(ynsbjEmp.getMasterDataCode());
			jobList.add(mainJob);
			List<Long> mainjobIds = new ArrayList<>();
			//原先任职信息改为停用
			if(oldMainJob!=null){
				oldMainJob.setCurState(1);
				oldMainJob.setJobEndTime(new Date());
				jobList.add(BeanMapper.map(oldMainJob, JobEntity.class));
				mainjobIds.add(oldMainJob.getId());
				partjobIds.add(oldMainJob.getId());
			}
			//
			Map<String, Object> params = new HashMap<>();
			if(mainjobIds!=null&&mainjobIds.size()>0){
				params.put("jobIds", mainjobIds);
				params.put("tenantId", 999999l);
				List<RoleUserRelationVO> roleList = roleUserRelationService.queryListByProperties(params);//获取之前的主职的授权信息
				if(roleList!=null&&roleList.size()>0){
					//说明该job下存在角色
					List<RoleUserRelationVO> addRoleUserList = new ArrayList<>();
					for(RoleUserRelationVO vo : roleList){
						if(!roleIds.contains(vo.getId())){
							roleIds.add(vo.getId());
						}
						RoleUserRelationVO add = new RoleUserRelationVO();
						add.setAuthOrgId(employeeEntity.getOrgId());
                        add.setTenantId(999999l);
						add.setAuthOrgName(orgName);
						add.setEmployeeId(employeeEntity.getId());
						add.setEmployeeName(employeeEntity.getName());
						add.setJobId(mainJobId);
						add.setProperty("1");
						add.setRoleId(vo.getRoleId());
						add.setRoleName(vo.getRoleName());
						add.setUserId(employeeEntity.getUserId());
						add.setUserMobile(employeeEntity.getMobilePhone());
						add.setUserName(employeeEntity.getName());
						addRoleUserList.add(add);
					}
					roleUserRelationService.saveRoleUser(addRoleUserList);
				}
			}
		}

		if(partjobIds!=null&&partjobIds.size()>0){
			Map<String, Object> params = new HashMap<>();
			params.put("jobIds", partjobIds);
			List<RoleUserRelationVO> roleList = roleUserRelationService.queryListByProperties(params);//获取所有停用的兼职的任职授权信息
			if(roleList!=null&&roleList.size()>0){
				//说明该job下存在角色
				for(RoleUserRelationVO vo : roleList){
					if(!roleIds.contains(vo.getId())){
						roleIds.add(vo.getId());
					}
				}
			}
		}
		if(roleIds!=null&&roleIds.size()>0){
			//删除所有停用的任职授权信息
			roleUserRelationService.delete(roleIds);
		}
		if(jobList!=null&&jobList.size()>0){
			jobService.saveOrUpdateBatch(jobList);
		}
		
	}
	/********************************处理云南建投数据结束****************/

	@Override
	public void saveOrUpdateGdtyEmployeeInfo(GdtyEmp gdtyEmp) {
		QueryWrapper<EmployeeEntity> employeeWrapper = new QueryWrapper<>();
		employeeWrapper.eq("source_id", gdtyEmp.getMasterDataCode());
		EmployeeEntity employeeEntity = employeeMapper.selectOne(employeeWrapper);
		if(employeeEntity != null) {
			employeeEntity.setCode(gdtyEmp.getEmployeeCode());
			employeeEntity.setName(gdtyEmp.getEmployeeName());
			employeeEntity.setMobilePhone(gdtyEmp.getMobile());
			employeeEntity.setSex(Integer.parseInt(gdtyEmp.getSex()));
			
			QueryWrapper<OrgEntity> orgWrapper = new QueryWrapper<>();
			orgWrapper.eq("code", gdtyEmp.getOrgCode());
			OrgEntity orgEntity = orgService.getOne(orgWrapper);
			if(orgEntity != null) {
				employeeEntity.setOrgId(orgEntity.getId());
			}
			if(StringUtils.isNotBlank(gdtyEmp.getPostCode())) {
				QueryWrapper<PostEntity> postWrapper = new QueryWrapper<>();
				postWrapper.eq("code", gdtyEmp.getPostCode());
				PostEntity postEntity = postService.getOne(postWrapper);
				if(postEntity != null) {
					employeeEntity.setPostId(postEntity.getId());
				}
			}
			if(StringUtils.isNotBlank(gdtyEmp.getEmployeeType())) {
				employeeEntity.setEmployeeType(Integer.parseInt(gdtyEmp.getEmployeeType()));
			}
			employeeEntity.setOtherPhone(gdtyEmp.getOtherPhone());
			if(StringUtils.isNotBlank(gdtyEmp.getJobStartTime())) {
				SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
				try {
					employeeEntity.setWorkTime(dateFormat.parse(gdtyEmp.getJobStartTime()));
				} catch (ParseException e) {}
			}
			employeeEntity.setSourceId(gdtyEmp.getMasterDataCode());
			if("X".equals(gdtyEmp.getZstatus())) {
				employeeEntity.setState(0);
			}
			employeeMapper.insert(employeeEntity);
			
			UserEntity userEntity = userService.getById(employeeEntity.getUserId());
			userEntity.setOrgId(employeeEntity.getOrgId());
			userEntity.setUserName(gdtyEmp.getEmployeeName());
			userEntity.setSex(Integer.parseInt(gdtyEmp.getSex()));
			userEntity.setUserMobile(gdtyEmp.getMobile());
			userEntity.setSourceId(gdtyEmp.getMasterDataCode());
			if(userEntity.getTypeId()==null){
				userEntity.setTypeId(2);
			}
			userEntity.setUserCode(gdtyEmp.getUserCode());
			String password = passwordPolicyService.getUserDefaultPassword(999999l);
			String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
			userEntity.setPassword(PasswordUtils.encodePasswordByUserCode(shaPassword, userEntity.getSalt(), userEntity.getUserCode()));
			userEntity.setPwdStartTime(new Date());
			if("X".equals(gdtyEmp.getZstatus())) {
				userEntity.setUserState(0);
			}
			userService.saveOrUpdate(userEntity, false);
			
			QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
    		wrapper.eq("user_id", userEntity.getId());
    		wrapper.eq("tenant_id", employeeEntity.getTenantId());
    		wrapper.eq("dr", 0);
			List<UserTenantRelationEntity> list = userTenantRelationService.list(wrapper);
			if(list!=null&&list.size()>0){
				UserTenantRelationEntity userTenantRelationEntity = list.get(0);
				userTenantRelationEntity.setOrgId(employeeEntity.getOrgId());
				userTenantRelationEntity.setPostId(employeeEntity.getTenantId());
				userTenantRelationEntity.setDeptId(employeeEntity.getDeptId());
				userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
			}else{
				UserTenantRelationEntity entity = new UserTenantRelationEntity();
	            entity.setUserId(userEntity.getId());
	            entity.setEmployeeId(employeeEntity.getId());
	            entity.setOrgId(employeeEntity.getOrgId());
	            entity.setTenantId(employeeEntity.getTenantId());
	            entity.setPostId(employeeEntity.getTenantId());
	            entity.setDeptId(employeeEntity.getDeptId());
	            entity.setMainSpaceFlag(1);//主空间
	            entity.setTypeId(2);//普通用户
	            entity.setState(1);//启用
	            userTenantRelationService.saveOrUpdate(entity, false);
			}
			//任职信息
			QueryWrapper<JobEntity> jobWrapper = new QueryWrapper<>();
			jobWrapper.eq("employee_id", employeeEntity.getId());
			jobWrapper.eq("property", 1);
			JobEntity mainJob = jobService.getOne(jobWrapper);
			if(mainJob != null) {
				mainJob.setOrgId(employeeEntity.getOrgId());
				mainJob.setDeptId(employeeEntity.getDeptId());
				mainJob.setPostId(employeeEntity.getPostId());
				mainJob.setJobStartTime(employeeEntity.getWorkTime());
				jobService.updateById(mainJob);
			}else{
				mainJob = new JobEntity();
				mainJob.setOrgId(employeeEntity.getOrgId());
				mainJob.setDeptId(employeeEntity.getDeptId());
				mainJob.setEmployeeId(employeeEntity.getId());
				mainJob.setPostId(employeeEntity.getPostId());
				mainJob.setJobStartTime(new Date());
				mainJob.setProperty(1);
				mainJob.setCurState(0);
				mainJob.setTenantId(999999l);
				jobService.save(mainJob);
			}
		}else{
			Long employeeId = IdWorker.getId();
			Long userId = employeeId;
					
			employeeEntity = new EmployeeEntity();
			employeeEntity.setId(employeeId);
			employeeEntity.setCode(gdtyEmp.getEmployeeCode());
			employeeEntity.setName(gdtyEmp.getEmployeeName());
			employeeEntity.setMobilePhone(gdtyEmp.getMobile());
			employeeEntity.setSex(Integer.parseInt(gdtyEmp.getSex()));
			
			QueryWrapper<OrgEntity> orgWrapper = new QueryWrapper<>();
			orgWrapper.eq("code", gdtyEmp.getOrgCode());
			OrgEntity orgEntity = orgService.getOne(orgWrapper);
			if(orgEntity != null) {
				employeeEntity.setOrgId(orgEntity.getId());
			}
			if(StringUtils.isNotBlank(gdtyEmp.getPostCode())) {
				QueryWrapper<PostEntity> postWrapper = new QueryWrapper<>();
				postWrapper.eq("code", gdtyEmp.getPostCode());
				PostEntity postEntity = postService.getOne(postWrapper);
				if(postEntity != null) {
					employeeEntity.setPostId(postEntity.getId());
				}
			}
			if(StringUtils.isNotBlank(gdtyEmp.getEmployeeType())) {
				employeeEntity.setEmployeeType(Integer.parseInt(gdtyEmp.getEmployeeType()));
			}
			employeeEntity.setOtherPhone(gdtyEmp.getOtherPhone());
			if(StringUtils.isNotBlank(gdtyEmp.getJobStartTime())) {
				SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
				try {
					employeeEntity.setWorkTime(dateFormat.parse(gdtyEmp.getJobStartTime()));
				} catch (ParseException e) {}
			}
			employeeEntity.setSourceId(gdtyEmp.getMasterDataCode());
			if("X".equals(gdtyEmp.getZstatus())) {
				employeeEntity.setState(0);
			}
			employeeEntity.setUserId(userId);
			employeeEntity.setTenantId(999999l);
			employeeMapper.insert(employeeEntity);
			
			UserEntity userEntity = new UserEntity();
			userEntity.setId(userId);
			userEntity.setOrgId(employeeEntity.getOrgId());
			userEntity.setUserName(gdtyEmp.getEmployeeName());
			userEntity.setSex(Integer.parseInt(gdtyEmp.getSex()));
			userEntity.setUserMobile(gdtyEmp.getMobile());
			userEntity.setSourceId(gdtyEmp.getMasterDataCode());
			if(userEntity.getTypeId()==null){
				userEntity.setTypeId(2);
			}
			userEntity.setUserCode(gdtyEmp.getUserCode());
			String password = passwordPolicyService.getUserDefaultPassword(999999l);
			String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
			userEntity.setPassword(PasswordUtils.encodePasswordByUserCode(shaPassword, userEntity.getSalt(), userEntity.getUserCode()));
			userEntity.setPwdStartTime(new Date());
			if("X".equals(gdtyEmp.getZstatus())) {
				userEntity.setUserState(0);
			}
			userEntity.setTenantId(999999l);
			userService.saveOrUpdate(userEntity, false);
			
			QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
    		wrapper.eq("user_id", userEntity.getId());
    		wrapper.eq("tenant_id", employeeEntity.getTenantId());
    		wrapper.eq("dr", 0);
			List<UserTenantRelationEntity> list = userTenantRelationService.list(wrapper);
			if(list!=null&&list.size()>0){
				UserTenantRelationEntity userTenantRelationEntity = list.get(0);
				userTenantRelationEntity.setOrgId(employeeEntity.getOrgId());
				userTenantRelationEntity.setPostId(employeeEntity.getTenantId());
				userTenantRelationEntity.setDeptId(employeeEntity.getDeptId());
				userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
			}else{
				UserTenantRelationEntity entity = new UserTenantRelationEntity();
	            entity.setUserId(userEntity.getId());
	            entity.setEmployeeId(employeeEntity.getId());
	            entity.setOrgId(employeeEntity.getOrgId());
	            entity.setTenantId(employeeEntity.getTenantId());
	            entity.setPostId(employeeEntity.getTenantId());
	            entity.setDeptId(employeeEntity.getDeptId());
	            entity.setMainSpaceFlag(1);//主空间
	            entity.setTypeId(2);//普通用户
	            entity.setState(1);//启用
	            userTenantRelationService.saveOrUpdate(entity, false);
			}
			//任职信息
			JobEntity mainJob = new JobEntity();
			mainJob.setOrgId(employeeEntity.getOrgId());
			mainJob.setDeptId(employeeEntity.getDeptId());
			mainJob.setEmployeeId(employeeEntity.getId());
			mainJob.setPostId(employeeEntity.getPostId());
			mainJob.setJobStartTime(new Date());
			mainJob.setProperty(1);
			mainJob.setCurState(0);
			mainJob.setTenantId(999999l);
			jobService.save(mainJob);
		}
	}

    @Override
    public void updateJobType(Map<String, Object> memberInfo) {
	    JobEntity jobEntity =jobService.selectById(Long.parseLong(memberInfo.get("jobId").toString()));
	    jobEntity.setProjectPost(memberInfo.get("projectPost").toString());
	    jobService.saveOrUpdate(jobEntity);
    }

    /**
     * 查询人员台账
      * @param params
     * @return
     */
    public IPage<EmployeeVO> pageBookList(Map<String, Object> params) {
        Object orgId = params.get("orgId");
        if(orgId != null) {
            OrgVO orgVo = orgService.queryDetail(Long.parseLong(orgId.toString()));
            if(orgVo != null) {
                params.put("innerCode", orgVo.getInnerCode());
            }else {
                params.put("deptId", orgId);
            }
        }else{
            return new Page<>();
        }
        List<EmployeeVO> voList = new ArrayList<>();
        IPage<EmployeeVO> page = new Page<>();
        page.setCurrent(Integer.valueOf(params.get("pageNumber").toString()));
        page.setSize(Integer.valueOf(params.get("pageSize").toString()));

        long total = employeeMapper.countBook(params);
        page.setTotal(total);
        if(total == 0) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1 ? 0 : page.getCurrent() -  1) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        voList = employeeMapper.getBookList(params);
		List<JobEntity> jobList =this.getSubjectionList();
		List<Long> orgIds =jobList.stream().map(JobEntity::getOrgId).collect(Collectors.toList());
		List<OrgEntity> orgList =orgService.getAllByIds(orgIds);
		Map<Long,String> orgMap = new HashMap<>();
        QueryParam param = new QueryParam();
        List<Long> employeeIds =voList.stream().map(EmployeeVO::getId).collect(Collectors.toList());

        List<RoleUserRelationVO> roleUserList =roleUserRelationService.queryByEmployeeIdsList(employeeIds);
		for (OrgEntity orgEntity:orgList){
			orgMap.put(orgEntity.getId(),orgEntity.getName());
		}
		for (EmployeeVO employee:voList){

			Map<Long,String> subjectionMap = new HashMap();
			Map<Long,String> directlyOrgListMap = new HashMap();
            Map<Long,String> roleMap = new HashMap<>();

			for (JobEntity job:jobList){
				if(employee.getId().equals(job.getEmployeeId()) ){
					if(job.getProperty().equals(1)){
						directlyOrgListMap.put(employee.getOrgId(),orgMap.get(job.getOrgId()));
					}else{
						subjectionMap.put(employee.getOrgId(),orgMap.get(job.getOrgId()));
					}
				}
		    }
			for (RoleUserRelationVO role:roleUserList){
				if(role.getEmployeeId().equals(employee.getId())){
					roleMap.put(role.getRoleId(),role.getRoleName());
				}
			}

			employee.setDirectlyOrgList(new ArrayList<>(directlyOrgListMap.values()));
			employee.setRoleList(new ArrayList<>(roleMap.values()));
			employee.setSubjectionList(new ArrayList<>(subjectionMap.values()));
		}

		if(params.containsKey("directlyName")){
			Iterator<EmployeeVO> it = voList.iterator();
			while (it.hasNext()){
				String directlyName =params.get("directlyName").toString();
				for (String dirName :it.next().getDirectlyOrgList()){
					if(!dirName.contains(directlyName)){
						it.remove();
					}
				}
			}
		}
		if(params.containsKey("subjectionName")){
			Iterator<EmployeeVO> it = voList.iterator();
			while (it.hasNext()){
				String subjectionName =params.get("subjectionName").toString();
				for (String subName :it.next().getSubjectionList()){
					if(!subName.contains(subjectionName)){
						it.remove();
					}
				}
			}
		}
		if(params.containsKey("roleName")){
			Iterator<EmployeeVO> it = voList.iterator();
			while (it.hasNext()){
				String roleName =params.get("roleName").toString();
				for (String roleNames :it.next().getRoleList()){
					if(!roleName.contains(roleNames)){
						it.remove();
					}
				}
			}
		}
        page.setRecords(voList);
        return page;
    }

	private List<JobEntity> getSubjectionList(){
        QueryWrapper<JobEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        wrapper.eq("dr", 0);

		List<JobEntity> jobList =jobMapper.selectList(wrapper);

        return jobList;
    }

    @Override
    public List<EmployeeVO> queryEmployeeByPostAndOrg(List<Long> postIds, List<Long> orgIds) {
        return baseMapper.queryEmployeeByPostAndOrg(postIds, orgIds);
    }

    @Override
    public void manageUpdateProjectMembers(Map<String, Object> memberInfo) {

        Map<String, List<RoleUserRelationVO>> relations = (Map<String, List<RoleUserRelationVO>>) memberInfo.get("detail");
        List<RoleUserRelationVO> rList = null;
        for(String employeeId : relations.keySet()) {
            rList = JSONArray.parseArray(JSONArray.toJSONString(relations.get(employeeId)), RoleUserRelationVO.class);
            //创建新的工作记录
            logger.info("rList{}",rList.size());
            for (RoleUserRelationVO vo:rList){
                logger.info("vo{}",vo.getJobId());

                JobEntity jobEntity =jobService.selectById(vo.getJobId());
                if (jobEntity != null){
                    jobEntity.setPostId(vo.getPostId());
                }
                jobService.saveOrUpdate(jobEntity);
            }

        }
    }

    @Override
    public List<EmployeeVO> getByCodeOrIdcard(List<String> codeOrIdcard) {
        return baseMapper.getByCodeOrIdcard(codeOrIdcard, InvocationInfoProxy.getTenantid());
    }

    @Override
    public EmployeeVO getOneBySourceId(String sourceId) {
        EmployeeVO resp = null;
        QueryWrapper<EmployeeEntity> query = new QueryWrapper<>();
        query.eq("source_id", sourceId);
        query.eq("dr", BaseVO.DR_UNDELETE);

        EmployeeEntity employee = employeeMapper.selectOne(query);
        if(null != employee) {
            resp = BeanMapper.map(employee, EmployeeVO.class);
        }
        return resp;
    }

    /**
     *			[
     *                 {
     *                     "projectDepartmentId": 123212326523985113, //组织id，项目id
     *                     "C_CM_AccountingProjectSet_SuBOID": "7247d656-1100-4cde-aa40-0bb36edb71f0",  //主数据系统兼职数据id
     *                     "HeadSID": "000A8211-0000-0000-0000-0000C7C1DE56", //兼职人员id
     *                     "HeadName": "康利聪",   // 兼职人员姓名
     *                     "IsScene": "1",       //是否在场	1在场 2撤场
     *                     "BeginTime": "2022/6/22 18:01:06",
     *                     "CON_EMP_NUM": "105265",
     *                     "EndTime": "1900/1/1 0:00:00",
     *                     "EstimateEndTime": "1900/1/1 0:00:00",
     *                     "Title": "项目经理",
     *                     "Title_ID": "3401"
     *                 }
     *            ]
     * */
    @Override
    public void partJobBeachForZd4(JSONArray array) {
        if(array!=null && array.size()>0){
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId",Parameter.getEqInstance(999999L));
            List<JobEntity> jobEntityList = new ArrayList<>();
            for (Object o : array) {
                JSONObject data = JSONObject.parseObject(JSONObject.toJSONString(o));
                EmployeeVO employeeVO = getByCode(data.getString("CON_EMP_NUM"));
                if(employeeVO == null){
                    logger.info("中电四人员兼职出错！兼职人员不存在！{}",data.toJSONString());
                    continue;
                }
                param.getParams().put("sourceId",Parameter.getEqInstance(data.getString("C_CM_AccountingProjectSet_SuBOID")));
                List<JobEntity> entities = jobService.queryList(param);
                JobEntity jobEntity = null;
                if(ListUtil.isNotEmpty(entities)){
                    jobEntity = entities.get(0);
                }else {
                    jobEntity = new JobEntity();
                    jobEntity.setSourceId(data.getString("C_CM_AccountingProjectSet_SuBOID"));
                    jobEntity.setTenantId(999999L);
                    generateNewJob(employeeVO.getId(),
                            data.getLong("projectDepartmentId"),
                            null,null,
                            jobEntity,
                            JobVO.JOB_TYPE_PARTTIME,
                            0,null);
                    try {
                        jobEntity.setJobStartTime(DateFormatUtil.parseDate("yyyy/MM/dd HH:mm:ss",data.getString("BeginTime")));
                    } catch (ParseException e) {
                        logger.info("格式化中电四人员兼职起始时间出错！{}",data.toJSONString());
                        e.printStackTrace();
                    }
                }
                if(data.getInteger("IsScene")!=1){
                    /** 撤场了，兼职结束！*/
                    jobEntity.setCurState(JobVO.STATE_INACTIVE);
                    try {
                        jobEntity.setJobEndTime(DateFormatUtil.parseDate("yyyy/MM/dd HH:mm:ss",data.getString("EndTime")));
                    } catch (ParseException e) {
                        logger.info("格式化中电四人员兼职结束时间出错！{}",data.toJSONString());
                        e.printStackTrace();
                    }
                }
                jobEntityList.add(jobEntity);
            }
            if(ListUtil.isNotEmpty(jobEntityList)){
                jobService.saveOrUpdateBatch(jobEntityList);
            }
        }
    }

}
