package com.ejianc.foundation.orgcenter.service.impl;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.bean.DeptEntity;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.mapper.OrgMapper;
import com.ejianc.foundation.orgcenter.service.IDeptService;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.bean.RoleEntity;
import com.ejianc.foundation.permission.service.IRoleAppRelationService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.utils.gdty.param.GdtyOrg;
import com.ejianc.foundation.workbench.bean.LayoutEntity;
import com.ejianc.foundation.workbench.service.ILayoutOrgRelationService;
import com.ejianc.foundation.workbench.service.ILayoutRoleRelationService;
import com.ejianc.foundation.workbench.service.ILayoutService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

@Service
public class OrgServiceImpl extends BaseServiceImpl<OrgMapper, OrgEntity> implements IOrgService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private OrgMapper orgMapper;
	@Autowired
	private IDeptService deptService;
	@Autowired
	private IRoleUserRelationService roleUserRelationService;
	@Autowired
	private IRoleAppRelationService roleAppRelationService;
	@Autowired
	private IRoleService roleService;
	@Autowired
	private ILayoutRoleRelationService layoutRoleRelationService;
	@Autowired
	private ILayoutOrgRelationService layoutOrgRelationService;
	@Autowired
	private ILayoutService layoutService;
	@Autowired
	private IJobService jobService;
	@Autowired
	private IEmployeeService employeeService;
	@Autowired
	private IUserService userService;


	@Override
	@Transactional(rollbackFor = Exception.class)
	public String delAllByOrgId(Long orgId) {

		logger.info("执行组织[id-{}]删除操作------start-----", orgId);

		String userType = InvocationInfoProxy.getUserType();
		if(!"1".equals(userType)) {
			logger.info("组织删除操作终止，当前登陆人[userId-{}]无删除权限。---------", InvocationInfoProxy.getUserid());
			return "请联系管理员执行删除操作。";
		}

		return delProjectDepartment(orgId);
	}

	@Override
	public String delSDSJPrjDepartmentByOrgId(Long orgId) {
		logger.info("执行组织[id-{}]删除操作------start-----", orgId);
		return delProjectDepartment(orgId);
	}

	private String delProjectDepartment(Long orgId) {
		OrgEntity orgEntity = super.selectById(orgId);
		if(null == orgEntity.getOrgType() || !OrgVO.ORG_TYPE_DEPARTMENT.equals(orgEntity.getOrgType())) {
			logger.info("组织删除操作终止，只支持对项目部的删除操作。---------");
			return "删除失败，只能删除类型为项目部的组织。";
		}
		//查询所有的门户设计
		QueryWrapper<LayoutEntity> layoutQuery = new QueryWrapper<>();
		layoutQuery.eq("org_id", orgId);
		layoutQuery.eq("dr", BaseVO.DR_UNDELETE);

		List<LayoutEntity> layoutList = layoutService.list(layoutQuery);
		final List<Long> layoutIds = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(layoutList)) {
			layoutIds.addAll(layoutList.stream().map(LayoutEntity::getId).collect(Collectors.toList()));
		}
		//删除对应的布局组织关系
		layoutOrgRelationService.deleteByOrgIdAndLayoutIds(layoutIds, orgId);

		//查询组织下所有的角色信息
		QueryWrapper<RoleEntity> roleQuery = new QueryWrapper<>();
		roleQuery.eq("org_id", orgId);
		roleQuery.eq("dr", BaseVO.DR_UNDELETE);
		List<RoleEntity> roleList = roleService.list(roleQuery);
		List<Long> roleIds = null;
		if(CollectionUtils.isNotEmpty(roleList)) {
			roleIds = roleList.stream().map(RoleEntity::getId).collect(Collectors.toList());
			//删除角色应用关系
			roleAppRelationService.delByRoleIds(roleIds);
		}
		//删除布局角色关系
		if(CollectionUtils.isNotEmpty(roleIds) || CollectionUtils.isNotEmpty(layoutIds)) {
			layoutRoleRelationService.delByRoleIdsAndOrgId(roleIds, layoutIds);
		}

		if(CollectionUtils.isNotEmpty(layoutIds)) {
			//删除布局相关信息
			logger.info("组织删除：删除对应布局[ids-{}]", StringUtils.join(layoutIds, ","));
			layoutService.removeByIds(layoutIds);
		}

		QueryWrapper<JobEntity> jobQuery = new QueryWrapper<>();
		jobQuery.eq("org_id", orgId);
		jobQuery.eq("dr", BaseVO.DR_UNDELETE);

		List<JobEntity> jobList = jobService.list(jobQuery);
		if(CollectionUtils.isNotEmpty(jobList)) {
			List<Long> jobIds = new ArrayList<>();
			Set<Long> employeeIds = new HashSet<>();
			jobList.stream().forEach(job -> {
				jobIds.add(job.getId());
				if(job.getProperty() == 1) {
					//删除主职人员
					employeeIds.add(job.getEmployeeId());
				}
			});
			roleUserRelationService.deleteByJobIds(jobIds);

			//删除对应人员的任职记录
			logger.info("组织删除：删除对应任职记录[ids-{}]", StringUtils.join(jobIds, ","));
			jobService.removeByIds(jobIds);
			//删除对应的人员用户
			if(CollectionUtils.isNotEmpty(employeeIds)) {
				logger.info("组织删除：删除对应人员[ids-{}]", StringUtils.join(employeeIds, ","));
//				employeeService.removeByIds(employeeIds);
				//删除对应的人员用户
				for(Long employeeId : employeeIds){
					EmployeeEntity employee = employeeService.selectById(employeeId);
					employeeService.deleteEmployee(BeanMapper.map(employee, EmployeeVO.class));
				}
			}
		}

		//删除对应的角色
		if(CollectionUtils.isNotEmpty(roleIds)) {
			logger.info("组织删除：删除对应角色[ids-{}]", StringUtils.join(roleIds, ","));
			roleService.delete(roleIds);
		}
/*
		//删除对应项目部下所有用户
		Map<String, Object> delUserParam = new HashMap<>(12);
		delUserParam.put("org_id", orgId);
		delUserParam.put("dr", BaseVO.DR_UNDELETE);
		logger.info("组织删除：删除对应组织下用户[orgId-{}]", orgId);
		userService.removeByMap(delUserParam, false);*/

		//删除对应组织
		super.removeById(orgId, false);

		logger.info("组织【id-{}】删除成功------end-----", orgId);
		return null;
	}

	@Override
	public List<OrgVO> queryOrgList(Map<String, Object> params) {
		if(InvocationInfoProxy.getTenantid()==null){
			HttpServletRequest request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
			params.put("tenantId", getAuthority(request.getHeader("authority")).getLong("tenantid"));
		}else {
			params.put("tenantId", InvocationInfoProxy.getTenantid());
		}
		if(params.get("orgId")!=null){
			OrgEntity currentEntity = baseMapper.selectById(Long.parseLong(params.get("orgId").toString()));
			if (currentEntity != null) {
				if (4 == currentEntity.getOrgType()) { // 如果当前组织为虚拟组织，
					// 则向上找到最近的集团、分子公司、经理部、项目部结束
					loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
				}
//				params.put("innerCode", currentEntity.getInnerCode());
				params.put("orgId", currentEntity.getId());
			}
		}

		logger.info("组织树查询参数{}", JSONObject.toJSONString(params));

		List<OrgVO> list = orgMapper.queryOrgList(params);
		return list;
	}

	//查询组织部门树时，之前的无法判断该节点是否是叶子节点，故作处理
	@Override
	public List<OrgVO> queryOrgList2(Map<String, Object> params) {
		if(InvocationInfoProxy.getTenantid()==null){
			HttpServletRequest request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
			params.put("tenantId", getAuthority(request.getHeader("authority")).getLong("tenantid"));
		}else {
			params.put("tenantId", InvocationInfoProxy.getTenantid());
		}
		if(params.get("orgId")!=null){
			OrgEntity currentEntity = baseMapper.selectById(Long.parseLong(params.get("orgId").toString()));
			if (currentEntity != null) {
				if (4 == currentEntity.getOrgType()) { // 如果当前组织为虚拟组织，
					// 则向上找到最近的集团、分子公司、经理部、项目部结束
					loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
				}
//				params.put("innerCode", currentEntity.getInnerCode());
				params.put("orgId", currentEntity.getId());
			}
		}

		logger.info("组织树查询参数{}", JSONObject.toJSONString(params));

		List<OrgVO> list = orgMapper.queryOrgList2(params);
		return list;
	}
	@Override
	public List<OrgVO> getDirectChildrenByPid(Long parentId, String searchText) {
		QueryWrapper<OrgEntity> query = new QueryWrapper();
		OrgEntity parent = null;
		if(null == parentId || StringUtils.isNotEmpty(searchText)) {
			//查询本租户根组织
			query.eq("tenant_id", InvocationInfoProxy.getTenantid());
			if(StringUtils.isEmpty(searchText)){
				query.isNull("parent_id");
			}
		} else {
			query.eq("parent_id", parentId);
			parent = super.selectById(parentId);
		}
		//启用状态
		query.eq("state", 1);
		query.eq("dr", BaseVO.DR_UNDELETE);
		if(StringUtils.isNotBlank(searchText)) {
			query.like("name", searchText);
		}

		query.orderByAsc("org_type", "create_time");
		List<OrgEntity> list = super.list(query);
		List<OrgVO> voList = BeanMapper.mapList(list, OrgVO.class);
		if(null != parent && CollectionUtils.isNotEmpty(voList)) {
			for(OrgVO org : voList) {
				org.setpFName(parent.getName());
				org.setpSName(parent.getShortName());
			}
		}

		return voList;
	}

	@Override
	public OrgEntity queryBySourceId(String sourceId,Long tenantId) {
		QueryParam param = new QueryParam();
		param.getParams().put("sourceId",new Parameter(QueryParam.EQ,sourceId));
		param.getParams().put("tenantId",new Parameter(QueryParam.EQ,tenantId));
		List<OrgEntity> orgEntities = queryList(param,false);
		if(ListUtil.isNotEmpty(orgEntities)){
			return orgEntities.get(0);
		}
		return null;
	}

	@Override
	public List<Map<String, Object>> getSubOrgMaps(Long orgId) {
		return orgMapper.getSubOrgMaps(orgId);
	}

	@Override
	public List<Map<String, Object>> findOrgMapsByTenantId(Long tenantId) {
		return orgMapper.findOrgMapsByTenantId(tenantId);
	}

	@Override
	public List<OrgEntity> queryListTree(Map<String, Object> params) {
		QueryWrapper<OrgEntity> query = new QueryWrapper<>();
		query.eq("dr", BaseVO.DR_UNDELETE);
		query.eq("tenant_id", InvocationInfoProxy.getTenantid());
		for (String key : params.keySet()) {
			switch (key) {
				case "orgId":
					Long orgId = (Long) params.get(key);
					OrgEntity currentEntity = null;
					if (orgId != null) {
						currentEntity = baseMapper.selectById(orgId);
					}
					if (currentEntity != null) {
						if (4 == currentEntity.getOrgType()) { // 如果当前组织为虚拟组织，
							// 则向上找到最近的集团、分子公司、经理部、项目部结束
							loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
						}
						query.likeRight("inner_code", currentEntity.getInnerCode());
					}
					break;
				case "orgTypes":
					query.in("org_type", (List<Integer>)params.get("orgTypes"));
					break;
				default:
					query.like(CamelAndUnderLineConverter.humpToLine(key), params.get(key));
			}
		}

		query.orderByAsc("sequence");
		query.orderByDesc("create_time");
		List<OrgEntity> eList = baseMapper.selectList(query);
		return eList;
	}

	@Override
	public List<OrgEntity> getRootOrgList(Long tenantId) {
		QueryParam param = new QueryParam();
		param.getParams().put("tenantId",new Parameter(QueryParam.EQ,tenantId));
		param.getParams().put("parentId",new Parameter(QueryParam.EQ,null));
		List<OrgEntity> list = queryList(param,false);
		return list;
	}

	@Override
	public OrgVO queryDetail(Long id) {
		OrgEntity entity = baseMapper.selectById(id);
		if (entity != null) {
			return BeanMapper.map(entity, OrgVO.class);
		}
		return null;
	}

	@Override
	public void delete(Long id) {
		//先查询该档案项有没有子节点
		List<OrgVO> defdocDetails = queryListByPid(id);
		if(defdocDetails != null && defdocDetails.size() > 0) {
			throw new BusinessException("该组织有子节点，不允许删除");
		}
		//查询该组织下有没有部门
		QueryParam deptParam = new QueryParam();
		deptParam.getParams().put("orgId", new Parameter(QueryParam.EQ, id));
		List<DeptEntity> deptList = deptService.queryList(deptParam, false);
		if(deptList != null && deptList.size() > 0) {
			throw new BusinessException("该组织下已经有部门了，不允许删除");
		}
		//查询该组织下有没有员工--查询任职信息表
		QueryWrapper<JobEntity> jobQuery = new QueryWrapper<>();
		jobQuery.eq("org_id", id);
		jobQuery.eq("dr", BaseVO.DR_UNDELETE);
		List<JobEntity> jobList = jobService.list(jobQuery);
		if(jobList != null && jobList.size() > 0) {
			throw new BusinessException("该组织下已经有员工了， 不允许删除");
		}
		baseMapper.deleteById(id);
	}

	@Override
	public List<OrgVO> queryListByPid(Long id) {
		QueryWrapper<OrgEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("parent_id", id);
		wrapper.eq("dr", 0);
		List<OrgEntity> entity = baseMapper.selectList(wrapper);
		if (entity != null) {
			return BeanMapper.mapList(entity, OrgVO.class);
		}

		return null;
	}

	@Override
	public List<OrgVO> selectByMap(Map<String, Object> map) {
		List<OrgEntity> entity = baseMapper.selectByMap(map);
		return BeanMapper.mapList(entity, OrgVO.class);
	}

	@Override
	public List<OrgEntity> getAllByIds(List<Long> ids) {
		return baseMapper.selectBatchIds(ids);
	}

	private void loopOrgEntityByPid(Long parentId, OrgEntity result) {
		OrgEntity entity = baseMapper.selectById(parentId);
		if (4 != entity.getOrgType()) {
			BeanUtils.copyProperties(entity, result);
		} else {
			if (entity.getParentId() != null && entity.getParentId() > 0) {
				loopOrgEntityByPid(entity.getParentId(), result);
			} else {
				BeanUtils.copyProperties(entity, result);
			}
		}
	}

	@Override
	public OrgVO queryUserContextOrg(Long orgId) {
		OrgEntity currentEntity = baseMapper.selectById(orgId);
		if (currentEntity != null) {
			if (4 == currentEntity.getOrgType()) { // 如果当前组织为虚拟组织，
															// 则向上找到最近的集团、分子公司、经理部、项目部结束
				loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
			}
		}
		if (currentEntity != null) {
			QueryWrapper<OrgEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("parent_id", currentEntity.getId());
			Integer count = baseMapper.selectCount(queryWrapper);

			OrgVO orgVo = BeanMapper.map(currentEntity, OrgVO.class);
			if (count != null && count > 0) {
				orgVo.setIsParent(true);
			}

			return orgVo;
		}
		return null;
	}

	@Override
	public List<OrgVO> getSubOrgs(Long orgId, Integer prjstate) {
		List<OrgVO> orgVoList = baseMapper.getSubOrgs(orgId, prjstate);
		return orgVoList;
	}

	@Override
	public List<OrgVO> searchOrgs(String searchText, String orgIds, Integer prjstate) {
		List<OrgVO> orgVos = new ArrayList<OrgVO>();
		if(StringUtils.isNotBlank(orgIds)) {
			String[] orgIdArr = orgIds.split(",");
			for(String orgId:orgIdArr) {
				OrgEntity entity = baseMapper.selectById(Long.parseLong(orgId));
				
				if(entity != null) {
					List<OrgVO> orgVoList = baseMapper.searchOrgs(searchText, entity.getInnerCode(), prjstate);
					if(orgVoList != null && orgVoList.size() > 0) {
						orgVos.addAll(orgVoList);
					}
				}
			}
		}
		return orgVos;
	}

	@Override
	public List<OrgVO> queryUserContextOrgList(List<Long> resultList, Integer prjstate) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		StringBuffer orgIds = new StringBuffer();
		if(resultList != null && resultList.size() > 0) {
			for(Long orgId:resultList) {
				orgIds.append(orgId).append(",");
			}
		}
		if(StringUtils.isNotBlank(orgIds)) {
			String orgIdString = orgIds.substring(0, orgIds.length() - 1);
			return orgMapper.queryUserContextOrgList(tenantId, orgIdString, prjstate);
		}
		return null;
	}

	@Override
	public List<OrgVO> queryJobOrgs(Long userId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<OrgVO> orgList = orgMapper.queryJobOrgsByUserId(userId,tenantId );
		return orgList;
	}

	@Override
	public List<OrgVO> queryJobOrgs2(Long userId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<OrgVO> orgList = orgMapper.queryJobOrgsByUserId2(userId,tenantId );
		return orgList;
	}

	@Override
	public List<OrgVO> queryAppSubByPid(Long orgId) {
		OrgEntity entity = orgMapper.selectById(orgId);
		
		if(entity != null) {
			List<OrgVO> result = orgMapper.queryAppSubByPid(entity.getInnerCode());
			return result;
		}
		return null;
	}

	@Override
	public List<OrgVO> queryAppSubByPid2(Long orgId) {
		OrgEntity entity = orgMapper.selectById(orgId);

		if(entity != null) {
			List<OrgVO> result = orgMapper.queryAppSubByPid2(entity.getInnerCode());
			return result;
		}
		return null;
	}

	@Override
	public List<OrgVO> findParentsByOrgId(Long orgId) {
		OrgEntity entity = orgMapper.selectById(orgId);
		
		if(entity != null) {
			List<OrgVO> result = orgMapper.queryParentsByOrgId(entity.getInnerCode());
			List<OrgVO> fictitious = new ArrayList<>();
			if(ListUtil.isNotEmpty(result)){
				QueryParam param = new QueryParam();
				param.getParams().put("orgType",new Parameter(QueryParam.EQ,4));
				for (OrgVO orgVO : result) {
					param.getParams().put("parentId",new Parameter(QueryParam.EQ,orgVO.getId()));
					List<OrgEntity> orgEntities = queryList(param);
					if(ListUtil.isNotEmpty(orgEntities)){
						fictitious.addAll(BeanMapper.mapList(orgEntities,OrgVO.class));
					}
				}
				/** 判重 */
				for (OrgVO orgVO : fictitious) {
					boolean has = false;
					for (OrgVO vo : result) {
						if(vo.getId().equals(orgVO.getId())){
							has = true;
							break;
						}
					}
					if(!has){
						result.add(orgVO);
					}
				}
			}
			return result;
		}
		return null;
	}
	
	@Override
	public List<OrgVO> findParentsByOrgIdAsc(Long orgId) {
		OrgEntity entity = orgMapper.selectById(orgId);
		
		if(entity != null) {
			List<OrgVO> result = orgMapper.queryParentsByOrgIdAsc(entity.getInnerCode());
			return result;
		}
		return null;
	}

	@Override
	public OrgVO findOrgByTenantId(Long tenantId) {
		OrgVO orgVO = new OrgVO();
		QueryWrapper<OrgEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("tenant_id", tenantId);
		wrapper.eq("dr", 0);
		wrapper.isNull("parent_id");
		wrapper.isNotNull("inner_code");
		List<OrgEntity> entity = baseMapper.selectList(wrapper);
		if(entity!=null&&entity.size()>0){
			orgVO = BeanMapper.map(entity.get(0), OrgVO.class);
		}
		return orgVO;
	}

	@Override
	public List<OrgVO> queryOrgListByIds(List<Long> orgIds) {
		String orgIdStr = "";
		for(Long orgId:orgIds) {
			orgIdStr += orgId + ",";
		}
		if(StringUtils.isNotBlank(orgIdStr)) {
			orgIdStr = orgIdStr.substring(0, orgIdStr.length()-1);
			List<OrgVO> orgVos = orgMapper.queryOrgListByIds(orgIdStr);
			return orgVos;
		}
		return null;
	}

	@Override
	public List<OrgVO> queryAllProjectOrgsByInnerCode(String innerCode) {
		List<OrgVO> orgVos = orgMapper.queryAllProjectOrgsByInnerCode(innerCode);
		return orgVos;
	}

	@Override
	public List<OrgVO> queryAllProjectOrgsByInnerCode2(String innerCode) {
		List<OrgVO> orgVos = orgMapper.queryAllProjectOrgsByInnerCode2(innerCode);
		return orgVos;
	}

	@Override
	public List<OrgVO> queryAllOrgByInnerCodeWithoutProjectDept(String innerCode) {
		List<OrgVO> orgVos = orgMapper.queryAllOrgByInnerCodeWithoutProjectDept(innerCode);
		return orgVos;
	}

	@Override
	public void saveOrgAndDept(OrgEntity saveOrgBean) {
		orgMapper.insert(saveOrgBean);
		
		DeptEntity deptEntity = new DeptEntity();
		Long deptPkId = IdWorker.getId();
		deptEntity.setId(deptPkId);
		deptEntity.setOrgId(saveOrgBean.getId());
		deptEntity.setCode(saveOrgBean.getCode());
		deptEntity.setName(saveOrgBean.getName());
		deptEntity.setShortName(saveOrgBean.getShortName());
		deptEntity.setState(1);
		deptEntity.setSequence(saveOrgBean.getSequence());
		deptEntity.setType(1);
		deptEntity.setSourceId(saveOrgBean.getSourceId());
		deptEntity.setTenantId(999999l);
		deptService.saveOrUpdate(deptEntity, false);
	}

	@Override
	public void updateOrgAndDept(OrgEntity saveOrgBean) {
		orgMapper.updateById(saveOrgBean);
		
		QueryWrapper<DeptEntity> deptWrapper = new QueryWrapper<>();
		deptWrapper.eq("source_id", saveOrgBean.getSourceId());
		DeptEntity deptEntity = deptService.getOne(deptWrapper);
		if(deptEntity == null) {
			deptEntity = new DeptEntity();
			Long deptPkId = IdWorker.getId();
			deptEntity.setId(deptPkId);
			deptEntity.setOrgId(saveOrgBean.getId());
			deptEntity.setCode(saveOrgBean.getCode());
			deptEntity.setName(saveOrgBean.getName());
			deptEntity.setShortName(saveOrgBean.getShortName());
			deptEntity.setState(1);
			deptEntity.setSequence(saveOrgBean.getSequence());
			deptEntity.setType(1);
			deptEntity.setSourceId(saveOrgBean.getSourceId());
			deptEntity.setTenantId(999999l);
		}
		deptEntity.setState(saveOrgBean.getState());
		deptService.saveOrUpdate(deptEntity, false);
	}

	@Override
	public void insertGdtyOrgData(String insertOrgSql) {
		orgMapper.insertGdtyOrgData(insertOrgSql);
	}

	@Override
	public List<GdtyOrg> queryGdtyOrgData() {
		List<GdtyOrg> gdtyOrgList = orgMapper.queryGdtyOrgData();
		return gdtyOrgList;
	}

	@Override
	public JSONObject getAuthority(String authority) {
		JSONObject object = new JSONObject();
		if(StringUtils.isNotEmpty(authority)){
			String[] ac = authority.split(";");
			for (String s : ac) {
				String[] cookieArr = s.split("=");
				String key = StringUtils.trim(cookieArr[0]);
				String value = StringUtils.trim(cookieArr[1]);
				object.put(key,value);
			}
		}
		return object;
	}

	@Override
	public List<OrgVO> queryOrgNewList(Map<String, Object> params) {
		if(InvocationInfoProxy.getTenantid()==null){
			HttpServletRequest request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
			params.put("tenantId", getAuthority(request.getHeader("authority")).getLong("tenantid"));
		}else {
			params.put("tenantId", InvocationInfoProxy.getTenantid());
		}
		if(params.get("orgId")!=null){
			OrgEntity currentEntity = baseMapper.selectById(Long.parseLong(params.get("orgId").toString()));
			if (currentEntity != null) {
				if (4 == currentEntity.getOrgType()) { // 如果当前组织为虚拟组织，
					// 则向上找到最近的集团、分子公司、经理部、项目部结束
					loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
				}
				params.put("orgId", currentEntity.getId());
			}
		}

		logger.info("组织树查询参数{}", JSONObject.toJSONString(params));

		List<OrgVO> list = orgMapper.queryOrgNewList(params);
		return list;
	}
}
