package com.ejianc.foundation.workbench.element.node;

import org.springframework.util.Assert;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;

public class Attributes implements Iterable<Attribute> {
    private static final int InitialCapacity = 4;
    private static final int GrowthFactor = 2;

    private static final String[] Empty = {};

    static final int NotFound = -1;

    private int size = 0;
    String[] keys = Empty;
    String[] vals = Empty;

    private void checkCapacity(int minNewSize) {
        Assert.isTrue(minNewSize >= size);
        int curSize = keys.length;
        if (curSize >= minNewSize)
            return;

        int newSize = curSize >= InitialCapacity ? size * GrowthFactor : InitialCapacity;
        if (minNewSize > newSize)
            newSize = minNewSize;

        keys = copyOf(keys, newSize);
        vals = copyOf(vals, newSize);
    }

    private static String[] copyOf(String[] orig, int size) {
        final String[] copy = new String[size];
        System.arraycopy(orig, 0, copy, 0,
                Math.min(orig.length, size));
        return copy;
    }

    @Override
    public Iterator<Attribute> iterator() {
        return null;
    }

    @Override
    public void forEach(Consumer<? super Attribute> action) {

    }

    @Override
    public Spliterator<Attribute> spliterator() {
        return null;
    }

    static String checkNotNull(String val) {
        return val == null ? "" : val;
    }

    public String get(String key) {
        int i = indexOfKey(key);
        return i == NotFound ? "" : checkNotNull(vals[i]);
    }

    public Attributes put(String key, String value) {
        int i = indexOfKey(key);

        if (i != NotFound) {
            vals[i] = value;
        } else {
            add(key, value);
        }

        return this;
    }

    private void add(String key, String value) {
        checkCapacity(size + 1);
        keys[size] = key;
        vals[size] = value;
        size++;
    }

    int indexOfKey(String key) {
        Assert.notNull(key);
        for (int i = 0; i < size; i++) {
            if (key.equals(keys[i]))
                return i;
        }
        return NotFound;
    }
}
