/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.apigateway.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.apigateway.bean.ServInfoEntity;
import com.ejianc.foundation.apigateway.mapper.ServInfoMapper;
import com.ejianc.foundation.apigateway.service.IServInfoService;
import com.ejianc.foundation.apigateway.vo.ServInfoVO;
import com.ejianc.foundation.cache.ServiceCacheManage;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServInfoServiceImpl
extends BaseServiceImpl<ServInfoMapper, ServInfoEntity>
implements IServInfoService {
    @Autowired
    private ServInfoMapper servInfoMapper;
    @Autowired
    private ServiceCacheManage serviceCacheManage;

    @Override
    public List<ServInfoVO> queryListByGroupId(Long groupId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"group_id", (Object)groupId);
        wrapper.eq((Object)"dr", (Object)0);
        List entities = this.servInfoMapper.selectList((Wrapper)wrapper);
        if (entities != null && entities.size() > 0) {
            return BeanMapper.mapList((Iterable)entities, ServInfoVO.class);
        }
        return null;
    }

    @Override
    public ServInfoEntity queryDetail(Long id) {
        ServInfoEntity entity = (ServInfoEntity)((Object)this.servInfoMapper.selectById(id));
        return entity;
    }

    @Override
    public void deleteServInfo(List<Long> ids) {
        this.servInfoMapper.deleteBatchIds(ids);
        List entities = this.servInfoMapper.selectBatchIds(ids);
        if (entities != null && entities.size() > 0) {
            List servInfoVos = BeanMapper.mapList((Iterable)entities, ServInfoVO.class);
            for (int i = 0; i < servInfoVos.size(); ++i) {
                this.serviceCacheManage.removeServInfo(((ServInfoVO)servInfoVos.get(i)).getUrl());
            }
        }
    }

    @Override
    public void refreshServInfoCache() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        List entities = this.servInfoMapper.selectList((Wrapper)wrapper);
        if (entities != null && entities.size() > 0) {
            List servInfoVoList = BeanMapper.mapList((Iterable)entities, ServInfoVO.class);
            this.serviceCacheManage.putServiceListToCache(servInfoVoList);
        }
    }

    @Override
    public void saveOrUpdateBean(ServInfoEntity uniqueBean) {
        super.saveOrUpdate((Object)uniqueBean);
        ServInfoVO servInfoVo = (ServInfoVO)BeanMapper.map((Object)((Object)uniqueBean), ServInfoVO.class);
        this.serviceCacheManage.putServiceToCache(servInfoVo);
    }
}

