package com.ejianc.foundation.apigateway.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.apigateway.bean.ServInfoEntity;
import com.ejianc.foundation.apigateway.mapper.ServInfoMapper;
import com.ejianc.foundation.apigateway.service.IServInfoService;
import com.ejianc.foundation.apigateway.vo.ServInfoVO;
import com.ejianc.foundation.cache.ServiceCacheManage;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class ServInfoServiceImpl extends BaseServiceImpl<ServInfoMapper, ServInfoEntity> implements IServInfoService {
	
	@Autowired
	private ServInfoMapper servInfoMapper;
	@Autowired
	private ServiceCacheManage serviceCacheManage;

	@Override
	public List<ServInfoVO> queryListByGroupId(Long groupId) {
		QueryWrapper<ServInfoEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("group_id", groupId);
		wrapper.eq("dr", 0);
		List<ServInfoEntity> entities = servInfoMapper.selectList(wrapper);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.mapList(entities, ServInfoVO.class);
		}
		return null;
	}

	@Override
	public ServInfoEntity queryDetail(Long id) {
		ServInfoEntity entity = servInfoMapper.selectById(id);
		return entity;
	}

	@Override
	public void deleteServInfo(List<Long> ids) {
		servInfoMapper.deleteBatchIds(ids);
		List<ServInfoEntity> entities = servInfoMapper.selectBatchIds(ids);
		if(entities != null && entities.size() > 0) {
			List<ServInfoVO> servInfoVos = BeanMapper.mapList(entities, ServInfoVO.class);
			for(int i=0;i<servInfoVos.size();i++) {
				serviceCacheManage.removeServInfo(servInfoVos.get(i).getUrl());
			}
		}
	}

	@Override
	public void refreshServInfoCache() {
		QueryWrapper<ServInfoEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("dr", 0);
		List<ServInfoEntity> entities = servInfoMapper.selectList(wrapper);
		if(entities != null && entities.size() > 0) {
			List<ServInfoVO> servInfoVoList = BeanMapper.mapList(entities, ServInfoVO.class);
			serviceCacheManage.putServiceListToCache(servInfoVoList);
		}
	}

	@Override
	public void saveOrUpdateBean(ServInfoEntity uniqueBean) {
		super.saveOrUpdate(uniqueBean);
		ServInfoVO servInfoVo = BeanMapper.map(uniqueBean, ServInfoVO.class);
		serviceCacheManage.putServiceToCache(servInfoVo);
	}

}
