package com.ejianc.foundation.openapi.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.openapi.bean.SecurityLogEntity;
import com.ejianc.foundation.openapi.mapper.SecurityLogMapper;
import com.ejianc.foundation.openapi.service.ISecurityLogService;
import com.ejianc.foundation.openapi.vo.SecurityLogVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class SecurityLogServiceImpl extends BaseServiceImpl<SecurityLogMapper, SecurityLogEntity> implements ISecurityLogService {

	@Autowired
	private SecurityLogMapper securityLogMapper;
	
	@Override
	public IPage<SecurityLogVO> querySecurityLogPage(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		
		Map<String, Object> condition = new HashMap<>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());
		
		List<SecurityLogVO> records = securityLogMapper.querySecurityLogList(condition);
		Long count = securityLogMapper.querySecurityLogCount(condition);
		
		IPage<SecurityLogVO> page = new Page<>();
		page.setCurrent(queryParam.getPageIndex());
		page.setSize(queryParam.getPageSize());
		page.setTotal(count);
		page.setRecords(records);
		return page;
	}

}
