package com.ejianc.foundation.tenant.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 密码策略
 * 
 * @author guominga
 *
 */
@TableName("ejc_idm_passwordpolicy")
public class PasswordPolicyEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 策略编码
	 */
	@TableField(value = "code")
	private String code;
	/**
	 * 策略名称
	 */
	@TableField(value = "name")
	private String name;
	/**
	 * 密码复杂度（1: 数字和字母混合，2：数字、字母和!@#$%^&*?混合，3：大写字母、小写字母、数字和!@#$%^&*?混合）
	 */
	@TableField(value = "pwd_complexity")
	private Integer pwdComplexity;
	/**
	 * 密码最小长度
	 */
	@TableField(value = "min_length")
	private Integer minLength;
	/**
	 * 密码有效天数
	 */
	@TableField(value = "validate_days")
	private Integer validiteDays;

	/**
	 * 默认密码是否强制修改密码(1:是，0：否)
	 */
	@TableField(value = "default_pwd_flag")
	private Integer defaultPwdFlag;
	/**
	 * 密码过了有效期是否强制修改（1：是，0：否）
	 */
	@TableField(value = "force_update_flag")
	private Integer forceUpdateFlag;

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getPwdComplexity() {
		return pwdComplexity;
	}

	public void setPwdComplexity(Integer pwdComplexity) {
		this.pwdComplexity = pwdComplexity;
	}

	public Integer getMinLength() {
		return minLength;
	}

	public void setMinLength(Integer minLength) {
		this.minLength = minLength;
	}

	public Integer getValiditeDays() {
		return validiteDays;
	}

	public void setValiditeDays(Integer validiteDays) {
		this.validiteDays = validiteDays;
	}

	public Integer getDefaultPwdFlag() {
		return defaultPwdFlag;
	}

	public void setDefaultPwdFlag(Integer defaultPwdFlag) {
		this.defaultPwdFlag = defaultPwdFlag;
	}

	public Integer getForceUpdateFlag() {
		return forceUpdateFlag;
	}

	public void setForceUpdateFlag(Integer forceUpdateFlag) {
		this.forceUpdateFlag = forceUpdateFlag;
	}
}
