/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.orgcenter.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.orgcenter.bean.DeptEntity;
import com.ejianc.foundation.orgcenter.mapper.DeptMapper;
import com.ejianc.foundation.orgcenter.service.IDeptService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeptServiceImpl
extends BaseServiceImpl<DeptMapper, DeptEntity>
implements IDeptService {
    private static final String DEPT_BILL_CODE = "IDM_DEPT";
    @Autowired
    private IOrgService orgService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IJobService jobService;

    @Override
    public CommonResponse<String> save(DeptVO deptVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        DeptEntity entity = new DeptEntity();
        if (deptVo.getId() != null && deptVo.getId() > 0L) {
            DeptEntity oldEntity = (DeptEntity)((Object)super.getById((Serializable)deptVo.getId()));
            oldEntity.setManager(deptVo.getManager());
            oldEntity.setName(deptVo.getName());
            oldEntity.setShortName(deptVo.getShortName());
            oldEntity.setPhone(deptVo.getPhone());
            oldEntity.setSequence(deptVo.getSequence());
            oldEntity.setNote(deptVo.getNote());
            oldEntity.setOrgId(deptVo.getOrgId());
            oldEntity.setCode(deptVo.getCode());
            entity = (DeptEntity)((Object)BeanMapper.map((Object)((Object)oldEntity), DeptEntity.class));
            this.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        CommonResponse deptResponse = this.billCodeApi.getCodeBatchByRuleCode(DEPT_BILL_CODE, tenantId);
        if (!deptResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        deptVo.setCode((String)deptResponse.getData());
        deptVo.setDr(Integer.valueOf(0));
        if ("\u865a\u62df\u90e8\u95e8".equals(deptVo.getName())) {
            deptVo.setType(DeptVO.DEPT_TYPE_VIRTUAL);
        } else {
            deptVo.setType(DeptVO.DEPT_TYPE_NORMAL);
        }
        deptVo.setState(Integer.valueOf(1));
        entity = (DeptEntity)((Object)BeanMapper.map((Object)deptVo, DeptEntity.class));
        this.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public CommonResponse<String> delete(List<Long> ids) {
        QueryWrapper jobQuery = new QueryWrapper();
        jobQuery.in((Object)"dept_id", ids);
        jobQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List jobList = this.jobService.list((Wrapper)jobQuery);
        if (jobList != null && jobList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u90e8\u95e8\u4e0b\u5df2\u6709\u5458\u5de5\u4efb\u804c\u4e86\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        super.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public JSONObject checkQuote(Long sourceOrgId, Long targetOrgId) {
        JSONObject json = new JSONObject();
        OrgVO orgVO = this.orgService.queryDetail(sourceOrgId);
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("dr", BaseVO.DR_UNDELETE);
        map.put("tenant_id", InvocationInfoProxy.getTenantid());
        map.put("org_id", sourceOrgId);
        List sourceList = ((DeptMapper)this.baseMapper).selectByMap(map);
        map.replace("org_id", targetOrgId);
        List targetList = ((DeptMapper)this.baseMapper).selectByMap(map);
        HashMap targetMap = new HashMap();
        if (sourceList != null && sourceList.size() > 0) {
            if (targetList != null && targetList.size() > 0) {
                targetList.stream().forEach(entity -> targetMap.put(entity.getName(), entity));
                ArrayList<DeptEntity> addList = new ArrayList<DeptEntity>();
                String exitName = "";
                for (DeptEntity entity2 : sourceList) {
                    if (targetMap.get(entity2.getName()) != null) {
                        exitName = exitName + "[" + entity2.getName() + "]";
                        continue;
                    }
                    addList.add(entity2);
                }
                json.put("code", (Object)"2");
                String msg = "[\u7ec4\u7ec7:" + orgVO.getName() + "]\u4e0b\u6709" + sourceList.size() + "\u4e2a\u90e8\u95e8\u53ef\u4ee5\u5f15\u5165,\u5176\u4e2d" + exitName + "\u4e0e\u672c\u7ec4\u7ec7\u90e8\u95e8\u91cd\u590d\u7684\u90e8\u95e8\u3002\u672c\u6b21\u5f15\u5165\u90e8\u95e8\u4e3a";
                ArrayList<Long> deptIds = new ArrayList<Long>();
                for (DeptEntity entity3 : addList) {
                    msg = msg + "[" + entity3.getName() + "]";
                    deptIds.add(entity3.getId());
                }
                if (deptIds == null || deptIds.size() == 0) {
                    msg = msg + "\u7a7a";
                }
                json.put("msg", (Object)msg);
                json.put("data", deptIds);
            } else {
                json.put("code", (Object)"2");
                String msg = "[\u7ec4\u7ec7:" + orgVO.getName() + "]\u4e0b\u6709" + sourceList.size() + "\u4e2a\u90e8\u95e8\u53ef\u4ee5\u5f15\u5165,\u4e14\u4e0d\u5b58\u5728\u4e0e\u672c\u7ec4\u7ec7\u90e8\u95e8\u91cd\u590d\u7684\u90e8\u95e8\u3002\u672c\u6b21\u5f15\u5165\u90e8\u95e8\u4e3a";
                ArrayList<Long> deptIds = new ArrayList<Long>();
                for (DeptEntity entity4 : sourceList) {
                    msg = msg + "[" + entity4.getName() + "]";
                    deptIds.add(entity4.getId());
                }
                json.put("msg", (Object)msg);
                json.put("data", deptIds);
            }
        } else {
            json.put("code", (Object)"1");
            String msg = "[\u7ec4\u7ec7:" + orgVO.getName() + "]\u4e0b\u6ca1\u6709\u90e8\u95e8\u53ef\u4ee5\u5f15\u5165\u5230\u76ee\u6807\u7ec4\u7ec7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ec4\u7ec7";
            json.put("msg", (Object)msg);
        }
        return json;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<String> quoteDept(Map<String, Object> params) {
        if (params.get("targetOrgId") == null) return CommonResponse.error((String)"\u76ee\u6807\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        if (params.get("deptIds") == null) return CommonResponse.error((String)"\u5f15\u7528\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
        List deptIds = (List)params.get("deptIds");
        if (deptIds == null || deptIds.size() <= 0) return CommonResponse.success((String)"\u5f15\u5165\u6210\u529f");
        List entitys = (List)this.listByIds(deptIds);
        Long tenantId = InvocationInfoProxy.getTenantid();
        HashMap<Long, Long> corresponding = new HashMap<Long, Long>();
        for (DeptEntity entity : entitys) {
            corresponding.put(entity.getId(), IdWorker.getId());
        }
        for (DeptEntity entity : entitys) {
            CommonResponse deptResponse = this.billCodeApi.getCodeBatchByRuleCode(DEPT_BILL_CODE, tenantId);
            if (!deptResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)deptResponse.getData());
            entity.setId((Long)corresponding.get(entity.getId()));
            entity.setOrgId(Long.parseLong(params.get("targetOrgId").toString()));
            entity.setCreateTime(null);
            entity.setCreateUserCode(null);
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            entity.setUpdateTime(null);
            entity.setUpdateUserCode(null);
            entity.setPid((Long)corresponding.get(entity.getPid()));
        }
        this.saveBatch(entitys);
        return CommonResponse.success((String)"\u5f15\u5165\u6210\u529f");
    }

    @Override
    public DeptEntity selectById(Long deptId) {
        return (DeptEntity)((Object)((DeptMapper)this.baseMapper).selectById(deptId));
    }

    @Override
    public List<DeptEntity> getAllByIds(List<Long> deptIds) {
        return ((DeptMapper)this.baseMapper).selectBatchIds(deptIds);
    }

    @Override
    public List<DeptVO> queryDeptList(Map<String, Object> param) {
        return ((DeptMapper)this.baseMapper).queryDeptList(param);
    }
}

