package com.ejianc.foundation.usercenter.service.impl;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.permission.bean.RoleEntity;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.tenant.bean.DefaultPwdEntity;
import com.ejianc.foundation.tenant.service.IDefaultpwdService;
import com.ejianc.foundation.usercenter.bean.UserManagerRelationAppEntity;
import com.ejianc.foundation.usercenter.service.*;
import com.ejianc.framework.core.response.QueryParam;
import joptsimple.internal.Strings;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.mapper.EmployeeMapper;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.password.verify.CharDigitPassVerifier;
import com.ejianc.foundation.password.verify.CharDigitSignPassVerifier;
import com.ejianc.foundation.password.verify.UpAndLowerCharDigitSignPassVerifier;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.tenant.service.IPasswordPolicyService;
import com.ejianc.foundation.tenant.vo.PasswordPolicyVO;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.mapper.UserMapper;
import com.ejianc.foundation.usercenter.pm.encoder.PasswordEncoder;
import com.ejianc.foundation.usercenter.pm.encoder.UsernameSaltPasswordEncoder;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.PwdHistoryVO;
import com.ejianc.foundation.usercenter.vo.UserRefVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;

@Service
public class UserServiceImpl extends BaseServiceImpl<UserMapper, UserEntity> implements IUserService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    private static final String REFER_CACHE_KEY = "refer_cache_key:";
	
	@Autowired
	private UserMapper userMapper;

	@Autowired
	private IPasswordPolicyService passwordPolicyService;
	@Autowired
	private IDefaultpwdService iDefaultpwdService;
	@Autowired
	private IOrgService orgService;
    @Autowired
    private IEmployeeService employeeService;
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IPwdHistoryService pwdHistoryService;
	@Autowired
	private IRoleUserRelationService roleUserRelationService;
	@Autowired
	private EmployeeMapper employeeMapper;
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	@Autowired
	private IUserTenantRelationService userTenantRelationService;
	@Autowired
	private IThirdSystemService thirdSystemService;
	@Autowired
	private EnvironmentTools environmentTools;

	@Autowired
	private IAppService appService;
	@Autowired
	private IRoleService roleService;
	@Autowired
	private IJobService jobService;
	@Autowired
	private IUserManagerRelationAppService userManagerRelationAppService;
	@Value("${oms.tenantid}")
	private String OMS_TENANT;
	@Autowired
	private PermissionCacheManage permissionCacheManage;

	@Override
	public UserVO selectById(Long userId) {
		UserEntity entity = this.getById(userId);
		UserTenantRelationEntity relation = userTenantRelationService.getOne(userId, null);
		if(relation!=null){
			entity.setTenantId(relation.getTenantId());
			entity.setOrgId(relation.getOrgId());
			entity.setTypeId(relation.getTypeId());
		}
		UserVO userVo = BeanMapper.map(entity, UserVO.class);
		return userVo;
	}

	@Override
	public void updateUserPassword(Long userId, String password) {
		userMapper.updateUserPassword(userId, password);
	}

	@Override
	public UserVO queryLoginUserByUserCodeOrPhoneNumOrEMail(String condition) {
		//先根据账号查， 没有再根据手机号查询， 没有再根据邮箱查询
		UserVO userVo = null;
		QueryWrapper<UserEntity> userCodeWrapper = new QueryWrapper<>();
		userCodeWrapper.eq("user_code", condition).eq("dr", 0);
		UserEntity userEntity = this.getOne(userCodeWrapper);
		if(userEntity != null) {
			userVo = BeanMapper.map(userEntity, UserVO.class);
			return userVo;
		}
		
		QueryWrapper<UserEntity> userPhoneWrapper = new QueryWrapper<>();
		userPhoneWrapper.eq("user_mobile", condition).eq("dr", 0);
		userEntity = this.getOne(userPhoneWrapper);
		if(userEntity != null) {
			userVo = BeanMapper.map(userEntity, UserVO.class);
			return userVo;
		}
		
		QueryWrapper<UserEntity> emailWrapper = new QueryWrapper<>();
		emailWrapper.eq("user_email", condition).eq("dr", 0);
		userEntity = this.getOne(emailWrapper);
		if(userEntity != null) {
			userVo = BeanMapper.map(userEntity, UserVO.class);
			return userVo;
		}
		return null;
	}

	@Override
	@Transactional
	public UserVO generateNewUser(EmployeeVO employeeVO) {
		//当用户编码存在时根据用户编码判重
		if(StringUtils.isNotBlank(employeeVO.getUserCode())){
			QueryWrapper<UserEntity> userCodeWrapper = new QueryWrapper<>();
			userCodeWrapper.eq("user_code", employeeVO.getUserCode()).eq("dr", 0);
			UserEntity uniqueBean = userMapper.selectOne(userCodeWrapper);
			if(uniqueBean!=null){
				throw new BusinessException("新增人员失败，用户编码已存在！");
			}
		}
		//根据人员手机号查询用户
		QueryWrapper<UserEntity> userPhoneWrapper = new QueryWrapper<>();
		userPhoneWrapper.eq("user_mobile", employeeVO.getMobilePhone()).eq("dr", 0);
		UserEntity uniqueBean = userMapper.selectOne(userPhoneWrapper);
		if(uniqueBean != null) {
			if(uniqueBean.getTenantId() != null && uniqueBean.getTenantId() > 0) {
				return null;
			} else {
				uniqueBean.setTenantId(employeeVO.getTenantId());
				uniqueBean.setOrgId(employeeVO.getOrgId());
				if(employeeVO.getTypeId()!=null){
					uniqueBean.setTypeId(employeeVO.getTypeId()); //普通用户
				}else {
					uniqueBean.setTypeId(2); //普通用户
				}
				super.saveOrUpdate(uniqueBean);
				
				return BeanMapper.map(uniqueBean, UserVO.class);
			}
		}else{
			UserVO userVO = new UserVO();
			userVO.setAvator(employeeVO.getPhotoPath());
			userVO.setSex(employeeVO.getSex().toString());
			userVO.setTenantId(InvocationInfoProxy.getTenantid());
			userVO.setUserName(employeeVO.getName());
			userVO.setUserCode(StringUtils.isNotBlank(employeeVO.getUserCode()) ? employeeVO.getUserCode() : "U"+ IdWorker.getId());
			userVO.setUserMobile(employeeVO.getMobilePhone());
			userVO.setTenantId(employeeVO.getTenantId());
			userVO.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态
			userVO.setDr(BaseVO.DR_UNDELETE);
			if(employeeVO.getTypeId()!=null){
				userVO.setTypeId(employeeVO.getTypeId()); //普通用户
			}else {
				userVO.setTypeId(2); //普通用户
			}
			userVO.setOrgId(employeeVO.getOrgId());
			PasswordUtils.setSalt(userVO);
			userCheck(userVO);

			String password = PasswordUtils.getSalt();
			String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
			userVO.setPassword(shaPassword);
			userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
			userVO.setPwdStartTime(new Date());
			userVO.setTenantId(InvocationInfoProxy.getTenantid());

			UserEntity saveEntity = BeanMapper.map(userVO, UserEntity.class);
			super.saveOrUpdate(saveEntity);
			return BeanMapper.map(saveEntity, UserVO.class);
		}
	}

	@Override
	public void resetpwd(Long userId) {
		UserVO user = this.selectById(userId);
		if(null == user) {
			throw new BusinessException("用户不存在！");
		}

		String password = passwordPolicyService.getUserDefaultPassword(user.getTenantId());
		String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
		user.setPassword(shaPassword);
		user.setPassword(PasswordUtils.encodebyUserCode(user));
		user.setPwdStartTime(new Date());
		UserEntity saveEntity = BeanMapper.map(user, UserEntity.class);
		super.saveOrUpdate(saveEntity);
	}

	private void userCheck(UserVO vo) {
		if(StringUtils.isNotBlank(vo.getUserMobile())){
			Pattern patternMobile = Pattern.compile("^[1][3456789][0-9]{9}$", Pattern.CASE_INSENSITIVE);
			Matcher matcherMobile = patternMobile.matcher(vo.getUserMobile());
			if (!matcherMobile.matches()) {
				throw new BusinessException("保存失败，用户手机非法");
			}
		}
		if(StringUtils.isNotBlank(vo.getUserEmail())){
			Pattern patternEmail = Pattern.compile("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$",
					Pattern.CASE_INSENSITIVE);
			Matcher matcherEmail = patternEmail.matcher(vo.getUserEmail());
			if (!matcherEmail.matches()) {
				throw new BusinessException("保存失败，用户邮箱非法");
			}
		}
	}

	@Override
	public IPage<UserRefVO> pageList(Map<String, Object> params) {
        List<UserRefVO> voList = new ArrayList<>();
        IPage<UserRefVO> page = new Page<>();
		if(params.get("pageNumber")!=null){
			Integer pn = Integer.parseInt(params.get("pageNumber").toString());
			pn = pn - 1 < 0 ? 1 : pn;
	        long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
	        params.put("startLine", startLine);
		}
        long total = userMapper.countRef(params);
        page.setTotal(total);
        if(total == 0) {
            page.setRecords(voList);
            return page;
        }
        voList = userMapper.queryListRef(params);
        page.setRecords(voList);
		return page;
	}

	@Override
	public void updateUserState(Long userId, Integer state) {
		userMapper.updateUserState(userId, state);
	}

	@Override
	public List<UserVO> selectAllByIds(List<Long> userIds,Long tenantId) {
//		return baseMapper.selectBatchIds(userIds);
		//包括查询组织信息
		return userMapper.selectAllByIds(userIds, tenantId);
	}

	@Override
	public IPage<UserRefVO> queryPage(Map<String, Object> queryParam, Integer pageIndex, Integer pageSize) {
		queryParam.put("pageIndex", pageIndex);
		queryParam.put("pageSize", pageSize);
		queryParam.put("tenantId", InvocationInfoProxy.getTenantid());
		Long userCount = userMapper.queryCount(queryParam);
		List<UserRefVO> userList = new ArrayList<>();
		if(userCount > 0) {
			userList = userMapper.queryList(queryParam);
		}
		IPage<UserRefVO> page = new Page<>();
		page.setRecords(userList);
		page.setSize(userCount);
		return page;
	}

	@Override
	public List<Map<String, Object>> getEmployeeList(Long orgId) {
		OrgVO orgVO = orgService.queryDetail(orgId);

		List<Map<String, Object>> dataMapList = new ArrayList<>();
		Map<String, Object> queryParam = new HashMap<>();
		queryParam.put("tenantId", orgVO.getTenantId());
		queryParam.put("innerCode", orgVO.getInnerCode());
		//Map<employeeId-jobId, EmployeeVO>
		Map<String, EmployeeVO> employeeMap = new HashMap<>();
		Map<String, Map<String, Object>> cacheMap = new HashMap<>();

		Map<String, Object> params = new HashMap<>();
		params.put("tenantId", orgVO.getTenantId());
		params.put("innerCode", orgVO.getInnerCode());
		List<Long> empIds = new ArrayList<>();
		empIds.add(0L);
		List<EmployeeVO> employeeVOS = employeeMapper.getListAPI(params);

		employeeVOS.stream().forEach(employeeVO -> {
			empIds.add(employeeVO.getId());
			employeeMap.put(employeeVO.getId() + "-" + employeeVO.getJobId(), employeeVO);
		});
		queryParam.put("employeeIds", empIds);
		queryParam.put("tenantId", orgVO.getTenantId());
		List<RoleUserRelationVO> roleUserList = roleUserRelationService.queryListByProperties(queryParam);
		roleUserList.stream().forEach(roleUser -> {
			EmployeeVO emp = employeeMap.get(roleUser.getEmployeeId() + "-" +roleUser.getJobId());
			if(null != emp) {
				Map<String, Object> dataMap = cacheMap.get(roleUser.getEmployeeId() + "-" +roleUser.getJobId());
				if(null == dataMap) {
					dataMap = new HashMap<>();
					dataMap.put("employeeId", emp.getId());
					dataMap.put("roleId", roleUser.getRoleId());
					dataMap.put("roleName", roleUser.getRoleName());
					dataMap.put("userId", emp.getUserId());
					dataMap.put("userName", emp.getName());
					dataMap.put("jobId", emp.getJobId());
					dataMap.put("postId", emp.getPostId());
					dataMap.put("onPost", emp.getOnPost());
					dataMap.put("postName", emp.getPostName());
					dataMap.put("isAdd", false);
					dataMap.put("state", emp.getState());
					dataMap.put("projectPost", emp.getProjectPost());

					dataMap.put("jobType", emp.getJobType() == 1 ? "直属" : "隶属");
					dataMap.put("id", UUID.randomUUID().toString().replaceAll("-", ""));

					dataMapList.add(dataMap);
					cacheMap.put(roleUser.getEmployeeId() + "-" +roleUser.getJobId(), dataMap);
				} else {
					dataMap.put("roleId", dataMap.get("roleId") + ","+roleUser.getRoleId());
					dataMap.put("roleName", dataMap.get("roleName") + ","+roleUser.getRoleName());
				}
				UserEntity user = super.getById(emp.getUserId());
				dataMap.put("avator", user.getAvator());
				dataMap.put("userMobile", user.getUserMobile());

				employeeVOS.remove(emp);
			}
		});

		//没有角色的人员
		if(CollectionUtils.isNotEmpty(employeeVOS)) {
			employeeVOS.stream().forEach(emp -> {
				Map<String, Object> dataMap = new HashMap<>();
				UserEntity user = super.getById(emp.getUserId());
				dataMap.put("avator", user.getAvator());
				dataMap.put("userMobile", user.getUserMobile());
				dataMap.put("employeeId", emp.getId());
				dataMap.put("userId", emp.getUserId());
				dataMap.put("userName", emp.getName());
				dataMap.put("jobId", emp.getJobId());
				dataMap.put("onPost", emp.getOnPost());
				dataMap.put("postId", emp.getPostId());
				dataMap.put("postName", emp.getPostName());
				dataMap.put("isAdd", false);
				dataMap.put("state", emp.getState());

				dataMap.put("jobType", emp.getJobType() == 1 ? "直属" : "隶属");
				dataMap.put("id", UUID.randomUUID().toString().replaceAll("-", ""));
				dataMapList.add(dataMap);
			});
		}

		return dataMapList;
	}

	@Override
	public List<UserVO> queryUserByPostAndOrg(List<Long> postIds, List<Long> orgIds) {
		return baseMapper.queryUserByPostAndOrg(postIds, orgIds);
	}

	/**
	 * 微信小程序
	 */
	@Override
	public UserVO getUserByWxOpenId(String openId) {
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("weixin_minprogram_id", openId);
		UserEntity userEntity = baseMapper.selectOne(queryWrapper);
		if(userEntity != null) {
			return BeanMapper.map(userEntity, UserVO.class);
		}
		return null;
	}
	
	public UserVO getUserByWeixineeId(String weixineeId) {
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("weixinee_id", weixineeId);
		UserEntity userEntity = baseMapper.selectOne(queryWrapper);
		if(userEntity != null) {
			return BeanMapper.map(userEntity, UserVO.class);
		}
		return null;
	}

	/**
	 * 根据第三方应用 企业微信租户 获取用户列表接口
	 *
	 * @return
	 */
	@Override
	public List<UserEntity> getWXEEThirdUserByTenantId() {
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		return baseMapper.selectList(queryWrapper);
	}

	@Override
	public void updateOpenId(Long userId, String openId) {
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("weixin_minprogram_id", openId);
		List<UserEntity> users = baseMapper.selectList(queryWrapper);
		UserEntity curUser = null;

		//清空该微信号与其他账号的绑定关系
		if(CollectionUtils.isNotEmpty(users)) {
			for(UserEntity user : users) {
				if(!user.getId().equals(userId)) {
					user.setWeixinMinprogramId(null);
				} else {
					curUser = user;
				}
			}
		}

		if(null == curUser) {
			curUser = baseMapper.selectById(userId);
			curUser.setWeixinMinprogramId(openId);
			users.add(curUser);
		}
		super.saveOrUpdateBatch(users);
	}

	@Override
	@Transactional
	public void unbindingWechat(Long userid) {
		userMapper.unbindingWechat(userid);
	}

	@Override
	public void updateUserLastLoginTime(Long userid) {
		userMapper.updateUserLastLoginTime(userid);
	}

	@Override
	public CommonResponse<UserVO> save(UserVO userVo) {
		this.userCheck(userVo);
		UserEntity userEntity = this.getById(userVo.getId());
		if(!userVo.getUserMobile().equals(userEntity.getUserMobile())){
			//当手机号改变时判断手机号是否被使用，
			QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("dr", 0);
			queryWrapper.eq("user_mobile", userVo.getUserMobile());
			queryWrapper.ne("id", userVo.getId());
			List<UserEntity> list = this.list(queryWrapper);
			if(list!=null&&list.size()>0){
				throw new BusinessException("保存用户信息失败，手机号已被使用");
			}
		}
		userEntity.setUserEmail(userVo.getUserEmail());
		userEntity.setUserMobile(userVo.getUserMobile());
		userEntity.setUserName(userVo.getUserName());
		if(StringUtils.isNotBlank(userVo.getSex())) {
			userEntity.setSex(StringUtils.isNotBlank(userVo.getSex())?Integer.valueOf(userVo.getSex()):null);
		}
		//处理头像
		if(StringUtils.isNotBlank(userEntity.getAvator())){
			if(StringUtils.isNotBlank(userVo.getAvator())){
				if(!userEntity.getAvator().equals(userVo.getAvator())){
					//删除原先的头像
					if(StringUtils.isNotBlank(userEntity.getAvator())){
						String id = userEntity.getAvator().split("=")[1];
						if(StringUtils.isNotBlank(id)){
							attachmentApi.delete(id);
						}
					}
					//绑定新的头像图标
					if(StringUtils.isNotBlank(userVo.getAvator())){
						String id = userVo.getAvator().split("=")[1];
						if(StringUtils.isNotBlank(id)){
							List<Long> attachIds = new ArrayList<>();
							attachIds.add(Long.parseLong(id));
							attachmentApi.updateAttachRef(userEntity.getId(), attachIds);
						}
					}
				}
			}else{
				//删除原先的头像
				if(StringUtils.isNotBlank(userEntity.getAvator())){
					String id = userEntity.getAvator().split("=")[1];
					if(StringUtils.isNotBlank(id)){
						attachmentApi.delete(id);
					}
				}
			}
		}else{
			if(StringUtils.isNotBlank(userVo.getAvator())){
				String id = userVo.getAvator().split("=")[1];
				if(StringUtils.isNotBlank(id)){
					List<Long> attachIds = new ArrayList<>();
					attachIds.add(Long.parseLong(id));
					attachmentApi.updateAttachRef(userEntity.getId(), attachIds);
				}
			}
		}
		userEntity.setAvator(userVo.getAvator());
		//保存用户信息
		this.saveOrUpdate(userEntity, false);
		//保存人员信息
		QueryWrapper<EmployeeEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("dr", 0);
		wrapper.eq("user_id", userVo.getId());
		EmployeeEntity employeeEntity = employeeService.getOne(wrapper);
		if(employeeEntity!=null){
			employeeEntity.setPhotoPath(userVo.getAvator());
			employeeEntity.setName(userVo.getUserName());
			employeeEntity.setMobilePhone(userVo.getUserMobile());
			employeeEntity.setSex(userEntity.getSex());
			employeeEntity.setUserSignaturePath(userVo.getUserSignaturePath());
			
	        CommonResponse<List<AttachmentVO>> attachListResp = attachmentApi.queryListBySourceId(employeeEntity.getId(), null, "userSignature", null);
	        if(attachListResp.isSuccess()) {
	            List<AttachmentVO> attachList = attachListResp.getData();
	            CommonResponse<String> updateResp = null;
	            if(attachList.isEmpty() && (null != userVo.getUserSignatureFileId())) {
	                updateResp = attachmentApi.updateAttachRef(employeeEntity.getId(), Arrays.asList(userVo.getUserSignatureFileId()));
	            } else {
	                StringBuilder delIds = new StringBuilder();
	                for(AttachmentVO file : attachList) {
	                    if(!file.getId().equals(userVo.getUserSignatureFileId())) {
	                        delIds.append(file.getId()).append(",");
	                    }
	                }
	                if(delIds.length() > 1) {
	                    updateResp = attachmentApi.delete(delIds.substring(0, delIds.length() -1));
	                }
	            }
	            if(null !=updateResp && !updateResp.isSuccess()) {
	                logger.error("保存/更新人员签名信息失败，更新对应人员签名文件信息失败！");
	            }
	        } else {
	            logger.error("保存/更新人员签名信息失败，查询对应人员签名文件信息失败！");
	        }
			employeeService.saveOrUpdate(employeeEntity,false);
		}
		userVo = BeanMapper.map(userEntity, UserVO.class);
		return CommonResponse.success("保存成功",userVo);
	}

	@Override
	public CommonResponse<String> modifyPwd(Map<String, Object> param) {

		String oldPwd = param.get("oldPwd").toString();
		String newPwd = param.get("newPwd").toString();
		Long userId = Long.parseLong(param.get("userId").toString());
		//校验旧密码是否正确
		UserEntity userEntity = this.getById(userId);

        PasswordEncoder encoder = new UsernameSaltPasswordEncoder(userEntity.getUserCode(), userEntity.getSalt());
        String encryptedPassword = userEntity.getPassword();
		JSONObject errorObject = new JSONObject();
		PasswordPolicyVO passwordPolicyVo = passwordPolicyService.findByTenantId(userEntity.getTenantId());
		switch (passwordPolicyVo.getPwdComplexity()) {
		case 1: //数字和字母混合
			if(!CharDigitPassVerifier.verify(newPwd)) {
				errorObject.put("validatePasswordError", "密码需要数字和字母组合");
			}
			break;
		case 2: //数字、字母和!@#$%^&*?混合
			if(!CharDigitSignPassVerifier.verify(newPwd)) {
				errorObject.put("validatePasswordError", "密码需要数字、字母和!@#$%^&*?组合");
			}
			break;
		case 3: //大写字母、小写字母、数字和!@#$%^&*?混合
			if(!UpAndLowerCharDigitSignPassVerifier.verify(newPwd)) {
				errorObject.put("validatePasswordError", "密码需要大写字母、小写字母、数字和!@#$%^&*?组合");
			}
			break;
		default:
			errorObject.put("validatePasswordError", "密码不符合规范");
			break;
		}
		if(errorObject.isEmpty()) {
	        String newEncryptedPassword = encoder.encode(newPwd);
			this.updateUserPassword(userEntity.getId(),newEncryptedPassword);

			//添加密码历史记录
            PwdHistoryVO pwdHistoryVO = new PwdHistoryVO();
            pwdHistoryVO.setUserId(userEntity.getId());
            pwdHistoryVO.setUsedPassword(encryptedPassword);
            pwdHistoryVO.setUsedPwdTime(new Date());
            pwdHistoryService.insert(pwdHistoryVO);
            
			return CommonResponse.success("修改密码成功");
		}else{
			return CommonResponse.error(errorObject.getString("validatePasswordError"));
		}
	}

	@Override
	public UserVO querySuperAdminByTenantId(Long tenantId) {
		QueryWrapper<UserTenantRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("tenant_id", tenantId);
		queryWrapper.eq("type_id", 1).eq("dr",0);
		List<UserTenantRelationEntity> entities = userTenantRelationService.list(queryWrapper);
		if(entities != null && entities.size() > 0) {
			UserVO useEntity = this.selectById(entities.get(0).getUserId());
			useEntity.setTenantId(entities.get(0).getTenantId());
			useEntity.setOrgId(entities.get(0).getOrgId());
			return BeanMapper.map(useEntity, UserVO.class);
		}
		return null;
	}

	@Override
	public void updateWxEEId(Long userId, String wxeeId) {
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("weixinee_id", wxeeId).eq("dr",0);
		List<UserEntity> users = baseMapper.selectList(queryWrapper);
		UserEntity curUser = null;

		//清空该企业微信号与其他账号的绑定关系
		if(CollectionUtils.isNotEmpty(users)) {
			for(UserEntity user : users) {
				if(!user.getId().equals(userId)) {
					user.setWeixineeId(null);
				} else {
					curUser = user;
				}
			}
		}

		if(null == curUser) {
			curUser = baseMapper.selectById(userId);
			curUser.setWeixineeId(wxeeId);
			users.add(curUser);
		}
		super.saveOrUpdateBatch(users);
	}
	
	@Override
	public void updateWeixinId(Long userId, String weixinId) {
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("weixin_id", weixinId).eq("dr",0);
		List<UserEntity> users = baseMapper.selectList(queryWrapper);
		UserEntity curUser = null;

		//清空该企业微信号与其他账号的绑定关系
		if(CollectionUtils.isNotEmpty(users)) {
			for(UserEntity user : users) {
				if(!user.getId().equals(userId)) {
					user.setWeixineeId(null);
				} else {
					curUser = user;
				}
			}
		}

		if(null == curUser) {
			curUser = baseMapper.selectById(userId);
			curUser.setWeixinId(weixinId);
			users.add(curUser);
		}
		super.saveOrUpdateBatch(users);
	}
	
	@Override
	public void updateDdId(Long userId, String ddId) {
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("dingding_id", ddId).eq("dr",0);
		List<UserEntity> users = baseMapper.selectList(queryWrapper);
		UserEntity curUser = null;

		//清空该钉钉号与其他账号的绑定关系
		if(CollectionUtils.isNotEmpty(users)) {
			for(UserEntity user : users) {
				if(!user.getId().equals(userId)) {
					user.setDingdingId(null);
				} else {
					curUser = user;
				}
			}
		}

		if(null == curUser) {
			curUser = baseMapper.selectById(userId);
			curUser.setDingdingId(ddId);
			users.add(curUser);
		}
		super.saveOrUpdateBatch(users);
	}

	@Override
	public UserVO getUserByWxIdOrMinProgramIdOrWxEEIdOrDdId(String openid,String reqFrom) {
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("dr",0).and(wrap->wrap.eq("weixin_minprogram_id", openid)
				.or()
				.eq("weixin_id", openid)
				.or()
				.eq("weixinee_id", openid)
				.or()
				.eq("dingding_id", openid));
		if("wxminApp".equals(reqFrom)){
			/** 微信小程序登录 */
			queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("weixin_minprogram_id", openid).eq("dr",0);
		}
		UserEntity userEntity = baseMapper.selectOne(queryWrapper);
		if(userEntity != null) {
			return BeanMapper.map(userEntity, UserVO.class);
		}
		return null;
	}

	@Override
	public UserVO queryUserByIdOrSourceId(String userId) {
		UserEntity userEntity = userMapper.selectById(userId);
		if(userEntity != null) {
			return BeanMapper.map(userEntity, UserVO.class);
		}else{
			QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("source_id", userId);
			userEntity = userMapper.selectOne(queryWrapper);
			if(userEntity != null) {
				return BeanMapper.map(userEntity, UserVO.class);
			}
		}
		return null;
	}

	@Override
	public UserVO queryUserBySourceId(String userId,Long tenantId) {
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("source_id", userId).eq("tenant_id",tenantId).eq("dr",0);
		UserEntity userEntity = userMapper.selectOne(queryWrapper);
		if(userEntity != null) {
			return BeanMapper.map(userEntity, UserVO.class);
		}
		return null;
	}

	/**
	 * 通过微信公众号返回的code 换取openid 再根据openid查询供方用户信息
	 * 仅供供方使用
	 *
	 * @param code
	 * @return 查到返回具体用户信息，没有返回null
	 */
	@Override
	public UserVO querySupplierUserInfoByWXCode(String code) {
		QueryWrapper<ThirdSystemEntity> thirdSystemWrapper = new QueryWrapper<>();
		thirdSystemWrapper.eq("tenant_id", "999999");
		thirdSystemWrapper.eq("code", "Weixin").eq("dr",0);
		ThirdSystemEntity thirdSystemEntity = thirdSystemService.getOne(thirdSystemWrapper);
		UserVO userVo = null;
		if(thirdSystemEntity != null) {
			String configInfo = thirdSystemEntity.getConfigInfo();
			JSONObject configJson = JSON.parseObject(configInfo);
			String appid = configJson.getString("appid");
			String secret = configJson.getString("secret");
			String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid="+appid+"&secret="+secret+"&code="+code+"&grant_type=authorization_code";
			String userInfoResult = null;
			try {
				Map<String,String> param = new HashMap<>();
				userInfoResult = ReferHttpClientUtils.get(url, param, new HashMap<>());
			} catch (GeneralSecurityException | IOException e) {
				e.printStackTrace();
			}
			logger.info("userInfoResult === "+userInfoResult);
			if(StringUtils.isNotBlank(userInfoResult)) {
				JSONObject userInfoJson = JSON.parseObject(userInfoResult);
				String weixinOpenid = userInfoJson.getString("openid");
				/** 供方默认*/
				userVo = getUserByWxIdOrMinProgramIdOrWxEEIdOrDdId(weixinOpenid,null);
			}
		}
		return userVo;
	}

	@Override
	public UserVO queryUserByUserCode(String userCode) {
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("user_code", userCode).eq("dr",0);
		UserEntity userEntity = userMapper.selectOne(queryWrapper);
		if(userEntity != null) {
			UserVO userVO = BeanMapper.map(userEntity, UserVO.class);
			UserTenantRelationEntity relation = userTenantRelationService.getOne(userEntity.getId(), null);
			if(relation!=null){
				userVO.setTenantId(relation.getTenantId());
				userVO.setOrgId(relation.getOrgId());
				userVO.setDeptId(relation.getDeptId());
				userVO.setPostId(relation.getPostId());
			}
			return userVO;
		}
		return null;
	}


	@Override
	public List<UserVO> queryUserByUserCodes(String[] userCodes) {
		List<UserVO> resp = new ArrayList<>();
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.in("user_code", userCodes).eq("dr",0);
		List<UserEntity> users = userMapper.selectList(queryWrapper);
		if(CollectionUtils.isNotEmpty(users)) {
			resp = BeanMapper.mapList(users, UserVO.class);
		}
		return resp;
	}

	@Override
	public void refreshReferUserCache() {
		List<UserEntity> userEntities = userMapper.queryAllUsers();
		if(userEntities != null && userEntities.size() > 0) {
			for(UserEntity entity:userEntities) {
				String cacheKey = REFER_CACHE_KEY + "idm-employee:" + entity.getUserCode();
				
				JSONObject jsonObject = new JSONObject();
				jsonObject.put("id", entity.getId());
				jsonObject.put("userCode", entity.getUserCode());
				jsonObject.put("userName", entity.getUserName());
				jsonObject.put("userMobile", entity.getUserMobile());
				redisTemplate.opsForValue().set(cacheKey, jsonObject.toString());
			}
		}
	}

	@Override
	public void updateTenantIdAndUserType(Integer userType, Long userId, long tenantId,
			Long orgId, Long deptId, Long postId) {
		userMapper.updateTenantIdAndUserType(userType, userId, tenantId, orgId);
		
		employeeMapper.updateTenantId(userId, tenantId, orgId, deptId, postId);
	}

	@Override
	public UserVO findByUserMobile(String phone) {
		UserVO resp = null;
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("user_mobile", phone).eq("dr",0);
		queryWrapper.last("limit 1");

		UserEntity userEntity = super.getOne(queryWrapper);
		if(null != userEntity) {
			resp = BeanMapper.map(userEntity, UserVO.class);
		}

		return resp;
	}

	/**
	 * 给指定手机号发送验证码或者短信
	 *
	 * @param phone         手机号
	 * @param templateCode  短信模板编码
	 * @param signName      短信签名
	 * @return
	 */
	@Override
	public void sendMsg(String phone, String templateCode, String signName) {
		JSONObject messageParam = new JSONObject();
		messageParam.put("phone", phone);
		if(StringUtils.isBlank(templateCode)) {
			messageParam.put("templateCode", "SMS_464980197"); //登录验证模板
		}else{
			messageParam.put("templateCode", templateCode);
		}
		if(StringUtils.isNotBlank(signName)) {
			messageParam.put("signName", signName);
		}
		String messageUrl = environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
		try {
			String responseStr = HttpTookit.postByJson(messageUrl, JSON.toJSONString(messageParam));
			logger.info("向手机号[{}]发送验证码结果：[{}]", phone, responseStr);

			CommonResponse<String> response = JSON.parseObject(responseStr, CommonResponse.class);
			if(response.isSuccess()) {
				return;
			}
		} catch (ConnectTimeoutException e) {
			e.printStackTrace();
		} catch (SocketTimeoutException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		throw new BusinessException("短信发送失败");
	}

	/**
	 * 根据传入的sourceIds查询符合条件的sourceIds
	 * @param users     传入的用户sourceIds
	 * @param tenantId  租户id
	 * @param type      条件（disabled：租户内已停用的用户，exitOther：不存在当前租户但在系统中的用户id，
	 *                     toDisabled：该租户内要停用的用户id(在本租户内启用的用户), exit: 获取存在当前系统的中的用户id）
	 * @return 符合条件的sourceIds
	 */
	@Override
	public List<String> selectSourceIds(List<String> users, Long tenantId, String type) {
		return userMapper.selectSourceIds(users, tenantId, type);
	}

	/**
	 * 初始化 用户 信息-----钉钉或企业微信第三方应用 初始化信息调用
	 *
	 * @param thirdUserId
	 * @param name
	 * @param mobile
	 * @param tenantId
	 */
	@Override
	@Transactional
	public void initThirdAppUsers(String thirdUserId, String name, String mobile,String openUserId, Long tenantId,String roleCode) {

		UserVO userVO = queryUserBySourceId(thirdUserId,tenantId);
		if(userVO == null){
			userVO = new UserVO();
			userVO.setUserCode(openUserId);
			userVO.setId(IdWorker.getId());
			userVO.setUserName(name);
			userVO.setSourceId(thirdUserId);
			userVO.setUserMobile(mobile);
			userVO.setTenantId(tenantId);
			DefaultPwdEntity defaultPwdEntity = iDefaultpwdService.getUserDefaultPassword(tenantId);
			PasswordUtils.setSalt(userVO);
			String password = defaultPwdEntity.getDefaultpwd();
			String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
			userVO.setPassword(shaPassword);
			userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
			userVO.setPwdStartTime(new Date());
			userVO.setEmployeeId(userVO.getId());


			userVO.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态
			userVO.setTypeId(2); //普通员工
			userVO.setDr(BaseVO.DR_UNDELETE);
			OrgVO orgVO = orgService.findOrgByTenantId(tenantId);
			userVO.setOrgId(orgVO.getId());

			//2、生成租户与用户之间的关系
			UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
			userTenantRelationEntity.setMainSpaceFlag(1);
			userTenantRelationEntity.setUserId(userVO.getId());
			userTenantRelationEntity.setTenantId(tenantId);
			userTenantRelationEntity.setTypeId(2);//普通员工
			userTenantRelationEntity.setEmployeeId(userVO.getId());
			userTenantRelationEntity.setOrgId(orgVO.getId());
			userTenantRelationEntity.setState(1);
			UserEntity userEntity = BeanMapper.map(userVO, UserEntity.class);

			//3、创建人员
			EmployeeVO employeeVO = new EmployeeVO();
			employeeVO.setId(userVO.getId());
			employeeVO.setUserId(userVO.getId());
			employeeVO.setName(userVO.getUserName());
			employeeVO.setCode(openUserId);
			employeeVO.setEmployeeType(1);
			employeeVO.setState(0);
			employeeVO.setSex(1);
			if(net.logstash.logback.encoder.org.apache.commons.lang.StringUtils.isBlank(userEntity.getUserMobile())){
				employeeVO.setMobilePhone(userEntity.getSourceId());
			}else {
				employeeVO.setMobilePhone(userEntity.getUserMobile());
			}
			employeeVO.setOrgName(orgVO.getName());
			employeeVO.setOrgId(orgVO.getId());
			employeeVO.setTenantId(tenantId);

			userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
			employeeService.save(employeeVO, userEntity);
			saveOrUpdate(userEntity);
			addUserApp(userVO.getId(), tenantId, orgVO.getId(), 2,roleCode);
		}else {
			userVO.setUserCode(openUserId);
			userVO.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态

			updateThirdAppUsers(userVO,UserVO.USER_STATE_ACTIVE);
		}
	}
	@Override
	@Transactional
	public void addUserApp(Long userId, Long tenantId, Long orgId, Integer typeId,String roleCode){
		try{
			InvocationInfoProxy.setTenantid(tenantId);
			List<UserManagerRelationAppEntity> userManagerRelationAppList = new ArrayList<>();
			//角色授权
			if(typeId == 3){
				//管理员授权
				//1、获取套餐内的运营应用
				//获取当前套餐的角色(平台运营组织的角色)
				Map<String, Object> params = new HashMap<>();
				params.put("tenant_id", tenantId);
				params.put("classify", "oms");
				List<AppVO> list = appService.queryList(params);
				//建立用户与应用之间的关系
				for(AppVO vo : list){
					UserManagerRelationAppEntity userManagerRelationAppEntity = new UserManagerRelationAppEntity();
					userManagerRelationAppEntity.setTenantId(tenantId);
					userManagerRelationAppEntity.setUserId(userId);
					userManagerRelationAppEntity.setAppId(vo.getId());
					userManagerRelationAppList.add(userManagerRelationAppEntity);
				}
			}

			if(userManagerRelationAppList!=null && userManagerRelationAppList.size()>0){
				userManagerRelationAppService.saveOrUpdateBatch(userManagerRelationAppList, userManagerRelationAppList.size(), false);
			}

			//普通用户授权
			JobEntity jobEntity = jobService.getCurMainJob(userId);
			//获取角色id
			QueryWrapper<RoleEntity> roleWrapper = new QueryWrapper<>();
			roleWrapper.eq("dr", 0);
			roleWrapper.eq("tenant_id", 999999l);
			roleWrapper.eq("code", roleCode);
			RoleEntity roleOms = roleService.getOne(roleWrapper);
			QueryWrapper<RoleEntity> roleSourceWrapper = new QueryWrapper<>();
			roleSourceWrapper.eq("dr", 0);
			roleSourceWrapper.eq("tenant_id", tenantId);
			roleSourceWrapper.eq("source_id", roleOms.getId());
			RoleEntity roleSourceOms = roleService.getOne(roleSourceWrapper);
			List<RoleUserRelationVO> roleUserRelationList = new ArrayList<>();
			RoleUserRelationVO vo = new RoleUserRelationVO();
			vo.setAuthOrgId(orgId);
			vo.setUserId(userId);
			vo.setRoleId(roleSourceOms.getId());
			vo.setJobId(jobEntity.getId());
			vo.setEmployeeId(userId);
			roleUserRelationList.add(vo);
			roleUserRelationService.saveRoleUser(roleUserRelationList);
		}catch (Exception e){
			logger.info("用户应用授权-------{}", e);
		}
	}

	/**
	 * 更新 用户 信息-----钉钉或企业微信 云市场 初始化信息调用
	 *
	 * @param userVo
	 * @param state  状态标识 (1:启用，0：停用)
	 */
	@Override
	@Transactional
	public void updateThirdAppUsers(UserVO userVo, Integer state) {
		UserEntity userEntity = BeanMapper.map(userVo, UserEntity.class);
		EmployeeVO employeeEntity = employeeService.queryEmployeeByUserId(userEntity.getId());
		if(employeeEntity!=null){
			QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
			wrapper.eq("user_id", userVo.getId());
			wrapper.eq("tenant_id", userVo.getTenantId());
			wrapper.eq("dr", 0);

			List<UserTenantRelationEntity> oldList = userTenantRelationService.list(wrapper);
			UserTenantRelationEntity relationEntity = oldList.get(0);
			if(relationEntity.getTypeId()!=1){/** 非超管 更改状态 */
				relationEntity.setState(state);
				userEntity.setUserState(state);
				employeeEntity.setState(state);
			}
			employeeEntity.setMobilePhone(userVo.getUserMobile());
			employeeEntity.setName(userEntity.getUserName());

			saveOrUpdate(userEntity);
			userTenantRelationService.saveOrUpdate(relationEntity,false);
			employeeService.saveOrUpdate(BeanMapper.map(employeeEntity,EmployeeEntity.class),false);
		}
	}

	@Override
	public List<UserVO> queryMangerUserList(QueryParam param) {
		Map<String,Object> map = new HashMap<>();
		map.put("searchText",param.getSearchText());
		map.put("tenantId",InvocationInfoProxy.getTenantid());
		/** 本下查询 */
		List<OrgVO> orgVOS = orgService.queryAppSubByPid(InvocationInfoProxy.getOrgId());
		map.put("orgIds", Strings.join(orgVOS.stream().map(vo->vo.getId().toString()).collect(Collectors.toList()), ","));
		return userMapper.queryMangerUserList(map);
	}

	@Override
	public Boolean queryUserHasAppPermission(Long appIdToCheck) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		Long userId = InvocationInfoProxy.getUserid();
		// 查询当前登录人是否是管理员或者超级管理员
		UserVO userVo = selectById(userId);
		// 查出该用户的所有角色
		List<Long> userRoleIds = permissionCacheManage.getUserRoleCache(userId,tenantId);
		if (userRoleIds == null || userRoleIds.size() == 0) {
			userRoleIds = roleService.queryRoleIdstByCurrentUserId(userId, tenantId, null);
		}
		// 根据角色list查出其所有权限
		Map<Long, Long> appIdMap = new HashMap<>();
		if (userRoleIds != null && userRoleIds.size() > 0) {
			List<Long> appIds = null;
			for (Long roleId : userRoleIds) {
				appIds = permissionCacheManage.getRoleAppsCache(roleId);
				if (appIds != null && appIds.size() > 0) {
					for (Long appId : appIds) {
						appIdMap.put(appId, appId);
					}
				}
			}
		}
		// 判断是否为管理员
		List<Long> omAppIds = null;
		if (1 == userVo.getTypeId()) { // 超级管理员，则查出所有的运营类角色
			if (OMS_TENANT.equals(tenantId.toString())) {
				omAppIds = appService.queryAllOperateList();
			} else {
				//查出所有套餐购买(没有停用/到期)的应用权限
				omAppIds = appService.queryAllHasAuthOmsOprateList();
			}
		} else { // 普通管理员，则查出具有权限的运营类角色
			if (OMS_TENANT.equals(tenantId.toString())) {
				omAppIds = appService.queryAuthOperateList();
			} else {
				omAppIds = appService.queryAuthOperateOmsList();
			}
		}
		if (omAppIds != null) {
			for (Long omAppId : omAppIds) {
				if (!appIdMap.containsKey(omAppId)) {
					appIdMap.put(omAppId, omAppId);
				}
			}
		}
		return appIdMap.get(appIdToCheck) != null;
	}

	@Override
	public UserVO dealAndDealUserBySourceId(String sourceId, Long tenantId) {
		QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("source_id", sourceId).eq("dr",0);
		UserEntity userEntity = userMapper.selectOne(queryWrapper);
		if(userEntity != null) {
			if(!tenantId.equals(userEntity.getTenantId())){
				//当前租户空间不是主空间，手动切换
				QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
				wrapper.eq("user_id", userEntity.getId());
				wrapper.eq("tenant_id", tenantId);
				wrapper.eq("dr", 0);
				UserTenantRelationEntity userTenant = userTenantRelationService.getOne(wrapper);
				//修改当前用户和人员的租户ID 、用户类型、组织、部门、岗位
				this.updateTenantIdAndUserType(userTenant.getTypeId(), userEntity.getId(), tenantId, userTenant.getOrgId(),
						userTenant.getDeptId(),userTenant.getPostId());
				userTenantRelationService.updateUserMainSpace(userEntity.getId(), tenantId.toString());
				userEntity = this.getById(userEntity.getId());
			}
			return BeanMapper.map(userEntity, UserVO.class);
		}
		return null;
	}

	@Override
	public List<JSONObject> queryUserInfosForZds(Map<String, String> param) {
		return userMapper.queryUserInfosForZds(param);
	}
}
