package com.ejianc.foundation.workbench.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.foundation.permission.bean.AppEntity;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.cache.AppCacheManage;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.tenant.mapper.TenantMenuMapper;
import com.ejianc.foundation.tenant.service.impl.TenantMenuServiceImpl;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.MenuAsTree;
import com.ejianc.foundation.workbench.bean.MenuEntity;
import com.ejianc.foundation.workbench.mapper.MenuMapper;
import com.ejianc.foundation.workbench.service.IMenuService;
import com.ejianc.foundation.workbench.vo.MenuItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class MenuServiceImpl extends BaseServiceImpl<MenuMapper, MenuEntity> implements IMenuService {

	@Value("${oms.tenantid}")
	private String OMS_TENANT;
	private final static Logger LOGGER = LoggerFactory.getLogger(TenantMenuServiceImpl.class);

	@Autowired
	private PermissionCacheManage permissionCacheManage;
	@Autowired
	private IUserService userService;
	@Autowired
	private IRoleService roleService;
	@Autowired
	private IAppService appService;
	@Autowired
	private AppCacheManage appCacheManage;
    @Autowired
	private TenantMenuMapper tenantMenuMapper;
    @Autowired
    private EnvironmentTools environmentTools;
	@Autowired
	private CacheManager cacheManager;
    
	@Override
	public MenuEntity getOneById(Long id) {
		return baseMapper.selectById(id);
	}

	@Override
	public List<MenuItemVO> queryMenuItemListByTenantId(Long tenantId) {
		List<MenuItemVO> entities = tenantMenuMapper.queryMenuAll(tenantId,null,null);
		List<MenuItemVO> menuItemVos = new ArrayList<>();
		if (entities != null && entities.size() > 0) {
			for(MenuItemVO entity:entities) {
				MenuItemVO menuItemVo = BeanMapper.map(entity, MenuItemVO.class);
				if(StringUtils.isNotBlank(menuItemVo.getIcon())) {
					menuItemVo.setIcon("icon-"+menuItemVo.getIcon().split(":")[1]);
				}
				menuItemVos.add(menuItemVo);
			}
			return menuItemVos;
		}
		return null;
	}

	/**
	 * pc菜单展示服务
	 */
	@Override
	public List<MenuItemVO> queryMenuListByCurrentUser() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		Long userId = InvocationInfoProxy.getUserid();
		// 查询当前登录人是否是管理员或者超级管理员
		UserVO userVo = userService.selectById(userId);
		// 查出该用户的所有角色
		List<Long> userRoleIds = permissionCacheManage.getUserRoleCache(userId,tenantId);
		if (userRoleIds == null || userRoleIds.size() == 0) {
			userRoleIds = roleService.queryRoleIdstByCurrentUserId(userId, tenantId, null);
		}
		// 根据角色list查出其所有权限
		Map<Long, Long> appIdMap = new HashMap<>();
		List<Long> appList = new ArrayList<Long>();
		if (userRoleIds != null && userRoleIds.size() > 0) {
			List<Long> appIds = null;
			for (Long roleId : userRoleIds) {
				appIds = permissionCacheManage.getRoleAppsCache(roleId);
				if (appIds != null && appIds.size() > 0) {
					for (Long appId : appIds) {
						appIdMap.put(appId, appId);

						appList.add(appId);
					}
				}
			}
		}
		// 判断是否为管理员
		List<Long> omAppIds = null;
		if (1 == userVo.getTypeId()) { // 超级管理员，则查出所有的运营类角色
			if (OMS_TENANT.equals(tenantId.toString())) {
				omAppIds = appService.queryAllOperateList();
			} else {
				//查出所有套餐购买(没有停用/到期)的应用权限
				omAppIds = appService.queryAllHasAuthOmsOprateList();
			}
		} else { // 普通管理员，则查出具有权限的运营类角色
			if (OMS_TENANT.equals(tenantId.toString())) {
				omAppIds = appService.queryAuthOperateList();
			} else {
				omAppIds = appService.queryAuthOperateOmsList();
			}
		}
		if (omAppIds != null) {
			for (Long omAppId : omAppIds) {
				if (!appIdMap.containsKey(omAppId)) {
					appIdMap.put(omAppId, omAppId);
					appList.add(omAppId);
				}
			}
		}

		// 查询该应用对应的菜单
		Map<Long, MenuItemVO> allMenuMap = new HashMap<>();
		List<MenuItemVO> childrens = new ArrayList<>();
		List<MenuItemVO> menuItemList = queryMenuItemListByTenantId(tenantId);
		if (menuItemList != null && menuItemList.size() > 0) {
			for (MenuItemVO menuItemVo : menuItemList) {
				if(menuItemVo.getMobile()!=1){//pc
					allMenuMap.put(menuItemVo.getId(), menuItemVo);
					if (appIdMap.containsKey(menuItemVo.getAppId())) {
						childrens.add(menuItemVo);
					}
				}
			}
		}
		Map<String, String> resultVOMap = new HashMap<>();
		for(MenuItemVO menuItemVo:childrens) {
			String[] innerCodeArr = menuItemVo.getInnerCode().split("\\|");
			for(int i=0;i<innerCodeArr.length;i++) {
				if(!resultVOMap.containsKey(innerCodeArr[i])) {
					resultVOMap.put(innerCodeArr[i], innerCodeArr[i]);
				}
			}
		}
		List<MenuItemVO> resultVOList = new ArrayList<>();
		for(MenuItemVO menuItemVo:menuItemList) {
			if(menuItemVo.getMobile()!=1 && resultVOMap.containsKey(menuItemVo.getId().toString())) {//pc
				if(menuItemVo.getAppId() != null) {
					AppVO appVo = appCacheManage.getAppsCache(menuItemVo.getTenantId(), menuItemVo.getAppId());
					if(appVo != null) {
						menuItemVo.setAppPath(appVo.getPcUrl());
						menuItemVo.setOpenMode(appVo.getOpenMode());
						if(StringUtils.isNotEmpty(appVo.getAppAddPath())){
							menuItemVo.setAppAddPath(JSONObject.parseArray(appVo.getAppAddPath()));
						}

						String appIconSrc = appVo.getAppIconSrc();
						if(StringUtils.isNotBlank(appIconSrc)) {
							if(appIconSrc.indexOf("http") == -1) {
								appIconSrc = environmentTools.getBaseHost() + appIconSrc;
								appVo.setAppIconSrc(appIconSrc);
							}
						}
						menuItemVo.setIcon(appVo.getAppIconSrc());
					}
				}
				resultVOList.add(menuItemVo);
			}
		}
		resultVOMap.clear();
		return MenuAsTree.createTreeData(resultVOList);
	}

	/**
	 * 移动菜单展示服务
	 */
	@Override
	public List<MenuItemVO> queryMobileMenuListByCurrentUser(String searchText) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		Long userId = InvocationInfoProxy.getUserid();
		return queryMobileMenuListByUser(searchText,userId,tenantId);
	}

	/**
	 * 查询当前用户的移动菜单列表
	 *
	 * @param searchText
	 * @param userId
	 * @param tenantId
	 * @return
	 */
	@Override
	public List<MenuItemVO> queryMobileMenuListByUser(String searchText, Long userId, Long tenantId) {
		// 查询当前登录人是否是管理员或者超级管理员
		UserVO userVo = userService.selectById(userId);
		// 查出该用户的所有角色
		List<Long> userRoleIds = permissionCacheManage.getUserRoleCache(userId,tenantId);
		if (userRoleIds == null || userRoleIds.size() == 0) {
			userRoleIds = roleService.queryRoleIdstByCurrentUserId(userId, tenantId, null);
		}
		// 根据角色list查出其所有权限
		Map<Long, Long> appIdMap = new HashMap<>();
		List<Long> appList = new ArrayList<Long>();
		if (userRoleIds != null && userRoleIds.size() > 0) {
			List<Long> appIds = null;
			for (Long roleId : userRoleIds) {
				appIds = permissionCacheManage.getRoleAppsCache(roleId);
				if (appIds != null && appIds.size() > 0) {
					for (Long appId : appIds) {
						appIdMap.put(appId, appId);
						appList.add(appId);
					}
				}
			}
		}
		// 判断是否为管理员
		List<Long> omAppIds = null;
		if (1 == userVo.getTypeId()) { // 超级管理员，则查出所有的运营类角色
			if (OMS_TENANT.equals(tenantId.toString())) {
				omAppIds = appService.queryAllOperateList();
			} else {
				//查出所有套餐购买(没有停用/到期)的应用权限
				omAppIds = appService.queryAllHasAuthOmsOprateList();
			}
		} else { // 普通管理员，则查出具有权限的运营类角色, 包括供方
			if (OMS_TENANT.equals(tenantId.toString())) {
				omAppIds = appService.queryAuthOperateList();
			} else {
				omAppIds = appService.queryAuthOperateOmsList();
			}
		}
		if (omAppIds != null) {
			for (Long omAppId : omAppIds) {
				if (!appIdMap.containsKey(omAppId)) {
					appIdMap.put(omAppId, omAppId);
					appList.add(omAppId);
				}
			}
		}

		// 查询该应用对应的菜单
		Map<Long, MenuItemVO> allMenuMap = new HashMap<>();
		List<MenuItemVO> childrens = new ArrayList<>();
		List<MenuItemVO> menuItemList = queryMenuItemListByTenantId(tenantId);
		if (menuItemList != null && menuItemList.size() > 0) {
			for (MenuItemVO menuItemVo : menuItemList) {
				if(menuItemVo.getMobile()==1){//移动
					allMenuMap.put(menuItemVo.getId(), menuItemVo);
					if (appIdMap.containsKey(menuItemVo.getAppId())) {
						childrens.add(menuItemVo);
					}
				}
			}
		}
		Map<String, String> resultVOMap = new HashMap<>();
		for(MenuItemVO menuItemVo:childrens) {
			String[] innerCodeArr = menuItemVo.getInnerCode().split("\\|");
			for(int i=0;i<innerCodeArr.length;i++) {
				if(!resultVOMap.containsKey(innerCodeArr[i])) {
					resultVOMap.put(innerCodeArr[i], innerCodeArr[i]);
				}
			}
		}
		List<MenuItemVO> resultVOList = new ArrayList<>();

		if (ListUtil.isNotEmpty(menuItemList)) {
			for(MenuItemVO menuItemVo:menuItemList) {
				if(menuItemVo.getMobile()==1 && resultVOMap.containsKey(menuItemVo.getId().toString())) {//移动
					if(menuItemVo.getAppId() != null) {
						AppVO appVo = appCacheManage.getAppsCache(menuItemVo.getTenantId(), menuItemVo.getAppId());
						if(appVo != null) {
							menuItemVo.setAppPath(appVo.getMobileUrl());
							String appIconSrc = appVo.getAppIconSrc();
							if(StringUtils.isNotBlank(appIconSrc)) {
								if(!appIconSrc.contains("http")) {
									appIconSrc = environmentTools.getBaseHost() + appIconSrc;
									appVo.setAppIconSrc(appIconSrc);
								}
							}
							menuItemVo.setIcon(appVo.getAppIconSrc());
						}
					}
					if(StringUtils.isNotEmpty(searchText)){
						if(menuItemVo.getName().contains(searchText)){
							resultVOList.add(menuItemVo);
						}
					}else {
						resultVOList.add(menuItemVo);
					}
				}
			}
		}
		resultVOMap.clear();
		if(StringUtils.isEmpty(searchText)){
			return MenuAsTree.createTreeData(resultVOList);
		}
		List<MenuItemVO> resVOS = new ArrayList<>();
		Map<String, String> searchVOMap = new HashMap<>();
		if(ListUtil.isNotEmpty(resultVOList)){
			for (MenuItemVO menuItemVO : resultVOList) {
				if(!searchVOMap.containsKey(menuItemVO.getId()+"")) {
					resVOS.add(menuItemVO);
					searchVOMap.put(menuItemVO.getId()+"",menuItemVO.getId()+"");
				}
				String[] innerCodeArr = menuItemVO.getInnerCode().split("\\|");
				for(int i=0;i<innerCodeArr.length;i++) {
					if(!searchVOMap.containsKey(innerCodeArr[i])) {
						resVOS.add(allMenuMap.get(Long.parseLong(innerCodeArr[i])));
						searchVOMap.put(innerCodeArr[i],innerCodeArr[i]);
					}
				}
			}
		}
		resVOS = MenuAsTree.createTreeData(resVOS);
		if(ListUtil.isNotEmpty(resVOS)){
			resVOS.removeIf(resVO -> ListUtil.isEmpty(resVO.getChildren()));
		}
		return resVOS;
	}

	/**
	 * 查询当前用户的菜单列表 pc
	 *
	 * @param searchText
	 * @return
	 */
	@Override
	public List<JSONObject> search(String searchText) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		Long userId = InvocationInfoProxy.getUserid();
		// 查询当前登录人是否是管理员或者超级管理员
		UserVO userVo = userService.selectById(userId);
		// 查出该用户的所有角色
		List<Long> userRoleIds = permissionCacheManage.getUserRoleCache(userId,tenantId);
		if (userRoleIds == null || userRoleIds.size() == 0) {
			userRoleIds = roleService.queryRoleIdstByCurrentUserId(userId, tenantId, null);
		}
		// 根据角色list查出其所有权限
		Map<Long, Long> appIdMap = new HashMap<>();
		if (userRoleIds != null && userRoleIds.size() > 0) {
			List<Long> appIds = null;
			for (Long roleId : userRoleIds) {
				appIds = permissionCacheManage.getRoleAppsCache(roleId);
				if (appIds != null && appIds.size() > 0) {
					for (Long appId : appIds) {
						appIdMap.put(appId, appId);
					}
				}
			}
		}
		// 判断是否为管理员
		List<Long> omAppIds = null;
		if (1 == userVo.getTypeId()) { // 超级管理员，则查出所有的运营类角色
			if (OMS_TENANT.equals(tenantId.toString())) {
				omAppIds = appService.queryAllOperateList();
			} else {
				//查出所有套餐购买(没有停用/到期)的应用权限
				omAppIds = appService.queryAllHasAuthOmsOprateList();
			}
		} else { // 普通管理员，则查出具有权限的运营类角色
			if (OMS_TENANT.equals(tenantId.toString())) {
				omAppIds = appService.queryAuthOperateList();
			} else {
				omAppIds = appService.queryAuthOperateOmsList();
			}
		}
		
		if (omAppIds != null) {
			for (Long omAppId : omAppIds) {
				if (!appIdMap.containsKey(omAppId)) {
					appIdMap.put(omAppId, omAppId);
				}
			}
		}
		
		List<MenuItemVO> menuItemVos = null;
		if(OMS_TENANT.equals(tenantId + "")) {
			menuItemVos = tenantMenuMapper.queryMenuAll(tenantId, null, searchText);
		}else{
			menuItemVos = tenantMenuMapper.queryTenantProperties(tenantId, searchText, null);
		}
		List<JSONObject> res = new ArrayList<>();
		if(ListUtil.isNotEmpty(menuItemVos)){
			int count = 1;
			for (MenuItemVO menuItemVo : menuItemVos) {
				if(appIdMap.containsKey(menuItemVo.getAppId())) {
					AppVO appVo = appCacheManage.getAppsCache(menuItemVo.getTenantId(), menuItemVo.getAppId());
					if(appVo != null) {
						menuItemVo.setAppPath(appVo.getPcUrl());
						menuItemVo.setOpenMode(appVo.getOpenMode());
						String appIconSrc = appVo.getAppIconSrc();
						if(StringUtils.isNotBlank(appIconSrc)) {
							if(appIconSrc.indexOf("http") == -1) {
								appIconSrc = environmentTools.getBaseHost() + appIconSrc;
								appVo.setAppIconSrc(appIconSrc);
							}
							menuItemVo.setIcon(appVo.getAppIconSrc());
						}
						if(appVo.getAppIconSrc()==null){
							menuItemVo.setIcon("/portal/themes/default/images/default-appicon.png");
						}
					}
					JSONObject en = JSONObject.parseObject(JSONObject.toJSONString(menuItemVo));
					en.put("showNameHtml",menuItemVo.getName().replace(searchText,"<span style='color:#F41A22;'>"+searchText+"</span>"));
					String[] pids = menuItemVo.getInnerCode().split("\\|");
					StringBuilder pathAllName = new StringBuilder();
					for (int i = 0; i < pids.length; i++) {
						MenuEntity parent = baseMapper.selectById(pids[i]);
						if(parent!=null){
							pathAllName.append(parent.getName());
						}
						if(i<pids.length-1){
							pathAllName.append(">");
						}
					}
					en.put("pathAllName",pathAllName);
					if(count<7){
						res.add(en);
						count++;
					}
				}
			}
		}
		return res;
	}

	@Override
	public CommonResponse<AppVO> getJumpAppInfoToOpen(String appKey) {
		String appCode = cacheManager.get(appKey);
		if(StringUtils.isEmpty(appKey)){
			return CommonResponse.success("应用已打开过，或者不存在！");
		}
		cacheManager.removeCache(appKey);
		QueryParam param = new QueryParam();
		param.getParams().put("code", Parameter.getEqInstance(appCode));
		List<AppEntity> entities =  appService.queryList(param);
		if(ListUtil.isEmpty(entities)){
			return CommonResponse.error("应用不存在！");
		}
		AppEntity appEntity = entities.get(0);
		boolean hasAuth = false;//当前用户是否有该应用权限
		Long tenantId = InvocationInfoProxy.getTenantid();
		Long userId = InvocationInfoProxy.getUserid();
		// 查询当前登录人是否是管理员或者超级管理员
		UserVO userVo = userService.selectById(userId);
		// 查出该用户的所有角色
		List<Long> userRoleIds = permissionCacheManage.getUserRoleCache(userId,tenantId);
		if (userRoleIds == null || userRoleIds.size() == 0) {
			userRoleIds = roleService.queryRoleIdstByCurrentUserId(userId, tenantId, null);
		}
		// 根据角色list查出其所有权限
		if (userRoleIds != null && userRoleIds.size() > 0) {
			List<Long> appIds = null;
			for (Long roleId : userRoleIds) {
				appIds = permissionCacheManage.getRoleAppsCache(roleId);
				if (appIds != null && appIds.size() > 0) {
					for (Long appId : appIds) {
						if(appId.equals(appEntity.getId())){
							hasAuth = true;
							break;
						}
					}
				}
			}
		}
		if(hasAuth){
			return CommonResponse.success(BeanMapper.map(appEntity,AppVO.class));
		}
		// 判断是否为管理员
		List<Long> omAppIds = null;
		if (1 == userVo.getTypeId()) { // 超级管理员，则查出所有的运营类角色
			if (OMS_TENANT.equals(tenantId.toString())) {
				omAppIds = appService.queryAllOperateList();
			} else {
				//查出所有套餐购买(没有停用/到期)的应用权限
				omAppIds = appService.queryAllHasAuthOmsOprateList();
			}
		} else { // 普通管理员，则查出具有权限的运营类角色
			if (OMS_TENANT.equals(tenantId.toString())) {
				omAppIds = appService.queryAuthOperateList();
			} else {
				omAppIds = appService.queryAuthOperateOmsList();
			}
		}

		if (omAppIds != null) {
			for (Long omAppId : omAppIds) {
				if(omAppId.equals(appEntity.getId())){
					hasAuth = true;
					break;
				}
			}
		}
		if(hasAuth){
			return CommonResponse.success(BeanMapper.map(appEntity,AppVO.class));
		}
		return CommonResponse.error("您没有该应用权限！");
	}
}
