/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cache;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.permission.bean.ButtonEntity;
import com.ejianc.foundation.permission.service.IButtonService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.ButtonVO;
import com.ejianc.foundation.permission.vo.RolePostRelationVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.cache.serializer.Serializer;
import com.ejianc.framework.cache.serializer.impl.DefaultJDKSerializer;
import com.ejianc.framework.core.kit.collection.ListUtil;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

@Component
public class PermissionCacheManage {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final String CURRENTUSER_ROLE_KEY = "currentuser_role_key:";
    private static final String CURRENTROLE_APP_KEY = "currentrole_app_key:";
    private static final String CURRENTROLE_USER_KEY = "currentrole_user_key:";
    private static final String CURRENTROLE_APP_BUTTON_KEY = "currentrole_app_button_key:";
    private static final String CURRENTROLE_POST_KEY = "currentrole_post_key:";
    private Serializer serializer = new DefaultJDKSerializer();
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IButtonService buttonService;

    public void putUserRoleCache(Long userId, Long tenantId, List<Long> roleIdList) {
        String key = CURRENTUSER_ROLE_KEY + userId + "-" + tenantId;
        this.cacheManager.removeCache(key);
        if (roleIdList != null && roleIdList.size() > 0) {
            this.cacheManager.piplineExecute(pipeline -> {
                pipeline.multi();
                for (Long roleId : roleIdList) {
                    byte[] keyBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
                    byte[] fieldBytes = roleId.toString().getBytes(Charset.forName(DEFAULT_CHARSET));
                    pipeline.sadd(keyBytes, (byte[][])new byte[][]{fieldBytes});
                }
                pipeline.exec();
            });
        }
    }

    public List<Long> getUserRoleCache(Long userId, Long tenantId) {
        ArrayList<Long> resultList = new ArrayList<Long>();
        final String key = CURRENTUSER_ROLE_KEY + userId + "-" + tenantId;
        Set roleIds = (Set)this.cacheManager.execute((CacheManager.JedisAction)new CacheManager.JedisAction<Set<String>>(){

            public Set<String> action(Jedis jedis) {
                return jedis.smembers(key);
            }
        });
        if (roleIds != null && !roleIds.isEmpty()) {
            for (String roleId : roleIds) {
                resultList.add(Long.parseLong(roleId));
            }
        }
        return resultList;
    }

    public void putRoleAppsCache(Long roleId, List<AppVO> appVos) {
        if (appVos != null && appVos.size() > 0) {
            this.cacheManager.piplineExecute(pipeline -> {
                pipeline.multi();
                String key = CURRENTROLE_APP_KEY + roleId;
                String keyButton = CURRENTROLE_APP_BUTTON_KEY + roleId;
                for (AppVO appVo : appVos) {
                    byte[] keyBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
                    byte[] fieldBytes = appVo.getId().toString().getBytes(Charset.forName(DEFAULT_CHARSET));
                    byte[] contentBytes = this.serializer.marshalToByte((Serializable)((Object)appVo.getId().toString()));
                    pipeline.hset(keyBytes, fieldBytes, contentBytes);
                    if (!ListUtil.isNotEmpty((List)appVo.getChildren())) continue;
                    for (ButtonVO btn : appVo.getChildren()) {
                        ButtonEntity buttonEntity = (ButtonEntity)((Object)((Object)this.buttonService.selectById(btn.getId())));
                        keyBytes = keyButton.getBytes(Charset.forName(DEFAULT_CHARSET));
                        fieldBytes = (buttonEntity.getPageCode() + buttonEntity.getCode()).getBytes(Charset.forName(DEFAULT_CHARSET));
                        contentBytes = this.serializer.marshalToByte((Serializable)((Object)JSONObject.toJSONString((Object)((Object)buttonEntity))));
                        pipeline.hset(keyBytes, fieldBytes, contentBytes);
                    }
                }
                pipeline.exec();
            });
        }
    }

    public void removeRoleAppsCache(Long roleId, Long appId) {
        String key = CURRENTROLE_APP_KEY + roleId;
        this.cacheManager.hdel(key, appId.toString());
    }

    public void removeRoleAppsBtnCache(Long roleId, String btnKey) {
        String key = CURRENTROLE_APP_BUTTON_KEY + roleId;
        this.cacheManager.hdel(key, btnKey);
    }

    public List<Long> getRoleAppsCache(Long roleId) {
        ArrayList<Long> resultList = new ArrayList<Long>();
        final String key = CURRENTROLE_APP_KEY + roleId;
        Set appIds = (Set)this.cacheManager.execute((CacheManager.JedisAction)new CacheManager.JedisAction<Set<String>>(){

            public Set<String> action(Jedis jedis) {
                HashSet<String> resultSet = new HashSet<String>();
                Map resultMap = jedis.hgetAll(key);
                if (!resultMap.isEmpty()) {
                    for (Map.Entry entry : resultMap.entrySet()) {
                        resultSet.add((String)entry.getKey());
                    }
                }
                return resultSet;
            }
        });
        if (appIds != null && !appIds.isEmpty()) {
            for (String appId : appIds) {
                resultList.add(Long.parseLong(appId));
            }
        }
        return resultList;
    }

    public boolean isExistInRoleAppBtnCache(Long roleId, String btnkey) {
        String key = CURRENTROLE_APP_BUTTON_KEY + roleId;
        return this.cacheManager.hexists(key, btnkey);
    }

    public boolean isExistInRoleAppsCache(Long roleId, Long appId) {
        String key = CURRENTROLE_APP_KEY + roleId;
        return this.cacheManager.hexists(key, appId.toString());
    }

    public void putOneRoleUsersCache(Long roleId, RoleUserRelationVO roleUserRelationVo) {
        String key = CURRENTROLE_USER_KEY + roleId;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String authOrgId = roleUserRelationVo.getAuthOrgId().toString();
        resultMap.put(roleUserRelationVo.getUserId().toString(), authOrgId);
        String cacheValue = (String)((Object)this.cacheManager.hget(key, roleUserRelationVo.getUserId().toString()));
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            if (cacheValue.indexOf(authOrgId) == -1) {
                resultMap.put(roleUserRelationVo.getUserId().toString(), authOrgId + "," + cacheValue);
            }
        } else {
            resultMap.put(roleUserRelationVo.getUserId().toString(), authOrgId + "");
        }
        this.cacheManager.piplineExecute(pipeline -> {
            pipeline.multi();
            for (Map.Entry entry : resultMap.entrySet()) {
                byte[] keyBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
                byte[] fieldBytes = ((String)entry.getKey()).getBytes(Charset.forName(DEFAULT_CHARSET));
                byte[] contentBytes = this.serializer.marshalToByte((Serializable)entry.getValue());
                pipeline.hset(keyBytes, fieldBytes, contentBytes);
            }
            pipeline.exec();
        });
    }

    public void putRoleUsersCache(Long roleId, List<RoleUserRelationVO> roleUserRelations) {
        if (roleUserRelations != null && roleUserRelations.size() > 0) {
            String key = CURRENTROLE_USER_KEY + roleId;
            HashMap<String, String> resultMap = new HashMap<String, String>();
            for (RoleUserRelationVO roleUserRelationVo : roleUserRelations) {
                String cacheValue;
                String value = (String)resultMap.get(roleUserRelationVo.getUserId().toString());
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    resultMap.put(roleUserRelationVo.getUserId().toString(), value + "," + roleUserRelationVo.getAuthOrgId().toString());
                } else {
                    resultMap.put(roleUserRelationVo.getUserId().toString(), roleUserRelationVo.getAuthOrgId().toString());
                }
                if (!StringUtils.isNotBlank((CharSequence)(cacheValue = (String)((Object)this.cacheManager.hget(key, roleUserRelationVo.getUserId().toString()))))) continue;
                resultMap.put(roleUserRelationVo.getUserId().toString(), (String)resultMap.get(roleUserRelationVo.getUserId().toString()) + "," + cacheValue);
            }
            this.cacheManager.piplineExecute(pipeline -> {
                pipeline.multi();
                for (Map.Entry entry : resultMap.entrySet()) {
                    byte[] keyBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
                    byte[] fieldBytes = ((String)entry.getKey()).getBytes(Charset.forName(DEFAULT_CHARSET));
                    byte[] contentBytes = this.serializer.marshalToByte((Serializable)entry.getValue());
                    pipeline.hset(keyBytes, fieldBytes, contentBytes);
                }
                pipeline.exec();
            });
        }
    }

    public void removeRoleUsersCache(Long roleId, Long userId, Long authOrgId) {
        String key = CURRENTROLE_USER_KEY + roleId;
        String cacheValue = (String)((Object)this.cacheManager.hget(key, userId.toString()));
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            if (authOrgId != null && authOrgId.toString().equals(cacheValue)) {
                this.cacheManager.hdel(key, userId.toString());
            } else {
                String[] values = cacheValue.split(",");
                String newOrgIds = "";
                for (String value : values) {
                    if (authOrgId == null || authOrgId.toString().equals(value)) continue;
                    newOrgIds = newOrgIds + value + ",";
                }
                if (StringUtils.isNotBlank((CharSequence)newOrgIds)) {
                    this.cacheManager.hset(key, userId.toString(), (Serializable)((Object)newOrgIds.substring(0, newOrgIds.length() - 1)));
                }
            }
        }
    }

    public void putRolePostsCache(Long roleId, List<RolePostRelationVO> rolePostRelations) {
        if (rolePostRelations != null && rolePostRelations.size() > 0) {
            String key = CURRENTROLE_POST_KEY + roleId;
            this.cacheManager.piplineExecute(pipeline -> {
                pipeline.multi();
                for (RolePostRelationVO rolePostRelationVO : rolePostRelations) {
                    byte[] keyBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
                    byte[] fieldBytes = String.valueOf(rolePostRelationVO.getPostId()).getBytes(Charset.forName(DEFAULT_CHARSET));
                    pipeline.hset(keyBytes, fieldBytes, new byte[0]);
                }
                pipeline.exec();
            });
        }
    }

    public void removeRolePostsCache(Long roleId, Long postId) {
        String key = CURRENTROLE_POST_KEY + roleId;
        this.cacheManager.hdel(key, postId.toString());
    }

    public List<Long> getRoleUserIdsCache(Long roleId, Long userId) {
        ArrayList<Long> resultList = new ArrayList<Long>();
        String key = CURRENTROLE_USER_KEY + roleId;
        String authOrgs = (String)((Object)this.cacheManager.hget(key, userId.toString()));
        if (StringUtils.isNotBlank((CharSequence)authOrgs)) {
            String[] orgIds;
            for (String orgId : orgIds = authOrgs.split(",")) {
                resultList.add(Long.parseLong(orgId));
            }
        }
        return resultList;
    }
}

