/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.comment.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.comment.bean.CommentEntity;
import com.ejianc.foundation.comment.mapper.CommentMapper;
import com.ejianc.foundation.comment.service.ICommentService;
import com.ejianc.foundation.comment.vo.CommentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="commentService")
public class CommentServiceImpl
extends BaseServiceImpl<CommentMapper, CommentEntity>
implements ICommentService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${weixinParam.sendCcUser:nFBuRUh66OVkyaJI4xnO2235TR7uf35fAxoRaWcNI5k}")
    private String sendCcUserTemplateId;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ICommentService commentService;
    @Autowired
    private CommentMapper commentMapper;
    @Autowired
    private IThirdSystemService thirdSystemService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommentVO saveOrUpdates(CommentEntity entity, boolean b) {
        this.commentService.saveOrUpdate((Object)entity);
        CommentVO vo = (CommentVO)BeanMapper.map((Object)((Object)entity), CommentVO.class);
        this.commentService.sendMessage(vo);
        return vo;
    }

    @Override
    public void sendMessage(CommentVO vo) {
        block16: {
            try {
                Object[] receivers;
                String attention = vo.getAttention();
                if (StringUtils.isEmpty((CharSequence)attention)) {
                    this.logger.info("\u8bc4\u8bba\u4fdd\u5b58\u65f6\uff0c\u6ca1\u6709@\u4eba\uff0c\u4e0d\u53d1\u6d88\u606f\uff01");
                    return;
                }
                if (attention.contains("1247777316689256450")) {
                    attention = attention.replaceAll("1247777316689256450", "303581417601122400");
                }
                if ((receivers = attention.split(",")).length <= 0) break block16;
                this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========>{}", receivers);
                PushMsgParameter parameter = new PushMsgParameter();
                ArrayList<String> channel = new ArrayList<String>();
                channel.add("sys");
                channel.add("weixin");
                parameter.setChannel(channel.toArray(new String[0]));
                parameter.setReceivers((String[])receivers);
                parameter.setMsgType("commentcc");
                String subject = "\u60a8\u6709\u4e00\u6761\u8bc4\u8bba\u6d88\u606f\uff0c\u3010" + vo.getUserName() + "\u3011\u8bc4\u8bba\u4e86\u3010" + vo.getCreateBillUserName() + "\u3011\u521b\u5efa\u7684\u3010" + vo.getBillTypeName() + "\u3011\u5e76@\u4e86\u4f60\u3002";
                parameter.setSubject(subject);
                String url = this.environmentTools.getBaseHost() + vo.getProjectUrl() + "?" + vo.getBillTypeId();
                if (vo.getPcAndMobile().booleanValue()) {
                    parameter.setContent(vo.getUserName() + "@\u4e86\u4f60\u70b9\u51fb\u67e5\u770b\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
                } else {
                    parameter.setContent(vo.getUserName() + "@\u4e86\u4f60\u3002<a href=" + '\"' + vo.getProjectUrl() + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>");
                }
                parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
                parameter.setSendUserId(vo.getUserId());
                String maUrl = vo.getMaUrl().contains("http") ? vo.getMaUrl() : this.environmentTools.getBaseHost() + vo.getMaUrl();
                parameter.setMobileUrl(maUrl);
                String pcUrl = vo.getProjectUrl();
                if (StringUtils.isNotBlank((CharSequence)pcUrl) && !pcUrl.contains("http")) {
                    pcUrl = this.environmentTools.getBaseHost() + pcUrl;
                }
                parameter.setPcUrl(pcUrl);
                JSONObject weixinParams = new JSONObject();
                weixinParams.put("template_id", (Object)this.sendCcUserTemplateId);
                JSONObject wxparams = new JSONObject();
                wxparams.put("first", (Object)(vo.getUserName() + "@\u4e86\u4f60"));
                wxparams.put("keyword1", (Object)vo.getBillTypeName());
                wxparams.put("keyword2", (Object)this.sessionManager.getUserContext().getUserName());
                wxparams.put("keyword3", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                wxparams.put("remark", (Object)"\u8bf7\u60a8\u5173\u6ce8\uff01");
                weixinParams.put("data", (Object)wxparams);
                weixinParams.put("url", (Object)(maUrl + "&openid={openid}"));
                parameter.setWeixinParams(weixinParams);
                String customerChannel = this.sessionManager.getUserContext().getCustomerChannel();
                QueryWrapper thirdSystemWrapper = new QueryWrapper();
                thirdSystemWrapper.eq((Object)"tenant_id", (Object)"999999");
                if (StringUtils.isNotBlank((CharSequence)customerChannel)) {
                    ThirdSystemEntity thirdSystemEntity = new ThirdSystemEntity();
                    if ("weixinee_channel".equals(customerChannel)) {
                        channel.add("weixinee");
                        thirdSystemWrapper.eq((Object)"code", (Object)"weixineeThirdApp");
                        thirdSystemEntity = (ThirdSystemEntity)((Object)this.thirdSystemService.getOne((Wrapper)thirdSystemWrapper));
                        String configInfo = thirdSystemEntity.getConfigInfo();
                        JSONObject configJson = JSON.parseObject((String)configInfo);
                        String agentid = configJson.getString("agentid");
                        JSONObject weixineeParams = new JSONObject();
                        weixineeParams.put("agentid", (Object)agentid);
                        weixineeParams.put("msgtype", (Object)"textcard");
                        weixineeParams.put("title", (Object)"\u8bc4\u8bba\u6d88\u606f\u6284\u9001\u901a\u77e5");
                        weixineeParams.put("description", (Object)("\u8bc4\u8bba:" + vo.getUserName() + "@\u4e86\u4f60"));
                        weixineeParams.put("url", (Object)(maUrl + "&userid={userid}"));
                        weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
                        parameter.setWeixineeParams(weixineeParams);
                    } else if ("dingding_channel".equals(customerChannel)) {
                        channel.add("ddThirdApp");
                        thirdSystemWrapper.eq((Object)"code", (Object)"ddThirdAppTemlateId");
                        thirdSystemEntity = (ThirdSystemEntity)((Object)this.thirdSystemService.getOne((Wrapper)thirdSystemWrapper));
                        String configInfo = thirdSystemEntity.getConfigInfo();
                        JSONObject configJson = JSON.parseObject((String)configInfo);
                        String templateId = configJson.getString("noticeId");
                        if (StringUtils.isNotBlank((CharSequence)templateId)) {
                            channel.add("ddThirdApp");
                            JSONObject dingdingParams = new JSONObject();
                            dingdingParams.put("type", (Object)"bpmNotice");
                            dingdingParams.put("title", (Object)"\u8bc4\u8bba\u6d88\u606f\u6284\u9001\u901a\u77e5");
                            dingdingParams.put("content", (Object)("\u8bc4\u8bba:" + vo.getUserName() + "@\u4e86\u4f60"));
                            String ddPcurl = url;
                            ddPcurl = this.environmentTools.getBaseHost() + "portal/sso/index?userid={userid}&targeturl=" + ddPcurl;
                            dingdingParams.put("pcurl", (Object)ddPcurl);
                            dingdingParams.put("maurl", (Object)(maUrl + "&ddThirdAppid={ddThirdAppid}"));
                            dingdingParams.put("billTypeName", (Object)vo.getBillTypeName());
                            dingdingParams.put("userLabel", (Object)"\u8bc4\u8bba\u4eba\uff1a");
                            dingdingParams.put("userName", (Object)this.sessionManager.getUserContext().getUserName());
                            dingdingParams.put("timeLabel", (Object)"\u8bc4\u8bba\u65f6\u95f4\uff1a");
                            dingdingParams.put("timeValue", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            dingdingParams.put("templateId", (Object)templateId);
                            parameter.setDingdingParams(dingdingParams);
                        } else {
                            this.logger.info("---------------\u7f3a\u5c11\u9489\u9489\u7b2c\u4e09\u65b9\u5e94\u7528\u5ba1\u6279\u6d88\u606f\u6a21\u677f-------------------");
                        }
                    }
                }
                this.logger.info("parameter###{}", (Object)((JSONObject)BeanMapper.map((Object)parameter, JSONObject.class)).toJSONString());
                try {
                    CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                    if (result.isSuccess()) {
                        this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                        break block16;
                    }
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
                catch (Exception e) {
                    this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------{}", (Object)(e.getMessage() == null ? "\u7a7a\u6307\u9488\u4e86" : e.getMessage()));
            }
        }
    }

    @Override
    public void removeUserById(Long billTypeId, Long userId) {
        QueryWrapper delWrapper = new QueryWrapper();
        delWrapper.eq((Object)"bill_type_id", (Object)billTypeId);
        delWrapper.eq((Object)"user_id", (Object)userId);
        this.remove((Wrapper)delWrapper);
    }

    @Override
    public List<CommentVO> queryTipsList(Long billTypeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bill_type_id", (Object)billTypeId);
        queryWrapper.eq((Object)"whether_tips", (Object)false);
        queryWrapper.orderByDesc((Object)"create_time");
        List list = this.commentMapper.selectList((Wrapper)queryWrapper);
        List voList = BeanMapper.mapList((Iterable)list, CommentVO.class);
        return voList;
    }

    @Override
    public void updateHandleTips(Long billTypeId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"whether_tips", (Object)true);
        CommentEntity commentEntity = (CommentEntity)((Object)this.selectById(billTypeId));
        commentEntity.setWhetherTips(true);
        this.commentService.saveOrUpdate((Object)commentEntity, false);
    }
}

