package com.ejianc.foundation.orgcenter.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 岗位bean
 * 
 * @author guominga
 *
 */
@TableName("ejc_idm_post")
public class PostEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 岗位编码
	 */
	@TableField(value = "code")
	private String code;

	/**
	 * 岗位名称
	 */
	@TableField(value = "name")
	private String name;

	/**
	 * 备注
	 */
	@TableField(value = "note")
	private String note;

	/**
	 * 状态（1：启用， 0：停用）
	 */
	@TableField(value = "state")
	private Integer state;

	/**
	 * 排序号
	 */
	@TableField(value = "sequence")
	private Integer sequence;

	/**
	 * 岗位类型：1-公共档案，0-自定义 组织岗, 2-项目岗位
	 */
	@TableField(value = "type")
	private Integer type;

	@TableField(value = "pid")
	private Long pid;// 上级Id

	@TableField(value = "inner_code")
	private String innerCode; // 内码

	/**
	 * 岗位来源数据Id
	 */
	@TableField(value = "source_id")
	private String sourceId;

	@TableField(value = "system_id")
	private String systemId; // 系统id
	
	@TableField(value = "org_id")
	private Long orgId;

	@TableField(value = "post_dict_id")
	private Long postDictId;


	public Long getPostDictId() {
		return postDictId;
	}

	public void setPostDictId(Long postDictId) {
		this.postDictId = postDictId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getSourceId() {
		return sourceId;
	}

	public Long getPid() {
		return pid;
	}

	public void setPid(Long pid) {
		this.pid = pid;
	}

	public String getInnerCode() {
		return innerCode;
	}

	public void setInnerCode(String innerCode) {
		this.innerCode = innerCode;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}
	
}
