package com.ejianc.foundation.usercenter.bean;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 用户bean
 * 
 * @author guominga
 *
 */
@TableName("ejc_idm_user")
public class UserEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "org_id")
	private Long orgId;// 所属公司ID

	@TableField(value = "user_name")
	private String userName; // 用户昵称

	@TableField(value = "user_code")
	private String userCode; // 用户账号（区分大小写）

	@TableField(value = "user_mobile")
	private String userMobile; // 用户手机号

	@TableField(value = "user_email")
	private String userEmail; // 用户邮箱

	@TableField(value = "sex")
	private Integer sex; // 用户性别（1：男，2：女）

	@TableField(value = "type_id")
	private Integer typeId; // 用户类型（1：超级管理员，2：普通用户，3.管理员）

	@TableField(value = "salt")
	private String salt;// 盐

	@TableField(value = "password")
	private String password; // 用户密码

	@TableField(value = "avator")
	private String avator; // 用户头像

	@TableField(value = "pwd_start_time")
	private Date pwdStartTime; // 密码开始时间

	@TableField(value = "last_login_time")
	private Date lastLoginTime; // 最后一次登录时间

	@TableField(value = "regist_time")
	private Date registTime; // 注册时间

	@TableField(value = "weixinee_id")
	private String weixineeId; // 企业微信ID

	@TableField(value = "weixin_id")
	private String weixinId; // 微信Id

	@TableField(value = "weixin_minprogram_id")
	private String weixinMinprogramId; // 微信小程序Id

	@TableField(value = "dingding_id")
	private String dingdingId; // 钉钉Id

	@TableField(value = "qq_id")
	private String qqId; // qq ID

	@TableField(value = "manager_notes")
	private String managerNotes; // 描述（管理员页面使用，描述管理员的类型）

	/**
	 * 用户状态，0-禁用，1-启用
	 */
	@TableField(value = "user_state")
	private Integer userState;

	@TableField(value = "source_id")
	private String sourceId; // 来源组织id

	@TableField(value = "source_org_id")
	private String sourceOrgId; // 来源组织id(同步数据使用）

	@TableField(value = "system_id")
	private String systemId; // 系统id

	@TableField(value = "finger_signature")
	private String fingerSignature;

	@TableField(value = "face_signature")
	private String faceSignature;

	@TableField(value = "locale")
	private String locale;

	@TableField(value = "face_img")
	private String faceImg;

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getUserCode() {
		return userCode;
	}

	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}

	public String getUserMobile() {
		return userMobile;
	}

	public void setUserMobile(String userMobile) {
		this.userMobile = userMobile;
	}

	public String getUserEmail() {
		return userEmail;
	}

	public void setUserEmail(String userEmail) {
		this.userEmail = userEmail;
	}

	public Integer getSex() {
		return sex;
	}

	public void setSex(Integer sex) {
		this.sex = sex;
	}

	public Integer getTypeId() {
		return typeId;
	}

	public void setTypeId(Integer typeId) {
		this.typeId = typeId;
	}

	public String getSalt() {
		return salt;
	}

	public void setSalt(String salt) {
		this.salt = salt;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getAvator() {
		return avator;
	}

	public void setAvator(String avator) {
		this.avator = avator;
	}

	public Date getPwdStartTime() {
		return pwdStartTime;
	}

	public void setPwdStartTime(Date pwdStartTime) {
		this.pwdStartTime = pwdStartTime;
	}

	public Date getLastLoginTime() {
		return lastLoginTime;
	}

	public void setLastLoginTime(Date lastLoginTime) {
		this.lastLoginTime = lastLoginTime;
	}

	public Date getRegistTime() {
		return registTime;
	}

	public void setRegistTime(Date registTime) {
		this.registTime = registTime;
	}

	public String getWeixineeId() {
		return weixineeId;
	}

	public void setWeixineeId(String weixineeId) {
		this.weixineeId = weixineeId;
	}

	public String getWeixinId() {
		return weixinId;
	}

	public void setWeixinId(String weixinId) {
		this.weixinId = weixinId;
	}

	public String getWeixinMinprogramId() {
		return weixinMinprogramId;
	}

	public void setWeixinMinprogramId(String weixinMinprogramId) {
		this.weixinMinprogramId = weixinMinprogramId;
	}

	public String getDingdingId() {
		return dingdingId;
	}

	public void setDingdingId(String dingdingId) {
		this.dingdingId = dingdingId;
	}

	public String getQqId() {
		return qqId;
	}

	public void setQqId(String qqId) {
		this.qqId = qqId;
	}

	public Integer getUserState() {
		return userState;
	}

	public void setUserState(Integer userState) {
		this.userState = userState;
	}

	public String getManagerNotes() {
		return managerNotes;
	}

	public void setManagerNotes(String managerNotes) {
		this.managerNotes = managerNotes;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public String getFingerSignature() {
		return fingerSignature;
	}

	public void setFingerSignature(String fingerSignature) {
		this.fingerSignature = fingerSignature;
	}

	public String getFaceSignature() {
		return faceSignature;
	}

	public void setFaceSignature(String faceSignature) {
		this.faceSignature = faceSignature;
	}

	public String getSourceOrgId() {
		return sourceOrgId;
	}

	public void setSourceOrgId(String sourceOrgId) {
		this.sourceOrgId = sourceOrgId;
	}

	public String getLocale() {
		return locale;
	}

	public void setLocale(String locale) {
		this.locale = locale;
	}

	public String getFaceImg() {
		return faceImg;
	}

	public void setFaceImg(String faceImg) {
		this.faceImg = faceImg;
	}

}
