package com.ejianc.foundation.usercenter.service.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import com.aliyun.dingtalkoauth2_1_0.Client;
import com.alibaba.fastjson.JSONArray;
import com.aliyun.dingtalkoauth2_1_0.models.GetCorpAccessTokenResponse;
import com.aliyun.dingtalkoauth2_1_0.models.GetUserTokenRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetUserTokenResponse;
import com.aliyun.dingtalkoauth2_1_0.models.GetUserTokenResponseBody;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.dingtalk.api.request.OapiServiceGetAuthInfoRequest;
import com.dingtalk.api.request.OapiServiceGetSuiteTokenRequest;
import com.dingtalk.api.response.OapiServiceGetAuthInfoResponse;
import com.dingtalk.api.response.OapiServiceGetSuiteTokenResponse;
import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.tenant.service.ITenantService;
import com.ejianc.foundation.usercenter.bean.SuiteTicketEntity;
import com.ejianc.foundation.usercenter.service.SuitTicketService;
import com.ejianc.foundation.utils.DdConstant;
import com.ejianc.foundation.utils.WXEEConstant;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiV2UserGetuserinfoRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiV2UserGetuserinfoResponse;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.mapper.ThirdSystemMapper;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.util.YonYouCloudSignHelper;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.WeixinRestUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.taobao.api.ApiException;

import static com.ejianc.foundation.utils.WXEEConstant.YJB_SECRET;
import static com.ejianc.foundation.utils.WXEEConstant.YJB_SUIT_ID;

@Service
public class ThirdSystemServiceImpl extends BaseServiceImpl<ThirdSystemMapper, ThirdSystemEntity> implements IThirdSystemService {
	private static Logger logger = LoggerFactory.getLogger(ThirdSystemServiceImpl.class);

	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	@Value("${ejc.wechat.soterVrifyUrl}")
	private String soterVrifyUrl;

	@Autowired
	private IUserService userService;

	@Autowired
	private SuitTicketService suitTicketService;

	@Value("${ejc.yonYouCloud.accessTokenUrl:#{null}}")
	private String yonYouCloutAccessTokeUrl;

	@Value("${ejc.yonYouCloud.appKey:#{null}}")
	private String yonYouAppKey;
	@Value("${ejc.yonYouCloud.appSecret:#{null}}")
	private String yonYouAppSecret;

	@Value("${ejc.yonYouCloud.getBaseInfoByCodeUrl:#{null}}")
	private String yonYouCloudGetBaseInfoByCodeUrl;

	@Value("${ejc.yonYouCloud.getEmpInfoByUserIdUrl:#{null}}")
	private String yonYouCloudGetEmpInfoByUserIdUrl;

	@Value("${ejc.yonYouCloud.getTicketUrl:#{null}}")
	private String yonYouGetTicketUrl;
	@Value("${ejc.qunjeCloud.tokenUrl:#{null}}")
	private String tokenUrl;
	@Autowired
	private ITenantService iTenantService;



	private static final String YONYOUCLOUD_ACCESSTOEKN_KEY = "yonyoucloud::accessToken";
	private static final String YONYOUCLOUD_TICKET_KEY = "yonyoucloud::ticket";

	@Override
	public ThirdSystemEntity queryThirdSystemByCode(String systemCode) {
		QueryWrapper<ThirdSystemEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("code", systemCode);
		ThirdSystemEntity entity = super.getOne(queryWrapper);
		return entity;
	}

	@Override
	public ThirdSystemVO findSysByCode(String sysCode, Long tenantId) {
		QueryWrapper<ThirdSystemEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("code", sysCode);
		queryWrapper.eq("tenant_id", tenantId);
		ThirdSystemEntity entity = super.getOne(queryWrapper);
		if(entity != null) {
			return BeanMapper.map(entity, ThirdSystemVO.class);
		}
		return null;
	}

	@Override
	public UserVO bindUserWithSoterSignature(String soterJsonStr, String appId, String secret) {
		UserVO resp = null;
		String msg = this.virifySoterSignature(soterJsonStr, appId, secret);
		JSONObject soterJson = JSONObject.parseObject(soterJsonStr);
		String openId = soterJson.getString("openId");
		Long userId = soterJson.getLong("userId");
		String type = soterJson.getString("loginType");
		if(StringUtils.isNotBlank(msg)) {
			throw new BusinessException("身份校验未通过！");
		}
		QueryWrapper<UserEntity> query = new QueryWrapper<>();
		query.or(r -> r.eq("face_signature", openId));
		query.or(r -> r.eq("finger_signature", openId));
		query.or(r -> r.eq("weixin_minprogram_id", openId));
		query.eq("dr", BaseVO.DR_UNDELETE);

		if(null != userId) {
			//账号绑定
			List<UserEntity> userList = userService.list(query);
			if(CollectionUtils.isNotEmpty(userList)) {
				for(UserEntity u : userList) {
					if(!u.getId().equals(userId)) {
						//解除其他账号与该微信账户的绑定关系
						u.setFingerSignature(null);
						u.setWeixinMinprogramId(null);
						u.setFaceSignature(null);
					} else {
						if(!openId.equals(u.getWeixinMinprogramId())) {
							u.setWeixinMinprogramId(openId);
						}
						if(StringUtils.isBlank(u.getFingerSignature())) {
							if("finger".equals(type)) {
								u.setFingerSignature(openId);
							} else if(!openId.equals(u.getFingerSignature())) {
								u.setFingerSignature(null);
							}
						}
						if(StringUtils.isBlank(u.getFaceSignature())) {
							if("facial".equals(type)) {
								u.setFaceSignature(openId);
							} else if(!openId.equals(u.getFaceSignature())) {
								u.setFaceSignature(null);
							}
						}

						resp = BeanMapper.map(u, UserVO.class);
					}

				}
			}
			if(null == resp) {
				UserEntity ue = userService.getById(userId);
				ue.setWeixinMinprogramId(openId);
				if("finger".equals(type)) {
					ue.setFingerSignature(openId);
					if(!openId.equals(ue.getFaceSignature())) {
						ue.setFaceSignature(null);
					}
				} else {
					ue.setFaceSignature(openId);
					if(!openId.equals(ue.getFingerSignature())) {
						ue.setFingerSignature(null);
					}
				}
				userList.add(ue);
				resp = BeanMapper.map(ue, UserVO.class);


//                QueryWrapper<UserEntity> userByOpenIdQuery = new QueryWrapper<>();
//                userByOpenIdQuery.eq("weixin_minprogram_id", openId);
//                List<UserEntity> usersByOpenId = userService.list(userByOpenIdQuery);
//                if(CollectionUtils.isNotEmpty(usersByOpenId)) {
//                    usersByOpenId.stream().filter(u -> !u.getId().equals(ue.getId())).forEach(u -> {
//                        u.setWeixinMinprogramId(null);
//                        userList.add(u);
//                    });
//                }
			}
			userService.saveOrUpdateBatch(userList);
		} else {
			UserEntity user = userService.getOne(query);
			if(StringUtils.isBlank(user.getWeixinMinprogramId()) || !(openId).equals(user.getWeixinMinprogramId())) {
				user.setWeixinMinprogramId(openId);
				userService.saveOrUpdate(user, false);
			}
			if(null != user) {
				resp = BeanMapper.map(user, UserVO.class);
			}
		}
		return resp;
	}

	@Override
	public String getYonYouCloudAccessToken(boolean reload) throws Exception {
		String accessToken = (String) redisTemplate.opsForValue().get(YONYOUCLOUD_ACCESSTOEKN_KEY);
		logger.info("redis--yonyoucloud--accessToken="+accessToken);
		if(StringUtils.isBlank(accessToken) || reload) {
			Map<String, Object> params = new HashMap<>();
			params.put("appKey", yonYouAppKey);
			params.put("timestamp", String.valueOf(System.currentTimeMillis()));
			params.put("signature", YonYouCloudSignHelper.sign(params, yonYouAppSecret));
			logger.info("请求友空间获取接口令牌，url-{}, 参数：{}", yonYouCloutAccessTokeUrl, params);
			String httpResultJsonStr = HttpTookit.get(yonYouCloutAccessTokeUrl, params, new HashMap<>());
			logger.info("请求友空间获取接口令牌结果：{}", httpResultJsonStr);

			JSONObject httpResultJson = JSONObject.parseObject(httpResultJsonStr);
			if("00000".equals(httpResultJson.getString("code"))) {
				JSONObject data = httpResultJson.getJSONObject("data");
				accessToken = data.getString("access_token");
				Long expire = data.getLong("expire");
				redisTemplate.opsForValue().set(YONYOUCLOUD_ACCESSTOEKN_KEY, accessToken, expire - 3L, TimeUnit.SECONDS);
			} else {
				throw new BusinessException("请求友空间获取接口令牌失败: " + httpResultJson.getString("message"));
			}
		}
		return accessToken;
	}

	@Override
	public JSONObject getYhtBaseInfoByCode(String tmpCode) throws Exception {
		String accessToken = getYonYouCloudAccessToken(false);
		Map<String, String> params = new HashMap<>();
		params.put("access_token", accessToken);
		params.put("code", tmpCode);
		logger.info("请求友空间根据code获取免登信息，url-{}, 参数：{}", yonYouCloudGetBaseInfoByCodeUrl, params);
		String httpResultJsonStr = HttpTookit.get(yonYouCloudGetBaseInfoByCodeUrl, params, new HashMap<>());
		logger.info("请求友空间根据code获取免登信息：{}", httpResultJsonStr);
		JSONObject httpResultJson = JSONObject.parseObject(httpResultJsonStr);
		if(httpResultJson.getInteger("code") != 0) {
			throw new BusinessException("请求友空间根据code获取免登信息失败，" + httpResultJson.getString("msg"));
		}

		return httpResultJson.getJSONObject("data");
	}

	@Override
	public JSONObject getYhtEmployeeInfoByYhtUserId(String yhtUserId) throws Exception {
		String accessToken = getYonYouCloudAccessToken(false);
		Map<String, String> params = new HashMap<>();
		params.put("access_token", accessToken);
		params.put("yhtUserId", yhtUserId);
		logger.info("根据友互通userId信息查询友互通人员信息，url-{}, 参数：{}", yonYouCloudGetEmpInfoByUserIdUrl, params);
		String httpResultJsonStr = HttpTookit.get(yonYouCloudGetEmpInfoByUserIdUrl, params, new HashMap<>());
		logger.info("根据友互通userId信息查询友互通人员信息：{}", httpResultJsonStr);
		JSONObject httpResultJson = JSONObject.parseObject(httpResultJsonStr);
		if(httpResultJson.getInteger("code") != 0) {
			throw new BusinessException("根据友互通userId信息查询友互通人员信息失败，" + httpResultJson.getString("msg"));
		}

		return httpResultJson.getJSONArray("data").getJSONObject(0);
	}


	private String virifySoterSignature(String soterJsonStr, String appId, String secret) {
		String accessToke = this.getMiniProgramAccessToken(appId, secret);
		String url = soterVrifyUrl + "?access_token=" + accessToke;
		JSONObject soterJson = JSONObject.parseObject(soterJsonStr);
		JSONObject param = new JSONObject();
		param.put("openid", soterJson.get("openId"));
		param.put("json_string", soterJson.getString("json_string"));
		param.put("json_signature", soterJson.get("json_signature"));
		String result = WeixinRestUtil.doPostByURL(url, param.toJSONString());
		logger.info("verifySoterResult: {}", result);
		if(StringUtils.isNotBlank(result)) {
			JSONObject resultJson = JSON.parseObject(result);
			if(!"true".equals(resultJson.getString("is_ok"))) {
				return "身份校验未通过！";
			}
		}
		return null;
	}

	@Override
	public String getWeixinAccessToken(String appid, String secret, Boolean refresh) {
		String key = appid+"_"+secret;
		String accessToken = null;
		if(!refresh){
			accessToken = (String) redisTemplate.opsForValue().get(key);
			logger.info("redis----accessToken="+accessToken);
			System.out.println("redis----accessToken="+accessToken);
		}
		if(StringUtils.isBlank(accessToken)) {
			String accessResult = WeixinRestUtil.doGetByURL("https://api.weixin.qq.com/cgi-bin/token", "grant_type=client_credential&appid="+appid+"&secret="+secret);
			logger.info("accessResult="+accessResult);
			System.out.println("accessResult="+accessResult);
			if(StringUtils.isNotBlank(accessResult)) {
				JSONObject accessJson = JSON.parseObject(accessResult);
				accessToken = accessJson.getString("access_token");
				String errmsg = accessJson.getString("errmsg");
				if("ok".equals(errmsg)&&StringUtils.isNotBlank(accessToken)) {
					redisTemplate.opsForValue().set(key, accessToken, 7000, TimeUnit.SECONDS);
				}
			}
		}
		return accessToken;
	}

	@Override
	public String getWeixineeAccessToken(String corpAppId, String corpSecret, Boolean refresh) {
		String key = corpAppId+"_"+corpSecret;
		String accessToken = null;
		if(!refresh){
			accessToken = (String) redisTemplate.opsForValue().get(key);
			logger.info("redis----accessToken="+accessToken);
			System.out.println("redis----accessToken="+accessToken);
		}
		if(StringUtils.isBlank(accessToken)) {
			Map<String,String> param = new HashMap<>();
			String accessResult = null;
			param.put("corpid",corpAppId);
			param.put("corpsecret",corpSecret);
			try {
				accessResult = ReferHttpClientUtils.get("https://qyapi.weixin.qq.com/cgi-bin/gettoken",param,new HashMap<>());
			} catch (GeneralSecurityException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
			logger.info("accessResult="+accessResult);
			System.out.println("accessResult="+accessResult);
			if(StringUtils.isNotBlank(accessResult)) {
				JSONObject accessJson = JSON.parseObject(accessResult);
				accessToken = accessJson.getString("access_token");
				String errmsg = accessJson.getString("errmsg");
				if("ok".equals(errmsg)&&StringUtils.isNotBlank(accessToken)) {
					redisTemplate.opsForValue().set(key, accessToken, 7000, TimeUnit.SECONDS);
				}
			}
		}
		return accessToken;
	}

	/**
	 * 获取钉钉内部的access_token
	 *
	 * @param corpAppId
	 * @param corpSecret
	 * @param refresh
	 * @return
	 */
	@Override
	public String getDingDingAccessToken(String corpAppId, String corpSecret, Boolean refresh) {
		String key = corpAppId+"_"+corpSecret;
		String accessToken = null;
		if(!refresh){
			accessToken = (String) redisTemplate.opsForValue().get(key);
			logger.info("redis----accessToken="+accessToken);
			System.out.println("redis----accessToken="+accessToken);
		}
		if(StringUtils.isBlank(accessToken)) {
			DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
			OapiGettokenRequest request = new OapiGettokenRequest();
			request.setAppkey(corpAppId);
			request.setAppsecret(corpSecret);
			request.setHttpMethod("GET");
			OapiGettokenResponse response = null;
			try {
				response = client.execute(request);
			} catch (ApiException e) {
				e.printStackTrace();
				throw new BusinessException("获取钉钉权限信息失败");
			}
			JSONObject body = JSONObject.parseObject(response.getBody());
			logger.info("accessToken---------》》》》"+response.getBody());
			if("0".equals(body.getString("errcode"))){
				accessToken = body.getString("access_token");
				redisTemplate.opsForValue().set(key, accessToken, 7000, TimeUnit.SECONDS);
			}
		}
		return accessToken;
	}

	/**
	 * 获取钉钉的用户信息
	 *
	 * @param code
	 * @param token
	 * @return
	 */
	@Override
	public String getDingDingUserInfo(String code, String token) {
		DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/getuserinfo");
		OapiV2UserGetuserinfoRequest req = new OapiV2UserGetuserinfoRequest();
		req.setCode(code);
		OapiV2UserGetuserinfoResponse rsp = null;
		try {
			rsp = client.execute(req, token);
		} catch (ApiException e) {
			e.printStackTrace();
			throw new BusinessException("获取钉钉用户信息失败");
		}
		logger.info("获取到的用户信息--------------"+rsp.getBody());
		JSONObject body = JSONObject.parseObject(rsp.getBody());
		if("0".equals(body.getString("errcode"))){
			return body.getString("result");
		}else{
			throw new BusinessException("获取钉钉用户信息失败");
		}
	}

	/**
	 * @param appId
	 * @param appSecret
	 * @Author mrsir_wxp
	 * @Date 2020/10/17
	 * @Description 获取小程序的AccessToken
	 * @Param
	 * @Return
	 */
	@Override
	public String getMiniProgramAccessToken(String appId, String appSecret) {
		String key = appId+"_"+appSecret;
		String accessToken = (String) redisTemplate.opsForValue().get(key);
		logger.info("redis----MiniProgramaccessToken="+accessToken);
		System.out.println("redis----MiniProgramaccessToken="+accessToken);
		if(StringUtils.isBlank(accessToken)) {
			Map<String,String> param = new HashMap<>();
			String accessResult = null;
			param.put("grant_type","client_credential");
			param.put("appid",appId);
			param.put("secret",appSecret);
			try {
				accessResult = ReferHttpClientUtils.get("https://api.weixin.qq.com/cgi-bin/token",param,new HashMap<>());
			} catch (GeneralSecurityException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
			logger.info("MiniProgramaccessTokenaccessResult="+accessResult);
			System.out.println("MiniProgramaccessTokenaccessResult="+accessResult);
			if(StringUtils.isNotBlank(accessResult)) {
				JSONObject accessJson = JSON.parseObject(accessResult);
				accessToken = accessJson.getString("access_token");
				String errmsg = accessJson.getString("errcode");
				if("0".equals(errmsg)&&StringUtils.isNotBlank(accessToken)) {
					redisTemplate.opsForValue().set(key, accessToken, 7000, TimeUnit.SECONDS);
				}
			}
		}
		return accessToken;
	}

	/**
	 * @param corpAppId
	 * @param accessToken
	 * @Author mrsir_wxp
	 * @Date 2020/10/17
	 * @Description 获取小程序的jsapi_ticket
	 * @Param
	 * @Return
	 */
	@Override
	public String getMiniProgramJsapiTicket(String corpAppId, String accessToken) {
		String key = corpAppId+"_jsapi_ticket";
		String jsapiTicket = (String) redisTemplate.opsForValue().get(key);
		logger.info("redis----jsapiTicket="+jsapiTicket);
		System.out.println("redis----jsapiTicket="+jsapiTicket);
		if(StringUtils.isBlank(jsapiTicket)) {
			Map<String,String> param = new HashMap<>();
			String accessResult = null;
			param.put("access_token",accessToken);
			param.put("type","jsapi");
			try {
				accessResult = ReferHttpClientUtils.get("https://api.weixin.qq.com/cgi-bin/ticket/getticket",param,new HashMap<>());
			} catch (GeneralSecurityException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
			System.out.println("accessResult="+accessResult);
			logger.info("accessResult="+accessResult);
			if(StringUtils.isNotBlank(accessResult)) {
				JSONObject accessJson = JSON.parseObject(accessResult);
				jsapiTicket = accessJson.getString("ticket");
				String errmsg = accessJson.getString("errcode");
				if("0".equals(errmsg)&&StringUtils.isNotBlank(jsapiTicket)) {
					redisTemplate.opsForValue().set(key, jsapiTicket, 7000, TimeUnit.SECONDS);
				}
			}
		}
		return jsapiTicket;
	}

	/**
	 * @param accessToken
	 * @Author mrsir_wxp
	 * @Date 2020/10/17
	 * @Description 获取企业的jsapi_ticket
	 * @Return jsapi_ticket
	 */
	@Override
	public String getWeixineeJsapiTicket(String corpAppId ,String accessToken) {
		String key = corpAppId+"_jsapi_ticket";
		String jsapiTicket = (String) redisTemplate.opsForValue().get(key);
		logger.info("redis----jsapiTicket="+jsapiTicket);
		System.out.println("redis----jsapiTicket="+jsapiTicket);
		if(StringUtils.isBlank(jsapiTicket)) {
			Map<String,String> param = new HashMap<>();
			String accessResult = null;
			param.put("access_token",accessToken);
			try {
				accessResult = ReferHttpClientUtils.get("https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket",param,new HashMap<>());
			} catch (GeneralSecurityException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
			System.out.println("accessResult="+accessResult);
			logger.info("accessResult="+accessResult);
			if(StringUtils.isNotBlank(accessResult)) {
				JSONObject accessJson = JSON.parseObject(accessResult);
				jsapiTicket = accessJson.getString("ticket");
				String errmsg = accessJson.getString("errmsg");
				if("ok".equals(errmsg)&&StringUtils.isNotBlank(jsapiTicket)) {
					redisTemplate.opsForValue().set(key, jsapiTicket, 7000, TimeUnit.SECONDS);
				}
			}
		}
		return jsapiTicket;
	}

	/**
	 * @param corpAppId
	 * @param accessToken
	 * @Author mrsir_wxp
	 * @Date 2020/10/17
	 * @Description 获取企业应用的jsapi_ticket
	 * @Param
	 * @Return
	 */
	@Override
	public String getWeixineeAppJsapiTicket(String corpAppId, String accessToken) {
		String key = corpAppId+"_app_jsapi_ticket";
		String jsapiTicket = (String) redisTemplate.opsForValue().get(key);
		logger.info("redis----app--jsapiTicket="+jsapiTicket);
		if(StringUtils.isBlank(jsapiTicket)) {
			Map<String,String> param = new HashMap<>();
			String accessResult = null;
			param.put("access_token",accessToken);
			param.put("type","agent_config");
			try {
				accessResult = ReferHttpClientUtils.get("https://qyapi.weixin.qq.com/cgi-bin/ticket/get",param,new HashMap<>());
			} catch (GeneralSecurityException | IOException e) {
				e.printStackTrace();
			}
			logger.info("accessResult="+accessResult);
			if(StringUtils.isNotBlank(accessResult)) {
				JSONObject accessJson = JSON.parseObject(accessResult);
				jsapiTicket = accessJson.getString("ticket");
				String errmsg = accessJson.getString("errmsg");
				if("ok".equals(errmsg)&&StringUtils.isNotBlank(jsapiTicket)) {
					redisTemplate.opsForValue().set(key, jsapiTicket, 7000, TimeUnit.SECONDS);
				}
			}
		}
		return jsapiTicket;
	}

	@Override
	public String getYonYouCloudAccessTicket(boolean reload) throws Exception{
		String accessToken = getYonYouCloudAccessToken(reload);
		String jsTicket = (String) redisTemplate.opsForValue().get(YONYOUCLOUD_TICKET_KEY);
		logger.info("redis--yonyoucloud--jsTicket="+jsTicket);
		if(StringUtils.isBlank(jsTicket) || reload) {
			Map<String, Object> params = new HashMap<>();
			params.put("access_token", accessToken);
			logger.info("请求友空间获取票据，url-{}, 参数：{}", yonYouGetTicketUrl, params);
			String httpResultJsonStr = HttpTookit.get(yonYouGetTicketUrl, params, new HashMap<>());
			logger.info("请求友空间获取票据结果：{}", httpResultJsonStr);

			JSONObject httpResultJson = JSONObject.parseObject(httpResultJsonStr);
			if ("200".equals(httpResultJson.getString("code"))) {
				JSONObject data = httpResultJson.getJSONObject("data");
				jsTicket = data.getString("js_ticket");
				Long expire = data.getLong("expires_in");
				redisTemplate.opsForValue().set(YONYOUCLOUD_TICKET_KEY, jsTicket, expire - 3L, TimeUnit.SECONDS);
			} else {
				throw new BusinessException("请求友空间获取接口令牌失败: " + httpResultJson.getString("message"));
			}
		}
		return jsTicket;
	}

	@Override
	public String getQunjeToken(String restname, String password, Boolean refresh) {
		String key = "qunje_"+restname+"_"+password;
		String token = null;
		if(!refresh){
			token = (String) redisTemplate.opsForValue().get(key);
			logger.info("redis----qunje_token="+token);
		}
		if(StringUtils.isBlank(token)) {
			String getTokenUrl = tokenUrl + "/token/getToken";
			logger.info("getTokenUrl="+getTokenUrl);
			try {
				Map<String,String> paramMap = new HashMap<>();
				paramMap.put("restname", restname);
				paramMap.put("password", password);
				String responseStr = HttpTookit.postParameters(getTokenUrl, paramMap, "application/x-www-form-urlencoded");
				logger.info("responseStr="+responseStr);
				JSONObject responseJson = JSON.parseObject(responseStr);
				if(responseJson != null) {
					String status = responseJson.getString("status");
					if("0".equals(status)) {
						JSONObject dataJson = responseJson.getJSONObject("data");
						token = dataJson.getString("token");
						redisTemplate.opsForValue().set(key, token, 2, TimeUnit.HOURS);
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return token;
	}


	/*************************************************************************************/
	/****       企业微信第三方应用相关接口      开始      **************************************/
	/*************************************************************************************/
	@Override
	public String getWXEESuiteAccessToken(JSONObject body, String suiteId) {
		String accessToken = (String) redisTemplate.opsForValue().get("EJB_SuiteAccessToken"+suiteId);
		if(StringUtils.isBlank(accessToken)){
			try {
				String res = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token",body.toJSONString());
				logger.info("请求获取suite_access_token:{}   响应：{}","https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token",res);
				if (StringUtils.isNotEmpty(res)){
					JSONObject token = JSONObject.parseObject(res);
					if(StringUtils.isEmpty(token.getString("errcode")) || token.getInteger("errcode") == 0){
						accessToken = token.getString("suite_access_token");
						redisTemplate.opsForValue().set("EJB_SuiteAccessToken"+suiteId,accessToken,7000, TimeUnit.SECONDS);
					}else {
						logger.info("获取suite_access_token失败！suiteId:{}  请求体：{}，响应：{}",suiteId,body,res);
						throw new BusinessException("errcode:"+token.getString("errcode"));
					}
				}else {
					logger.info("获取suite_access_token失败！suiteId:{}  请求体：{}，响应为空",suiteId,body);
					throw new BusinessException("响应为空！");
				}
			} catch (Exception e) {
				logger.info("获取suite_access_token失败！{}",e.getMessage());
				e.printStackTrace();
				throw new BusinessException("获取suite_access_token失败！"+e.getMessage());
			}
		}

		return accessToken;
	}

	@Override
	public String getWXEEPreAuthCode(String suiteAccessToken) {
		String pre_auth_code = null;
		try {
			Map<String, String> params = new HashMap<>();
			params.put("suite_access_token",suiteAccessToken);
			String res = WeixinRestUtil.doGetByURL("https://qyapi.weixin.qq.com/cgi-bin/service/get_pre_auth_code?suite_access_token="+suiteAccessToken,null);
			logger.info("请求获取pre_auth_code:{}   响应：{}","https://qyapi.weixin.qq.com/cgi-bin/service/get_pre_auth_code?suite_access_token="+suiteAccessToken,res);
			if (StringUtils.isNotEmpty(res)){
				JSONObject token = JSONObject.parseObject(res);
				if(StringUtils.isEmpty(token.getString("errcode")) || token.getInteger("errcode") == 0){
					pre_auth_code = token.getString("pre_auth_code");
				}else {
					logger.info("获取pre_auth_code失败！suiteAccessToken:{}  响应：{}",suiteAccessToken,res);
					throw new BusinessException("errcode:"+token.getString("errcode"));
				}
			}else {
				logger.info("获取pre_auth_code失败！suiteAccessToken:{} ，响应为空",suiteAccessToken);
				throw new BusinessException("响应为空！");
			}
		} catch (Exception e) {
			logger.info("获取pre_auth_code失败！{}",e.getMessage());
			e.printStackTrace();
			throw new BusinessException("获取pre_auth_code失败！"+e.getMessage());
		}

		return pre_auth_code;
	}

	@Override
	public String setWXEESessionInfo(String suiteAccessToken, JSONObject body) {
		try {
			String res = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/service/set_session_info?suite_access_token="+suiteAccessToken,body.toJSONString());
			logger.info("请求设置授权配置:{}   响应：{}","https://qyapi.weixin.qq.com/cgi-bin/service/set_session_info?suite_access_token="+suiteAccessToken,res);
			if (StringUtils.isNotEmpty(res)){
				JSONObject token = JSONObject.parseObject(res);
				if(StringUtils.isEmpty(token.getString("errcode")) || token.getInteger("errcode") == 0){
				}else {
					logger.info("设置授权配置失败！suiteAccessToken:{}  请求体：{}，响应：{}",suiteAccessToken,body,res);
					throw new BusinessException("errcode:"+token.getString("errcode"));
				}
			}else {
				logger.info("设置授权配置失败！suiteAccessToken:{}  请求体：{}，响应为空",suiteAccessToken,body);
				throw new BusinessException("响应为空！");
			}
		}catch (Exception e){
			logger.info("设置授权配置失败！{}",e.getMessage());
			e.printStackTrace();
			throw new BusinessException("设置授权配置失败！"+e.getMessage());
		}
		return null;
	}

	@Override
	public JSONObject getWXEEPermanentCode(String suiteAccessToken, JSONObject body) {
		try {
			String res = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/service/get_permanent_code?suite_access_token="+suiteAccessToken,body.toJSONString());
			logger.info("请求获取企业永久授权码:{}   响应：{}","https://qyapi.weixin.qq.com/cgi-bin/service/get_permanent_code?suite_access_token="+suiteAccessToken,res);
			if (StringUtils.isNotEmpty(res)){
				JSONObject token = JSONObject.parseObject(res);
				if(StringUtils.isEmpty(token.getString("errcode")) || token.getInteger("errcode") == 0){
					return token;
				}else {
					logger.info("获取企业永久授权码失败！suiteAccessToken:{}  请求体：{}，响应：{}",suiteAccessToken,body,res);
					throw new BusinessException("errcode:"+token.getString("errcode"));
				}
			}else {
				logger.info("获取企业永久授权码失败！suiteAccessToken:{}  请求体：{}，响应为空",suiteAccessToken,body);
				throw new BusinessException("响应为空！");
			}
		}catch (Exception e){
			logger.info("获取企业永久授权码失败！{}",e.getMessage());
			e.printStackTrace();
			throw new BusinessException("获取企业永久授权码失败！"+e.getMessage());
		}
	}

	@Override
	public JSONObject getWXEEAuthInfo(String suiteAccessToken, JSONObject body) {
		try {
			String res = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/service/get_auth_info?suite_access_token="+suiteAccessToken,body.toJSONString());
			logger.info("请求获取企业授权信:{}   响应：{}","https://qyapi.weixin.qq.com/cgi-bin/service/get_auth_info?suite_access_token="+suiteAccessToken,res);
			if (StringUtils.isNotEmpty(res)){
				JSONObject token = JSONObject.parseObject(res);
				if(StringUtils.isEmpty(token.getString("errcode")) || token.getInteger("errcode") == 0){
					return token;
				}else {
					logger.info("获取企业授权信息失败！suiteAccessToken:{}  请求体：{}，响应：{}",suiteAccessToken,body,res);
					throw new BusinessException("errcode:"+token.getString("errcode"));
				}
			}else {
				logger.info("获取企业授权信息失败！suiteAccessToken:{}  请求体：{}，响应为空",suiteAccessToken,body);
				throw new BusinessException("响应为空！");
			}
		}catch (Exception e){
			logger.info("获取企业授权信息失败！{}",e.getMessage());
			e.printStackTrace();
			throw new BusinessException("获取企业授权信息失败！"+e.getMessage());
		}
	}

	@Override
	public String getWXEECorpToken(String corpid, String suiteAccessToken, JSONObject body) {
		String accessToken = (String) redisTemplate.opsForValue().get("EJB_corpid_AccessToken"+corpid);
		if(StringUtils.isBlank(accessToken)){
			try {
				String res = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/service/get_corp_token?suite_access_token="+suiteAccessToken,body.toJSONString());
				logger.info("请求获取企业access_token:{}   响应：{}","https://qyapi.weixin.qq.com/cgi-bin/service/get_corp_token?suite_access_token="+suiteAccessToken,res);
				if (StringUtils.isNotEmpty(res)){
					JSONObject token = JSONObject.parseObject(res);
					if(StringUtils.isEmpty(token.getString("errcode")) || token.getInteger("errcode") == 0){
						accessToken = token.getString("access_token");
						redisTemplate.opsForValue().set("EJB_corpid_AccessToken"+corpid,accessToken,7000, TimeUnit.SECONDS);
					}else {
						logger.info("获取企业access_token失败！corpid:{},suiteAccessToken:{},  请求体：{}，响应：{}",corpid,suiteAccessToken,body,res);
						throw new BusinessException("errcode:"+token.getString("errcode"));
					}
				}else {
					logger.info("获取企业access_token失败！corpid:{} ，suiteAccessToken:{}, 请求体：{}，响应为空",corpid,suiteAccessToken,body);
					throw new BusinessException("响应为空！");
				}
			} catch (Exception e) {
				logger.info("获取企业access_token失败！{}",e.getMessage());
				e.printStackTrace();
				throw new BusinessException("获取企业access_token失败！"+e.getMessage());
			}
		}

		return accessToken;
	}

	@Override
	public JSONObject getWXEEUserInfo(String access_token, String userId) {
		try {
			String res = WeixinRestUtil.doGetByURL("https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token="+access_token+"&userid="+userId,null);
			logger.info("请求读取企业微信成员详细信息:{}   响应：{}","https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token="+access_token+"&userid="+userId,res);
			if (StringUtils.isNotEmpty(res)){
				JSONObject userInfo = JSONObject.parseObject(res);
				if(StringUtils.isEmpty(userInfo.getString("errcode")) || userInfo.getInteger("errcode") == 0){
					return userInfo;
				}else {
					logger.info("读取企业微信成员详细信息失败！access_token:{}  userId：{}，响应：{}",access_token,userId,res);
					throw new BusinessException("errcode:"+userInfo.getString("errcode"));
				}
			}else {
				logger.info("读取企业微信成员详细信息失败！access_token:{}  userId：{}，响应为空",access_token,userId);
				throw new BusinessException("响应为空！");
			}
		}catch (Exception e){
			logger.info("读取企业微信成员详细信息失败！{}",e.getMessage());
			e.printStackTrace();
			throw new BusinessException("读取企业微信成员详细信息失败！"+e.getMessage());
		}
	}

	@Override
	public JSONArray getWXEEDeptUserList(String access_token, String department_id) {
		try {
			String res = WeixinRestUtil.doGetByURL("https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token="+access_token+"&department_id="+department_id,null);
			logger.info("请求读取企业微信部门成员:{}   响应：{}","https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token="+access_token+"&department_id="+department_id,res);
			if (StringUtils.isNotEmpty(res)){
				JSONObject userlist = JSONObject.parseObject(res);
				if(StringUtils.isEmpty(userlist.getString("errcode")) || userlist.getInteger("errcode") == 0){
					return userlist.getJSONArray("userlist");
				}else {
					logger.info("读取企业微信部门成员失败！access_token:{}  department_id：{}，响应：{}",access_token,department_id,res);
					throw new BusinessException("errcode:"+userlist.getString("errcode"));
				}
			}else {
				logger.info("读取企业微信部门成员失败！access_token:{}  department_id：{}，响应为空",access_token,department_id);
				throw new BusinessException("响应为空！");
			}
		}catch (Exception e){
			logger.info("读取企业微信部门成员失败！{}",e.getMessage());
			e.printStackTrace();
			throw new BusinessException("读取企业微信部门成员失败！"+e.getMessage());
		}
	}

	/**
	 * 获取企业微信 访问用户身份
	 * <p>
	 * 请求方式：GET（HTTPS）
	 * 请求地址：https://qyapi.weixin.qq.com/cgi-bin/service/auth/getuserinfo3rd?suite_access_token=SUITE_ACCESS_TOKEN&code=CODE
	 * suite_access_token	是	第三方应用的suite_access_token，参见“获取第三方应用凭证” 。不允许代开发自建应用调用。代开发自建应用获取用户身份参考“获取访问用户身份”
	 * code	是	通过成员授权获取到的code，最大为512字节。每次成员授权带上的code将不一样，code只能使用一次，5分钟未被使用自动过期。
	 * <p>
	 * 参考链接 https://developer.work.weixin.qq.com/document/path/91121
	 *
	 * @param suite_access_token
	 * @param code
	 * @return
	 */
	@Override
	public JSONObject getWXEEUser3rd(String suite_access_token, String code) {
		try {
			String res = WeixinRestUtil.doGetByURL("https://qyapi.weixin.qq.com/cgi-bin/service/auth/getuserinfo3rd?suite_access_token="+suite_access_token+"&code="+code,null);
			logger.info("请求获取企业微信访问用户身份:{}   响应：{}","https://qyapi.weixin.qq.com/cgi-bin/service/auth/getuserinfo3rd?suite_access_token="+suite_access_token+"&code="+code,res);
			if (StringUtils.isNotEmpty(res)){
				JSONObject user = JSONObject.parseObject(res);
				if(StringUtils.isEmpty(user.getString("errcode")) || user.getInteger("errcode") == 0){
					return user;
				}else {
					logger.info("获取企业微信访问用户身份失败！suite_access_token:{}  department_id：{}，响应：{}",suite_access_token,code,res);
					throw new BusinessException("errcode:"+user.getString("errcode"));
				}
			}else {
				logger.info("获取企业微信访问用户身份失败！suite_access_token:{}  department_id：{}，响应为空",suite_access_token,code);
				throw new BusinessException("响应为空！");
			}
		}catch (Exception e){
			logger.info("获取企业微信访问用户身份失败！{}",e.getMessage());
			e.printStackTrace();
			throw new BusinessException("获取企业微信访问用户身份失败！"+e.getMessage());
		}
	}

	/**
	 * 获取服务商的accessToken
	 */
	@Override
	public String getWXEEProviderToken() {
		String accessToken = (String) redisTemplate.opsForValue().get("ww2dd60a57572d9031");
		if(StringUtils.isEmpty(accessToken)){
			String getProviderToken = "https://qyapi.weixin.qq.com/cgi-bin/service/get_provider_token";
			JSONObject providerTokenParam = new JSONObject();
			providerTokenParam.put("corpid", "ww2dd60a57572d9031");
			providerTokenParam.put("provider_secret", "PU6smE7tG5B48tJD-aoSI3WEV2tP8K9yvrENwnVS5DTeGVCj2x8hfGtN7lOuqYDS");
			String providerTokenResp = WeixinRestUtil.doPostByURL(getProviderToken, JSON.toJSONString(providerTokenParam));
			JSONObject providerTokenJson = JSON.parseObject(providerTokenResp);
			accessToken = providerTokenJson.getString("provider_access_token");
			redisTemplate.opsForValue().set("ww2dd60a57572d9031",accessToken,7000, TimeUnit.SECONDS);
		}
		return accessToken;
	}
	/**-----------***************************************************************************************/
	/**-----------结束！！企业微信第三方应用相关接口************************************************************/
	/**-----------***************************************************************************************/

	/**********************************钉钉第三方应用相关接口start************************************/
	//获取钉钉第三方企业应用的access_token
	@Override
	public String getDdThirdAppAccessToken(String corpId, String suiteTicket){
		try {
			com.aliyun.teaopenapi.models.Config config = new com.aliyun.teaopenapi.models.Config();
			config.protocol = "https";
			config.regionId = "central";
			com.aliyun.dingtalkoauth2_1_0.Client client =  new com.aliyun.dingtalkoauth2_1_0.Client(config);
			com.aliyun.dingtalkoauth2_1_0.models.GetCorpAccessTokenRequest getCorpAccessTokenRequest = new com.aliyun.dingtalkoauth2_1_0.models.GetCorpAccessTokenRequest()
					.setSuiteKey(DdConstant.SUITEKEY)
					.setSuiteSecret(DdConstant.SUITESECRET)
					.setAuthCorpId(corpId)
					.setSuiteTicket(suiteTicket);
			GetCorpAccessTokenResponse response = client.getCorpAccessToken(getCorpAccessTokenRequest);
			return response.getBody().getAccessToken();
		} catch (TeaException err) {
			if (!com.aliyun.teautil.Common.empty(err.code) && !com.aliyun.teautil.Common.empty(err.message)) {
				// err 中含有 code 和 message 属性，可帮助开发定位问题
			}
		} catch (Exception _err) {
			TeaException err = new TeaException(_err.getMessage(), _err);
			if (!com.aliyun.teautil.Common.empty(err.code) && !com.aliyun.teautil.Common.empty(err.message)) {
				// err 中含有 code 和 message 属性，可帮助开发定位问题
			}
		}
		return null;
	}

	//获取钉钉第三方企业应用的suite_access_token
	@Override
	public String getDdThirdAppSuiteAccessToken(String suiteTicket) {
		String suiteAccessToken = null;
		String key = DdConstant.EJC_DD_SUITEACCESSTOKEN;
		if(redisTemplate.opsForValue().get(key)!=null){
			suiteAccessToken = redisTemplate.opsForValue().get(key).toString();
		}
		if(StringUtils.isNotBlank(suiteAccessToken)){
			return suiteAccessToken;
		}
		try {
			DingTalkClient client = new DefaultDingTalkClient(DdConstant.GET_SUITE_TOKEN);
			OapiServiceGetSuiteTokenRequest req = new OapiServiceGetSuiteTokenRequest();
			req.setSuiteKey(DdConstant.SUITEKEY);
			req.setSuiteSecret(DdConstant.SUITESECRET);
			req.setSuiteTicket(suiteTicket);
			OapiServiceGetSuiteTokenResponse response = client.execute(req);
			JSONObject body = JSONObject.parseObject(response.getBody());
			logger.info("suiteAccessToken---------》》》》"+response.getBody());
			if("0".equals(body.getString("errcode"))){
				suiteAccessToken = body.getString("suite_access_token");
				redisTemplate.opsForValue().set(key, suiteAccessToken, 7000, TimeUnit.SECONDS);
			}
		} catch (ApiException e) {
			e.printStackTrace();
		}
		return suiteAccessToken;
	}

	/**
	 * 获取钉钉第三方应用用户的access_token
	 *
	 * @return
	 */
	@Override
	public String getDdUserAccessToken(String code) {
		String key = DdConstant.EJC_DD_USER_ACCESSTOKEN;
		String accessToken = null;
		if(redisTemplate.opsForValue().get(key)!=null){
			accessToken = redisTemplate.opsForValue().get(key).toString();
		}
		if(StringUtils.isNotBlank(accessToken)){
			return accessToken;
		}
		if(StringUtils.isBlank(accessToken)) {
			try {
				Config config = new Config();
				config.protocol = "https";
				config.regionId = "central";
				Client client = new Client(config);
				GetUserTokenRequest getUserTokenRequest = new GetUserTokenRequest()
						.setClientSecret(DdConstant.SUITESECRET)
						.setClientId(DdConstant.SUITEKEY)
						.setCode(code)
						.setGrantType("authorization_code");
				GetUserTokenResponse response = client.getUserToken(getUserTokenRequest);
				GetUserTokenResponseBody body = response.getBody();
				accessToken = body.getAccessToken();
				logger.info("body === "+ BeanMapper.map(body,JSONObject.class).toJSONString() );
				logger.info("accessToken === "+accessToken);
				redisTemplate.opsForValue().set(key, accessToken, 5000, TimeUnit.SECONDS);
			} catch (TeaException err) {
				if (!com.aliyun.teautil.Common.empty(err.code) && !com.aliyun.teautil.Common.empty(err.message)) {
					// err 中含有 code 和 message 属性，可帮助开发定位问题
				}
			} catch (Exception _err) {
				TeaException err = new TeaException(_err.getMessage(), _err);
				if (!com.aliyun.teautil.Common.empty(err.code) && !com.aliyun.teautil.Common.empty(err.message)) {
					// err 中含有 code 和 message 属性，可帮助开发定位问题
				}
			}
		}
		return accessToken;
	}

	@Override
	public String getDdThirdAgentid(String corpid) {
		String key = corpid + "-Agentid";
		String agentid = null;
		if(redisTemplate.opsForValue().get(key)!=null){
			agentid = redisTemplate.opsForValue().get(key).toString();
		}
		if(StringUtils.isNotBlank(agentid)){
			logger.info("agentid === "+agentid);
			return agentid;
		}
		if(StringUtils.isBlank(agentid)) {
			try {
				DingTalkClient client = new DefaultDingTalkClient(DdConstant.GET_AUTH_INFO);
				OapiServiceGetAuthInfoRequest req = new OapiServiceGetAuthInfoRequest();
				req.setAuthCorpid(corpid);
				String suiteTicket = this.getThirdAppSuiteTicket(DdConstant.SUITEID,"ddThirdApp");

				OapiServiceGetAuthInfoResponse rsp = client.execute(req, DdConstant.SUITEKEY ,DdConstant.SUITESECRET ,suiteTicket);
				logger.info("AuthInfoResponse === "+BeanMapper.map(rsp,JSONObject.class).toJSONString());
				List<OapiServiceGetAuthInfoResponse.Agent> agentList = rsp.getAuthInfo().getAgent();
				if(agentList!=null && agentList.size()>0){
					for(OapiServiceGetAuthInfoResponse.Agent agent : agentList){
						if(DdConstant.APPID.equals(agent.getAppid().toString())){
							agentid = agent.getAgentid().toString();
							break;
						}
					}
				}
				logger.info("agentid === "+agentid);
				redisTemplate.opsForValue().set(key, agentid, 10000, TimeUnit.SECONDS);
			} catch (TeaException err) {
				if (!com.aliyun.teautil.Common.empty(err.code) && !com.aliyun.teautil.Common.empty(err.message)) {
					// err 中含有 code 和 message 属性，可帮助开发定位问题
				}
			} catch (Exception _err) {
				TeaException err = new TeaException(_err.getMessage(), _err);
				if (!com.aliyun.teautil.Common.empty(err.code) && !com.aliyun.teautil.Common.empty(err.message)) {
					// err 中含有 code 和 message 属性，可帮助开发定位问题
				}
			}
		}
		return agentid;
	}
	/**********************************钉钉第三方应用相关接口end************************************/

	/**
	 * 公共 获取第三方应用的 租户的 企业永久授权码 已持久化数据库的授权码，非从第三方获取
	 * 目前钉钉、企业微信 第三方应用使用
	 *
	 * @param corpid 第三方系统中企业id
	 * @return
	 */
	@Override
	public String getTenantPromiseCode(String corpid) {
		QueryWrapper<TenantEntity> tenantWrapper = new QueryWrapper<>();
		tenantWrapper.eq("corpid", corpid).eq("dr", 0);
		TenantEntity exitTenantEntity = iTenantService.getOne(tenantWrapper);
		if(exitTenantEntity!=null){
			return exitTenantEntity.getPermanentCode();
		}
		return null;
	}

	/**
	 * 公共 获取第三方应用的 租户信息
	 * 目前钉钉、企业微信 第三方应用使用
	 *
	 * @param corpid 第三方系统中企业id
	 * @return
	 */
	@Override
	public TenantEntity getTenantByThirdCorpid(String corpid) {
		QueryWrapper<TenantEntity> tenantWrapper = new QueryWrapper<>();
		tenantWrapper.eq("corpid", corpid).eq("dr", 0);
		return iTenantService.getOne(tenantWrapper);
	}

	/**
	 * 公共 获取第三方应用的suite ticket
	 * 目前钉钉、企业微信 第三方应用使用
	 *
	 * @param suiteId 应用id
	 * @param sys     区分系统，企业微信：wxee，钉钉：dingding
	 * @return
	 */
	@Override
	public String getThirdAppSuiteTicket(String suiteId, String sys) {
		QueryParam param = new QueryParam();
		param.getParams().put("suiteId",new Parameter(QueryParam.EQ,suiteId));
		param.getParams().put("sourceSys",new Parameter(QueryParam.EQ,sys));
		List<SuiteTicketEntity> ticketEntities = suitTicketService.queryList(param,false);
		if(ListUtil.isNotEmpty(ticketEntities)){
			return ticketEntities.get(0).getTicket();
		}
		return null;
	}

	/**
	 * 公共 获取第三方应用的AccessToken
	 * 目前钉钉、企业微信 第三方应用使用
	 *
	 * @param corpid
	 * @param sys    区分系统，企业微信：wxee，钉钉：ddThirdApp
	 * @return
	 */
	@Override
	public String getThirdAppAccessToken(String corpid, String sys) {

		if("wxee".equals(sys)){
			String promiseCode = getTenantPromiseCode(corpid);
			String suite_ticket = getThirdAppSuiteTicket(WXEEConstant.SUITEID,"wxee");
			JSONObject body = new JSONObject();
			body.put("suite_id",YJB_SUIT_ID);
			body.put("suite_secret",YJB_SECRET);
			body.put("suite_ticket",suite_ticket);
			String suite_access_token = getWXEESuiteAccessToken(body,YJB_SUIT_ID);
			body = new JSONObject();
			body.put("auth_corpid",corpid);
			body.put("permanent_code",promiseCode);
			return getWXEECorpToken(corpid,suite_access_token,body);
		}
		if("ddThirdApp".equals(sys)){
			String suite_ticket = getThirdAppSuiteTicket(DdConstant.SUITEID,"ddThirdApp");
			return getDdThirdAppAccessToken(corpid,suite_ticket);
		}
		return null;
	}

	/**
	 * 公共 设置第三方应用的suite ticket
	 * 目前钉钉、企业微信 第三方应用使用
	 *
	 * @param suiteTicket 要设置的 suiteTicket
	 * @param suiteId     应用id
	 * @param sys         区分系统，企业微信：wxee，钉钉：dingding
	 * @return
	 */
	@Override
	public void setThirdAppSuiteTicket(String suiteTicket, String suiteId, String sys) {
		QueryParam param = new QueryParam();
		param.getParams().put("suiteId",new Parameter(QueryParam.EQ,suiteId));
		param.getParams().put("sourceSys",new Parameter(QueryParam.EQ,sys));
		List<SuiteTicketEntity> ticketEntities = suitTicketService.queryList(param,false);
		SuiteTicketEntity entity ;
		if(ListUtil.isNotEmpty(ticketEntities)){
			entity = ticketEntities.get(0);
		}else {
			entity = new SuiteTicketEntity();
		}
		entity.setSourceSys(sys);
		entity.setTicket(suiteTicket);
		entity.setSuiteId(suiteId);
		suitTicketService.saveOrUpdate(entity,false);
	}
	
	@Override
	public ThirdSystemVO queryThirdSystemByTargetTenantId(Long tenantId) {
		QueryWrapper<ThirdSystemEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("target_tenant_id", tenantId);
		List<ThirdSystemEntity> thirdSystemList = baseMapper.selectList(queryWrapper);
		if(thirdSystemList != null && thirdSystemList.size() > 0) {
			return BeanMapper.map(thirdSystemList.get(0), ThirdSystemVO.class);
		}
		return null;
	}

}
